/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSelector;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

public class HAUtil {
    private static final Log LOG = LogFactory.getLog(HAUtil.class);

    private HAUtil() {
    }

    public static boolean isHAEnabled(Configuration conf, String nsId) {
        Map<String, Map<String, InetSocketAddress>> addresses = DFSUtil.getHaNnRpcAddresses(conf);
        if (addresses == null) {
            return false;
        }
        Map<String, InetSocketAddress> nnMap = addresses.get(nsId);
        return nnMap != null && nnMap.size() > 1;
    }

    public static boolean usesSharedEditsDir(Configuration conf) {
        return null != conf.get("dfs.namenode.shared.edits.dir");
    }

    public static String getNameNodeId(Configuration conf, String nsId) {
        String namenodeId = conf.getTrimmed("dfs.ha.namenode.id");
        if (namenodeId != null) {
            return namenodeId;
        }
        String[] suffixes = DFSUtil.getSuffixIDs(conf, "dfs.namenode.rpc-address", nsId, null, DFSUtil.LOCAL_ADDRESS_MATCHER);
        if (suffixes == null) {
            String msg = "Configuration dfs.namenode.rpc-address must be suffixed with nameservice and namenode ID for HA configuration.";
            throw new HadoopIllegalArgumentException(msg);
        }
        return suffixes[1];
    }

    public static String getNameNodeIdFromAddress(Configuration conf, InetSocketAddress address, String ... keys) {
        String[] ids = DFSUtil.getSuffixIDs(conf, address, keys);
        if (ids != null && ids.length > 1) {
            return ids[1];
        }
        return null;
    }

    public static Configuration getConfForOtherNode(Configuration myConf) {
        String nsId = DFSUtil.getNamenodeNameServiceId(myConf);
        Preconditions.checkArgument((nsId != null ? 1 : 0) != 0, (Object)"Could not determine namespace id. Please ensure that this machine is one of the machines listed as a NN RPC address, or configure dfs.federation.nameservice.id");
        Collection<String> nnIds = DFSUtil.getNameNodeIds(myConf, nsId);
        String myNNId = myConf.get("dfs.ha.namenode.id");
        Preconditions.checkArgument((nnIds != null ? 1 : 0) != 0, (String)("Could not determine namenode ids in namespace '%s'. Please configure " + DFSUtil.addKeySuffixes("dfs.ha.namenodes", nsId)), (Object[])new Object[]{nsId});
        Preconditions.checkArgument((nnIds.size() == 2 ? 1 : 0) != 0, (String)"Expected exactly 2 NameNodes in namespace '%s'. Instead, got only %s (NN ids were '%s'", (Object[])new Object[]{nsId, nnIds.size(), Joiner.on((String)"','").join(nnIds)});
        Preconditions.checkState((myNNId != null && !myNNId.isEmpty() ? 1 : 0) != 0, (String)"Could not determine own NN ID in namespace '%s'. Please ensure that this node is one of the machines listed as an NN RPC address, or configure dfs.ha.namenode.id", (Object[])new Object[]{nsId});
        ArrayList nnSet = Lists.newArrayList(nnIds);
        nnSet.remove(myNNId);
        assert (nnSet.size() == 1);
        String activeNN = (String)nnSet.get(0);
        Configuration confForOtherNode = new Configuration(myConf);
        NameNode.initializeGenericKeys(confForOtherNode, nsId, activeNN);
        return confForOtherNode;
    }

    public static boolean shouldAllowStandbyReads(Configuration conf) {
        return conf.getBoolean("dfs.ha.allow.stale.reads", false);
    }

    public static void setAllowStandbyReads(Configuration conf, boolean val) {
        conf.setBoolean("dfs.ha.allow.stale.reads", val);
    }

    public static boolean isLogicalUri(Configuration conf, URI nameNodeUri) {
        String host = nameNodeUri.getHost();
        String configKey = "dfs.client.failover.proxy.provider." + host;
        return conf.get(configKey) != null;
    }

    public static URI getServiceUriFromToken(Token<DelegationTokenIdentifier> token) throws IOException {
        String tokStr = token.getService().toString();
        if (tokStr.startsWith("ha-hdfs:")) {
            tokStr = tokStr.replaceFirst("ha-hdfs:", "");
        }
        try {
            return new URI("hdfs://" + tokStr);
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid token contents: '" + tokStr + "'");
        }
    }

    public static Text buildTokenServiceForLogicalUri(URI uri) {
        return new Text("ha-hdfs:" + uri.getHost());
    }

    public static boolean isTokenForLogicalUri(Token<DelegationTokenIdentifier> token) {
        return token.getService().toString().startsWith("ha-hdfs:");
    }

    public static void cloneDelegationTokenForLogicalUri(UserGroupInformation ugi, URI haUri, InetSocketAddress singleNNAddr) {
        Text haService = HAUtil.buildTokenServiceForLogicalUri(haUri);
        Token<DelegationTokenIdentifier> haToken = DelegationTokenSelector.selectHdfsDelegationToken(haService, ugi);
        if (haToken == null) {
            return;
        }
        Token specificToken = new Token(haToken);
        specificToken.setService(SecurityUtil.buildTokenService((InetSocketAddress)singleNNAddr));
        ugi.addToken(specificToken);
        LOG.debug((Object)("Mapped HA service delegation token for logical URI " + haUri + " to namenode " + singleNNAddr));
    }

    public static InetSocketAddress getAddressOfActive(FileSystem fs) throws IOException {
        if (!(fs instanceof DistributedFileSystem)) {
            throw new IllegalArgumentException("FileSystem " + fs + " is not a DFS.");
        }
        fs.exists(new Path("/"));
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        DFSClient dfsClient = dfs.getClient();
        return RPC.getServerAddress((Object)dfsClient.getNamenode());
    }
}

