/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class LocatedBlock
implements Writable {
    private ExtendedBlock b;
    private long offset;
    private DatanodeInfo[] locs;
    private boolean corrupt;
    private Token<BlockTokenIdentifier> blockToken = new Token();

    public LocatedBlock() {
        this(new ExtendedBlock(), new DatanodeInfo[0], 0L, false);
    }

    public LocatedBlock(ExtendedBlock eb) {
        this(eb, new DatanodeInfo[0], 0L, false);
    }

    public LocatedBlock(String bpid, Block b, DatanodeInfo[] locs) {
        this(new ExtendedBlock(bpid, b), locs, -1L, false);
    }

    public LocatedBlock(ExtendedBlock b, DatanodeInfo[] locs) {
        this(b, locs, -1L, false);
    }

    public LocatedBlock(ExtendedBlock b, DatanodeInfo[] locs, long startOffset) {
        this(b, locs, startOffset, false);
    }

    public LocatedBlock(ExtendedBlock b, DatanodeInfo[] locs, long startOffset, boolean corrupt) {
        this.b = b;
        this.offset = startOffset;
        this.corrupt = corrupt;
        this.locs = locs == null ? new DatanodeInfo[0] : locs;
    }

    public Token<BlockTokenIdentifier> getBlockToken() {
        return this.blockToken;
    }

    public void setBlockToken(Token<BlockTokenIdentifier> token) {
        this.blockToken = token;
    }

    public ExtendedBlock getBlock() {
        return this.b;
    }

    public DatanodeInfo[] getLocations() {
        return this.locs;
    }

    public long getStartOffset() {
        return this.offset;
    }

    public long getBlockSize() {
        return this.b.getNumBytes();
    }

    void setStartOffset(long value) {
        this.offset = value;
    }

    void setCorrupt(boolean corrupt) {
        this.corrupt = corrupt;
    }

    public boolean isCorrupt() {
        return this.corrupt;
    }

    public void write(DataOutput out) throws IOException {
        this.blockToken.write(out);
        out.writeBoolean(this.corrupt);
        out.writeLong(this.offset);
        this.b.write(out);
        out.writeInt(this.locs.length);
        for (int i = 0; i < this.locs.length; ++i) {
            this.locs[i].write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.blockToken.readFields(in);
        this.corrupt = in.readBoolean();
        this.offset = in.readLong();
        this.b = new ExtendedBlock();
        this.b.readFields(in);
        int count = in.readInt();
        this.locs = new DatanodeInfo[count];
        for (int i = 0; i < this.locs.length; ++i) {
            this.locs[i] = new DatanodeInfo();
            this.locs[i].readFields(in);
        }
    }

    public static LocatedBlock read(DataInput in) throws IOException {
        LocatedBlock lb = new LocatedBlock();
        lb.readFields(in);
        return lb;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.b + "; getBlockSize()=" + this.getBlockSize() + "; corrupt=" + this.corrupt + "; offset=" + this.offset + "; locs=" + Arrays.asList(this.locs) + "}";
    }

    static {
        WritableFactories.setFactory(LocatedBlock.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new LocatedBlock();
            }
        });
    }
}

