/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.channels.AsynchronousCloseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataXceiver;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Daemon;

class DataXceiverServer
implements Runnable {
    public static final Log LOG = DataNode.LOG;
    ServerSocket ss;
    DataNode datanode;
    Set<Socket> childSockets = Collections.synchronizedSet(new HashSet());
    int maxXceiverCount = 4096;
    BlockBalanceThrottler balanceThrottler;
    long estimateBlockSize;

    DataXceiverServer(ServerSocket ss, Configuration conf, DataNode datanode) {
        this.ss = ss;
        this.datanode = datanode;
        this.maxXceiverCount = conf.getInt("dfs.datanode.max.transfer.threads", 4096);
        this.estimateBlockSize = conf.getLongBytes("dfs.blocksize", 0x4000000L);
        this.balanceThrottler = new BlockBalanceThrottler(conf.getLong("dfs.datanode.balance.bandwidthPerSec", 0x100000L));
    }

    @Override
    public void run() {
        while (this.datanode.shouldRun) {
            Socket s = null;
            try {
                s = this.ss.accept();
                s.setTcpNoDelay(true);
                int curXceiverCount = this.datanode.getXceiverCount();
                if (curXceiverCount > this.maxXceiverCount) {
                    throw new IOException("Xceiver count " + curXceiverCount + " exceeds the limit of concurrent xcievers: " + this.maxXceiverCount);
                }
                new Daemon(this.datanode.threadGroup, (Runnable)new DataXceiver(s, this.datanode, this)).start();
            }
            catch (SocketTimeoutException ignored) {
            }
            catch (AsynchronousCloseException ace) {
                if (!this.datanode.shouldRun) continue;
                LOG.warn((Object)(this.datanode.getMachineName() + ":DataXceiverServer: "), (Throwable)ace);
            }
            catch (IOException ie) {
                IOUtils.closeSocket((Socket)s);
                LOG.warn((Object)(this.datanode.getMachineName() + ":DataXceiverServer: "), (Throwable)ie);
            }
            catch (OutOfMemoryError ie) {
                IOUtils.closeSocket((Socket)s);
                LOG.warn((Object)"DataNode is out of memory. Will retry in 30 seconds.", (Throwable)ie);
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (Throwable te) {
                LOG.error((Object)(this.datanode.getMachineName() + ":DataXceiverServer: Exiting due to: "), te);
                this.datanode.shouldRun = false;
            }
        }
        try {
            this.ss.close();
        }
        catch (IOException ie) {
            LOG.warn((Object)(this.datanode.getMachineName() + " :DataXceiverServer: close exception"), (Throwable)ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void kill() {
        assert (!this.datanode.shouldRun) : "shoudRun should be set to false before killing";
        try {
            this.ss.close();
        }
        catch (IOException ie) {
            LOG.warn((Object)(this.datanode.getMachineName() + ":DataXceiverServer.kill(): "), (Throwable)ie);
        }
        Set<Socket> set = this.childSockets;
        synchronized (set) {
            for (Socket thissock : this.childSockets) {
                try {
                    thissock.close();
                }
                catch (IOException e) {}
            }
        }
    }

    static class BlockBalanceThrottler
    extends DataTransferThrottler {
        private int numThreads;

        private BlockBalanceThrottler(long bandwidth) {
            super(bandwidth);
            LOG.info((Object)("Balancing bandwith is " + bandwidth + " bytes/s"));
        }

        synchronized boolean acquire() {
            if (this.numThreads >= 5) {
                return false;
            }
            ++this.numThreads;
            return true;
        }

        synchronized void release() {
            --this.numThreads;
        }
    }
}

