/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class NNHAStatusHeartbeat
implements Writable {
    private State state;
    private long txid = -12345L;

    public NNHAStatusHeartbeat() {
    }

    public NNHAStatusHeartbeat(State state, long txid) {
        this.state = state;
        this.txid = txid;
    }

    public State getState() {
        return this.state;
    }

    public long getTxId() {
        return this.txid;
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeEnum((DataOutput)out, (Enum)this.state);
        out.writeLong(this.txid);
    }

    public void readFields(DataInput in) throws IOException {
        this.state = (State)WritableUtils.readEnum((DataInput)in, State.class);
        this.txid = in.readLong();
    }

    @InterfaceAudience.Private
    public static enum State {
        ACTIVE,
        STANDBY;

    }
}

