/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.protocol.NodeRegistration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class NamenodeRegistration
extends StorageInfo
implements NodeRegistration {
    String rpcAddress;
    String httpAddress;
    HdfsServerConstants.NamenodeRole role;

    public NamenodeRegistration() {
    }

    public NamenodeRegistration(String address, String httpAddress, StorageInfo storageInfo, HdfsServerConstants.NamenodeRole role) {
        super(storageInfo);
        this.rpcAddress = address;
        this.httpAddress = httpAddress;
        this.role = role;
    }

    @Override
    public String getAddress() {
        return this.rpcAddress;
    }

    public String getHttpAddress() {
        return this.httpAddress;
    }

    @Override
    public String getRegistrationID() {
        return Storage.getRegistrationID(this);
    }

    @Override
    public int getVersion() {
        return super.getLayoutVersion();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.rpcAddress + ", role=" + (Object)((Object)this.getRole()) + ")";
    }

    public HdfsServerConstants.NamenodeRole getRole() {
        return this.role;
    }

    public boolean isRole(HdfsServerConstants.NamenodeRole that) {
        return this.role.equals((Object)that);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.rpcAddress);
        Text.writeString((DataOutput)out, (String)this.httpAddress);
        Text.writeString((DataOutput)out, (String)this.role.name());
        super.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.rpcAddress = Text.readString((DataInput)in);
        this.httpAddress = Text.readString((DataInput)in);
        this.role = HdfsServerConstants.NamenodeRole.valueOf(Text.readString((DataInput)in));
        super.readFields(in);
    }

    static {
        WritableFactories.setFactory(NamenodeRegistration.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new NamenodeRegistration();
            }
        });
    }
}

