/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ReplicaRecoveryInfo
extends Block {
    private HdfsServerConstants.ReplicaState originalState;

    public ReplicaRecoveryInfo() {
    }

    public ReplicaRecoveryInfo(long blockId, long diskLen, long gs, HdfsServerConstants.ReplicaState rState) {
        this.set(blockId, diskLen, gs);
        this.originalState = rState;
    }

    public HdfsServerConstants.ReplicaState getOriginalReplicaState() {
        return this.originalState;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.originalState = HdfsServerConstants.ReplicaState.read(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.originalState.write(out);
    }

    static {
        WritableFactories.setFactory(ReplicaRecoveryInfo.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new ReplicaRecoveryInfo();
            }
        });
    }
}

