/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.net.InetSocketAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.BadFencingConfigurationException;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.NodeFencer;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.net.NetUtils;

@InterfaceAudience.Private
public class NNHAServiceTarget
extends HAServiceTarget {
    private final InetSocketAddress addr;
    private NodeFencer fencer;
    private BadFencingConfigurationException fenceConfigError;

    public NNHAServiceTarget(HdfsConfiguration conf, String nsId, String nnId) {
        String serviceAddr = DFSUtil.getNamenodeServiceAddr(conf, nsId, nnId);
        if (serviceAddr == null) {
            throw new IllegalArgumentException("Unable to determine service address for namenode '" + nnId + "'");
        }
        this.addr = NetUtils.createSocketAddr((String)serviceAddr, (int)8020);
        try {
            this.fencer = NodeFencer.create((Configuration)conf);
        }
        catch (BadFencingConfigurationException e) {
            this.fenceConfigError = e;
        }
    }

    public InetSocketAddress getAddress() {
        return this.addr;
    }

    public void checkFencingConfigured() throws BadFencingConfigurationException {
        if (this.fenceConfigError != null) {
            throw this.fenceConfigError;
        }
    }

    public NodeFencer getFencer() {
        return this.fencer;
    }

    public String toString() {
        return "NameNode at " + this.addr;
    }
}

