/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.DeprecatedUTF8;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.EditsElement;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
interface Tokenizer {
    public Token read(Token var1) throws IOException;

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class EmptyToken
    extends Token {
        public EmptyToken(EditsElement e) {
            super(e);
        }

        @Override
        public void fromString(String s) throws IOException {
        }

        @Override
        public void fromBinary(DataInputStream in) throws IOException {
        }

        @Override
        public String toString() {
            return "";
        }

        @Override
        public void toBinary(DataOutputStream out) throws IOException {
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class BytesWritableToken
    extends Token {
        public BytesWritable value = new BytesWritable();

        public BytesWritableToken(EditsElement e) {
            super(e);
        }

        @Override
        public void fromString(String s) throws IOException {
            this.value = new BytesWritable(Base64.decodeBase64((String)s));
        }

        @Override
        public void fromBinary(DataInputStream in) throws IOException {
            this.value.readFields((DataInput)in);
        }

        @Override
        public String toString() {
            return Base64.encodeBase64URLSafeString((byte[])this.value.getBytes());
        }

        @Override
        public void toBinary(DataOutputStream out) throws IOException {
            this.value.write((DataOutput)out);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class BlobToken
    extends Token {
        public byte[] value = null;

        public BlobToken(EditsElement e, int length) {
            super(e);
            this.value = length == -1 ? null : new byte[length];
        }

        @Override
        public void fromString(String s) throws IOException {
            this.value = Base64.decodeBase64((String)s);
        }

        @Override
        public void fromBinary(DataInputStream in) throws IOException {
            in.readFully(this.value);
        }

        @Override
        public String toString() {
            return Base64.encodeBase64URLSafeString((byte[])this.value);
        }

        @Override
        public void toBinary(DataOutputStream out) throws IOException {
            out.write(this.value);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class StringTextToken
    extends Token {
        public String value;

        public StringTextToken(EditsElement e) {
            super(e);
        }

        @Override
        public void fromString(String s) throws IOException {
            this.value = s;
        }

        @Override
        public void fromBinary(DataInputStream in) throws IOException {
            this.value = Text.readString((DataInput)in);
        }

        @Override
        public String toString() {
            return this.value;
        }

        @Override
        public void toBinary(DataOutputStream out) throws IOException {
            Text.writeString((DataOutput)out, (String)this.value);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class StringUTF8Token
    extends Token {
        public String value;

        public StringUTF8Token(EditsElement e) {
            super(e);
        }

        @Override
        public void fromString(String s) throws IOException {
            this.value = s;
        }

        @Override
        public void fromBinary(DataInputStream in) throws IOException {
            this.value = DeprecatedUTF8.readString(in);
        }

        @Override
        public String toString() {
            return this.value;
        }

        @Override
        public void toBinary(DataOutputStream out) throws IOException {
            DeprecatedUTF8.writeString(out, this.value);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class VLongToken
    extends Token {
        public long value;

        public VLongToken(EditsElement e) {
            super(e);
        }

        @Override
        public void fromString(String s) throws IOException {
            this.value = Long.parseLong(s);
        }

        @Override
        public void fromBinary(DataInputStream in) throws IOException {
            this.value = WritableUtils.readVLong((DataInput)in);
        }

        @Override
        public String toString() {
            return Long.toString(this.value);
        }

        @Override
        public void toBinary(DataOutputStream out) throws IOException {
            WritableUtils.writeVLong((DataOutput)out, (long)this.value);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class LongToken
    extends Token {
        public long value;

        public LongToken(EditsElement e) {
            super(e);
        }

        @Override
        public void fromString(String s) throws IOException {
            this.value = Long.parseLong(s);
        }

        @Override
        public void fromBinary(DataInputStream in) throws IOException {
            this.value = in.readLong();
        }

        @Override
        public String toString() {
            return Long.toString(this.value);
        }

        @Override
        public void toBinary(DataOutputStream out) throws IOException {
            out.writeLong(this.value);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class VIntToken
    extends Token {
        public int value;

        public VIntToken(EditsElement e) {
            super(e);
        }

        @Override
        public void fromString(String s) throws IOException {
            this.value = Integer.parseInt(s);
        }

        @Override
        public void fromBinary(DataInputStream in) throws IOException {
            this.value = WritableUtils.readVInt((DataInput)in);
        }

        @Override
        public String toString() {
            return Integer.toString(this.value);
        }

        @Override
        public void toBinary(DataOutputStream out) throws IOException {
            WritableUtils.writeVInt((DataOutput)out, (int)this.value);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class IntToken
    extends Token {
        public int value;

        public IntToken(EditsElement e) {
            super(e);
        }

        @Override
        public void fromString(String s) throws IOException {
            this.value = Integer.parseInt(s);
        }

        @Override
        public void fromBinary(DataInputStream in) throws IOException {
            this.value = in.readInt();
        }

        @Override
        public String toString() {
            return Integer.toString(this.value);
        }

        @Override
        public void toBinary(DataOutputStream out) throws IOException {
            out.writeInt(this.value);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class ShortToken
    extends Token {
        public short value;

        public ShortToken(EditsElement e) {
            super(e);
        }

        @Override
        public void fromString(String s) throws IOException {
            this.value = Short.parseShort(s);
        }

        @Override
        public void fromBinary(DataInputStream in) throws IOException {
            this.value = in.readShort();
        }

        @Override
        public String toString() {
            return Short.toString(this.value);
        }

        @Override
        public void toBinary(DataOutputStream out) throws IOException {
            out.writeShort(this.value);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class ByteToken
    extends Token {
        public byte value;

        public ByteToken(EditsElement e) {
            super(e);
        }

        @Override
        public void fromString(String s) throws IOException {
            this.value = Byte.valueOf(s);
        }

        @Override
        public void fromBinary(DataInputStream in) throws IOException {
            this.value = in.readByte();
        }

        public void fromByte(byte b) {
            this.value = b;
        }

        @Override
        public String toString() {
            return Byte.toString(this.value);
        }

        @Override
        public void toBinary(DataOutputStream out) throws IOException {
            out.writeByte(this.value);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static abstract class Token {
        EditsElement e;

        public Token(EditsElement e) {
            this.e = e;
        }

        public EditsElement getEditsElement() {
            return this.e;
        }

        public abstract void fromString(String var1) throws IOException;

        public abstract void fromBinary(DataInputStream var1) throws IOException;

        public abstract String toString();

        public abstract void toBinary(DataOutputStream var1) throws IOException;
    }
}

