/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.protobuf.BlockingService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.ha.proto.HAServiceProtocolProtos;
import org.apache.hadoop.ha.protocolPB.HAServiceProtocolPB;
import org.apache.hadoop.ha.protocolPB.HAServiceProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HDFSPolicyProvider;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.GetUserMappingsProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.NamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.RefreshAuthorizationPolicyProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.RefreshUserMappingsProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.GetUserMappingsProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.GetUserMappingsProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.RefreshAuthorizationPolicyProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.RefreshAuthorizationPolicyProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.RefreshUserMappingsProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.RefreshUserMappingsProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.FinalizeCommand;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.NodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.UpgradeCommand;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.WritableRpcEngine;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.util.VersionUtil;

class NameNodeRpcServer
implements NamenodeProtocols {
    private static final Log LOG = NameNode.LOG;
    private static final Log stateChangeLog = NameNode.stateChangeLog;
    protected final FSNamesystem namesystem;
    protected final NameNode nn;
    private final NameNodeMetrics metrics;
    private final boolean serviceAuthEnabled;
    private final RPC.Server serviceRpcServer;
    private final InetSocketAddress serviceRPCAddress;
    protected final RPC.Server clientRpcServer;
    protected final InetSocketAddress clientRpcAddress;
    private final String minimumDataNodeVersion;

    public NameNodeRpcServer(Configuration conf, NameNode nn) throws IOException {
        this.nn = nn;
        this.namesystem = nn.getNamesystem();
        this.metrics = NameNode.getNameNodeMetrics();
        int handlerCount = conf.getInt("dfs.namenode.handler.count", 10);
        InetSocketAddress socAddr = nn.getRpcServerAddress(conf);
        RPC.setProtocolEngine((Configuration)conf, ClientNamenodeProtocolPB.class, ProtobufRpcEngine.class);
        ClientNamenodeProtocolServerSideTranslatorPB clientProtocolServerTranslator = new ClientNamenodeProtocolServerSideTranslatorPB(this);
        BlockingService clientNNPbService = ClientNamenodeProtocolProtos.ClientNamenodeProtocol.newReflectiveBlockingService(clientProtocolServerTranslator);
        DatanodeProtocolServerSideTranslatorPB dnProtoPbTranslator = new DatanodeProtocolServerSideTranslatorPB(this);
        BlockingService dnProtoPbService = DatanodeProtocolProtos.DatanodeProtocolService.newReflectiveBlockingService(dnProtoPbTranslator);
        NamenodeProtocolServerSideTranslatorPB namenodeProtocolXlator = new NamenodeProtocolServerSideTranslatorPB(this);
        BlockingService NNPbService = NamenodeProtocolProtos.NamenodeProtocolService.newReflectiveBlockingService(namenodeProtocolXlator);
        RefreshAuthorizationPolicyProtocolServerSideTranslatorPB refreshAuthPolicyXlator = new RefreshAuthorizationPolicyProtocolServerSideTranslatorPB(this);
        BlockingService refreshAuthService = RefreshAuthorizationPolicyProtocolProtos.RefreshAuthorizationPolicyProtocolService.newReflectiveBlockingService(refreshAuthPolicyXlator);
        RefreshUserMappingsProtocolServerSideTranslatorPB refreshUserMappingXlator = new RefreshUserMappingsProtocolServerSideTranslatorPB(this);
        BlockingService refreshUserMappingService = RefreshUserMappingsProtocolProtos.RefreshUserMappingsProtocolService.newReflectiveBlockingService(refreshUserMappingXlator);
        GetUserMappingsProtocolServerSideTranslatorPB getUserMappingXlator = new GetUserMappingsProtocolServerSideTranslatorPB(this);
        BlockingService getUserMappingService = GetUserMappingsProtocolProtos.GetUserMappingsProtocolService.newReflectiveBlockingService(getUserMappingXlator);
        HAServiceProtocolServerSideTranslatorPB haServiceProtocolXlator = new HAServiceProtocolServerSideTranslatorPB((HAServiceProtocol)this);
        BlockingService haPbService = HAServiceProtocolProtos.HAServiceProtocolService.newReflectiveBlockingService((HAServiceProtocolProtos.HAServiceProtocolService.BlockingInterface)haServiceProtocolXlator);
        WritableRpcEngine.ensureInitialized();
        InetSocketAddress dnSocketAddr = nn.getServiceRpcServerAddress(conf);
        if (dnSocketAddr != null) {
            int serviceHandlerCount = conf.getInt("dfs.namenode.service.handler.count", 10);
            this.serviceRpcServer = RPC.getServer(ClientNamenodeProtocolPB.class, (Object)clientNNPbService, (String)dnSocketAddr.getHostName(), (int)dnSocketAddr.getPort(), (int)serviceHandlerCount, (boolean)false, (Configuration)conf, (SecretManager)this.namesystem.getDelegationTokenSecretManager());
            DFSUtil.addPBProtocol(conf, HAServiceProtocolPB.class, haPbService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, NamenodeProtocolPB.class, NNPbService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, DatanodeProtocolPB.class, dnProtoPbService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, RefreshAuthorizationPolicyProtocolPB.class, refreshAuthService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, RefreshUserMappingsProtocolPB.class, refreshUserMappingService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, GetUserMappingsProtocolPB.class, getUserMappingService, this.serviceRpcServer);
            this.serviceRPCAddress = this.serviceRpcServer.getListenerAddress();
            nn.setRpcServiceServerAddress(conf, this.serviceRPCAddress);
        } else {
            this.serviceRpcServer = null;
            this.serviceRPCAddress = null;
        }
        this.clientRpcServer = RPC.getServer(ClientNamenodeProtocolPB.class, (Object)clientNNPbService, (String)socAddr.getHostName(), (int)socAddr.getPort(), (int)handlerCount, (boolean)false, (Configuration)conf, (SecretManager)this.namesystem.getDelegationTokenSecretManager());
        DFSUtil.addPBProtocol(conf, HAServiceProtocolPB.class, haPbService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, NamenodeProtocolPB.class, NNPbService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, DatanodeProtocolPB.class, dnProtoPbService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, RefreshAuthorizationPolicyProtocolPB.class, refreshAuthService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, RefreshUserMappingsProtocolPB.class, refreshUserMappingService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, GetUserMappingsProtocolPB.class, getUserMappingService, this.clientRpcServer);
        this.serviceAuthEnabled = conf.getBoolean("hadoop.security.authorization", false);
        if (this.serviceAuthEnabled) {
            this.clientRpcServer.refreshServiceAcl(conf, (PolicyProvider)new HDFSPolicyProvider());
            if (this.serviceRpcServer != null) {
                this.serviceRpcServer.refreshServiceAcl(conf, (PolicyProvider)new HDFSPolicyProvider());
            }
        }
        this.clientRpcAddress = this.clientRpcServer.getListenerAddress();
        nn.setRpcServerAddress(conf, this.clientRpcAddress);
        this.minimumDataNodeVersion = conf.get("dfs.namenode.min.supported.datanode.version", "2.0.0");
    }

    void start() {
        this.clientRpcServer.start();
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.start();
        }
    }

    void join() throws InterruptedException {
        this.clientRpcServer.join();
    }

    void stop() {
        if (this.clientRpcServer != null) {
            this.clientRpcServer.stop();
        }
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.stop();
        }
    }

    InetSocketAddress getServiceRpcAddress() {
        return this.serviceRPCAddress;
    }

    InetSocketAddress getRpcAddress() {
        return this.clientRpcAddress;
    }

    @Override
    public BlocksWithLocations getBlocks(DatanodeInfo datanode, long size) throws IOException {
        if (size <= 0L) {
            throw new IllegalArgumentException("Unexpected not positive size: " + size);
        }
        this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        return this.namesystem.getBlockManager().getBlocks(datanode, size);
    }

    @Override
    public ExportedBlockKeys getBlockKeys() throws IOException {
        return this.namesystem.getBlockManager().getBlockKeys();
    }

    @Override
    public void errorReport(NamenodeRegistration registration, int errorCode, String msg) throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.verifyRequest(registration);
        LOG.info((Object)("Error report from " + registration + ": " + msg));
        if (errorCode == 1) {
            this.namesystem.releaseBackupNode(registration);
        }
    }

    @Override
    public NamenodeRegistration register(NamenodeRegistration registration) throws IOException {
        this.verifyLayoutVersion(registration.getVersion());
        NamenodeRegistration myRegistration = this.nn.setRegistration();
        this.namesystem.registerBackupNode(registration, myRegistration);
        return myRegistration;
    }

    @Override
    public NamenodeCommand startCheckpoint(NamenodeRegistration registration) throws IOException {
        this.verifyRequest(registration);
        if (!this.nn.isRole(HdfsServerConstants.NamenodeRole.NAMENODE)) {
            throw new IOException("Only an ACTIVE node can invoke startCheckpoint.");
        }
        return this.namesystem.startCheckpoint(registration, this.nn.setRegistration());
    }

    @Override
    public void endCheckpoint(NamenodeRegistration registration, CheckpointSignature sig) throws IOException {
        this.namesystem.endCheckpoint(registration, sig);
    }

    @Override
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        return this.namesystem.getDelegationToken(renewer);
    }

    @Override
    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        return this.namesystem.renewDelegationToken(token);
    }

    @Override
    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        this.namesystem.cancelDelegationToken(token);
    }

    @Override
    public LocatedBlocks getBlockLocations(String src, long offset, long length) throws IOException {
        this.metrics.incrGetBlockLocations();
        return this.namesystem.getBlockLocations(NameNodeRpcServer.getClientMachine(), src, offset, length);
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        return this.namesystem.getServerDefaults();
    }

    @Override
    public void create(String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize) throws IOException {
        String clientMachine = NameNodeRpcServer.getClientMachine();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* NameNode.create: file " + src + " for " + clientName + " at " + clientMachine));
        }
        if (!this.checkPathLength(src)) {
            throw new IOException("create: Pathname too long.  Limit " + HdfsConstants.MAX_PATH_LENGTH + " characters, " + HdfsConstants.MAX_PATH_DEPTH + " levels.");
        }
        this.namesystem.startFile(src, new PermissionStatus(UserGroupInformation.getCurrentUser().getShortUserName(), null, masked), clientName, clientMachine, flag.get(), createParent, replication, blockSize);
        this.metrics.incrFilesCreated();
        this.metrics.incrCreateFileOps();
    }

    @Override
    public LocatedBlock append(String src, String clientName) throws IOException {
        String clientMachine = NameNodeRpcServer.getClientMachine();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* NameNode.append: file " + src + " for " + clientName + " at " + clientMachine));
        }
        LocatedBlock info = this.namesystem.appendFile(src, clientName, clientMachine);
        this.metrics.incrFilesAppended();
        return info;
    }

    @Override
    public boolean recoverLease(String src, String clientName) throws IOException {
        String clientMachine = NameNodeRpcServer.getClientMachine();
        return this.namesystem.recoverLease(src, clientName, clientMachine);
    }

    @Override
    public boolean setReplication(String src, short replication) throws IOException {
        return this.namesystem.setReplication(src, replication);
    }

    @Override
    public void setPermission(String src, FsPermission permissions) throws IOException {
        this.namesystem.setPermission(src, permissions);
    }

    @Override
    public void setOwner(String src, String username, String groupname) throws IOException {
        this.namesystem.setOwner(src, username, groupname);
    }

    @Override
    public LocatedBlock addBlock(String src, String clientName, ExtendedBlock previous, DatanodeInfo[] excludedNodes) throws IOException {
        LocatedBlock locatedBlock;
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*BLOCK* NameNode.addBlock: file " + src + " for " + clientName));
        }
        HashMap<Node, Node> excludedNodesSet = null;
        if (excludedNodes != null) {
            excludedNodesSet = new HashMap<Node, Node>(excludedNodes.length);
            for (DatanodeInfo node : excludedNodes) {
                excludedNodesSet.put(node, node);
            }
        }
        if ((locatedBlock = this.namesystem.getAdditionalBlock(src, clientName, previous, excludedNodesSet)) != null) {
            this.metrics.incrAddBlockOps();
        }
        return locatedBlock;
    }

    @Override
    public LocatedBlock getAdditionalDatanode(String src, ExtendedBlock blk, DatanodeInfo[] existings, DatanodeInfo[] excludes, int numAdditionalNodes, String clientName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getAdditionalDatanode: src=" + src + ", blk=" + blk + ", existings=" + Arrays.asList(existings) + ", excludes=" + Arrays.asList(excludes) + ", numAdditionalNodes=" + numAdditionalNodes + ", clientName=" + clientName));
        }
        this.metrics.incrGetAdditionalDatanodeOps();
        HashMap<Node, Node> excludeSet = null;
        if (excludes != null) {
            excludeSet = new HashMap<Node, Node>(excludes.length);
            for (DatanodeInfo node : excludes) {
                excludeSet.put(node, node);
            }
        }
        return this.namesystem.getAdditionalDatanode(src, blk, existings, excludeSet, numAdditionalNodes, clientName);
    }

    @Override
    public void abandonBlock(ExtendedBlock b, String src, String holder) throws IOException {
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*BLOCK* NameNode.abandonBlock: " + b + " of file " + src));
        }
        if (!this.namesystem.abandonBlock(b, src, holder)) {
            throw new IOException("Cannot abandon block during write to " + src);
        }
    }

    @Override
    public boolean complete(String src, String clientName, ExtendedBlock last) throws IOException {
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* NameNode.complete: " + src + " for " + clientName));
        }
        return this.namesystem.completeFile(src, clientName, last);
    }

    @Override
    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        this.namesystem.reportBadBlocks(blocks);
    }

    @Override
    public LocatedBlock updateBlockForPipeline(ExtendedBlock block, String clientName) throws IOException {
        return this.namesystem.updateBlockForPipeline(block, clientName);
    }

    @Override
    public void updatePipeline(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes) throws IOException {
        this.namesystem.updatePipeline(clientName, oldBlock, newBlock, newNodes);
    }

    @Override
    public void commitBlockSynchronization(ExtendedBlock block, long newgenerationstamp, long newlength, boolean closeFile, boolean deleteblock, DatanodeID[] newtargets, String[] newtargetstorages) throws IOException {
        this.namesystem.commitBlockSynchronization(block, newgenerationstamp, newlength, closeFile, deleteblock, newtargets, newtargetstorages);
    }

    @Override
    public long getPreferredBlockSize(String filename) throws IOException {
        return this.namesystem.getPreferredBlockSize(filename);
    }

    @Override
    @Deprecated
    public boolean rename(String src, String dst) throws IOException {
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* NameNode.rename: " + src + " to " + dst));
        }
        if (!this.checkPathLength(dst)) {
            throw new IOException("rename: Pathname too long.  Limit " + HdfsConstants.MAX_PATH_LENGTH + " characters, " + HdfsConstants.MAX_PATH_DEPTH + " levels.");
        }
        boolean ret = this.namesystem.renameTo(src, dst);
        if (ret) {
            this.metrics.incrFilesRenamed();
        }
        return ret;
    }

    @Override
    public void concat(String trg, String[] src) throws IOException {
        this.namesystem.concat(trg, src);
    }

    @Override
    public void rename2(String src, String dst, Options.Rename ... options) throws IOException {
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* NameNode.rename: " + src + " to " + dst));
        }
        if (!this.checkPathLength(dst)) {
            throw new IOException("rename: Pathname too long.  Limit " + HdfsConstants.MAX_PATH_LENGTH + " characters, " + HdfsConstants.MAX_PATH_DEPTH + " levels.");
        }
        this.namesystem.renameTo(src, dst, options);
        this.metrics.incrFilesRenamed();
    }

    @Override
    public boolean delete(String src, boolean recursive) throws IOException {
        boolean ret;
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* Namenode.delete: src=" + src + ", recursive=" + recursive));
        }
        if (ret = this.namesystem.delete(src, recursive)) {
            this.metrics.incrDeleteFileOps();
        }
        return ret;
    }

    private boolean checkPathLength(String src) {
        Path srcPath = new Path(src);
        return src.length() <= HdfsConstants.MAX_PATH_LENGTH && srcPath.depth() <= HdfsConstants.MAX_PATH_DEPTH;
    }

    @Override
    public boolean mkdirs(String src, FsPermission masked, boolean createParent) throws IOException {
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* NameNode.mkdirs: " + src));
        }
        if (!this.checkPathLength(src)) {
            throw new IOException("mkdirs: Pathname too long.  Limit " + HdfsConstants.MAX_PATH_LENGTH + " characters, " + HdfsConstants.MAX_PATH_DEPTH + " levels.");
        }
        return this.namesystem.mkdirs(src, new PermissionStatus(UserGroupInformation.getCurrentUser().getShortUserName(), null, masked), createParent);
    }

    @Override
    public void renewLease(String clientName) throws IOException {
        this.namesystem.renewLease(clientName);
    }

    @Override
    public DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws IOException {
        DirectoryListing files = this.namesystem.getListing(src, startAfter, needLocation);
        if (files != null) {
            this.metrics.incrGetListingOps();
            this.metrics.incrFilesInGetListingOps(files.getPartialListing().length);
        }
        return files;
    }

    @Override
    public HdfsFileStatus getFileInfo(String src) throws IOException {
        this.metrics.incrFileInfoOps();
        return this.namesystem.getFileInfo(src, true);
    }

    @Override
    public HdfsFileStatus getFileLinkInfo(String src) throws IOException {
        this.metrics.incrFileInfoOps();
        return this.namesystem.getFileInfo(src, false);
    }

    @Override
    public long[] getStats() throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        return this.namesystem.getStats();
    }

    @Override
    public DatanodeInfo[] getDatanodeReport(HdfsConstants.DatanodeReportType type) throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.UNCHECKED);
        DatanodeInfo[] results = this.namesystem.datanodeReport(type);
        if (results == null) {
            throw new IOException("Cannot find datanode report");
        }
        return results;
    }

    @Override
    public boolean setSafeMode(HdfsConstants.SafeModeAction action) throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.UNCHECKED);
        return this.namesystem.setSafeMode(action);
    }

    @Override
    public boolean restoreFailedStorage(String arg) throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.UNCHECKED);
        return this.namesystem.restoreFailedStorage(arg);
    }

    @Override
    public void saveNamespace() throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.namesystem.saveNamespace();
    }

    @Override
    public void refreshNodes() throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.namesystem.getBlockManager().getDatanodeManager().refreshNodes(new HdfsConfiguration());
    }

    @Override
    public long getTransactionID() throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.CHECKPOINT);
        return this.namesystem.getEditLog().getSyncTxId();
    }

    @Override
    public CheckpointSignature rollEditLog() throws IOException {
        return this.namesystem.rollEditLog();
    }

    @Override
    public RemoteEditLogManifest getEditLogManifest(long sinceTxId) throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        return this.namesystem.getEditLog().getEditLogManifest(sinceTxId);
    }

    @Override
    public void finalizeUpgrade() throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        this.namesystem.finalizeUpgrade();
    }

    @Override
    public UpgradeStatusReport distributedUpgradeProgress(HdfsConstants.UpgradeAction action) throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        return this.namesystem.distributedUpgradeProgress(action);
    }

    @Override
    public void metaSave(String filename) throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.namesystem.metaSave(filename);
    }

    @Override
    public CorruptFileBlocks listCorruptFileBlocks(String path, String cookie) throws IOException {
        String[] cookieTab = new String[]{cookie};
        Collection<FSNamesystem.CorruptFileBlockInfo> fbs = this.namesystem.listCorruptFileBlocks(path, cookieTab);
        String[] files = new String[fbs.size()];
        int i = 0;
        for (FSNamesystem.CorruptFileBlockInfo fb : fbs) {
            files[i++] = fb.path;
        }
        return new CorruptFileBlocks(files, cookieTab[0]);
    }

    @Override
    public void setBalancerBandwidth(long bandwidth) throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.namesystem.getBlockManager().getDatanodeManager().setBalancerBandwidth(bandwidth);
    }

    @Override
    public ContentSummary getContentSummary(String path) throws IOException {
        return this.namesystem.getContentSummary(path);
    }

    @Override
    public void setQuota(String path, long namespaceQuota, long diskspaceQuota) throws IOException {
        this.namesystem.setQuota(path, namespaceQuota, diskspaceQuota);
    }

    @Override
    public void fsync(String src, String clientName) throws IOException {
        this.namesystem.fsync(src, clientName);
    }

    @Override
    public void setTimes(String src, long mtime, long atime) throws IOException {
        this.namesystem.setTimes(src, mtime, atime);
    }

    @Override
    public void createSymlink(String target, String link, FsPermission dirPerms, boolean createParent) throws IOException {
        this.metrics.incrCreateSymlinkOps();
        if (!this.checkPathLength(link)) {
            throw new IOException("Symlink path exceeds " + HdfsConstants.MAX_PATH_LENGTH + " character limit");
        }
        if ("".equals(target)) {
            throw new IOException("Invalid symlink target");
        }
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        this.namesystem.createSymlink(target, link, new PermissionStatus(ugi.getShortUserName(), null, dirPerms), createParent);
    }

    @Override
    public String getLinkTarget(String path) throws IOException {
        this.metrics.incrGetLinkTargetOps();
        try {
            HdfsFileStatus stat = this.namesystem.getFileInfo(path, false);
            if (stat != null) {
                return stat.getSymlink();
            }
        }
        catch (UnresolvedPathException e) {
            return e.getResolvedPath().toString();
        }
        catch (UnresolvedLinkException e) {
            throw new AssertionError((Object)"UnresolvedLinkException thrown");
        }
        return null;
    }

    @Override
    public DatanodeRegistration registerDatanode(DatanodeRegistration nodeReg) throws IOException {
        this.verifyLayoutVersion(nodeReg.getVersion());
        this.verifySoftwareVersion(nodeReg);
        this.namesystem.registerDatanode(nodeReg);
        return nodeReg;
    }

    @Override
    public HeartbeatResponse sendHeartbeat(DatanodeRegistration nodeReg, StorageReport[] report, int xmitsInProgress, int xceiverCount, int failedVolumes) throws IOException {
        this.verifyRequest(nodeReg);
        return this.namesystem.handleHeartbeat(nodeReg, report[0].getCapacity(), report[0].getDfsUsed(), report[0].getRemaining(), report[0].getBlockPoolUsed(), xceiverCount, xmitsInProgress, failedVolumes);
    }

    @Override
    public DatanodeCommand blockReport(DatanodeRegistration nodeReg, String poolId, StorageBlockReport[] reports) throws IOException {
        this.verifyRequest(nodeReg);
        BlockListAsLongs blist = new BlockListAsLongs(reports[0].getBlocks());
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*BLOCK* NameNode.blockReport: from " + nodeReg + " " + blist.getNumberOfBlocks() + " blocks"));
        }
        this.namesystem.getBlockManager().processReport(nodeReg, poolId, blist);
        if (this.nn.getFSImage().isUpgradeFinalized() && !this.nn.isStandbyState()) {
            return new FinalizeCommand(poolId);
        }
        return null;
    }

    @Override
    public void blockReceivedAndDeleted(DatanodeRegistration nodeReg, String poolId, StorageReceivedDeletedBlocks[] receivedAndDeletedBlocks) throws IOException {
        this.verifyRequest(nodeReg);
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*BLOCK* NameNode.blockReceivedAndDeleted: from " + nodeReg + " " + receivedAndDeletedBlocks.length + " blocks."));
        }
        this.namesystem.getBlockManager().processIncrementalBlockReport(nodeReg, poolId, receivedAndDeletedBlocks[0].getBlocks());
    }

    @Override
    public void errorReport(DatanodeRegistration nodeReg, int errorCode, String msg) throws IOException {
        String dnName;
        String string = dnName = nodeReg == null ? "Unknown DataNode" : nodeReg.toString();
        if (errorCode == 0) {
            LOG.info((Object)("Error report from " + dnName + ": " + msg));
            return;
        }
        this.verifyRequest(nodeReg);
        if (errorCode == 1) {
            LOG.warn((Object)("Disk error on " + dnName + ": " + msg));
        } else if (errorCode == 3) {
            LOG.warn((Object)("Fatal disk error on " + dnName + ": " + msg));
            this.namesystem.getBlockManager().getDatanodeManager().removeDatanode(nodeReg);
        } else {
            LOG.info((Object)("Error report from " + dnName + ": " + msg));
        }
    }

    @Override
    public NamespaceInfo versionRequest() throws IOException {
        return this.namesystem.getNamespaceInfo();
    }

    @Override
    public UpgradeCommand processUpgradeCommand(UpgradeCommand comm) throws IOException {
        return this.namesystem.processDistributedUpgradeCommand(comm);
    }

    void verifyRequest(NodeRegistration nodeReg) throws IOException {
        this.verifyLayoutVersion(nodeReg.getVersion());
        if (!this.namesystem.getRegistrationID().equals(nodeReg.getRegistrationID())) {
            LOG.warn((Object)("Invalid registrationID - expected: " + this.namesystem.getRegistrationID() + " received: " + nodeReg.getRegistrationID()));
            throw new UnregisteredNodeException(nodeReg);
        }
    }

    public void refreshServiceAcl() throws IOException {
        if (!this.serviceAuthEnabled) {
            throw new AuthorizationException("Service Level Authorization not enabled!");
        }
        this.clientRpcServer.refreshServiceAcl(new Configuration(), (PolicyProvider)new HDFSPolicyProvider());
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.refreshServiceAcl(new Configuration(), (PolicyProvider)new HDFSPolicyProvider());
        }
    }

    public void refreshUserToGroupsMappings() throws IOException {
        LOG.info((Object)("Refreshing all user-to-groups mappings. Requested by user: " + UserGroupInformation.getCurrentUser().getShortUserName()));
        Groups.getUserToGroupsMappingService().refresh();
    }

    public void refreshSuperUserGroupsConfiguration() {
        LOG.info((Object)"Refreshing SuperUser proxy group mapping list ");
        ProxyUsers.refreshSuperUserGroupsConfiguration();
    }

    public String[] getGroupsForUser(String user) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting groups for user " + user));
        }
        return UserGroupInformation.createRemoteUser((String)user).getGroupNames();
    }

    public synchronized void monitorHealth() throws HealthCheckFailedException, AccessControlException {
        this.nn.monitorHealth();
    }

    public synchronized void transitionToActive() throws ServiceFailedException, AccessControlException {
        this.nn.transitionToActive();
    }

    public synchronized void transitionToStandby() throws ServiceFailedException, AccessControlException {
        this.nn.transitionToStandby();
    }

    public synchronized HAServiceStatus getServiceStatus() throws AccessControlException, ServiceFailedException {
        return this.nn.getServiceStatus();
    }

    void verifyLayoutVersion(int version) throws IOException {
        if (version != HdfsConstants.LAYOUT_VERSION) {
            throw new IncorrectVersionException(version, "data node");
        }
    }

    private void verifySoftwareVersion(DatanodeRegistration dnReg) throws IncorrectVersionException {
        String dnVersion = dnReg.getSoftwareVersion();
        if (VersionUtil.compareVersions((String)dnVersion, (String)this.minimumDataNodeVersion) < 0) {
            IncorrectVersionException ive = new IncorrectVersionException(this.minimumDataNodeVersion, dnVersion, "DataNode", "NameNode");
            LOG.warn((Object)(ive.getMessage() + " DN: " + dnReg));
            throw ive;
        }
        String nnVersion = VersionInfo.getVersion();
        if (!dnVersion.equals(nnVersion)) {
            long dnCTime;
            String messagePrefix = "Reported DataNode version '" + dnVersion + "' of DN " + dnReg + " does not match NameNode version '" + nnVersion + "'";
            long nnCTime = this.nn.getFSImage().getStorage().getCTime();
            if (nnCTime != (dnCTime = dnReg.getStorageInfo().getCTime())) {
                IncorrectVersionException ive = new IncorrectVersionException(messagePrefix + " and CTime of DN ('" + dnCTime + "') does not match CTime of NN ('" + nnCTime + "')");
                LOG.warn((Object)ive);
                throw ive;
            }
            LOG.info((Object)(messagePrefix + ". Note: This is normal during a rolling upgrade."));
        }
    }

    private static String getClientMachine() {
        String clientMachine = NamenodeWebHdfsMethods.getRemoteAddress();
        if (clientMachine == null) {
            clientMachine = Server.getRemoteAddress();
        }
        if (clientMachine == null) {
            clientMachine = "";
        }
        return clientMachine;
    }
}

