/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.protocol.NodeRegistration;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DatanodeRegistration
extends DatanodeID
implements NodeRegistration {
    private StorageInfo storageInfo;
    private ExportedBlockKeys exportedKeys;
    private String softwareVersion;

    public DatanodeRegistration(DatanodeID dn, StorageInfo info, ExportedBlockKeys keys, String softwareVersion) {
        super(dn);
        this.storageInfo = info;
        this.exportedKeys = keys;
        this.softwareVersion = softwareVersion;
    }

    public DatanodeRegistration(String ipAddr, int xferPort) {
        this(ipAddr, xferPort, new StorageInfo(), new ExportedBlockKeys());
    }

    public DatanodeRegistration(String ipAddr, int xferPort, StorageInfo info, ExportedBlockKeys keys) {
        super(ipAddr, xferPort);
        this.storageInfo = info;
        this.exportedKeys = keys;
    }

    public void setStorageInfo(StorageInfo storage) {
        this.storageInfo = new StorageInfo(storage);
    }

    public StorageInfo getStorageInfo() {
        return this.storageInfo;
    }

    public void setExportedKeys(ExportedBlockKeys keys) {
        this.exportedKeys = keys;
    }

    public ExportedBlockKeys getExportedKeys() {
        return this.exportedKeys;
    }

    public void setSoftwareVersion(String softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    @Override
    public int getVersion() {
        return this.storageInfo.getLayoutVersion();
    }

    @Override
    public String getRegistrationID() {
        return Storage.getRegistrationID(this.storageInfo);
    }

    @Override
    public String getAddress() {
        return this.getXferAddr();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getIpAddr() + ", storageID=" + this.storageID + ", infoPort=" + this.infoPort + ", ipcPort=" + this.ipcPort + ", storageInfo=" + this.storageInfo + ")";
    }

    @Override
    public boolean equals(Object to) {
        return super.equals(to);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

