/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSClusterStats;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;

@InterfaceAudience.Private
public class BlockPlacementPolicyDefault
extends BlockPlacementPolicy {
    private boolean considerLoad;
    private boolean preferLocalNode = true;
    private NetworkTopology clusterMap;
    private FSClusterStats stats;
    static final String enableDebugLogging = "For more information, please enable DEBUG level logging on the org.apache.hadoop.hdfs.server.namenode.FSNamesystem logger.";
    private ThreadLocal<StringBuilder> threadLocalBuilder = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder();
        }
    };

    BlockPlacementPolicyDefault(Configuration conf, FSClusterStats stats, NetworkTopology clusterMap) {
        this.initialize(conf, stats, clusterMap);
    }

    protected BlockPlacementPolicyDefault() {
    }

    @Override
    public void initialize(Configuration conf, FSClusterStats stats, NetworkTopology clusterMap) {
        this.considerLoad = conf.getBoolean("dfs.namenode.replication.considerLoad", true);
        this.stats = stats;
        this.clusterMap = clusterMap;
    }

    @Override
    public DatanodeDescriptor[] chooseTarget(String srcPath, int numOfReplicas, DatanodeDescriptor writer, List<DatanodeDescriptor> chosenNodes, long blocksize) {
        return this.chooseTarget(numOfReplicas, writer, chosenNodes, false, null, blocksize);
    }

    @Override
    public DatanodeDescriptor[] chooseTarget(String srcPath, int numOfReplicas, DatanodeDescriptor writer, List<DatanodeDescriptor> chosenNodes, boolean returnChosenNodes, HashMap<Node, Node> excludedNodes, long blocksize) {
        return this.chooseTarget(numOfReplicas, writer, chosenNodes, returnChosenNodes, excludedNodes, blocksize);
    }

    DatanodeDescriptor[] chooseTarget(int numOfReplicas, DatanodeDescriptor writer, List<DatanodeDescriptor> chosenNodes, boolean returnChosenNodes, HashMap<Node, Node> excludedNodes, long blocksize) {
        if (numOfReplicas == 0 || this.clusterMap.getNumOfLeaves() == 0) {
            return new DatanodeDescriptor[0];
        }
        if (excludedNodes == null) {
            excludedNodes = new HashMap();
        }
        int clusterSize = this.clusterMap.getNumOfLeaves();
        int totalNumOfReplicas = chosenNodes.size() + numOfReplicas;
        if (totalNumOfReplicas > clusterSize) {
            numOfReplicas -= totalNumOfReplicas - clusterSize;
            totalNumOfReplicas = clusterSize;
        }
        int maxNodesPerRack = (totalNumOfReplicas - 1) / this.clusterMap.getNumOfRacks() + 2;
        ArrayList<DatanodeDescriptor> results = new ArrayList<DatanodeDescriptor>(chosenNodes);
        for (DatanodeDescriptor node : chosenNodes) {
            excludedNodes.put(node, node);
        }
        if (!this.clusterMap.contains((Node)writer)) {
            writer = null;
        }
        DatanodeDescriptor localNode = this.chooseTarget(numOfReplicas, writer, excludedNodes, blocksize, maxNodesPerRack, results);
        if (!returnChosenNodes) {
            results.removeAll(chosenNodes);
        }
        return this.getPipeline(writer == null ? localNode : writer, results.toArray(new DatanodeDescriptor[results.size()]));
    }

    private DatanodeDescriptor chooseTarget(int numOfReplicas, DatanodeDescriptor writer, HashMap<Node, Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeDescriptor> results) {
        boolean newBlock;
        if (numOfReplicas == 0 || this.clusterMap.getNumOfLeaves() == 0) {
            return writer;
        }
        int totalReplicasExpected = numOfReplicas;
        int numOfResults = results.size();
        boolean bl = newBlock = numOfResults == 0;
        if (writer == null && !newBlock) {
            writer = results.get(0);
        }
        try {
            if (numOfResults == 0) {
                writer = this.chooseLocalNode(writer, excludedNodes, blocksize, maxNodesPerRack, results);
                if (--numOfReplicas == 0) {
                    return writer;
                }
            }
            if (numOfResults <= 1) {
                this.chooseRemoteRack(1, results.get(0), excludedNodes, blocksize, maxNodesPerRack, results);
                if (--numOfReplicas == 0) {
                    return writer;
                }
            }
            if (numOfResults <= 2) {
                if (this.clusterMap.isOnSameRack((Node)results.get(0), (Node)results.get(1))) {
                    this.chooseRemoteRack(1, results.get(0), excludedNodes, blocksize, maxNodesPerRack, results);
                } else if (newBlock) {
                    this.chooseLocalRack(results.get(1), excludedNodes, blocksize, maxNodesPerRack, results);
                } else {
                    this.chooseLocalRack(writer, excludedNodes, blocksize, maxNodesPerRack, results);
                }
                if (--numOfReplicas == 0) {
                    return writer;
                }
            }
            this.chooseRandom(numOfReplicas, "", excludedNodes, blocksize, maxNodesPerRack, results);
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException e) {
            LOG.warn((Object)("Not able to place enough replicas, still in need of " + numOfReplicas + " to reach " + totalReplicasExpected + "\n" + e.getMessage()));
        }
        return writer;
    }

    private DatanodeDescriptor chooseLocalNode(DatanodeDescriptor localMachine, HashMap<Node, Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeDescriptor> results) throws BlockPlacementPolicy.NotEnoughReplicasException {
        Node oldNode;
        if (localMachine == null) {
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results);
        }
        if (this.preferLocalNode && (oldNode = excludedNodes.put(localMachine, localMachine)) == null && this.isGoodTarget(localMachine, blocksize, maxNodesPerRack, false, results)) {
            results.add(localMachine);
            return localMachine;
        }
        return this.chooseLocalRack(localMachine, excludedNodes, blocksize, maxNodesPerRack, results);
    }

    private DatanodeDescriptor chooseLocalRack(DatanodeDescriptor localMachine, HashMap<Node, Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeDescriptor> results) throws BlockPlacementPolicy.NotEnoughReplicasException {
        if (localMachine == null) {
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results);
        }
        try {
            return this.chooseRandom(localMachine.getNetworkLocation(), excludedNodes, blocksize, maxNodesPerRack, results);
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException e1) {
            DatanodeInfo newLocal = null;
            for (DatanodeDescriptor nextNode : results) {
                if (nextNode == localMachine) continue;
                newLocal = nextNode;
                break;
            }
            if (newLocal != null) {
                try {
                    return this.chooseRandom(newLocal.getNetworkLocation(), excludedNodes, blocksize, maxNodesPerRack, results);
                }
                catch (BlockPlacementPolicy.NotEnoughReplicasException e2) {
                    return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results);
                }
            }
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results);
        }
    }

    private void chooseRemoteRack(int numOfReplicas, DatanodeDescriptor localMachine, HashMap<Node, Node> excludedNodes, long blocksize, int maxReplicasPerRack, List<DatanodeDescriptor> results) throws BlockPlacementPolicy.NotEnoughReplicasException {
        int oldNumOfReplicas = results.size();
        try {
            this.chooseRandom(numOfReplicas, "~" + localMachine.getNetworkLocation(), excludedNodes, blocksize, maxReplicasPerRack, results);
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException e) {
            this.chooseRandom(numOfReplicas - (results.size() - oldNumOfReplicas), localMachine.getNetworkLocation(), excludedNodes, blocksize, maxReplicasPerRack, results);
        }
    }

    private DatanodeDescriptor chooseRandom(String nodes, HashMap<Node, Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeDescriptor> results) throws BlockPlacementPolicy.NotEnoughReplicasException {
        int numOfAvailableNodes = this.clusterMap.countNumOfAvailableNodes(nodes, excludedNodes.keySet());
        StringBuilder builder = null;
        if (LOG.isDebugEnabled()) {
            builder = this.threadLocalBuilder.get();
            builder.setLength(0);
            builder.append("[");
        }
        boolean badTarget = false;
        while (numOfAvailableNodes > 0) {
            DatanodeDescriptor chosenNode = (DatanodeDescriptor)this.clusterMap.chooseRandom(nodes);
            Node oldNode = excludedNodes.put(chosenNode, chosenNode);
            if (oldNode != null) continue;
            --numOfAvailableNodes;
            if (this.isGoodTarget(chosenNode, blocksize, maxNodesPerRack, results)) {
                results.add(chosenNode);
                return chosenNode;
            }
            badTarget = true;
        }
        String detail = enableDebugLogging;
        if (LOG.isDebugEnabled()) {
            if (badTarget && builder != null) {
                detail = builder.append("]").toString();
                builder.setLength(0);
            } else {
                detail = "";
            }
        }
        throw new BlockPlacementPolicy.NotEnoughReplicasException(detail);
    }

    private void chooseRandom(int numOfReplicas, String nodes, HashMap<Node, Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeDescriptor> results) throws BlockPlacementPolicy.NotEnoughReplicasException {
        int numOfAvailableNodes = this.clusterMap.countNumOfAvailableNodes(nodes, excludedNodes.keySet());
        StringBuilder builder = null;
        if (LOG.isDebugEnabled()) {
            builder = this.threadLocalBuilder.get();
            builder.setLength(0);
            builder.append("[");
        }
        boolean badTarget = false;
        while (numOfReplicas > 0 && numOfAvailableNodes > 0) {
            DatanodeDescriptor chosenNode = (DatanodeDescriptor)this.clusterMap.chooseRandom(nodes);
            Node oldNode = excludedNodes.put(chosenNode, chosenNode);
            if (oldNode != null) continue;
            --numOfAvailableNodes;
            if (this.isGoodTarget(chosenNode, blocksize, maxNodesPerRack, results)) {
                --numOfReplicas;
                results.add(chosenNode);
                continue;
            }
            badTarget = true;
        }
        if (numOfReplicas > 0) {
            String detail = enableDebugLogging;
            if (LOG.isDebugEnabled()) {
                if (badTarget && builder != null) {
                    detail = builder.append("]").toString();
                    builder.setLength(0);
                } else {
                    detail = "";
                }
            }
            throw new BlockPlacementPolicy.NotEnoughReplicasException(detail);
        }
    }

    private boolean isGoodTarget(DatanodeDescriptor node, long blockSize, int maxTargetPerLoc, List<DatanodeDescriptor> results) {
        return this.isGoodTarget(node, blockSize, maxTargetPerLoc, this.considerLoad, results);
    }

    private boolean isGoodTarget(DatanodeDescriptor node, long blockSize, int maxTargetPerLoc, boolean considerLoad, List<DatanodeDescriptor> results) {
        if (node.isDecommissionInProgress() || node.isDecommissioned()) {
            if (LOG.isDebugEnabled()) {
                this.threadLocalBuilder.get().append(node.toString()).append(": ").append("Node ").append(NodeBase.getPath((Node)node)).append(" is not chosen because the node is (being) decommissioned ");
            }
            return false;
        }
        long remaining = node.getRemaining() - (long)node.getBlocksScheduled() * blockSize;
        if (blockSize * (long)HdfsConstants.MIN_BLOCKS_FOR_WRITE > remaining) {
            if (LOG.isDebugEnabled()) {
                this.threadLocalBuilder.get().append(node.toString()).append(": ").append("Node ").append(NodeBase.getPath((Node)node)).append(" is not chosen because the node does not have enough space ");
            }
            return false;
        }
        if (considerLoad) {
            double avgLoad = 0.0;
            int size = this.clusterMap.getNumOfLeaves();
            if (size != 0 && this.stats != null) {
                avgLoad = (double)this.stats.getTotalLoad() / (double)size;
            }
            if ((double)node.getXceiverCount() > 2.0 * avgLoad) {
                if (LOG.isDebugEnabled()) {
                    this.threadLocalBuilder.get().append(node.toString()).append(": ").append("Node ").append(NodeBase.getPath((Node)node)).append(" is not chosen because the node is too busy ");
                }
                return false;
            }
        }
        String rackname = node.getNetworkLocation();
        int counter = 1;
        for (Node node2 : results) {
            if (!rackname.equals(node2.getNetworkLocation())) continue;
            ++counter;
        }
        if (counter > maxTargetPerLoc) {
            if (LOG.isDebugEnabled()) {
                this.threadLocalBuilder.get().append(node.toString()).append(": ").append("Node ").append(NodeBase.getPath((Node)node)).append(" is not chosen because the rack has too many chosen nodes ");
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatanodeDescriptor[] getPipeline(DatanodeDescriptor writer, DatanodeDescriptor[] nodes) {
        if (nodes.length == 0) {
            return nodes;
        }
        NetworkTopology networkTopology = this.clusterMap;
        synchronized (networkTopology) {
            int index = 0;
            if (writer == null || !this.clusterMap.contains((Node)writer)) {
                writer = nodes[0];
            }
            while (index < nodes.length) {
                DatanodeDescriptor shortestNode = nodes[index];
                int shortestDistance = this.clusterMap.getDistance((Node)writer, (Node)shortestNode);
                int shortestIndex = index;
                for (int i = index + 1; i < nodes.length; ++i) {
                    DatanodeDescriptor currentNode = nodes[i];
                    int currentDistance = this.clusterMap.getDistance((Node)writer, (Node)currentNode);
                    if (shortestDistance <= currentDistance) continue;
                    shortestDistance = currentDistance;
                    shortestNode = currentNode;
                    shortestIndex = i;
                }
                if (index != shortestIndex) {
                    nodes[shortestIndex] = nodes[index];
                    nodes[index] = shortestNode;
                }
                writer = shortestNode;
                ++index;
            }
        }
        return nodes;
    }

    @Override
    public int verifyBlockPlacement(String srcPath, LocatedBlock lBlk, int minRacks) {
        int numRacks;
        DatanodeInfo[] locs = lBlk.getLocations();
        if (locs == null) {
            locs = new DatanodeInfo[]{};
        }
        if ((numRacks = this.clusterMap.getNumOfRacks()) <= 1) {
            return 0;
        }
        minRacks = Math.min(minRacks, numRacks);
        TreeSet<String> racks = new TreeSet<String>();
        for (DatanodeInfo dn : locs) {
            racks.add(dn.getNetworkLocation());
        }
        return minRacks - racks.size();
    }

    @Override
    public DatanodeDescriptor chooseReplicaToDelete(BlockCollection bc, Block block, short replicationFactor, Collection<DatanodeDescriptor> first, Collection<DatanodeDescriptor> second) {
        Iterator<DatanodeDescriptor> iter;
        long minSpace = Long.MAX_VALUE;
        DatanodeDescriptor cur = null;
        Iterator<DatanodeDescriptor> iterator = iter = first.isEmpty() ? second.iterator() : first.iterator();
        while (iter.hasNext()) {
            DatanodeDescriptor node = iter.next();
            long free = node.getRemaining();
            if (minSpace <= free) continue;
            minSpace = free;
            cur = node;
        }
        return cur;
    }

    @VisibleForTesting
    void setPreferLocalNode(boolean prefer) {
        this.preferLocalNode = prefer;
    }
}

