/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DeprecatedUTF8;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageSerialization;
import org.apache.hadoop.hdfs.util.XMLUtils;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.PureJavaCrc32;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class FSEditLogOp {
    public final FSEditLogOpCodes opCode;
    long txid;
    private static final int MAX_OP_SIZE = 0x6400000;

    private FSEditLogOp(FSEditLogOpCodes opCode) {
        this.opCode = opCode;
        this.txid = -12345L;
    }

    public long getTransactionId() {
        Preconditions.checkState((this.txid != -12345L ? 1 : 0) != 0);
        return this.txid;
    }

    public String getTransactionIdStr() {
        return this.txid == -12345L ? "(none)" : "" + this.txid;
    }

    public boolean hasTransactionId() {
        return this.txid != -12345L;
    }

    public void setTransactionId(long txid) {
        this.txid = txid;
    }

    abstract void readFields(DataInputStream var1, int var2) throws IOException;

    public abstract void writeFields(DataOutputStream var1) throws IOException;

    private static short readShort(DataInputStream in) throws IOException {
        return Short.parseShort(FSImageSerialization.readString(in));
    }

    private static long readLong(DataInputStream in) throws IOException {
        return Long.parseLong(FSImageSerialization.readString(in));
    }

    public void outputToXml(ContentHandler contentHandler) throws SAXException {
        contentHandler.startElement("", "", "RECORD", new AttributesImpl());
        XMLUtils.addSaxString(contentHandler, "OPCODE", this.opCode.toString());
        contentHandler.startElement("", "", "DATA", new AttributesImpl());
        XMLUtils.addSaxString(contentHandler, "TXID", "" + this.txid);
        this.toXml(contentHandler);
        contentHandler.endElement("", "", "DATA");
        contentHandler.endElement("", "", "RECORD");
    }

    protected abstract void toXml(ContentHandler var1) throws SAXException;

    abstract void fromXml(XMLUtils.Stanza var1) throws XMLUtils.InvalidXmlException;

    public void decodeXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
        this.txid = Long.valueOf(st.getValue("TXID"));
        this.fromXml(st);
    }

    public static void blockToXml(ContentHandler contentHandler, Block block) throws SAXException {
        contentHandler.startElement("", "", "BLOCK", new AttributesImpl());
        XMLUtils.addSaxString(contentHandler, "BLOCK_ID", Long.valueOf(block.getBlockId()).toString());
        XMLUtils.addSaxString(contentHandler, "NUM_BYTES", Long.valueOf(block.getNumBytes()).toString());
        XMLUtils.addSaxString(contentHandler, "GENSTAMP", Long.valueOf(block.getGenerationStamp()).toString());
        contentHandler.endElement("", "", "BLOCK");
    }

    public static Block blockFromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
        long blockId = Long.valueOf(st.getValue("BLOCK_ID"));
        long numBytes = Long.valueOf(st.getValue("NUM_BYTES"));
        long generationStamp = Long.valueOf(st.getValue("GENSTAMP"));
        return new Block(blockId, numBytes, generationStamp);
    }

    public static void delegationTokenToXml(ContentHandler contentHandler, DelegationTokenIdentifier token) throws SAXException {
        contentHandler.startElement("", "", "DELEGATION_TOKEN_IDENTIFIER", new AttributesImpl());
        XMLUtils.addSaxString(contentHandler, "KIND", token.getKind().toString());
        XMLUtils.addSaxString(contentHandler, "SEQUENCE_NUMBER", Integer.valueOf(token.getSequenceNumber()).toString());
        XMLUtils.addSaxString(contentHandler, "OWNER", token.getOwner().toString());
        XMLUtils.addSaxString(contentHandler, "RENEWER", token.getRenewer().toString());
        XMLUtils.addSaxString(contentHandler, "REALUSER", token.getRealUser().toString());
        XMLUtils.addSaxString(contentHandler, "ISSUE_DATE", Long.valueOf(token.getIssueDate()).toString());
        XMLUtils.addSaxString(contentHandler, "MAX_DATE", Long.valueOf(token.getMaxDate()).toString());
        XMLUtils.addSaxString(contentHandler, "MASTER_KEY_ID", Integer.valueOf(token.getMasterKeyId()).toString());
        contentHandler.endElement("", "", "DELEGATION_TOKEN_IDENTIFIER");
    }

    public static DelegationTokenIdentifier delegationTokenFromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
        String kind = st.getValue("KIND");
        if (!kind.equals(DelegationTokenIdentifier.HDFS_DELEGATION_KIND.toString())) {
            throw new XMLUtils.InvalidXmlException("can't understand DelegationTokenIdentifier KIND " + kind);
        }
        int seqNum = Integer.valueOf(st.getValue("SEQUENCE_NUMBER"));
        String owner = st.getValue("OWNER");
        String renewer = st.getValue("RENEWER");
        String realuser = st.getValue("REALUSER");
        long issueDate = Long.valueOf(st.getValue("ISSUE_DATE"));
        long maxDate = Long.valueOf(st.getValue("MAX_DATE"));
        int masterKeyId = Integer.valueOf(st.getValue("MASTER_KEY_ID"));
        DelegationTokenIdentifier token = new DelegationTokenIdentifier(new Text(owner), new Text(renewer), new Text(realuser));
        token.setSequenceNumber(seqNum);
        token.setIssueDate(issueDate);
        token.setMaxDate(maxDate);
        token.setMasterKeyId(masterKeyId);
        return token;
    }

    public static void delegationKeyToXml(ContentHandler contentHandler, DelegationKey key) throws SAXException {
        contentHandler.startElement("", "", "DELEGATION_KEY", new AttributesImpl());
        XMLUtils.addSaxString(contentHandler, "KEY_ID", Integer.valueOf(key.getKeyId()).toString());
        XMLUtils.addSaxString(contentHandler, "EXPIRY_DATE", Long.valueOf(key.getExpiryDate()).toString());
        if (key.getEncodedKey() != null) {
            XMLUtils.addSaxString(contentHandler, "KEY", Hex.encodeHexString((byte[])key.getEncodedKey()));
        }
        contentHandler.endElement("", "", "DELEGATION_KEY");
    }

    public static DelegationKey delegationKeyFromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
        int keyId = Integer.valueOf(st.getValue("KEY_ID"));
        long expiryDate = Long.valueOf(st.getValue("EXPIRY_DATE"));
        byte[] key = null;
        try {
            key = Hex.decodeHex((char[])st.getValue("KEY").toCharArray());
        }
        catch (DecoderException e) {
            throw new XMLUtils.InvalidXmlException(e.toString());
        }
        catch (XMLUtils.InvalidXmlException e) {
            // empty catch block
        }
        return new DelegationKey(keyId, expiryDate, key);
    }

    public static void permissionStatusToXml(ContentHandler contentHandler, PermissionStatus perm) throws SAXException {
        contentHandler.startElement("", "", "PERMISSION_STATUS", new AttributesImpl());
        XMLUtils.addSaxString(contentHandler, "USERNAME", perm.getUserName());
        XMLUtils.addSaxString(contentHandler, "GROUPNAME", perm.getGroupName());
        XMLUtils.addSaxString(contentHandler, "MODE", Short.valueOf(perm.getPermission().toShort()).toString());
        contentHandler.endElement("", "", "PERMISSION_STATUS");
    }

    public static PermissionStatus permissionStatusFromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
        String username = st.getValue("USERNAME");
        String groupname = st.getValue("GROUPNAME");
        short mode = Short.valueOf(st.getValue("MODE"));
        return new PermissionStatus(username, groupname, new FsPermission(mode));
    }

    static class GarbageAfterTerminatorException
    extends IOException {
        private static final long serialVersionUID = 1L;
        private final long numAfterTerminator;

        public GarbageAfterTerminatorException(String str, long numAfterTerminator) {
            super(str);
            this.numAfterTerminator = numAfterTerminator;
        }

        public long getNumAfterTerminator() {
            return this.numAfterTerminator;
        }
    }

    public static class Reader {
        private final DataInputStream in;
        private final int logVersion;
        private final Checksum checksum;
        private final OpInstanceCache cache;

        public Reader(DataInputStream in, int logVersion) {
            this.logVersion = logVersion;
            this.checksum = LayoutVersion.supports(LayoutVersion.Feature.EDITS_CHESKUM, logVersion) ? new PureJavaCrc32() : null;
            this.in = this.checksum != null ? new DataInputStream(new CheckedInputStream(in, this.checksum)) : in;
            this.cache = new OpInstanceCache();
        }

        public FSEditLogOp readOp(boolean skipBrokenEdits) throws IOException {
            do {
                try {
                    this.in.mark(0x6400000);
                    return this.decodeOp();
                }
                catch (GarbageAfterTerminatorException e) {
                    this.in.reset();
                    if (!skipBrokenEdits) {
                        throw e;
                    }
                    long numSkip = e.getNumAfterTerminator();
                    if (this.in.skip(numSkip) >= numSkip) continue;
                    FSImage.LOG.error((Object)("Failed to skip " + numSkip + " bytes of " + "garbage after an OP_INVALID.  Unexpected early EOF."));
                    return null;
                }
                catch (IOException e) {
                    this.in.reset();
                    if (skipBrokenEdits) continue;
                    throw e;
                }
                catch (RuntimeException e) {
                    this.in.reset();
                    if (skipBrokenEdits) continue;
                    throw e;
                }
                catch (Throwable e) {
                    this.in.reset();
                    if (skipBrokenEdits) continue;
                    throw new IOException("got unexpected exception " + e.getMessage(), e);
                }
            } while (this.in.skip(1L) >= 1L);
            return null;
        }

        private void verifyTerminator() throws IOException {
            long off = 0L;
            byte[] buf = new byte[4096];
            int numRead;
            block0: while ((numRead = this.in.read(buf)) != -1) {
                int i = 0;
                while (true) {
                    if (i >= numRead) continue block0;
                    if (buf[i] != 0 && buf[i] != -1) {
                        throw new GarbageAfterTerminatorException("Read garbage after the terminator!", off);
                    }
                    ++i;
                    ++off;
                }
                break;
            }
            return;
        }

        private FSEditLogOp decodeOp() throws IOException {
            byte opCodeByte;
            if (this.checksum != null) {
                this.checksum.reset();
            }
            try {
                opCodeByte = this.in.readByte();
            }
            catch (EOFException eof) {
                return null;
            }
            FSEditLogOpCodes opCode = FSEditLogOpCodes.fromByte(opCodeByte);
            if (opCode == FSEditLogOpCodes.OP_INVALID) {
                this.verifyTerminator();
                return null;
            }
            FSEditLogOp op = this.cache.get(opCode);
            if (op == null) {
                throw new IOException("Read invalid opcode " + (Object)((Object)opCode));
            }
            if (LayoutVersion.supports(LayoutVersion.Feature.STORED_TXIDS, this.logVersion)) {
                op.setTransactionId(this.in.readLong());
            } else {
                op.setTransactionId(-12345L);
            }
            op.readFields(this.in, this.logVersion);
            this.validateChecksum(this.in, this.checksum, op.txid);
            return op;
        }

        private void validateChecksum(DataInputStream in, Checksum checksum, long txid) throws IOException {
            if (checksum != null) {
                int calculatedChecksum = (int)checksum.getValue();
                int readChecksum = in.readInt();
                if (readChecksum != calculatedChecksum) {
                    throw new ChecksumException("Transaction is corrupt. Calculated checksum is " + calculatedChecksum + " but read checksum " + readChecksum, txid);
                }
            }
        }
    }

    public static class Writer {
        private final DataOutputBuffer buf;
        private final Checksum checksum;

        public Writer(DataOutputBuffer out) {
            this.buf = out;
            this.checksum = new PureJavaCrc32();
        }

        public void writeOp(FSEditLogOp op) throws IOException {
            int start = this.buf.getLength();
            this.buf.writeByte((int)op.opCode.getOpCode());
            this.buf.writeLong(op.txid);
            op.writeFields((DataOutputStream)this.buf);
            int end = this.buf.getLength();
            this.checksum.reset();
            this.checksum.update(this.buf.getData(), start, end - start);
            int sum = (int)this.checksum.getValue();
            this.buf.writeInt(sum);
        }
    }

    static class BlockTwo
    implements Writable {
        long blkid = 0L;
        long len = 0L;

        BlockTwo() {
        }

        public void write(DataOutput out) throws IOException {
            out.writeLong(this.blkid);
            out.writeLong(this.len);
        }

        public void readFields(DataInput in) throws IOException {
            this.blkid = in.readLong();
            this.len = in.readLong();
        }

        static {
            WritableFactories.setFactory(BlockTwo.class, (WritableFactory)new WritableFactory(){

                public Writable newInstance() {
                    return new BlockTwo();
                }
            });
        }
    }

    static class InvalidOp
    extends FSEditLogOp {
        private InvalidOp() {
            super(FSEditLogOpCodes.OP_INVALID);
        }

        static InvalidOp getInstance(OpInstanceCache cache) {
            return (InvalidOp)cache.get(FSEditLogOpCodes.OP_INVALID);
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("InvalidOp [opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
        }
    }

    static class LogSegmentOp
    extends FSEditLogOp {
        private LogSegmentOp(FSEditLogOpCodes code) {
            super(code);
            assert (code == FSEditLogOpCodes.OP_START_LOG_SEGMENT || code == FSEditLogOpCodes.OP_END_LOG_SEGMENT) : "Bad op: " + (Object)((Object)code);
        }

        static LogSegmentOp getInstance(OpInstanceCache cache, FSEditLogOpCodes code) {
            return (LogSegmentOp)cache.get(code);
        }

        @Override
        public void readFields(DataInputStream in, int logVersion) throws IOException {
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("LogSegmentOp [opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
        }
    }

    static class UpdateMasterKeyOp
    extends FSEditLogOp {
        DelegationKey key;

        private UpdateMasterKeyOp() {
            super(FSEditLogOpCodes.OP_UPDATE_MASTER_KEY);
        }

        static UpdateMasterKeyOp getInstance(OpInstanceCache cache) {
            return (UpdateMasterKeyOp)cache.get(FSEditLogOpCodes.OP_UPDATE_MASTER_KEY);
        }

        UpdateMasterKeyOp setDelegationKey(DelegationKey key) {
            this.key = key;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            this.key.write((DataOutput)out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.key = new DelegationKey();
            this.key.readFields((DataInput)in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("UpdateMasterKeyOp [key=");
            builder.append(this.key);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            FSEditLogOp.delegationKeyToXml(contentHandler, this.key);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.key = UpdateMasterKeyOp.delegationKeyFromXml(st.getChildren("DELEGATION_KEY").get(0));
        }
    }

    static class CancelDelegationTokenOp
    extends FSEditLogOp {
        DelegationTokenIdentifier token;

        private CancelDelegationTokenOp() {
            super(FSEditLogOpCodes.OP_CANCEL_DELEGATION_TOKEN);
        }

        static CancelDelegationTokenOp getInstance(OpInstanceCache cache) {
            return (CancelDelegationTokenOp)cache.get(FSEditLogOpCodes.OP_CANCEL_DELEGATION_TOKEN);
        }

        CancelDelegationTokenOp setDelegationTokenIdentifier(DelegationTokenIdentifier token) {
            this.token = token;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            this.token.write(out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.token = new DelegationTokenIdentifier();
            this.token.readFields(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("CancelDelegationTokenOp [token=");
            builder.append((Object)this.token);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            FSEditLogOp.delegationTokenToXml(contentHandler, this.token);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.token = CancelDelegationTokenOp.delegationTokenFromXml(st.getChildren("DELEGATION_TOKEN_IDENTIFIER").get(0));
        }
    }

    static class RenewDelegationTokenOp
    extends FSEditLogOp {
        DelegationTokenIdentifier token;
        long expiryTime;

        private RenewDelegationTokenOp() {
            super(FSEditLogOpCodes.OP_RENEW_DELEGATION_TOKEN);
        }

        static RenewDelegationTokenOp getInstance(OpInstanceCache cache) {
            return (RenewDelegationTokenOp)cache.get(FSEditLogOpCodes.OP_RENEW_DELEGATION_TOKEN);
        }

        RenewDelegationTokenOp setDelegationTokenIdentifier(DelegationTokenIdentifier token) {
            this.token = token;
            return this;
        }

        RenewDelegationTokenOp setExpiryTime(long expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            this.token.write(out);
            FSImageSerialization.writeLong(this.expiryTime, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.token = new DelegationTokenIdentifier();
            this.token.readFields(in);
            this.expiryTime = LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RenewDelegationTokenOp [token=");
            builder.append((Object)this.token);
            builder.append(", expiryTime=");
            builder.append(this.expiryTime);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            FSEditLogOp.delegationTokenToXml(contentHandler, this.token);
            XMLUtils.addSaxString(contentHandler, "EXPIRY_TIME", Long.valueOf(this.expiryTime).toString());
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.token = RenewDelegationTokenOp.delegationTokenFromXml(st.getChildren("DELEGATION_TOKEN_IDENTIFIER").get(0));
            this.expiryTime = Long.valueOf(st.getValue("EXPIRY_TIME"));
        }
    }

    static class GetDelegationTokenOp
    extends FSEditLogOp {
        DelegationTokenIdentifier token;
        long expiryTime;

        private GetDelegationTokenOp() {
            super(FSEditLogOpCodes.OP_GET_DELEGATION_TOKEN);
        }

        static GetDelegationTokenOp getInstance(OpInstanceCache cache) {
            return (GetDelegationTokenOp)cache.get(FSEditLogOpCodes.OP_GET_DELEGATION_TOKEN);
        }

        GetDelegationTokenOp setDelegationTokenIdentifier(DelegationTokenIdentifier token) {
            this.token = token;
            return this;
        }

        GetDelegationTokenOp setExpiryTime(long expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            this.token.write(out);
            FSImageSerialization.writeLong(this.expiryTime, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.token = new DelegationTokenIdentifier();
            this.token.readFields(in);
            this.expiryTime = LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("GetDelegationTokenOp [token=");
            builder.append((Object)this.token);
            builder.append(", expiryTime=");
            builder.append(this.expiryTime);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            FSEditLogOp.delegationTokenToXml(contentHandler, this.token);
            XMLUtils.addSaxString(contentHandler, "EXPIRY_TIME", Long.valueOf(this.expiryTime).toString());
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.token = GetDelegationTokenOp.delegationTokenFromXml(st.getChildren("DELEGATION_TOKEN_IDENTIFIER").get(0));
            this.expiryTime = Long.valueOf(st.getValue("EXPIRY_TIME"));
        }
    }

    static class ReassignLeaseOp
    extends FSEditLogOp {
        String leaseHolder;
        String path;
        String newHolder;

        private ReassignLeaseOp() {
            super(FSEditLogOpCodes.OP_REASSIGN_LEASE);
        }

        static ReassignLeaseOp getInstance(OpInstanceCache cache) {
            return (ReassignLeaseOp)cache.get(FSEditLogOpCodes.OP_REASSIGN_LEASE);
        }

        ReassignLeaseOp setLeaseHolder(String leaseHolder) {
            this.leaseHolder = leaseHolder;
            return this;
        }

        ReassignLeaseOp setPath(String path) {
            this.path = path;
            return this;
        }

        ReassignLeaseOp setNewHolder(String newHolder) {
            this.newHolder = newHolder;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.leaseHolder, out);
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeString(this.newHolder, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.leaseHolder = FSImageSerialization.readString(in);
            this.path = FSImageSerialization.readString(in);
            this.newHolder = FSImageSerialization.readString(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ReassignLeaseOp [leaseHolder=");
            builder.append(this.leaseHolder);
            builder.append(", path=");
            builder.append(this.path);
            builder.append(", newHolder=");
            builder.append(this.newHolder);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "LEASEHOLDER", this.leaseHolder);
            XMLUtils.addSaxString(contentHandler, "PATH", this.path);
            XMLUtils.addSaxString(contentHandler, "NEWHOLDER", this.newHolder);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.leaseHolder = st.getValue("LEASEHOLDER");
            this.path = st.getValue("PATH");
            this.newHolder = st.getValue("NEWHOLDER");
        }
    }

    static class RenameOp
    extends FSEditLogOp {
        int length;
        String src;
        String dst;
        long timestamp;
        Options.Rename[] options;

        private RenameOp() {
            super(FSEditLogOpCodes.OP_RENAME);
        }

        static RenameOp getInstance(OpInstanceCache cache) {
            return (RenameOp)cache.get(FSEditLogOpCodes.OP_RENAME);
        }

        RenameOp setSource(String src) {
            this.src = src;
            return this;
        }

        RenameOp setDestination(String dst) {
            this.dst = dst;
            return this;
        }

        RenameOp setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        RenameOp setOptions(Options.Rename[] options) {
            this.options = options;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.src, out);
            FSImageSerialization.writeString(this.dst, out);
            FSImageSerialization.writeLong(this.timestamp, out);
            RenameOp.toBytesWritable(this.options).write((DataOutput)out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            if (!LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.length = in.readInt();
                if (this.length != 3) {
                    throw new IOException("Incorrect data format. Rename operation.");
                }
            }
            this.src = FSImageSerialization.readString(in);
            this.dst = FSImageSerialization.readString(in);
            this.timestamp = LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in);
            this.options = RenameOp.readRenameOptions(in);
        }

        private static Options.Rename[] readRenameOptions(DataInputStream in) throws IOException {
            BytesWritable writable = new BytesWritable();
            writable.readFields((DataInput)in);
            byte[] bytes = writable.getBytes();
            Options.Rename[] options = new Options.Rename[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                options[i] = Options.Rename.valueOf((byte)bytes[i]);
            }
            return options;
        }

        static BytesWritable toBytesWritable(Options.Rename ... options) {
            byte[] bytes = new byte[options.length];
            for (int i = 0; i < options.length; ++i) {
                bytes[i] = options[i].value();
            }
            return new BytesWritable(bytes);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RenameOp [length=");
            builder.append(this.length);
            builder.append(", src=");
            builder.append(this.src);
            builder.append(", dst=");
            builder.append(this.dst);
            builder.append(", timestamp=");
            builder.append(this.timestamp);
            builder.append(", options=");
            builder.append(Arrays.toString(this.options));
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "LENGTH", Integer.valueOf(this.length).toString());
            XMLUtils.addSaxString(contentHandler, "SRC", this.src);
            XMLUtils.addSaxString(contentHandler, "DST", this.dst);
            XMLUtils.addSaxString(contentHandler, "TIMESTAMP", Long.valueOf(this.timestamp).toString());
            StringBuilder bld = new StringBuilder();
            String prefix = "";
            for (Options.Rename r : this.options) {
                bld.append(prefix).append(r.toString());
                prefix = "|";
            }
            XMLUtils.addSaxString(contentHandler, "OPTIONS", bld.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.length = Integer.valueOf(st.getValue("LENGTH"));
            this.src = st.getValue("SRC");
            this.dst = st.getValue("DST");
            this.timestamp = Long.valueOf(st.getValue("TIMESTAMP"));
            String opts = st.getValue("OPTIONS");
            String[] o = opts.split("\\|");
            this.options = new Options.Rename[o.length];
            for (int i = 0; i < o.length; ++i) {
                if (o[i].equals("")) continue;
                try {
                    this.options[i] = Options.Rename.valueOf((String)o[i]);
                    continue;
                }
                finally {
                    if (this.options[i] == null) {
                        System.err.println("error parsing Rename value: \"" + o[i] + "\"");
                    }
                }
            }
        }
    }

    static class SymlinkOp
    extends FSEditLogOp {
        int length;
        String path;
        String value;
        long mtime;
        long atime;
        PermissionStatus permissionStatus;

        private SymlinkOp() {
            super(FSEditLogOpCodes.OP_SYMLINK);
        }

        static SymlinkOp getInstance(OpInstanceCache cache) {
            return (SymlinkOp)cache.get(FSEditLogOpCodes.OP_SYMLINK);
        }

        SymlinkOp setPath(String path) {
            this.path = path;
            return this;
        }

        SymlinkOp setValue(String value) {
            this.value = value;
            return this;
        }

        SymlinkOp setModificationTime(long mtime) {
            this.mtime = mtime;
            return this;
        }

        SymlinkOp setAccessTime(long atime) {
            this.atime = atime;
            return this;
        }

        SymlinkOp setPermissionStatus(PermissionStatus permissionStatus) {
            this.permissionStatus = permissionStatus;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeString(this.value, out);
            FSImageSerialization.writeLong(this.mtime, out);
            FSImageSerialization.writeLong(this.atime, out);
            this.permissionStatus.write((DataOutput)out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            if (!LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.length = in.readInt();
                if (this.length != 4) {
                    throw new IOException("Incorrect data format. symlink operation.");
                }
            }
            this.path = FSImageSerialization.readString(in);
            this.value = FSImageSerialization.readString(in);
            if (LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.mtime = FSImageSerialization.readLong(in);
                this.atime = FSImageSerialization.readLong(in);
            } else {
                this.mtime = FSEditLogOp.readLong(in);
                this.atime = FSEditLogOp.readLong(in);
            }
            this.permissionStatus = PermissionStatus.read((DataInput)in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SymlinkOp [length=");
            builder.append(this.length);
            builder.append(", path=");
            builder.append(this.path);
            builder.append(", value=");
            builder.append(this.value);
            builder.append(", mtime=");
            builder.append(this.mtime);
            builder.append(", atime=");
            builder.append(this.atime);
            builder.append(", permissionStatus=");
            builder.append(this.permissionStatus);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "LENGTH", Integer.valueOf(this.length).toString());
            XMLUtils.addSaxString(contentHandler, "PATH", this.path);
            XMLUtils.addSaxString(contentHandler, "VALUE", this.value);
            XMLUtils.addSaxString(contentHandler, "MTIME", Long.valueOf(this.mtime).toString());
            XMLUtils.addSaxString(contentHandler, "ATIME", Long.valueOf(this.atime).toString());
            FSEditLogOp.permissionStatusToXml(contentHandler, this.permissionStatus);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.length = Integer.valueOf(st.getValue("LENGTH"));
            this.path = st.getValue("PATH");
            this.value = st.getValue("VALUE");
            this.mtime = Long.valueOf(st.getValue("MTIME"));
            this.atime = Long.valueOf(st.getValue("ATIME"));
            this.permissionStatus = SymlinkOp.permissionStatusFromXml(st.getChildren("PERMISSION_STATUS").get(0));
        }
    }

    static class TimesOp
    extends FSEditLogOp {
        int length;
        String path;
        long mtime;
        long atime;

        private TimesOp() {
            super(FSEditLogOpCodes.OP_TIMES);
        }

        static TimesOp getInstance(OpInstanceCache cache) {
            return (TimesOp)cache.get(FSEditLogOpCodes.OP_TIMES);
        }

        TimesOp setPath(String path) {
            this.path = path;
            return this;
        }

        TimesOp setModificationTime(long mtime) {
            this.mtime = mtime;
            return this;
        }

        TimesOp setAccessTime(long atime) {
            this.atime = atime;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeLong(this.mtime, out);
            FSImageSerialization.writeLong(this.atime, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            if (!LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.length = in.readInt();
                if (this.length != 3) {
                    throw new IOException("Incorrect data format. times operation.");
                }
            }
            this.path = FSImageSerialization.readString(in);
            if (LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.mtime = FSImageSerialization.readLong(in);
                this.atime = FSImageSerialization.readLong(in);
            } else {
                this.mtime = FSEditLogOp.readLong(in);
                this.atime = FSEditLogOp.readLong(in);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("TimesOp [length=");
            builder.append(this.length);
            builder.append(", path=");
            builder.append(this.path);
            builder.append(", mtime=");
            builder.append(this.mtime);
            builder.append(", atime=");
            builder.append(this.atime);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "LENGTH", Integer.valueOf(this.length).toString());
            XMLUtils.addSaxString(contentHandler, "PATH", this.path);
            XMLUtils.addSaxString(contentHandler, "MTIME", Long.valueOf(this.mtime).toString());
            XMLUtils.addSaxString(contentHandler, "ATIME", Long.valueOf(this.atime).toString());
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.length = Integer.valueOf(st.getValue("LENGTH"));
            this.path = st.getValue("PATH");
            this.mtime = Long.valueOf(st.getValue("MTIME"));
            this.atime = Long.valueOf(st.getValue("ATIME"));
        }
    }

    static class SetQuotaOp
    extends FSEditLogOp {
        String src;
        long nsQuota;
        long dsQuota;

        private SetQuotaOp() {
            super(FSEditLogOpCodes.OP_SET_QUOTA);
        }

        static SetQuotaOp getInstance(OpInstanceCache cache) {
            return (SetQuotaOp)cache.get(FSEditLogOpCodes.OP_SET_QUOTA);
        }

        SetQuotaOp setSource(String src) {
            this.src = src;
            return this;
        }

        SetQuotaOp setNSQuota(long nsQuota) {
            this.nsQuota = nsQuota;
            return this;
        }

        SetQuotaOp setDSQuota(long dsQuota) {
            this.dsQuota = dsQuota;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.src, out);
            FSImageSerialization.writeLong(this.nsQuota, out);
            FSImageSerialization.writeLong(this.dsQuota, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.src = FSImageSerialization.readString(in);
            this.nsQuota = FSImageSerialization.readLong(in);
            this.dsQuota = FSImageSerialization.readLong(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SetQuotaOp [src=");
            builder.append(this.src);
            builder.append(", nsQuota=");
            builder.append(this.nsQuota);
            builder.append(", dsQuota=");
            builder.append(this.dsQuota);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "SRC", this.src);
            XMLUtils.addSaxString(contentHandler, "NSQUOTA", Long.valueOf(this.nsQuota).toString());
            XMLUtils.addSaxString(contentHandler, "DSQUOTA", Long.valueOf(this.dsQuota).toString());
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.src = st.getValue("SRC");
            this.nsQuota = Long.valueOf(st.getValue("NSQUOTA"));
            this.dsQuota = Long.valueOf(st.getValue("DSQUOTA"));
        }
    }

    static class ClearNSQuotaOp
    extends FSEditLogOp {
        String src;

        private ClearNSQuotaOp() {
            super(FSEditLogOpCodes.OP_CLEAR_NS_QUOTA);
        }

        static ClearNSQuotaOp getInstance(OpInstanceCache cache) {
            return (ClearNSQuotaOp)cache.get(FSEditLogOpCodes.OP_CLEAR_NS_QUOTA);
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            throw new IOException("Deprecated");
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.src = FSImageSerialization.readString(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ClearNSQuotaOp [src=");
            builder.append(this.src);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "SRC", this.src);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.src = st.getValue("SRC");
        }
    }

    static class SetNSQuotaOp
    extends FSEditLogOp {
        String src;
        long nsQuota;

        private SetNSQuotaOp() {
            super(FSEditLogOpCodes.OP_SET_NS_QUOTA);
        }

        static SetNSQuotaOp getInstance(OpInstanceCache cache) {
            return (SetNSQuotaOp)cache.get(FSEditLogOpCodes.OP_SET_NS_QUOTA);
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            throw new IOException("Deprecated");
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.src = FSImageSerialization.readString(in);
            this.nsQuota = FSImageSerialization.readLong(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SetNSQuotaOp [src=");
            builder.append(this.src);
            builder.append(", nsQuota=");
            builder.append(this.nsQuota);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "SRC", this.src);
            XMLUtils.addSaxString(contentHandler, "NSQUOTA", Long.valueOf(this.nsQuota).toString());
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.src = st.getValue("SRC");
            this.nsQuota = Long.valueOf(st.getValue("NSQUOTA"));
        }
    }

    static class SetOwnerOp
    extends FSEditLogOp {
        String src;
        String username;
        String groupname;

        private SetOwnerOp() {
            super(FSEditLogOpCodes.OP_SET_OWNER);
        }

        static SetOwnerOp getInstance(OpInstanceCache cache) {
            return (SetOwnerOp)cache.get(FSEditLogOpCodes.OP_SET_OWNER);
        }

        SetOwnerOp setSource(String src) {
            this.src = src;
            return this;
        }

        SetOwnerOp setUser(String username) {
            this.username = username;
            return this;
        }

        SetOwnerOp setGroup(String groupname) {
            this.groupname = groupname;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.src, out);
            FSImageSerialization.writeString(this.username == null ? "" : this.username, out);
            FSImageSerialization.writeString(this.groupname == null ? "" : this.groupname, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.src = FSImageSerialization.readString(in);
            this.username = FSImageSerialization.readString_EmptyAsNull(in);
            this.groupname = FSImageSerialization.readString_EmptyAsNull(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SetOwnerOp [src=");
            builder.append(this.src);
            builder.append(", username=");
            builder.append(this.username);
            builder.append(", groupname=");
            builder.append(this.groupname);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "SRC", this.src);
            if (this.username != null) {
                XMLUtils.addSaxString(contentHandler, "USERNAME", this.username);
            }
            if (this.groupname != null) {
                XMLUtils.addSaxString(contentHandler, "GROUPNAME", this.groupname);
            }
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.src = st.getValue("SRC");
            this.username = st.hasChildren("USERNAME") ? st.getValue("USERNAME") : null;
            this.groupname = st.hasChildren("GROUPNAME") ? st.getValue("GROUPNAME") : null;
        }
    }

    static class SetPermissionsOp
    extends FSEditLogOp {
        String src;
        FsPermission permissions;

        private SetPermissionsOp() {
            super(FSEditLogOpCodes.OP_SET_PERMISSIONS);
        }

        static SetPermissionsOp getInstance(OpInstanceCache cache) {
            return (SetPermissionsOp)cache.get(FSEditLogOpCodes.OP_SET_PERMISSIONS);
        }

        SetPermissionsOp setSource(String src) {
            this.src = src;
            return this;
        }

        SetPermissionsOp setPermissions(FsPermission permissions) {
            this.permissions = permissions;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.src, out);
            this.permissions.write((DataOutput)out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.src = FSImageSerialization.readString(in);
            this.permissions = FsPermission.read((DataInput)in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SetPermissionsOp [src=");
            builder.append(this.src);
            builder.append(", permissions=");
            builder.append(this.permissions);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "SRC", this.src);
            XMLUtils.addSaxString(contentHandler, "MODE", Short.valueOf(this.permissions.toShort()).toString());
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.src = st.getValue("SRC");
            this.permissions = new FsPermission(Short.valueOf(st.getValue("MODE")).shortValue());
        }
    }

    static class SetGenstampOp
    extends FSEditLogOp {
        long genStamp;

        private SetGenstampOp() {
            super(FSEditLogOpCodes.OP_SET_GENSTAMP);
        }

        static SetGenstampOp getInstance(OpInstanceCache cache) {
            return (SetGenstampOp)cache.get(FSEditLogOpCodes.OP_SET_GENSTAMP);
        }

        SetGenstampOp setGenerationStamp(long genStamp) {
            this.genStamp = genStamp;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeLong(this.genStamp, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.genStamp = FSImageSerialization.readLong(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SetGenstampOp [genStamp=");
            builder.append(this.genStamp);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "GENSTAMP", Long.valueOf(this.genStamp).toString());
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.genStamp = Long.valueOf(st.getValue("GENSTAMP"));
        }
    }

    static class MkdirOp
    extends FSEditLogOp {
        int length;
        String path;
        long timestamp;
        PermissionStatus permissions;

        private MkdirOp() {
            super(FSEditLogOpCodes.OP_MKDIR);
        }

        static MkdirOp getInstance(OpInstanceCache cache) {
            return (MkdirOp)cache.get(FSEditLogOpCodes.OP_MKDIR);
        }

        MkdirOp setPath(String path) {
            this.path = path;
            return this;
        }

        MkdirOp setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        MkdirOp setPermissionStatus(PermissionStatus permissions) {
            this.permissions = permissions;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeLong(this.timestamp, out);
            FSImageSerialization.writeLong(this.timestamp, out);
            this.permissions.write((DataOutput)out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            if (!LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.length = in.readInt();
            }
            if (-17 < logVersion && this.length != 2 || logVersion <= -17 && this.length != 3 && !LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                throw new IOException("Incorrect data format. Mkdir operation.");
            }
            this.path = FSImageSerialization.readString(in);
            this.timestamp = LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in);
            if (LayoutVersion.supports(LayoutVersion.Feature.FILE_ACCESS_TIME, logVersion)) {
                if (LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                    FSImageSerialization.readLong(in);
                } else {
                    FSEditLogOp.readLong(in);
                }
            }
            this.permissions = PermissionStatus.read((DataInput)in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MkdirOp [length=");
            builder.append(this.length);
            builder.append(", path=");
            builder.append(this.path);
            builder.append(", timestamp=");
            builder.append(this.timestamp);
            builder.append(", permissions=");
            builder.append(this.permissions);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "LENGTH", Integer.valueOf(this.length).toString());
            XMLUtils.addSaxString(contentHandler, "PATH", this.path);
            XMLUtils.addSaxString(contentHandler, "TIMESTAMP", Long.valueOf(this.timestamp).toString());
            FSEditLogOp.permissionStatusToXml(contentHandler, this.permissions);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.length = Integer.valueOf(st.getValue("LENGTH"));
            this.path = st.getValue("PATH");
            this.timestamp = Long.valueOf(st.getValue("TIMESTAMP"));
            this.permissions = MkdirOp.permissionStatusFromXml(st.getChildren("PERMISSION_STATUS").get(0));
        }
    }

    static class DeleteOp
    extends FSEditLogOp {
        int length;
        String path;
        long timestamp;

        private DeleteOp() {
            super(FSEditLogOpCodes.OP_DELETE);
        }

        static DeleteOp getInstance(OpInstanceCache cache) {
            return (DeleteOp)cache.get(FSEditLogOpCodes.OP_DELETE);
        }

        DeleteOp setPath(String path) {
            this.path = path;
            return this;
        }

        DeleteOp setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeLong(this.timestamp, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            if (!LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.length = in.readInt();
                if (this.length != 2) {
                    throw new IOException("Incorrect data format. delete operation.");
                }
            }
            this.path = FSImageSerialization.readString(in);
            this.timestamp = LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DeleteOp [length=");
            builder.append(this.length);
            builder.append(", path=");
            builder.append(this.path);
            builder.append(", timestamp=");
            builder.append(this.timestamp);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "LENGTH", Integer.valueOf(this.length).toString());
            XMLUtils.addSaxString(contentHandler, "PATH", this.path);
            XMLUtils.addSaxString(contentHandler, "TIMESTAMP", Long.valueOf(this.timestamp).toString());
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.length = Integer.valueOf(st.getValue("LENGTH"));
            this.path = st.getValue("PATH");
            this.timestamp = Long.valueOf(st.getValue("TIMESTAMP"));
        }
    }

    static class RenameOldOp
    extends FSEditLogOp {
        int length;
        String src;
        String dst;
        long timestamp;

        private RenameOldOp() {
            super(FSEditLogOpCodes.OP_RENAME_OLD);
        }

        static RenameOldOp getInstance(OpInstanceCache cache) {
            return (RenameOldOp)cache.get(FSEditLogOpCodes.OP_RENAME_OLD);
        }

        RenameOldOp setSource(String src) {
            this.src = src;
            return this;
        }

        RenameOldOp setDestination(String dst) {
            this.dst = dst;
            return this;
        }

        RenameOldOp setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.src, out);
            FSImageSerialization.writeString(this.dst, out);
            FSImageSerialization.writeLong(this.timestamp, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            if (!LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.length = in.readInt();
                if (this.length != 3) {
                    throw new IOException("Incorrect data format. Old rename operation.");
                }
            }
            this.src = FSImageSerialization.readString(in);
            this.dst = FSImageSerialization.readString(in);
            this.timestamp = LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RenameOldOp [length=");
            builder.append(this.length);
            builder.append(", src=");
            builder.append(this.src);
            builder.append(", dst=");
            builder.append(this.dst);
            builder.append(", timestamp=");
            builder.append(this.timestamp);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "LENGTH", Integer.valueOf(this.length).toString());
            XMLUtils.addSaxString(contentHandler, "SRC", this.src);
            XMLUtils.addSaxString(contentHandler, "DST", this.dst);
            XMLUtils.addSaxString(contentHandler, "TIMESTAMP", Long.valueOf(this.timestamp).toString());
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.length = Integer.valueOf(st.getValue("LENGTH"));
            this.src = st.getValue("SRC");
            this.dst = st.getValue("DST");
            this.timestamp = Long.valueOf(st.getValue("TIMESTAMP"));
        }
    }

    static class ConcatDeleteOp
    extends FSEditLogOp {
        int length;
        String trg;
        String[] srcs;
        long timestamp;
        public static final int MAX_CONCAT_SRC = 0x100000;

        private ConcatDeleteOp() {
            super(FSEditLogOpCodes.OP_CONCAT_DELETE);
        }

        static ConcatDeleteOp getInstance(OpInstanceCache cache) {
            return (ConcatDeleteOp)cache.get(FSEditLogOpCodes.OP_CONCAT_DELETE);
        }

        ConcatDeleteOp setTarget(String trg) {
            this.trg = trg;
            return this;
        }

        ConcatDeleteOp setSources(String[] srcs) {
            if (srcs.length > 0x100000) {
                throw new RuntimeException("ConcatDeleteOp can only have 1048576 sources at most.");
            }
            this.srcs = srcs;
            return this;
        }

        ConcatDeleteOp setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.trg, out);
            DeprecatedUTF8[] info = new DeprecatedUTF8[this.srcs.length];
            int idx = 0;
            for (int i = 0; i < this.srcs.length; ++i) {
                info[idx++] = new DeprecatedUTF8(this.srcs[i]);
            }
            new ArrayWritable(DeprecatedUTF8.class, (Writable[])info).write((DataOutput)out);
            FSImageSerialization.writeLong(this.timestamp, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            if (!LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.length = in.readInt();
                if (this.length < 3) {
                    throw new IOException("Incorrect data format for ConcatDeleteOp.");
                }
            }
            this.trg = FSImageSerialization.readString(in);
            int srcSize = 0;
            srcSize = LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? in.readInt() : this.length - 1 - 1;
            if (srcSize < 0) {
                throw new IOException("Incorrect data format. ConcatDeleteOp cannot have a negative number of data  sources.");
            }
            if (srcSize > 0x100000) {
                throw new IOException("Incorrect data format. ConcatDeleteOp can have at most 1048576 sources, but we tried to have " + (this.length - 3) + " sources.");
            }
            this.srcs = new String[srcSize];
            for (int i = 0; i < srcSize; ++i) {
                this.srcs[i] = FSImageSerialization.readString(in);
            }
            this.timestamp = LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ConcatDeleteOp [length=");
            builder.append(this.length);
            builder.append(", trg=");
            builder.append(this.trg);
            builder.append(", srcs=");
            builder.append(Arrays.toString(this.srcs));
            builder.append(", timestamp=");
            builder.append(this.timestamp);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "LENGTH", Integer.valueOf(this.length).toString());
            XMLUtils.addSaxString(contentHandler, "TRG", this.trg);
            XMLUtils.addSaxString(contentHandler, "TIMESTAMP", Long.valueOf(this.timestamp).toString());
            contentHandler.startElement("", "", "SOURCES", new AttributesImpl());
            for (int i = 0; i < this.srcs.length; ++i) {
                XMLUtils.addSaxString(contentHandler, "SOURCE" + (i + 1), this.srcs[i]);
            }
            contentHandler.endElement("", "", "SOURCES");
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.length = Integer.valueOf(st.getValue("LENGTH"));
            this.trg = st.getValue("TRG");
            this.timestamp = Long.valueOf(st.getValue("TIMESTAMP"));
            List<XMLUtils.Stanza> sources = st.getChildren("SOURCES");
            int i = 0;
            while (sources.get(0).hasChildren("SOURCE" + (i + 1))) {
                ++i;
            }
            this.srcs = new String[i];
            for (i = 0; i < this.srcs.length; ++i) {
                this.srcs[i] = sources.get(0).getValue("SOURCE" + (i + 1));
            }
        }
    }

    static class SetReplicationOp
    extends FSEditLogOp {
        String path;
        short replication;

        private SetReplicationOp() {
            super(FSEditLogOpCodes.OP_SET_REPLICATION);
        }

        static SetReplicationOp getInstance(OpInstanceCache cache) {
            return (SetReplicationOp)cache.get(FSEditLogOpCodes.OP_SET_REPLICATION);
        }

        SetReplicationOp setPath(String path) {
            this.path = path;
            return this;
        }

        SetReplicationOp setReplication(short replication) {
            this.replication = replication;
            return this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeShort(this.replication, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.path = FSImageSerialization.readString(in);
            this.replication = LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readShort(in) : FSEditLogOp.readShort(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SetReplicationOp [path=");
            builder.append(this.path);
            builder.append(", replication=");
            builder.append(this.replication);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "PATH", this.path);
            XMLUtils.addSaxString(contentHandler, "REPLICATION", Short.valueOf(this.replication).toString());
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.path = st.getValue("PATH");
            this.replication = Short.valueOf(st.getValue("REPLICATION"));
        }
    }

    static class UpdateBlocksOp
    extends FSEditLogOp
    implements BlockListUpdatingOp {
        String path;
        Block[] blocks;

        private UpdateBlocksOp() {
            super(FSEditLogOpCodes.OP_UPDATE_BLOCKS);
        }

        static UpdateBlocksOp getInstance(OpInstanceCache cache) {
            return (UpdateBlocksOp)cache.get(FSEditLogOpCodes.OP_UPDATE_BLOCKS);
        }

        UpdateBlocksOp setPath(String path) {
            this.path = path;
            return this;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        UpdateBlocksOp setBlocks(Block[] blocks) {
            this.blocks = blocks;
            return this;
        }

        @Override
        public Block[] getBlocks() {
            return this.blocks;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeCompactBlockArray(this.blocks, out);
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            this.path = FSImageSerialization.readString(in);
            this.blocks = FSImageSerialization.readCompactBlockArray(in, logVersion);
        }

        @Override
        public boolean shouldCompleteLastBlock() {
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("UpdateBlocksOp [path=").append(this.path).append(", blocks=").append(Arrays.toString(this.blocks)).append("]");
            return sb.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "PATH", this.path);
            for (Block b : this.blocks) {
                FSEditLogOp.blockToXml(contentHandler, b);
            }
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.path = st.getValue("PATH");
            List<XMLUtils.Stanza> blocks = st.getChildren("BLOCK");
            this.blocks = new Block[blocks.size()];
            for (int i = 0; i < blocks.size(); ++i) {
                this.blocks[i] = FSEditLogOp.blockFromXml(blocks.get(i));
            }
        }
    }

    static class CloseOp
    extends AddCloseOp {
        private CloseOp() {
            super(FSEditLogOpCodes.OP_CLOSE);
        }

        static CloseOp getInstance(OpInstanceCache cache) {
            return (CloseOp)cache.get(FSEditLogOpCodes.OP_CLOSE);
        }

        @Override
        public boolean shouldCompleteLastBlock() {
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("CloseOp ");
            builder.append(this.stringifyMembers());
            return builder.toString();
        }
    }

    static class AddOp
    extends AddCloseOp {
        private AddOp() {
            super(FSEditLogOpCodes.OP_ADD);
        }

        static AddOp getInstance(OpInstanceCache cache) {
            return (AddOp)cache.get(FSEditLogOpCodes.OP_ADD);
        }

        @Override
        public boolean shouldCompleteLastBlock() {
            return false;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("AddOp ");
            builder.append(this.stringifyMembers());
            return builder.toString();
        }
    }

    static abstract class AddCloseOp
    extends FSEditLogOp
    implements BlockListUpdatingOp {
        int length;
        String path;
        short replication;
        long mtime;
        long atime;
        long blockSize;
        Block[] blocks;
        PermissionStatus permissions;
        String clientName;
        String clientMachine;
        public static final int MAX_BLOCKS = 0x4000000;

        private AddCloseOp(FSEditLogOpCodes opCode) {
            super(opCode);
            assert (opCode == FSEditLogOpCodes.OP_ADD || opCode == FSEditLogOpCodes.OP_CLOSE);
        }

        <T extends AddCloseOp> T setPath(String path) {
            this.path = path;
            return (T)this;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        <T extends AddCloseOp> T setReplication(short replication) {
            this.replication = replication;
            return (T)this;
        }

        <T extends AddCloseOp> T setModificationTime(long mtime) {
            this.mtime = mtime;
            return (T)this;
        }

        <T extends AddCloseOp> T setAccessTime(long atime) {
            this.atime = atime;
            return (T)this;
        }

        <T extends AddCloseOp> T setBlockSize(long blockSize) {
            this.blockSize = blockSize;
            return (T)this;
        }

        <T extends AddCloseOp> T setBlocks(Block[] blocks) {
            if (blocks.length > 0x4000000) {
                throw new RuntimeException("Can't have more than 67108864 in an AddCloseOp.");
            }
            this.blocks = blocks;
            return (T)this;
        }

        @Override
        public Block[] getBlocks() {
            return this.blocks;
        }

        <T extends AddCloseOp> T setPermissionStatus(PermissionStatus permissions) {
            this.permissions = permissions;
            return (T)this;
        }

        <T extends AddCloseOp> T setClientName(String clientName) {
            this.clientName = clientName;
            return (T)this;
        }

        <T extends AddCloseOp> T setClientMachine(String clientMachine) {
            this.clientMachine = clientMachine;
            return (T)this;
        }

        @Override
        public void writeFields(DataOutputStream out) throws IOException {
            FSImageSerialization.writeString(this.path, out);
            FSImageSerialization.writeShort(this.replication, out);
            FSImageSerialization.writeLong(this.mtime, out);
            FSImageSerialization.writeLong(this.atime, out);
            FSImageSerialization.writeLong(this.blockSize, out);
            new ArrayWritable(Block.class, (Writable[])this.blocks).write((DataOutput)out);
            this.permissions.write((DataOutput)out);
            if (this.opCode == FSEditLogOpCodes.OP_ADD) {
                FSImageSerialization.writeString(this.clientName, out);
                FSImageSerialization.writeString(this.clientMachine, out);
            }
        }

        @Override
        void readFields(DataInputStream in, int logVersion) throws IOException {
            if (!LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.length = in.readInt();
            }
            if (-17 < logVersion && this.length != 4 || logVersion <= -17 && this.length != 5 && !LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                throw new IOException("Incorrect data format. logVersion is " + logVersion + " but writables.length is " + this.length + ". ");
            }
            this.path = FSImageSerialization.readString(in);
            if (LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion)) {
                this.replication = FSImageSerialization.readShort(in);
                this.mtime = FSImageSerialization.readLong(in);
            } else {
                this.replication = FSEditLogOp.readShort(in);
                this.mtime = FSEditLogOp.readLong(in);
            }
            this.atime = LayoutVersion.supports(LayoutVersion.Feature.FILE_ACCESS_TIME, logVersion) ? (LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in)) : 0L;
            this.blockSize = LayoutVersion.supports(LayoutVersion.Feature.EDITLOG_OP_OPTIMIZATION, logVersion) ? FSImageSerialization.readLong(in) : FSEditLogOp.readLong(in);
            this.blocks = AddCloseOp.readBlocks(in, logVersion);
            this.permissions = PermissionStatus.read((DataInput)in);
            if (this.opCode == FSEditLogOpCodes.OP_ADD) {
                this.clientName = FSImageSerialization.readString(in);
                this.clientMachine = FSImageSerialization.readString(in);
            } else {
                this.clientName = "";
                this.clientMachine = "";
            }
        }

        private static Block[] readBlocks(DataInputStream in, int logVersion) throws IOException {
            int numBlocks = in.readInt();
            if (numBlocks < 0) {
                throw new IOException("invalid negative number of blocks");
            }
            if (numBlocks > 0x4000000) {
                throw new IOException("invalid number of blocks: " + numBlocks + ".  The maximum number of blocks per file is " + 0x4000000);
            }
            Block[] blocks = new Block[numBlocks];
            for (int i = 0; i < numBlocks; ++i) {
                Block blk = new Block();
                blk.readFields(in);
                blocks[i] = blk;
            }
            return blocks;
        }

        public String stringifyMembers() {
            StringBuilder builder = new StringBuilder();
            builder.append("[length=");
            builder.append(this.length);
            builder.append(", path=");
            builder.append(this.path);
            builder.append(", replication=");
            builder.append(this.replication);
            builder.append(", mtime=");
            builder.append(this.mtime);
            builder.append(", atime=");
            builder.append(this.atime);
            builder.append(", blockSize=");
            builder.append(this.blockSize);
            builder.append(", blocks=");
            builder.append(Arrays.toString(this.blocks));
            builder.append(", permissions=");
            builder.append(this.permissions);
            builder.append(", clientName=");
            builder.append(this.clientName);
            builder.append(", clientMachine=");
            builder.append(this.clientMachine);
            builder.append(", opCode=");
            builder.append((Object)this.opCode);
            builder.append(", txid=");
            builder.append(this.txid);
            builder.append("]");
            return builder.toString();
        }

        @Override
        protected void toXml(ContentHandler contentHandler) throws SAXException {
            XMLUtils.addSaxString(contentHandler, "LENGTH", Integer.valueOf(this.length).toString());
            XMLUtils.addSaxString(contentHandler, "PATH", this.path);
            XMLUtils.addSaxString(contentHandler, "REPLICATION", Short.valueOf(this.replication).toString());
            XMLUtils.addSaxString(contentHandler, "MTIME", Long.valueOf(this.mtime).toString());
            XMLUtils.addSaxString(contentHandler, "ATIME", Long.valueOf(this.atime).toString());
            XMLUtils.addSaxString(contentHandler, "BLOCKSIZE", Long.valueOf(this.blockSize).toString());
            XMLUtils.addSaxString(contentHandler, "CLIENT_NAME", this.clientName);
            XMLUtils.addSaxString(contentHandler, "CLIENT_MACHINE", this.clientMachine);
            for (Block b : this.blocks) {
                FSEditLogOp.blockToXml(contentHandler, b);
            }
            FSEditLogOp.permissionStatusToXml(contentHandler, this.permissions);
        }

        @Override
        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            this.length = Integer.valueOf(st.getValue("LENGTH"));
            this.path = st.getValue("PATH");
            this.replication = Short.valueOf(st.getValue("REPLICATION"));
            this.mtime = Long.valueOf(st.getValue("MTIME"));
            this.atime = Long.valueOf(st.getValue("ATIME"));
            this.blockSize = Long.valueOf(st.getValue("BLOCKSIZE"));
            this.clientName = st.getValue("CLIENT_NAME");
            this.clientMachine = st.getValue("CLIENT_MACHINE");
            if (st.hasChildren("BLOCK")) {
                List<XMLUtils.Stanza> blocks = st.getChildren("BLOCK");
                this.blocks = new Block[blocks.size()];
                for (int i = 0; i < blocks.size(); ++i) {
                    this.blocks[i] = FSEditLogOp.blockFromXml(blocks.get(i));
                }
            } else {
                this.blocks = new Block[0];
            }
            this.permissions = AddCloseOp.permissionStatusFromXml(st.getChildren("PERMISSION_STATUS").get(0));
        }
    }

    static interface BlockListUpdatingOp {
        public Block[] getBlocks();

        public String getPath();

        public boolean shouldCompleteLastBlock();
    }

    public static final class OpInstanceCache {
        private EnumMap<FSEditLogOpCodes, FSEditLogOp> inst = new EnumMap(FSEditLogOpCodes.class);

        public OpInstanceCache() {
            this.inst.put(FSEditLogOpCodes.OP_ADD, new AddOp());
            this.inst.put(FSEditLogOpCodes.OP_CLOSE, new CloseOp());
            this.inst.put(FSEditLogOpCodes.OP_SET_REPLICATION, new SetReplicationOp());
            this.inst.put(FSEditLogOpCodes.OP_CONCAT_DELETE, new ConcatDeleteOp());
            this.inst.put(FSEditLogOpCodes.OP_RENAME_OLD, new RenameOldOp());
            this.inst.put(FSEditLogOpCodes.OP_DELETE, new DeleteOp());
            this.inst.put(FSEditLogOpCodes.OP_MKDIR, new MkdirOp());
            this.inst.put(FSEditLogOpCodes.OP_SET_GENSTAMP, new SetGenstampOp());
            this.inst.put(FSEditLogOpCodes.OP_SET_PERMISSIONS, new SetPermissionsOp());
            this.inst.put(FSEditLogOpCodes.OP_SET_OWNER, new SetOwnerOp());
            this.inst.put(FSEditLogOpCodes.OP_SET_NS_QUOTA, new SetNSQuotaOp());
            this.inst.put(FSEditLogOpCodes.OP_CLEAR_NS_QUOTA, new ClearNSQuotaOp());
            this.inst.put(FSEditLogOpCodes.OP_SET_QUOTA, new SetQuotaOp());
            this.inst.put(FSEditLogOpCodes.OP_TIMES, new TimesOp());
            this.inst.put(FSEditLogOpCodes.OP_SYMLINK, new SymlinkOp());
            this.inst.put(FSEditLogOpCodes.OP_RENAME, new RenameOp());
            this.inst.put(FSEditLogOpCodes.OP_REASSIGN_LEASE, new ReassignLeaseOp());
            this.inst.put(FSEditLogOpCodes.OP_GET_DELEGATION_TOKEN, new GetDelegationTokenOp());
            this.inst.put(FSEditLogOpCodes.OP_RENEW_DELEGATION_TOKEN, new RenewDelegationTokenOp());
            this.inst.put(FSEditLogOpCodes.OP_CANCEL_DELEGATION_TOKEN, new CancelDelegationTokenOp());
            this.inst.put(FSEditLogOpCodes.OP_UPDATE_MASTER_KEY, new UpdateMasterKeyOp());
            this.inst.put(FSEditLogOpCodes.OP_START_LOG_SEGMENT, new LogSegmentOp(FSEditLogOpCodes.OP_START_LOG_SEGMENT));
            this.inst.put(FSEditLogOpCodes.OP_END_LOG_SEGMENT, new LogSegmentOp(FSEditLogOpCodes.OP_END_LOG_SEGMENT));
            this.inst.put(FSEditLogOpCodes.OP_UPDATE_BLOCKS, new UpdateBlocksOp());
        }

        public FSEditLogOp get(FSEditLogOpCodes opcode) {
            return this.inst.get((Object)opcode);
        }
    }
}

