/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolTranslatorPB;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputException;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.SecurityUtil;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class EditLogTailer {
    public static final Log LOG = LogFactory.getLog(EditLogTailer.class);
    private final EditLogTailerThread tailerThread;
    private final Configuration conf;
    private final FSNamesystem namesystem;
    private FSEditLog editLog;
    private volatile Runtime runtime = Runtime.getRuntime();
    private InetSocketAddress activeAddr;
    private NamenodeProtocol cachedActiveProxy = null;
    private long lastRollTriggerTxId = -12345L;
    private long lastLoadedTxnId = -12345L;
    private long lastLoadTimestamp;
    private long logRollPeriodMs;
    private long sleepTimeMs;

    public EditLogTailer(FSNamesystem namesystem, Configuration conf) {
        this.tailerThread = new EditLogTailerThread();
        this.conf = conf;
        this.namesystem = namesystem;
        this.editLog = namesystem.getEditLog();
        this.lastLoadTimestamp = Util.now();
        this.logRollPeriodMs = conf.getInt("dfs.ha.log-roll.period", 120) * 1000;
        if (this.logRollPeriodMs >= 0L) {
            this.activeAddr = this.getActiveNodeAddress();
            Preconditions.checkArgument((this.activeAddr.getPort() > 0 ? 1 : 0) != 0, (String)"Active NameNode must have an IPC port configured. Got address '%s'", (Object[])new Object[]{this.activeAddr});
            LOG.info((Object)("Will roll logs on active node at " + this.activeAddr + " every " + this.logRollPeriodMs / 1000L + " seconds."));
        } else {
            LOG.info((Object)"Not going to trigger log rolls on active node because dfs.ha.log-roll.period is negative.");
        }
        this.sleepTimeMs = conf.getInt("dfs.ha.tail-edits.period", 60) * 1000;
        LOG.debug((Object)("logRollPeriodMs=" + this.logRollPeriodMs + " sleepTime=" + this.sleepTimeMs));
    }

    private InetSocketAddress getActiveNodeAddress() {
        Configuration activeConf = HAUtil.getConfForOtherNode(this.conf);
        return NameNode.getServiceAddress(activeConf, true);
    }

    private NamenodeProtocol getActiveNodeProxy() throws IOException {
        if (this.cachedActiveProxy == null) {
            NamenodeProtocolPB proxy = (NamenodeProtocolPB)RPC.waitForProxy(NamenodeProtocolPB.class, (long)RPC.getProtocolVersion(NamenodeProtocolPB.class), (InetSocketAddress)this.activeAddr, (Configuration)this.conf);
            this.cachedActiveProxy = new NamenodeProtocolTranslatorPB(proxy);
        }
        assert (this.cachedActiveProxy != null);
        return this.cachedActiveProxy;
    }

    public void start() {
        this.tailerThread.start();
    }

    public void stop() throws IOException {
        this.tailerThread.setShouldRun(false);
        this.tailerThread.interrupt();
        try {
            this.tailerThread.join();
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Edit log tailer thread exited with an exception");
            throw new IOException(e);
        }
    }

    @VisibleForTesting
    FSEditLog getEditLog() {
        return this.editLog;
    }

    @VisibleForTesting
    void setEditLog(FSEditLog editLog) {
        this.editLog = editLog;
    }

    @VisibleForTesting
    synchronized void setRuntime(Runtime runtime) {
        this.runtime = runtime;
    }

    public void catchupDuringFailover() throws IOException {
        Preconditions.checkState((this.tailerThread == null || !this.tailerThread.isAlive() ? 1 : 0) != 0, (Object)"Tailer thread should not be running once failover starts");
        try {
            this.doTailEdits();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTailEdits() throws IOException, InterruptedException {
        this.namesystem.writeLockInterruptibly();
        try {
            Collection<EditLogInputStream> streams;
            FSImage image = this.namesystem.getFSImage();
            long lastTxnId = image.getLastAppliedTxId();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("lastTxnId: " + lastTxnId));
            }
            try {
                streams = this.editLog.selectInputStreams(lastTxnId + 1L, 0L, false);
            }
            catch (IOException ioe) {
                LOG.warn((Object)"Edits tailer failed to find any streams. Will try again later.", (Throwable)ioe);
                this.namesystem.writeUnlock();
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("edit streams to load from: " + streams.size()));
            }
            long editsLoaded = 0L;
            try {
                editsLoaded = image.loadEdits(streams, this.namesystem, null);
            }
            catch (EditLogInputException elie) {
                try {
                    editsLoaded = elie.getNumEditsLoaded();
                    throw elie;
                }
                catch (Throwable throwable) {
                    if (editsLoaded > 0L || LOG.isDebugEnabled()) {
                        LOG.info((Object)String.format("Loaded %d edits starting from txid %d ", editsLoaded, lastTxnId));
                    }
                    throw throwable;
                }
            }
            if (editsLoaded > 0L || LOG.isDebugEnabled()) {
                LOG.info((Object)String.format("Loaded %d edits starting from txid %d ", editsLoaded, lastTxnId));
            }
            if (editsLoaded > 0L) {
                this.lastLoadTimestamp = Util.now();
            }
            this.lastLoadedTxnId = image.getLastAppliedTxId();
        }
        finally {
            this.namesystem.writeUnlock();
        }
    }

    public long getLastLoadTimestamp() {
        return this.lastLoadTimestamp;
    }

    private boolean tooLongSinceLastLoad() {
        return this.logRollPeriodMs >= 0L && Util.now() - this.lastLoadTimestamp > this.logRollPeriodMs;
    }

    private void triggerActiveLogRoll() {
        LOG.info((Object)("Triggering log roll on remote NameNode " + this.activeAddr));
        try {
            this.getActiveNodeProxy().rollEditLog();
            this.lastRollTriggerTxId = this.lastLoadedTxnId;
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Unable to trigger a roll of the active NN", (Throwable)ioe);
        }
    }

    private class EditLogTailerThread
    extends Thread {
        private volatile boolean shouldRun;

        private EditLogTailerThread() {
            super("Edit log tailer");
            this.shouldRun = true;
        }

        private void setShouldRun(boolean shouldRun) {
            this.shouldRun = shouldRun;
        }

        @Override
        public void run() {
            SecurityUtil.doAsLoginUserOrFatal((PrivilegedAction)new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    EditLogTailerThread.this.doWork();
                    return null;
                }
            });
        }

        private void doWork() {
            while (this.shouldRun) {
                try {
                    if (EditLogTailer.this.tooLongSinceLastLoad() && EditLogTailer.this.lastRollTriggerTxId < EditLogTailer.this.lastLoadedTxnId) {
                        EditLogTailer.this.triggerActiveLogRoll();
                    }
                    if (!this.shouldRun) break;
                    EditLogTailer.this.doTailEdits();
                }
                catch (EditLogInputException elie) {
                    LOG.warn((Object)"Error while reading edits from disk. Will try again.", (Throwable)elie);
                }
                catch (InterruptedException ie) {
                    continue;
                }
                catch (Throwable t) {
                    LOG.error((Object)"Unknown error encountered while tailing edits. Shutting down standby NN.", t);
                    EditLogTailer.this.runtime.exit(1);
                }
                try {
                    Thread.sleep(EditLogTailer.this.sleepTimeMs);
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Edit log tailer interrupted", (Throwable)e);
                }
            }
        }
    }
}

