/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.URL;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.qjournal.protocol.QJournalProtocol;
import org.apache.hadoop.hdfs.qjournal.protocol.QJournalProtocolProtos;
import org.apache.hadoop.hdfs.qjournal.protocol.RequestInfo;
import org.apache.hadoop.hdfs.qjournal.protocolPB.QJournalProtocolPB;

@InterfaceAudience.Private
public class QJournalProtocolServerSideTranslatorPB
implements QJournalProtocolPB {
    private final QJournalProtocol impl;
    private static final QJournalProtocolProtos.JournalResponseProto VOID_JOURNAL_RESPONSE = QJournalProtocolProtos.JournalResponseProto.newBuilder().build();
    private static final QJournalProtocolProtos.StartLogSegmentResponseProto VOID_START_LOG_SEGMENT_RESPONSE = QJournalProtocolProtos.StartLogSegmentResponseProto.newBuilder().build();

    public QJournalProtocolServerSideTranslatorPB(QJournalProtocol impl) {
        this.impl = impl;
    }

    @Override
    public QJournalProtocolProtos.IsFormattedResponseProto isFormatted(RpcController controller, QJournalProtocolProtos.IsFormattedRequestProto request) throws ServiceException {
        try {
            boolean ret = this.impl.isFormatted(this.convert(request.getJid()));
            return QJournalProtocolProtos.IsFormattedResponseProto.newBuilder().setIsFormatted(ret).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    @Override
    public QJournalProtocolProtos.GetJournalStateResponseProto getJournalState(RpcController controller, QJournalProtocolProtos.GetJournalStateRequestProto request) throws ServiceException {
        try {
            return this.impl.getJournalState(this.convert(request.getJid()));
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    private String convert(QJournalProtocolProtos.JournalIdProto jid) {
        return jid.getIdentifier();
    }

    @Override
    public QJournalProtocolProtos.NewEpochResponseProto newEpoch(RpcController controller, QJournalProtocolProtos.NewEpochRequestProto request) throws ServiceException {
        try {
            return this.impl.newEpoch(request.getJid().getIdentifier(), PBHelper.convert(request.getNsInfo()), request.getEpoch());
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    @Override
    public QJournalProtocolProtos.FormatResponseProto format(RpcController controller, QJournalProtocolProtos.FormatRequestProto request) throws ServiceException {
        try {
            this.impl.format(request.getJid().getIdentifier(), PBHelper.convert(request.getNsInfo()));
            return QJournalProtocolProtos.FormatResponseProto.getDefaultInstance();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    @Override
    public QJournalProtocolProtos.JournalResponseProto journal(RpcController unused, QJournalProtocolProtos.JournalRequestProto req) throws ServiceException {
        try {
            this.impl.journal(this.convert(req.getReqInfo()), req.getSegmentTxnId(), req.getFirstTxnId(), req.getNumTxns(), req.getRecords().toByteArray());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_JOURNAL_RESPONSE;
    }

    @Override
    public QJournalProtocolProtos.HeartbeatResponseProto heartbeat(RpcController controller, QJournalProtocolProtos.HeartbeatRequestProto req) throws ServiceException {
        try {
            this.impl.heartbeat(this.convert(req.getReqInfo()));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return QJournalProtocolProtos.HeartbeatResponseProto.getDefaultInstance();
    }

    @Override
    public QJournalProtocolProtos.StartLogSegmentResponseProto startLogSegment(RpcController controller, QJournalProtocolProtos.StartLogSegmentRequestProto req) throws ServiceException {
        try {
            this.impl.startLogSegment(this.convert(req.getReqInfo()), req.getTxid());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_START_LOG_SEGMENT_RESPONSE;
    }

    @Override
    public QJournalProtocolProtos.FinalizeLogSegmentResponseProto finalizeLogSegment(RpcController controller, QJournalProtocolProtos.FinalizeLogSegmentRequestProto req) throws ServiceException {
        try {
            this.impl.finalizeLogSegment(this.convert(req.getReqInfo()), req.getStartTxId(), req.getEndTxId());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return QJournalProtocolProtos.FinalizeLogSegmentResponseProto.newBuilder().build();
    }

    @Override
    public QJournalProtocolProtos.PurgeLogsResponseProto purgeLogs(RpcController controller, QJournalProtocolProtos.PurgeLogsRequestProto req) throws ServiceException {
        try {
            this.impl.purgeLogsOlderThan(this.convert(req.getReqInfo()), req.getMinTxIdToKeep());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return QJournalProtocolProtos.PurgeLogsResponseProto.getDefaultInstance();
    }

    @Override
    public QJournalProtocolProtos.GetEditLogManifestResponseProto getEditLogManifest(RpcController controller, QJournalProtocolProtos.GetEditLogManifestRequestProto request) throws ServiceException {
        try {
            return this.impl.getEditLogManifest(request.getJid().getIdentifier(), request.getSinceTxId(), request.getForReading());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public QJournalProtocolProtos.PrepareRecoveryResponseProto prepareRecovery(RpcController controller, QJournalProtocolProtos.PrepareRecoveryRequestProto request) throws ServiceException {
        try {
            return this.impl.prepareRecovery(this.convert(request.getReqInfo()), request.getSegmentTxId());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public QJournalProtocolProtos.AcceptRecoveryResponseProto acceptRecovery(RpcController controller, QJournalProtocolProtos.AcceptRecoveryRequestProto request) throws ServiceException {
        try {
            this.impl.acceptRecovery(this.convert(request.getReqInfo()), request.getStateToAccept(), new URL(request.getFromURL()));
            return QJournalProtocolProtos.AcceptRecoveryResponseProto.getDefaultInstance();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private RequestInfo convert(QJournalProtocolProtos.RequestInfoProto reqInfo) {
        return new RequestInfo(reqInfo.getJournalId().getIdentifier(), reqInfo.getEpoch(), reqInfo.getIpcSerialNumber(), reqInfo.hasCommittedTxId() ? reqInfo.getCommittedTxId() : -12345L);
    }
}

