/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public enum FSEditLogOpCodes {
    OP_INVALID(-1),
    OP_ADD(0),
    OP_RENAME_OLD(1),
    OP_DELETE(2),
    OP_MKDIR(3),
    OP_SET_REPLICATION(4),
    OP_DATANODE_ADD(5),
    OP_DATANODE_REMOVE(6),
    OP_SET_PERMISSIONS(7),
    OP_SET_OWNER(8),
    OP_CLOSE(9),
    OP_SET_GENSTAMP(10),
    OP_SET_NS_QUOTA(11),
    OP_CLEAR_NS_QUOTA(12),
    OP_TIMES(13),
    OP_SET_QUOTA(14),
    OP_RENAME(15),
    OP_CONCAT_DELETE(16),
    OP_SYMLINK(17),
    OP_GET_DELEGATION_TOKEN(18),
    OP_RENEW_DELEGATION_TOKEN(19),
    OP_CANCEL_DELEGATION_TOKEN(20),
    OP_UPDATE_MASTER_KEY(21),
    OP_REASSIGN_LEASE(22),
    OP_END_LOG_SEGMENT(23),
    OP_START_LOG_SEGMENT(24),
    OP_UPDATE_BLOCKS(25),
    OP_CREATE_SNAPSHOT(26),
    OP_DELETE_SNAPSHOT(27),
    OP_RENAME_SNAPSHOT(28),
    OP_ALLOW_SNAPSHOT(29),
    OP_DISALLOW_SNAPSHOT(30);

    private byte opCode;
    private static final Map<Byte, FSEditLogOpCodes> byteToEnum;

    private FSEditLogOpCodes(byte opCode) {
        this.opCode = opCode;
    }

    public byte getOpCode() {
        return this.opCode;
    }

    public static FSEditLogOpCodes fromByte(byte opCode) {
        return byteToEnum.get(opCode);
    }

    static {
        byteToEnum = new HashMap<Byte, FSEditLogOpCodes>();
        for (FSEditLogOpCodes opCode : FSEditLogOpCodes.values()) {
            byteToEnum.put(opCode.getOpCode(), opCode);
        }
    }
}

