/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.PathIsNotDirectoryException;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageCompression;
import org.apache.hadoop.hdfs.server.namenode.FSImageSerialization;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryWithQuota;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.SaveNamespaceContext;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectorySnapshottable;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectoryWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeFileUnderConstructionWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeFileWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotFSImageFormat;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FSImageFormat {
    private static final Log LOG = FSImage.LOG;

    private FSImageFormat() {
    }

    static class Saver {
        private final SaveNamespaceContext context;
        private boolean saved = false;
        private MD5Hash savedDigest;
        private final SnapshotFSImageFormat.ReferenceMap referenceMap = new SnapshotFSImageFormat.ReferenceMap();

        private void checkSaved() {
            if (!this.saved) {
                throw new IllegalStateException("FSImageSaver has not saved an image");
            }
        }

        private void checkNotSaved() {
            if (this.saved) {
                throw new IllegalStateException("FSImageSaver has already saved an image");
            }
        }

        Saver(SaveNamespaceContext context) {
            this.context = context;
        }

        MD5Hash getSavedDigest() {
            this.checkSaved();
            return this.savedDigest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void save(File newFile, FSImageCompression compression) throws IOException {
            this.checkNotSaved();
            FSNamesystem sourceNamesystem = this.context.getSourceNamesystem();
            FSDirectory fsDir = sourceNamesystem.dir;
            long startTime = Time.now();
            MessageDigest digester = MD5Hash.getDigester();
            FileOutputStream fout = new FileOutputStream(newFile);
            DigestOutputStream fos = new DigestOutputStream(fout, digester);
            DataOutputStream out = new DataOutputStream(fos);
            try {
                out.writeInt(HdfsConstants.LAYOUT_VERSION);
                out.writeInt(sourceNamesystem.unprotectedGetNamespaceInfo().getNamespaceID());
                out.writeLong(fsDir.rootDir.numItemsInTree());
                out.writeLong(sourceNamesystem.getGenerationStamp());
                out.writeLong(this.context.getTxId());
                out.writeLong(sourceNamesystem.getLastInodeId());
                sourceNamesystem.getSnapshotManager().write(out);
                out = compression.writeHeaderAndWrapStream(fos);
                LOG.info((Object)("Saving image file " + newFile + " using " + compression));
                FSImageSerialization.saveINode2Image(fsDir.rootDir, out, false, this.referenceMap);
                this.saveImage(fsDir.rootDir, out, true);
                sourceNamesystem.saveFilesUnderConstruction(out);
                this.context.checkCancelled();
                sourceNamesystem.saveSecretManagerState(out);
                this.context.checkCancelled();
                out.flush();
                this.context.checkCancelled();
                fout.getChannel().force(true);
            }
            finally {
                out.close();
            }
            this.saved = true;
            this.savedDigest = new MD5Hash(digester.digest());
            LOG.info((Object)("Image file " + newFile + " of size " + newFile.length() + " bytes saved in " + (Time.now() - startTime) / 1000L + " seconds."));
        }

        private int saveChildren(ReadOnlyList<INode> children, DataOutputStream out) throws IOException {
            out.writeInt(children.size());
            int dirNum = 0;
            int i = 0;
            for (INode child : children) {
                FSImageSerialization.saveINode2Image(child, out, false, this.referenceMap);
                if (child.isDirectory()) {
                    ++dirNum;
                }
                if (i++ % 50 != 0) continue;
                this.context.checkCancelled();
            }
            return dirNum;
        }

        private void saveImage(INodeDirectory current, DataOutputStream out, boolean toSaveSubtree) throws IOException {
            boolean toSave;
            out.writeLong(current.getId());
            if (!toSaveSubtree) {
                return;
            }
            ReadOnlyList<INode> children = current.getChildrenList(null);
            int dirNum = 0;
            ArrayList<INodeDirectory> snapshotDirs = null;
            if (current instanceof INodeDirectoryWithSnapshot) {
                snapshotDirs = new ArrayList<INodeDirectory>();
                ((INodeDirectoryWithSnapshot)current).getSnapshotDirectory(snapshotDirs);
                dirNum += snapshotDirs.size();
            }
            if (current instanceof INodeDirectorySnapshottable) {
                INodeDirectorySnapshottable snapshottableNode = (INodeDirectorySnapshottable)current;
                SnapshotFSImageFormat.saveSnapshots(snapshottableNode, out);
            } else {
                out.writeInt(-1);
            }
            SnapshotFSImageFormat.saveDirectoryDiffList(current, out, this.referenceMap);
            out.writeInt(dirNum += this.saveChildren(children, out));
            for (INode child : children) {
                if (!child.isDirectory()) continue;
                toSave = child.isReference() ? this.referenceMap.toProcessSubtree(child.getId()) : true;
                this.saveImage(child.asDirectory(), out, toSave);
            }
            if (snapshotDirs != null) {
                for (INodeDirectory subDir : snapshotDirs) {
                    toSave = subDir.getParentReference() != null ? this.referenceMap.toProcessSubtree(subDir.getId()) : true;
                    this.saveImage(subDir, out, toSave);
                }
            }
        }
    }

    public static class Loader {
        private final Configuration conf;
        private final FSNamesystem namesystem;
        private boolean loaded = false;
        private long imgTxId;
        private MD5Hash imgDigest;
        private Map<Integer, Snapshot> snapshotMap = null;
        private final SnapshotFSImageFormat.ReferenceMap referenceMap = new SnapshotFSImageFormat.ReferenceMap();

        Loader(Configuration conf, FSNamesystem namesystem) {
            this.conf = conf;
            this.namesystem = namesystem;
        }

        MD5Hash getLoadedImageMd5() {
            this.checkLoaded();
            return this.imgDigest;
        }

        long getLoadedImageTxId() {
            this.checkLoaded();
            return this.imgTxId;
        }

        private void checkLoaded() {
            if (!this.loaded) {
                throw new IllegalStateException("Image not yet loaded!");
            }
        }

        private void checkNotLoaded() {
            if (this.loaded) {
                throw new IllegalStateException("Image already loaded!");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void load(File curFile) throws IOException {
            this.checkNotLoaded();
            assert (curFile != null) : "curFile is null";
            long startTime = Time.now();
            MessageDigest digester = MD5Hash.getDigester();
            DigestInputStream fin = new DigestInputStream(new FileInputStream(curFile), digester);
            DataInputStream in = new DataInputStream(fin);
            try {
                boolean eof;
                int imgVersion = in.readInt();
                if (this.getLayoutVersion() != imgVersion) {
                    throw new InconsistentFSStateException(curFile, "imgVersion " + imgVersion + " expected to be " + this.getLayoutVersion());
                }
                boolean supportSnapshot = LayoutVersion.supports(LayoutVersion.Feature.SNAPSHOT, imgVersion);
                in.readInt();
                long numFiles = in.readLong();
                long genstamp = in.readLong();
                this.namesystem.setGenerationStamp(genstamp);
                this.imgTxId = LayoutVersion.supports(LayoutVersion.Feature.STORED_TXIDS, imgVersion) ? in.readLong() : 0L;
                if (LayoutVersion.supports(LayoutVersion.Feature.ADD_INODE_ID, imgVersion)) {
                    long lastInodeId = in.readLong();
                    this.namesystem.resetLastInodeId(lastInodeId);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("load last allocated InodeId from fsimage:" + lastInodeId));
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Old layout version doesn't have inode id. Will assign new id for each inode.");
                }
                if (supportSnapshot) {
                    this.snapshotMap = this.namesystem.getSnapshotManager().read(in, this);
                }
                FSImageCompression compression = LayoutVersion.supports(LayoutVersion.Feature.FSIMAGE_COMPRESSION, imgVersion) ? FSImageCompression.readCompressionHeader(this.conf, in) : FSImageCompression.createNoopCompression();
                in = compression.unwrapInputStream(fin);
                LOG.info((Object)("Loading image file " + curFile + " using " + compression));
                LOG.info((Object)("Number of files = " + numFiles));
                if (LayoutVersion.supports(LayoutVersion.Feature.FSIMAGE_NAME_OPTIMIZATION, imgVersion)) {
                    if (supportSnapshot) {
                        this.loadLocalNameINodesWithSnapshot(in);
                    } else {
                        this.loadLocalNameINodes(numFiles, in);
                    }
                } else {
                    this.loadFullNameINodes(numFiles, in);
                }
                this.loadFilesUnderConstruction(in, supportSnapshot);
                this.loadSecretManagerState(in);
                boolean bl = eof = in.read() == -1;
                assert (eof) : "Should have reached the end of image file " + curFile;
            }
            finally {
                in.close();
            }
            this.imgDigest = new MD5Hash(digester.digest());
            this.loaded = true;
            LOG.info((Object)("Image file " + curFile + " of size " + curFile.length() + " bytes loaded in " + (Time.now() - startTime) / 1000L + " seconds."));
        }

        private void updateRootAttr(INodeWithAdditionalFields root) {
            long nsQuota = root.getNsQuota();
            long dsQuota = root.getDsQuota();
            FSDirectory fsDir = this.namesystem.dir;
            if (nsQuota != -1L || dsQuota != -1L) {
                fsDir.rootDir.setQuota(nsQuota, dsQuota);
            }
            fsDir.rootDir.cloneModificationTime(root);
            fsDir.rootDir.clonePermissionStatus(root);
        }

        private void loadLocalNameINodesWithSnapshot(DataInput in) throws IOException {
            assert (LayoutVersion.supports(LayoutVersion.Feature.FSIMAGE_NAME_OPTIMIZATION, this.getLayoutVersion()));
            assert (LayoutVersion.supports(LayoutVersion.Feature.SNAPSHOT, this.getLayoutVersion()));
            this.loadRoot(in);
            this.loadDirectoryWithSnapshot(in);
        }

        private void loadLocalNameINodes(long numFiles, DataInput in) throws IOException {
            assert (LayoutVersion.supports(LayoutVersion.Feature.FSIMAGE_NAME_OPTIMIZATION, this.getLayoutVersion()));
            assert (numFiles > 0L);
            this.loadRoot(in);
            --numFiles;
            while (numFiles > 0L) {
                numFiles -= (long)this.loadDirectory(in);
            }
            if (numFiles != 0L) {
                throw new IOException("Read unexpect number of files: " + -numFiles);
            }
        }

        private void loadRoot(DataInput in) throws IOException {
            if (in.readShort() != 0) {
                throw new IOException("First node is not root");
            }
            INodeDirectory root = this.loadINode(null, false, in).asDirectory();
            this.updateRootAttr(root);
        }

        private int loadChildren(INodeDirectory parent, DataInput in) throws IOException {
            int numChildren = in.readInt();
            for (int i = 0; i < numChildren; ++i) {
                INode newNode = this.loadINodeWithLocalName(false, in, true);
                this.addToParent(parent, newNode);
            }
            return numChildren;
        }

        private void loadDirectoryWithSnapshot(DataInput in) throws IOException {
            long inodeId = in.readLong();
            INodeDirectory parent = this.namesystem.dir.getInode(inodeId).asDirectory();
            boolean toLoadSubtree = this.referenceMap.toProcessSubtree(parent.getId());
            if (!toLoadSubtree) {
                return;
            }
            int numSnapshots = in.readInt();
            if (numSnapshots >= 0) {
                INodeDirectorySnapshottable snapshottableParent = INodeDirectorySnapshottable.valueOf((INode)parent, parent.getLocalName());
                SnapshotFSImageFormat.loadSnapshotList(snapshottableParent, numSnapshots, in, this);
                if (snapshottableParent.getSnapshotQuota() > 0) {
                    this.namesystem.getSnapshotManager().addSnapshottable(snapshottableParent);
                }
            }
            this.loadChildren(parent, in);
            SnapshotFSImageFormat.loadDirectoryDiffList(parent, in, this);
            int numSubTree = in.readInt();
            for (int i = 0; i < numSubTree; ++i) {
                this.loadDirectoryWithSnapshot(in);
            }
        }

        private int loadDirectory(DataInput in) throws IOException {
            String parentPath = FSImageSerialization.readString(in);
            INodeDirectory parent = INodeDirectory.valueOf(this.namesystem.dir.rootDir.getNode(parentPath, true), parentPath);
            return this.loadChildren(parent, in);
        }

        private void loadFullNameINodes(long numFiles, DataInput in) throws IOException {
            Object parentPath = new byte[][]{new byte[0]};
            FSDirectory fsDir = this.namesystem.dir;
            INodeDirectory parentINode = fsDir.rootDir;
            for (long i = 0L; i < numFiles; ++i) {
                byte[][] pathComponents = FSImageSerialization.readPathComponents(in);
                INode newNode = this.loadINode(pathComponents[pathComponents.length - 1], false, in);
                if (this.isRoot(pathComponents)) {
                    this.updateRootAttr(newNode.asDirectory());
                    continue;
                }
                if (!this.isParent(pathComponents, (byte[][])parentPath)) {
                    parentINode = this.getParentINodeDirectory(pathComponents);
                    parentPath = this.getParent(pathComponents);
                }
                this.addToParent(parentINode, newNode);
            }
        }

        private INodeDirectory getParentINodeDirectory(byte[][] pathComponents) throws FileNotFoundException, PathIsNotDirectoryException, UnresolvedLinkException {
            if (pathComponents.length < 2) {
                return null;
            }
            INodesInPath inodes = this.namesystem.dir.getExistingPathINodes(pathComponents);
            return INodeDirectory.valueOf(inodes.getINode(-2), pathComponents);
        }

        private void addToParent(INodeDirectory parent, INode child) {
            INodeFile file;
            BlockInfo[] blocks;
            FSDirectory fsDir = this.namesystem.dir;
            if (parent == fsDir.rootDir && FSDirectory.isReservedName(child)) {
                throw new HadoopIllegalArgumentException("File name \"" + child.getLocalName() + "\" is reserved. Please " + " change the name of the existing file or directory to another " + "name before upgrading to this release.");
            }
            if (!parent.addChild(child)) {
                return;
            }
            this.namesystem.dir.cacheName(child);
            if (child.isFile() && (blocks = (file = child.asFile()).getBlocks()) != null) {
                BlockManager bm = this.namesystem.getBlockManager();
                for (int i = 0; i < blocks.length; ++i) {
                    file.setBlock(i, bm.addBlockCollection(blocks[i], file));
                }
            }
        }

        public FSDirectory getFSDirectoryInLoading() {
            return this.namesystem.dir;
        }

        public INode loadINodeWithLocalName(boolean isSnapshotINode, DataInput in, boolean updateINodeMap) throws IOException {
            byte[] localName = FSImageSerialization.readLocalName(in);
            INode inode = this.loadINode(localName, isSnapshotINode, in);
            if (updateINodeMap && LayoutVersion.supports(LayoutVersion.Feature.ADD_INODE_ID, this.getLayoutVersion())) {
                this.namesystem.dir.addToInodeMap(inode);
            }
            return inode;
        }

        INode loadINode(byte[] localName, boolean isSnapshotINode, DataInput in) throws IOException {
            int imgVersion = this.getLayoutVersion();
            if (LayoutVersion.supports(LayoutVersion.Feature.SNAPSHOT, imgVersion)) {
                this.namesystem.getFSDirectory().verifyINodeName(localName);
            }
            long inodeId = LayoutVersion.supports(LayoutVersion.Feature.ADD_INODE_ID, imgVersion) ? in.readLong() : this.namesystem.allocateNewInodeId();
            short replication = this.namesystem.getBlockManager().adjustReplication(in.readShort());
            long modificationTime = in.readLong();
            long atime = 0L;
            if (LayoutVersion.supports(LayoutVersion.Feature.FILE_ACCESS_TIME, imgVersion)) {
                atime = in.readLong();
            }
            long blockSize = in.readLong();
            int numBlocks = in.readInt();
            if (numBlocks >= 0) {
                BlockInfo[] blocks = null;
                if (numBlocks >= 0) {
                    blocks = new BlockInfo[numBlocks];
                    for (int j = 0; j < numBlocks; ++j) {
                        blocks[j] = new BlockInfo(replication);
                        blocks[j].readFields(in);
                    }
                }
                String clientName = "";
                String clientMachine = "";
                boolean underConstruction = false;
                FileWithSnapshot.FileDiffList fileDiffs = null;
                if (LayoutVersion.supports(LayoutVersion.Feature.SNAPSHOT, imgVersion)) {
                    fileDiffs = SnapshotFSImageFormat.loadFileDiffList(in, this);
                    if (isSnapshotINode && (underConstruction = in.readBoolean())) {
                        clientName = FSImageSerialization.readString(in);
                        clientMachine = FSImageSerialization.readString(in);
                    }
                }
                PermissionStatus permissions = PermissionStatus.read((DataInput)in);
                INodeFile file = new INodeFile(inodeId, localName, permissions, modificationTime, atime, blocks, replication, blockSize);
                return fileDiffs != null ? new INodeFileWithSnapshot(file, fileDiffs) : (underConstruction ? new INodeFileUnderConstruction(file, clientName, clientMachine, null) : file);
            }
            if (numBlocks == -1) {
                INodeDirectory dir;
                long nsQuota = in.readLong();
                long dsQuota = -1L;
                if (LayoutVersion.supports(LayoutVersion.Feature.DISKSPACE_QUOTA, imgVersion)) {
                    dsQuota = in.readLong();
                }
                boolean snapshottable = false;
                boolean withSnapshot = false;
                if (LayoutVersion.supports(LayoutVersion.Feature.SNAPSHOT, imgVersion) && !(snapshottable = in.readBoolean())) {
                    withSnapshot = in.readBoolean();
                }
                PermissionStatus permissions = PermissionStatus.read((DataInput)in);
                INodeDirectory iNodeDirectory = dir = nsQuota >= 0L || dsQuota >= 0L ? new INodeDirectoryWithQuota(inodeId, localName, permissions, modificationTime, nsQuota, dsQuota) : new INodeDirectory(inodeId, localName, permissions, modificationTime);
                return snapshottable ? new INodeDirectorySnapshottable(dir) : (withSnapshot ? new INodeDirectoryWithSnapshot(dir) : dir);
            }
            if (numBlocks == -2) {
                String symlink = Text.readString((DataInput)in);
                PermissionStatus permissions = PermissionStatus.read((DataInput)in);
                return new INodeSymlink(inodeId, localName, permissions, modificationTime, atime, symlink);
            }
            if (numBlocks == -3) {
                boolean isWithName = in.readBoolean();
                int snapshotId = in.readInt();
                INodeReference.WithCount withCount = this.referenceMap.loadINodeReferenceWithCount(isSnapshotINode, in, this);
                if (isWithName) {
                    return new INodeReference.WithName(null, withCount, localName, snapshotId);
                }
                INodeReference.DstReference ref = new INodeReference.DstReference(null, withCount, snapshotId);
                return ref;
            }
            throw new IOException("Unknown inode type: numBlocks=" + numBlocks);
        }

        private void loadFilesUnderConstruction(DataInput in, boolean supportSnapshot) throws IOException {
            FSDirectory fsDir = this.namesystem.dir;
            int size = in.readInt();
            LOG.info((Object)("Number of files under construction = " + size));
            for (int i = 0; i < size; ++i) {
                INodeFileUnderConstruction cons = FSImageSerialization.readINodeUnderConstruction(in, this.namesystem, this.getLayoutVersion());
                String path = cons.getLocalName();
                INodesInPath iip = fsDir.getLastINodeInPath(path);
                INodeFile oldnode = INodeFile.valueOf(iip.getINode(0), path);
                cons.setLocalName(oldnode.getLocalNameBytes());
                cons.setParent(oldnode.getParent());
                if (oldnode instanceof INodeFileWithSnapshot) {
                    cons = new INodeFileUnderConstructionWithSnapshot(cons, ((INodeFileWithSnapshot)oldnode).getDiffs());
                }
                fsDir.replaceINodeFile(path, oldnode, cons);
                this.namesystem.leaseManager.addLease(cons.getClientName(), path);
            }
        }

        private void loadSecretManagerState(DataInput in) throws IOException {
            int imgVersion = this.getLayoutVersion();
            if (!LayoutVersion.supports(LayoutVersion.Feature.DELEGATION_TOKEN, imgVersion)) {
                return;
            }
            this.namesystem.loadSecretManagerState(in);
        }

        private int getLayoutVersion() {
            return this.namesystem.getFSImage().getStorage().getLayoutVersion();
        }

        private boolean isRoot(byte[][] path) {
            return path.length == 1 && path[0] == null;
        }

        private boolean isParent(byte[][] path, byte[][] parent) {
            if (path == null || parent == null) {
                return false;
            }
            if (parent.length == 0 || path.length != parent.length + 1) {
                return false;
            }
            boolean isParent = true;
            for (int i = 0; i < parent.length; ++i) {
                isParent = isParent && Arrays.equals(path[i], parent[i]);
            }
            return isParent;
        }

        String getParent(String path) {
            return path.substring(0, path.lastIndexOf("/"));
        }

        byte[][] getParent(byte[][] path) {
            byte[][] result = new byte[path.length - 1][];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new byte[path[i].length];
                System.arraycopy(path[i], 0, result[i], 0, path[i].length);
            }
            return result;
        }

        public Snapshot getSnapshot(DataInput in) throws IOException {
            return this.snapshotMap.get(in.readInt());
        }
    }
}

