/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeMap;
import org.apache.hadoop.hdfs.server.namenode.SerialNumberManager;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.util.LightWeightGSet;

@InterfaceAudience.Private
public abstract class INodeWithAdditionalFields
extends INode
implements LightWeightGSet.LinkedElement {
    private final long id;
    private byte[] name = null;
    private long permission = 0L;
    private long modificationTime = 0L;
    private long accessTime = 0L;
    private LightWeightGSet.LinkedElement next = null;

    private INodeWithAdditionalFields(INode parent, long id, byte[] name, long permission, long modificationTime, long accessTime) {
        super(parent);
        this.id = id;
        this.name = name;
        this.permission = permission;
        this.modificationTime = modificationTime;
        this.accessTime = accessTime;
    }

    INodeWithAdditionalFields(long id, byte[] name, PermissionStatus permissions, long modificationTime, long accessTime) {
        this(null, id, name, PermissionStatusFormat.toLong(permissions), modificationTime, accessTime);
    }

    INodeWithAdditionalFields(INodeWithAdditionalFields other) {
        this(other.getParentReference() != null ? other.getParentReference() : other.getParent(), other.getId(), other.getLocalNameBytes(), other.permission, other.modificationTime, other.accessTime);
    }

    @Override
    public void setNext(LightWeightGSet.LinkedElement next) {
        this.next = next;
    }

    @Override
    public LightWeightGSet.LinkedElement getNext() {
        return this.next;
    }

    @Override
    public final long getId() {
        return this.id;
    }

    @Override
    public final byte[] getLocalNameBytes() {
        return this.name;
    }

    @Override
    public final void setLocalName(byte[] name) {
        this.name = name;
    }

    final void clonePermissionStatus(INodeWithAdditionalFields that) {
        this.permission = that.permission;
    }

    @Override
    final PermissionStatus getPermissionStatus(Snapshot snapshot) {
        return new PermissionStatus(this.getUserName(snapshot), this.getGroupName(snapshot), this.getFsPermission(snapshot));
    }

    private final void updatePermissionStatus(PermissionStatusFormat f, long n) {
        this.permission = f.combine(n, this.permission);
    }

    @Override
    final String getUserName(Snapshot snapshot) {
        if (snapshot != null) {
            return this.getSnapshotINode(snapshot).getUserName();
        }
        int n = (int)PermissionStatusFormat.USER.retrieve(this.permission);
        return SerialNumberManager.INSTANCE.getUser(n);
    }

    @Override
    final void setUser(String user) {
        int n = SerialNumberManager.INSTANCE.getUserSerialNumber(user);
        this.updatePermissionStatus(PermissionStatusFormat.USER, n);
    }

    @Override
    final String getGroupName(Snapshot snapshot) {
        if (snapshot != null) {
            return this.getSnapshotINode(snapshot).getGroupName();
        }
        int n = (int)PermissionStatusFormat.GROUP.retrieve(this.permission);
        return SerialNumberManager.INSTANCE.getGroup(n);
    }

    @Override
    final void setGroup(String group) {
        int n = SerialNumberManager.INSTANCE.getGroupSerialNumber(group);
        this.updatePermissionStatus(PermissionStatusFormat.GROUP, n);
    }

    @Override
    final FsPermission getFsPermission(Snapshot snapshot) {
        if (snapshot != null) {
            return this.getSnapshotINode(snapshot).getFsPermission();
        }
        return new FsPermission((short)PermissionStatusFormat.MODE.retrieve(this.permission));
    }

    final short getFsPermissionShort() {
        return (short)PermissionStatusFormat.MODE.retrieve(this.permission);
    }

    @Override
    void setPermission(FsPermission permission) {
        short mode = permission.toShort();
        this.updatePermissionStatus(PermissionStatusFormat.MODE, mode);
    }

    @Override
    final long getModificationTime(Snapshot snapshot) {
        if (snapshot != null) {
            return this.getSnapshotINode(snapshot).getModificationTime(null);
        }
        return this.modificationTime;
    }

    @Override
    public final INode updateModificationTime(long mtime, Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        Preconditions.checkState((boolean)this.isDirectory());
        if (mtime <= this.modificationTime) {
            return this;
        }
        return this.setModificationTime(mtime, latest, inodeMap);
    }

    final void cloneModificationTime(INodeWithAdditionalFields that) {
        this.modificationTime = that.modificationTime;
    }

    @Override
    public final void setModificationTime(long modificationTime) {
        this.modificationTime = modificationTime;
    }

    @Override
    final long getAccessTime(Snapshot snapshot) {
        if (snapshot != null) {
            return this.getSnapshotINode(snapshot).getAccessTime(null);
        }
        return this.accessTime;
    }

    @Override
    public final void setAccessTime(long accessTime) {
        this.accessTime = accessTime;
    }

    private static enum PermissionStatusFormat {
        MODE(0, 16),
        GROUP(PermissionStatusFormat.MODE.OFFSET + PermissionStatusFormat.MODE.LENGTH, 25),
        USER(PermissionStatusFormat.GROUP.OFFSET + PermissionStatusFormat.GROUP.LENGTH, 23);

        final int OFFSET;
        final int LENGTH;
        final long MASK;

        private PermissionStatusFormat(int offset, int length) {
            this.OFFSET = offset;
            this.LENGTH = length;
            this.MASK = -1L >>> 64 - this.LENGTH << this.OFFSET;
        }

        long retrieve(long record) {
            return (record & this.MASK) >>> this.OFFSET;
        }

        long combine(long bits, long record) {
            return record & (this.MASK ^ 0xFFFFFFFFFFFFFFFFL) | bits << this.OFFSET;
        }

        static long toLong(PermissionStatus ps) {
            long permission = 0L;
            int user = SerialNumberManager.INSTANCE.getUserSerialNumber(ps.getUserName());
            permission = USER.combine(user, permission);
            int group = SerialNumberManager.INSTANCE.getGroupSerialNumber(ps.getGroupName());
            permission = GROUP.combine(group, permission);
            short mode = ps.getPermission().toShort();
            permission = MODE.combine(mode, permission);
            return permission;
        }
    }
}

