/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.snapshot.AbstractINodeDiff;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;

abstract class AbstractINodeDiffList<N extends INode, D extends AbstractINodeDiff<N, D>>
implements Iterable<D> {
    private final List<D> diffs = new ArrayList<D>();

    AbstractINodeDiffList() {
    }

    public final List<D> asList() {
        return Collections.unmodifiableList(this.diffs);
    }

    public void clear() {
        this.diffs.clear();
    }

    abstract D createDiff(Snapshot var1, N var2);

    abstract N createSnapshotCopy(N var1);

    public final Quota.Counts deleteSnapshotDiff(Snapshot snapshot, Snapshot prior, N currentINode, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, boolean countDiffChange) throws QuotaExceededException {
        int snapshotIndex = Collections.binarySearch(this.diffs, snapshot.getId());
        Quota.Counts counts = Quota.Counts.newInstance();
        AbstractINodeDiff removed = null;
        if (snapshotIndex == 0) {
            if (prior != null) {
                ((AbstractINodeDiff)this.diffs.get(snapshotIndex)).setSnapshot(prior);
            } else {
                removed = (AbstractINodeDiff)this.diffs.remove(0);
                if (countDiffChange) {
                    counts.add(Quota.NAMESPACE, 1L);
                } else {
                    ((INode)currentINode).addSpaceConsumed(-1L, 0L, false);
                }
                counts.add(removed.destroyDiffAndCollectBlocks(currentINode, collectedBlocks, removedINodes));
            }
        } else if (snapshotIndex > 0) {
            AbstractINodeDiff previous = (AbstractINodeDiff)this.diffs.get(snapshotIndex - 1);
            if (!previous.getSnapshot().equals(prior)) {
                ((AbstractINodeDiff)this.diffs.get(snapshotIndex)).setSnapshot(prior);
            } else {
                removed = (AbstractINodeDiff)this.diffs.remove(snapshotIndex);
                if (countDiffChange) {
                    counts.add(Quota.NAMESPACE, 1L);
                } else {
                    ((INode)currentINode).addSpaceConsumed(-1L, 0L, false);
                }
                if (previous.snapshotINode == null) {
                    previous.snapshotINode = removed.snapshotINode;
                } else if (removed.snapshotINode != null) {
                    ((INode)removed.snapshotINode).clear();
                }
                counts.add(previous.combinePosteriorAndCollectBlocks(currentINode, removed, collectedBlocks, removedINodes));
                previous.setPosterior(removed.getPosterior());
                removed.setPosterior(null);
            }
        }
        return counts;
    }

    final D addDiff(Snapshot latest, N currentINode) throws QuotaExceededException {
        ((INode)currentINode).addSpaceConsumed(1L, 0L, true);
        return this.addLast(this.createDiff(latest, currentINode));
    }

    private final D addLast(D diff) {
        D last = this.getLast();
        this.diffs.add(diff);
        if (last != null) {
            ((AbstractINodeDiff)last).setPosterior(diff);
        }
        return diff;
    }

    final void addFirst(D diff) {
        AbstractINodeDiff first = this.diffs.isEmpty() ? null : (AbstractINodeDiff)this.diffs.get(0);
        this.diffs.add(0, diff);
        diff.setPosterior((AbstractINodeDiff)first);
    }

    public final D getLast() {
        int n = this.diffs.size();
        return (D)(n == 0 ? null : (AbstractINodeDiff)this.diffs.get(n - 1));
    }

    public final Snapshot getLastSnapshot() {
        D last = this.getLast();
        return last == null ? null : ((AbstractINodeDiff)last).getSnapshot();
    }

    private final Snapshot getPrior(int anchorId, boolean exclusive) {
        if (anchorId == -1) {
            return this.getLastSnapshot();
        }
        int i = Collections.binarySearch(this.diffs, anchorId);
        if (exclusive) {
            if (i == -1 || i == 0) {
                return null;
            }
            int priorIndex = i > 0 ? i - 1 : -i - 2;
            return ((AbstractINodeDiff)this.diffs.get(priorIndex)).getSnapshot();
        }
        if (i >= 0) {
            return ((AbstractINodeDiff)this.diffs.get(i)).getSnapshot();
        }
        if (i < -1) {
            return ((AbstractINodeDiff)this.diffs.get(-i - 2)).getSnapshot();
        }
        return null;
    }

    public final Snapshot getPrior(int snapshotId) {
        return this.getPrior(snapshotId, false);
    }

    final Snapshot updatePrior(Snapshot snapshot, Snapshot prior) {
        int id = snapshot == null ? -1 : snapshot.getId();
        Snapshot s = this.getPrior(id, true);
        if (s != null && (prior == null || Snapshot.ID_COMPARATOR.compare(s, prior) > 0)) {
            return s;
        }
        return prior;
    }

    public final D getDiff(Snapshot snapshot) {
        return this.getDiffById(snapshot == null ? -1 : snapshot.getId());
    }

    private final D getDiffById(int snapshotId) {
        if (snapshotId == -1) {
            return null;
        }
        int i = Collections.binarySearch(this.diffs, snapshotId);
        if (i >= 0) {
            return (D)((AbstractINodeDiff)this.diffs.get(i));
        }
        int j = -i - 1;
        return (D)(j < this.diffs.size() ? (AbstractINodeDiff)this.diffs.get(j) : null);
    }

    public final Snapshot getSnapshotById(int snapshotId) {
        D diff = this.getDiffById(snapshotId);
        return diff == null ? null : ((AbstractINodeDiff)diff).getSnapshot();
    }

    final boolean changedBetweenSnapshots(Snapshot earlier, Snapshot later) {
        int laterDiffIndex;
        int size = this.diffs.size();
        int earlierDiffIndex = Collections.binarySearch(this.diffs, earlier.getId());
        if (-earlierDiffIndex - 1 == size) {
            return false;
        }
        return later == null || (laterDiffIndex = Collections.binarySearch(this.diffs, later.getId())) != -1 && laterDiffIndex != 0;
    }

    N getSnapshotINode(Snapshot snapshot, N currentINode) {
        D diff = this.getDiff(snapshot);
        Object inode = diff == null ? null : ((AbstractINodeDiff)diff).getSnapshotINode();
        return (N)(inode == null ? currentINode : inode);
    }

    final D checkAndAddLatestSnapshotDiff(Snapshot latest, N currentINode) throws QuotaExceededException {
        D last = this.getLast();
        if (last != null && Snapshot.ID_COMPARATOR.compare(((AbstractINodeDiff)last).getSnapshot(), latest) >= 0) {
            return last;
        }
        try {
            return this.addDiff(latest, currentINode);
        }
        catch (NSQuotaExceededException e) {
            e.setMessagePrefix("Failed to record modification for snapshot");
            throw e;
        }
    }

    public void saveSelf2Snapshot(Snapshot latest, N currentINode, N snapshotCopy) throws QuotaExceededException {
        if (latest != null) {
            D diff = this.checkAndAddLatestSnapshotDiff(latest, currentINode);
            if (((AbstractINodeDiff)diff).snapshotINode == null) {
                if (snapshotCopy == null) {
                    snapshotCopy = this.createSnapshotCopy(currentINode);
                }
                ((AbstractINodeDiff)diff).saveSnapshotCopy(snapshotCopy, currentINode);
            }
        }
    }

    @Override
    public Iterator<D> iterator() {
        return this.diffs.iterator();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.diffs;
    }
}

