/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.AuditLogger;
import org.apache.hadoop.mapred.CleanupQueue;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInfo;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.JobTrackerInstrumentation;
import org.apache.hadoop.mapred.JobTrackerStatistics;
import org.apache.hadoop.mapred.Operation;
import org.apache.hadoop.mapred.ResourceEstimator;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobCounter;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.JobFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistory;
import org.apache.hadoop.mapreduce.jobhistory.JobInfoChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobInitedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobPriorityChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobStatusChangedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobSubmittedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.jobhistory.MapAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.ReduceAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFailedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskStartedEvent;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.security.token.DelegationTokenRenewal;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.server.jobtracker.TaskTracker;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.split.SplitMetaInfoReader;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.LimitedPrivate(value={"MapReduce"})
@InterfaceStability.Unstable
public class JobInProgress {
    static final Log LOG = LogFactory.getLog(JobInProgress.class);
    JobProfile profile;
    JobStatus status;
    Path jobFile = null;
    Path localJobFile = null;
    TaskInProgress[] maps = new TaskInProgress[0];
    TaskInProgress[] reduces = new TaskInProgress[0];
    TaskInProgress[] cleanup = new TaskInProgress[0];
    TaskInProgress[] setup = new TaskInProgress[0];
    int numMapTasks = 0;
    int numReduceTasks = 0;
    final long memoryPerMap;
    final long memoryPerReduce;
    volatile int numSlotsPerMap = 1;
    volatile int numSlotsPerReduce = 1;
    final int maxTaskFailuresPerTracker;
    int runningMapTasks = 0;
    int runningReduceTasks = 0;
    int finishedMapTasks = 0;
    int finishedReduceTasks = 0;
    int failedMapTasks = 0;
    int failedReduceTasks = 0;
    static final float DEFAULT_COMPLETED_MAPS_PERCENT_FOR_REDUCE_SLOWSTART = 0.05f;
    int completedMapsForReduceSlowstart = 0;
    int speculativeMapTasks = 0;
    int speculativeReduceTasks = 0;
    int mapFailuresPercent = 0;
    int reduceFailuresPercent = 0;
    int failedMapTIPs = 0;
    int failedReduceTIPs = 0;
    private volatile boolean launchedCleanup = false;
    private volatile boolean launchedSetup = false;
    private volatile boolean jobKilled = false;
    private volatile boolean jobFailed = false;
    private final boolean jobSetupCleanupNeeded;
    private final boolean taskCleanupNeeded;
    JobPriority priority = JobPriority.NORMAL;
    protected JobTracker jobtracker;
    protected Credentials tokenStorage;
    JobHistory jobHistory;
    Map<Node, List<TaskInProgress>> nonRunningMapCache;
    Map<Node, Set<TaskInProgress>> runningMapCache;
    List<TaskInProgress> nonLocalMaps;
    Set<TaskInProgress> nonLocalRunningMaps;
    List<TaskInProgress> nonRunningReduces;
    Set<TaskInProgress> runningReduces;
    List<TaskAttemptID> mapCleanupTasks = new LinkedList<TaskAttemptID>();
    List<TaskAttemptID> reduceCleanupTasks = new LinkedList<TaskAttemptID>();
    int maxLevel;
    int anyCacheLevel;
    private static final int NON_LOCAL_CACHE_LEVEL = -1;
    private int taskCompletionEventTracker = 0;
    List<TaskCompletionEvent> taskCompletionEvents;
    private static final double CLUSTER_BLACKLIST_PERCENT = 0.25;
    private static final double MAX_ALLOWED_FETCH_FAILURES_PERCENT = 0.5;
    private volatile int clusterSize = 0;
    private volatile int flakyTaskTrackers = 0;
    private Map<String, Integer> trackerToFailuresMap = new TreeMap<String, Integer>();
    ResourceEstimator resourceEstimator;
    long startTime;
    long launchTime;
    long finishTime;
    final Map<TaskType, Long> firstTaskLaunchTimes = new EnumMap<TaskType, Long>(TaskType.class);
    private final int restartCount;
    JobConf conf;
    protected AtomicBoolean tasksInited = new AtomicBoolean(false);
    private JobInitKillStatus jobInitKillStatus = new JobInitKillStatus();
    LocalFileSystem localFs;
    FileSystem fs;
    String user;
    JobID jobId;
    private volatile boolean hasSpeculativeMaps;
    private volatile boolean hasSpeculativeReduces;
    long inputLength = 0L;
    org.apache.hadoop.mapred.Counters jobCounters = new org.apache.hadoop.mapred.Counters();
    private static final int MAX_FETCH_FAILURES_NOTIFICATIONS = 3;
    private static final int MIN_SPEC_CAP = 10;
    private static final float MIN_SLOTS_CAP = 0.01f;
    private Map<TaskAttemptID, Integer> mapTaskIdToFetchFailuresMap = new TreeMap<TaskAttemptID, Integer>();
    private Object schedulingInfo;
    private String submitHostName;
    private String submitHostAddress;
    float slowTaskThreshold;
    float speculativeCap;
    float slowNodeThreshold;
    private DataStatistics mapTaskStats = new DataStatistics();
    private DataStatistics reduceTaskStats = new DataStatistics();
    private Map<String, DataStatistics> trackerMapStats = new HashMap<String, DataStatistics>();
    private Map<String, DataStatistics> trackerReduceStats = new HashMap<String, DataStatistics>();
    private DataStatistics runningMapTaskStats = new DataStatistics();
    private DataStatistics runningReduceTaskStats = new DataStatistics();
    private Map<TaskTracker, FallowSlotInfo> trackersReservedForMaps = new HashMap<TaskTracker, FallowSlotInfo>();
    private Map<TaskTracker, FallowSlotInfo> trackersReservedForReduces = new HashMap<TaskTracker, FallowSlotInfo>();
    private Path jobSubmitDir = null;

    protected JobInProgress(JobID jobid, JobConf conf, JobTracker tracker) {
        this.conf = conf;
        this.jobId = jobid;
        this.numMapTasks = conf.getNumMapTasks();
        this.numReduceTasks = conf.getNumReduceTasks();
        this.maxLevel = 2;
        this.anyCacheLevel = this.maxLevel + 1;
        this.jobtracker = tracker;
        this.restartCount = 0;
        this.profile = new JobProfile(conf.getUser(), jobid, "", "", conf.getJobName(), conf.getQueueName());
        this.memoryPerMap = conf.getMemoryForMapTask();
        this.memoryPerReduce = conf.getMemoryForReduceTask();
        this.maxTaskFailuresPerTracker = conf.getMaxTaskFailuresPerTracker();
        this.hasSpeculativeMaps = conf.getMapSpeculativeExecution();
        this.hasSpeculativeReduces = conf.getReduceSpeculativeExecution();
        this.nonLocalMaps = new LinkedList<TaskInProgress>();
        this.nonLocalRunningMaps = new LinkedHashSet<TaskInProgress>();
        this.runningMapCache = new IdentityHashMap<Node, Set<TaskInProgress>>();
        this.nonRunningReduces = new LinkedList<TaskInProgress>();
        this.runningReduces = new LinkedHashSet<TaskInProgress>();
        this.resourceEstimator = new ResourceEstimator(this);
        this.status = new JobStatus(jobid, 0.0f, 0.0f, JobStatus.PREP, this.profile.getUser(), this.profile.getJobName(), this.profile.getJobFile(), "");
        this.jobtracker.getInstrumentation().addPrepJob(conf, jobid);
        this.taskCompletionEvents = new ArrayList<TaskCompletionEvent>(this.numMapTasks + this.numReduceTasks + 10);
        this.slowTaskThreshold = Math.max(0.0f, conf.getFloat("mapreduce.job.speculative.slowtaskthreshold", 1.0f));
        this.speculativeCap = conf.getFloat("mapreduce.job.speculative.speculativecap", 0.1f);
        this.slowNodeThreshold = conf.getFloat("mapreduce.job.speculative.slownodethreshold", 1.0f);
        this.jobSetupCleanupNeeded = conf.getBoolean("mapreduce.job.committer.setup.cleanup.needed", true);
        this.taskCleanupNeeded = conf.getBoolean("mapreduce.job.committer.task.cleanup.needed", true);
        if (tracker != null) {
            this.jobHistory = tracker.getJobHistory();
        }
        this.tokenStorage = null;
    }

    JobInProgress(JobConf conf) {
        this.restartCount = 0;
        this.jobSetupCleanupNeeded = false;
        this.taskCleanupNeeded = true;
        this.memoryPerMap = conf.getMemoryForMapTask();
        this.memoryPerReduce = conf.getMemoryForReduceTask();
        this.maxTaskFailuresPerTracker = conf.getMaxTaskFailuresPerTracker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInProgress(JobTracker jobtracker, final JobConf default_conf, int rCount, JobInfo jobInfo, Credentials ts) throws IOException, InterruptedException {
        try {
            String primaryGroup;
            this.restartCount = rCount;
            this.jobId = JobID.downgrade(jobInfo.getJobID());
            String url = "http://" + jobtracker.getJobTrackerMachine() + ":" + jobtracker.getInfoPort() + "/jobdetails.jsp?jobid=" + this.jobId;
            this.jobtracker = jobtracker;
            this.jobHistory = jobtracker.getJobHistory();
            this.startTime = System.currentTimeMillis();
            this.localFs = jobtracker.getLocalFileSystem();
            this.tokenStorage = ts;
            this.jobSubmitDir = jobInfo.getJobSubmitDir();
            this.user = jobInfo.getUser().toString();
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)this.user);
            if (ts != null) {
                for (Token token : ts.getAllTokens()) {
                    ugi.addToken(token);
                }
            }
            this.fs = (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws IOException {
                    return JobInProgress.this.jobSubmitDir.getFileSystem((Configuration)default_conf);
                }
            });
            this.localJobFile = default_conf.getLocalPath("jobTracker/" + this.jobId + ".xml");
            this.jobFile = JobSubmissionFiles.getJobConfPath(this.jobSubmitDir);
            this.fs.copyToLocalFile(this.jobFile, this.localJobFile);
            this.conf = new JobConf(this.localJobFile);
            if (this.conf.getUser() == null) {
                this.conf.setUser(this.user);
            }
            if (!this.conf.getUser().equals(this.user)) {
                String desc = "The username " + this.conf.getUser() + " obtained from the " + "conf doesn't match the username " + this.user + " the user " + "authenticated as";
                AuditLogger.logFailure(this.user, Operation.SUBMIT_JOB.name(), this.conf.getUser(), this.jobId.toString(), desc);
                throw new IOException(desc);
            }
            String[] userGroups = ugi.getGroupNames();
            String string = primaryGroup = userGroups.length > 0 ? userGroups[0] : null;
            if (primaryGroup != null) {
                this.conf.set("group.name", primaryGroup);
            }
            this.priority = this.conf.getJobPriority();
            this.profile = new JobProfile(this.conf.getUser(), this.jobId, this.jobFile.toString(), url, this.conf.getJobName(), this.conf.getQueueName());
            this.status = new JobStatus(this.jobId, 0.0f, 0.0f, JobStatus.PREP, this.profile.getUser(), this.profile.getJobName(), this.profile.getJobFile(), this.profile.getURL().toString());
            this.jobtracker.getInstrumentation().addPrepJob(this.conf, this.jobId);
            this.status.setStartTime(this.startTime);
            this.status.setJobPriority(this.priority);
            this.numMapTasks = this.conf.getNumMapTasks();
            this.numReduceTasks = this.conf.getNumReduceTasks();
            this.memoryPerMap = this.conf.getMemoryForMapTask();
            this.memoryPerReduce = this.conf.getMemoryForReduceTask();
            this.taskCompletionEvents = new ArrayList<TaskCompletionEvent>(this.numMapTasks + this.numReduceTasks + 10);
            JobContextImpl jobContext = new JobContextImpl(this.conf, this.jobId);
            this.jobSetupCleanupNeeded = jobContext.getJobSetupCleanupNeeded();
            this.taskCleanupNeeded = jobContext.getTaskCleanupNeeded();
            this.status.setJobACLs(jobtracker.getJobACLsManager().constructJobACLs(this.conf));
            this.mapFailuresPercent = this.conf.getMaxMapTaskFailuresPercent();
            this.reduceFailuresPercent = this.conf.getMaxReduceTaskFailuresPercent();
            this.maxTaskFailuresPerTracker = this.conf.getMaxTaskFailuresPerTracker();
            this.hasSpeculativeMaps = this.conf.getMapSpeculativeExecution();
            this.hasSpeculativeReduces = this.conf.getReduceSpeculativeExecution();
            this.maxLevel = jobtracker.getNumTaskCacheLevels();
            this.anyCacheLevel = this.maxLevel + 1;
            this.nonLocalMaps = new LinkedList<TaskInProgress>();
            this.nonLocalRunningMaps = new LinkedHashSet<TaskInProgress>();
            this.runningMapCache = new IdentityHashMap<Node, Set<TaskInProgress>>();
            this.nonRunningReduces = new LinkedList<TaskInProgress>();
            this.runningReduces = new LinkedHashSet<TaskInProgress>();
            this.resourceEstimator = new ResourceEstimator(this);
            this.submitHostName = this.conf.getJobSubmitHostName();
            this.submitHostAddress = this.conf.getJobSubmitHostAddress();
            this.slowTaskThreshold = Math.max(0.0f, this.conf.getFloat("mapreduce.job.speculative.slowtaskthreshold", 1.0f));
            this.speculativeCap = this.conf.getFloat("mapreduce.job.speculative.speculativecap", 0.1f);
            this.slowNodeThreshold = this.conf.getFloat("mapreduce.job.speculative.slownodethreshold", 1.0f);
            DelegationTokenRenewal.registerDelegationTokensForRenewal(jobInfo.getJobID(), ts, jobtracker.getConf());
        }
        finally {
            FileSystem.closeAllForUGI((UserGroupInformation)UserGroupInformation.getCurrentUser());
        }
    }

    private void printCache(Map<Node, List<TaskInProgress>> cache) {
        LOG.info((Object)"The taskcache info:");
        for (Map.Entry<Node, List<TaskInProgress>> n : cache.entrySet()) {
            List<TaskInProgress> tips = n.getValue();
            LOG.info((Object)("Cached TIPs on node: " + n.getKey()));
            for (TaskInProgress tip : tips) {
                LOG.info((Object)("tip : " + tip.getTIPId()));
            }
        }
    }

    Map<Node, List<TaskInProgress>> createCache(JobSplit.TaskSplitMetaInfo[] splits, int maxLevel) {
        IdentityHashMap<Node, List<TaskInProgress>> cache = new IdentityHashMap<Node, List<TaskInProgress>>(maxLevel);
        for (int i = 0; i < splits.length; ++i) {
            String[] splitLocations = splits[i].getLocations();
            if (splitLocations.length == 0) {
                this.nonLocalMaps.add(this.maps[i]);
                continue;
            }
            for (String host : splitLocations) {
                Node node = this.jobtracker.resolveAndAddToTopology(host);
                LOG.info((Object)("tip:" + this.maps[i].getTIPId() + " has split on node:" + node));
                for (int j = 0; j < maxLevel; ++j) {
                    ArrayList<TaskInProgress> hostMaps = (ArrayList<TaskInProgress>)cache.get(node);
                    if (hostMaps == null) {
                        hostMaps = new ArrayList<TaskInProgress>();
                        cache.put(node, hostMaps);
                        hostMaps.add(this.maps[i]);
                    }
                    if (hostMaps.get(hostMaps.size() - 1) != this.maps[i]) {
                        hostMaps.add(this.maps[i]);
                    }
                    node = node.getParent();
                }
            }
        }
        return cache;
    }

    public boolean inited() {
        return this.tasksInited.get();
    }

    public String getUser() {
        return this.user;
    }

    boolean getMapSpeculativeExecution() {
        return this.hasSpeculativeMaps;
    }

    boolean getReduceSpeculativeExecution() {
        return this.hasSpeculativeReduces;
    }

    long getMemoryForMapTask() {
        return this.memoryPerMap;
    }

    long getMemoryForReduceTask() {
        return this.memoryPerReduce;
    }

    int getNumSlotsPerMap() {
        return this.numSlotsPerMap;
    }

    void setNumSlotsPerMap(int numSlotsPerMap) {
        this.numSlotsPerMap = numSlotsPerMap;
    }

    int getNumSlotsPerReduce() {
        return this.numSlotsPerReduce;
    }

    void setNumSlotsPerReduce(int numSlotsPerReduce) {
        this.numSlotsPerReduce = numSlotsPerReduce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initTasks() throws IOException, KillInterruptedException {
        if (this.tasksInited.get() || this.isComplete()) {
            return;
        }
        JobInitKillStatus jobInitKillStatus = this.jobInitKillStatus;
        synchronized (jobInitKillStatus) {
            if (this.jobInitKillStatus.killed || this.jobInitKillStatus.initStarted) {
                return;
            }
            this.jobInitKillStatus.initStarted = true;
        }
        LOG.info((Object)("Initializing " + this.jobId));
        this.logSubmissionToJobHistory();
        this.setPriority(this.priority);
        this.generateAndStoreTokens();
        JobSplit.TaskSplitMetaInfo[] taskSplitMetaInfo = this.createSplits(this.jobId);
        this.numMapTasks = taskSplitMetaInfo.length;
        this.checkTaskLimits();
        this.jobtracker.getInstrumentation().addWaitingMaps(this.getJobID(), this.numMapTasks);
        this.jobtracker.getInstrumentation().addWaitingReduces(this.getJobID(), this.numReduceTasks);
        this.createMapTasks(this.jobFile.toString(), taskSplitMetaInfo);
        if (this.numMapTasks > 0) {
            this.nonRunningMapCache = this.createCache(taskSplitMetaInfo, this.maxLevel);
        }
        this.launchTime = JobTracker.getClock().getTime();
        this.createReduceTasks(this.jobFile.toString());
        this.completedMapsForReduceSlowstart = (int)Math.ceil(this.conf.getFloat("mapreduce.job.reduce.slowstart.completedmaps", 0.05f) * (float)this.numMapTasks);
        this.initSetupCleanupTasks(this.jobFile.toString());
        JobInitKillStatus jobInitKillStatus2 = this.jobInitKillStatus;
        synchronized (jobInitKillStatus2) {
            this.jobInitKillStatus.initDone = true;
            if (this.jobInitKillStatus.killed) {
                throw new KillInterruptedException("Job " + this.jobId + " killed in init");
            }
        }
        this.tasksInited.set(true);
        JobInitedEvent jie = new JobInitedEvent(this.profile.getJobID(), this.launchTime, this.numMapTasks, this.numReduceTasks, JobStatus.getJobRunState(JobStatus.PREP));
        this.jobHistory.logEvent(jie, this.jobId);
        LOG.info((Object)("Job " + this.jobId + " initialized successfully with " + this.numMapTasks + " map tasks and " + this.numReduceTasks + " reduce tasks."));
    }

    synchronized boolean isJobEmpty() {
        return this.maps.length == 0 && this.reduces.length == 0 && !this.jobSetupCleanupNeeded;
    }

    synchronized boolean isSetupCleanupRequired() {
        return this.jobSetupCleanupNeeded;
    }

    synchronized void completeEmptyJob() {
        this.jobComplete();
    }

    synchronized void completeSetup() {
        this.setupComplete();
    }

    void logSubmissionToJobHistory() throws IOException {
        String username = this.conf.getUser();
        if (username == null) {
            username = "";
        }
        String jobname = this.conf.getJobName();
        String jobQueueName = this.conf.getQueueName();
        this.setUpLocalizedJobConf(this.conf, this.jobId);
        this.jobHistory.setupEventWriter(this.jobId, this.conf);
        JobSubmittedEvent jse = new JobSubmittedEvent(this.jobId, jobname, username, this.startTime, this.jobFile.toString(), this.status.getJobACLs(), jobQueueName);
        this.jobHistory.logEvent(jse, this.jobId);
    }

    JobSplit.TaskSplitMetaInfo[] createSplits(org.apache.hadoop.mapreduce.JobID jobId) throws IOException {
        JobSplit.TaskSplitMetaInfo[] allTaskSplitMetaInfo = SplitMetaInfoReader.readSplitMetaInfo(jobId, this.fs, this.conf, this.jobSubmitDir);
        return allTaskSplitMetaInfo;
    }

    void checkTaskLimits() throws IOException {
        int maxTasks = this.jobtracker.getMaxTasksPerJob();
        if (maxTasks > 0 && this.numMapTasks + this.numReduceTasks > maxTasks) {
            throw new IOException("The number of tasks for this job " + (this.numMapTasks + this.numReduceTasks) + " exceeds the configured limit " + maxTasks);
        }
    }

    synchronized void createMapTasks(String jobFile, JobSplit.TaskSplitMetaInfo[] splits) {
        this.maps = new TaskInProgress[this.numMapTasks];
        for (int i = 0; i < this.numMapTasks; ++i) {
            this.inputLength += splits[i].getInputDataLength();
            this.maps[i] = new TaskInProgress(this.jobId, jobFile, splits[i], this.jobtracker, this.conf, this, i, this.numSlotsPerMap);
        }
        LOG.info((Object)("Input size for job " + this.jobId + " = " + this.inputLength + ". Number of splits = " + splits.length));
    }

    synchronized void createReduceTasks(String jobFile) {
        this.reduces = new TaskInProgress[this.numReduceTasks];
        for (int i = 0; i < this.numReduceTasks; ++i) {
            this.reduces[i] = new TaskInProgress(this.jobId, jobFile, this.numMapTasks, i, this.jobtracker, this.conf, this, this.numSlotsPerReduce);
            this.nonRunningReduces.add(this.reduces[i]);
        }
    }

    synchronized void initSetupCleanupTasks(String jobFile) {
        if (!this.jobSetupCleanupNeeded) {
            LOG.info((Object)("Setup/Cleanup not needed for job " + this.jobId));
            return;
        }
        this.cleanup = new TaskInProgress[2];
        JobSplit.TaskSplitMetaInfo emptySplit = JobSplit.EMPTY_TASK_SPLIT;
        this.cleanup[0] = new TaskInProgress(this.jobId, jobFile, emptySplit, this.jobtracker, this.conf, this, this.numMapTasks, 1);
        this.cleanup[0].setJobCleanupTask();
        this.cleanup[1] = new TaskInProgress(this.jobId, jobFile, this.numMapTasks, this.numReduceTasks, this.jobtracker, this.conf, this, 1);
        this.cleanup[1].setJobCleanupTask();
        this.setup = new TaskInProgress[2];
        this.setup[0] = new TaskInProgress(this.jobId, jobFile, emptySplit, this.jobtracker, this.conf, this, this.numMapTasks + 1, 1);
        this.setup[0].setJobSetupTask();
        this.setup[1] = new TaskInProgress(this.jobId, jobFile, this.numMapTasks, this.numReduceTasks + 1, this.jobtracker, this.conf, this, 1);
        this.setup[1].setJobSetupTask();
    }

    void setupComplete() {
        this.status.setSetupProgress(1.0f);
        if (this.status.getRunState() == JobStatus.PREP) {
            this.changeStateTo(JobStatus.RUNNING);
            JobStatusChangedEvent jse = new JobStatusChangedEvent(this.profile.getJobID(), JobStatus.getJobRunState(JobStatus.RUNNING));
            this.jobHistory.logEvent(jse, this.profile.getJobID());
        }
    }

    public JobProfile getProfile() {
        return this.profile;
    }

    public JobStatus getStatus() {
        return this.status;
    }

    public synchronized long getLaunchTime() {
        return this.launchTime;
    }

    Map<TaskType, Long> getFirstTaskLaunchTimes() {
        return this.firstTaskLaunchTimes;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public int desiredMaps() {
        return this.numMapTasks;
    }

    public synchronized int finishedMaps() {
        return this.finishedMapTasks;
    }

    public int desiredReduces() {
        return this.numReduceTasks;
    }

    public synchronized int runningMaps() {
        return this.runningMapTasks;
    }

    public synchronized int runningReduces() {
        return this.runningReduceTasks;
    }

    public synchronized int finishedReduces() {
        return this.finishedReduceTasks;
    }

    public synchronized int pendingMaps() {
        return this.numMapTasks - this.runningMapTasks - this.failedMapTIPs - this.finishedMapTasks + this.speculativeMapTasks;
    }

    public synchronized int pendingReduces() {
        return this.numReduceTasks - this.runningReduceTasks - this.failedReduceTIPs - this.finishedReduceTasks + this.speculativeReduceTasks;
    }

    public int getNumSlotsPerTask(TaskType taskType) {
        if (taskType == TaskType.MAP) {
            return this.numSlotsPerMap;
        }
        if (taskType == TaskType.REDUCE) {
            return this.numSlotsPerReduce;
        }
        return 1;
    }

    public JobPriority getPriority() {
        return this.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(JobPriority priority) {
        if (priority == null) {
            priority = JobPriority.NORMAL;
        }
        JobInProgress jobInProgress = this;
        synchronized (jobInProgress) {
            this.priority = priority;
            this.status.setJobPriority(priority);
            JobPriorityChangeEvent prEvent = new JobPriorityChangeEvent(this.jobId, priority);
            this.jobHistory.logEvent(prEvent, this.jobId);
        }
    }

    synchronized void updateJobInfo(long startTime, long launchTime) {
        this.startTime = startTime;
        this.launchTime = launchTime;
        JobInfoChangeEvent event = new JobInfoChangeEvent(this.jobId, startTime, launchTime);
        this.jobHistory.logEvent(event, this.jobId);
    }

    int getNumRestarts() {
        return this.restartCount;
    }

    long getInputLength() {
        return this.inputLength;
    }

    boolean isCleanupLaunched() {
        return this.launchedCleanup;
    }

    boolean isSetupLaunched() {
        return this.launchedSetup;
    }

    TaskInProgress[] getTasks(TaskType type) {
        TaskInProgress[] tasks = null;
        switch (type) {
            case MAP: {
                tasks = this.maps;
                break;
            }
            case REDUCE: {
                tasks = this.reduces;
                break;
            }
            case JOB_SETUP: {
                tasks = this.setup;
                break;
            }
            case JOB_CLEANUP: {
                tasks = this.cleanup;
                break;
            }
            default: {
                tasks = new TaskInProgress[]{};
            }
        }
        return tasks;
    }

    Set<TaskInProgress> getNonLocalRunningMaps() {
        return this.nonLocalRunningMaps;
    }

    Map<Node, Set<TaskInProgress>> getRunningMapCache() {
        return this.runningMapCache;
    }

    Set<TaskInProgress> getRunningReduces() {
        return this.runningReduces;
    }

    JobConf getJobConf() {
        return this.conf;
    }

    public synchronized Vector<TaskInProgress> reportTasksInProgress(boolean shouldBeMap, boolean shouldBeComplete) {
        Vector<TaskInProgress> results = new Vector<TaskInProgress>();
        TaskInProgress[] tips = null;
        tips = shouldBeMap ? this.maps : this.reduces;
        for (int i = 0; i < tips.length; ++i) {
            if (tips[i].isComplete() != shouldBeComplete) continue;
            results.add(tips[i]);
        }
        return results;
    }

    public synchronized Vector<TaskInProgress> reportCleanupTIPs(boolean shouldBeComplete) {
        Vector<TaskInProgress> results = new Vector<TaskInProgress>();
        for (int i = 0; i < this.cleanup.length; ++i) {
            if (this.cleanup[i].isComplete() != shouldBeComplete) continue;
            results.add(this.cleanup[i]);
        }
        return results;
    }

    public synchronized Vector<TaskInProgress> reportSetupTIPs(boolean shouldBeComplete) {
        Vector<TaskInProgress> results = new Vector<TaskInProgress>();
        for (int i = 0; i < this.setup.length; ++i) {
            if (this.setup[i].isComplete() != shouldBeComplete) continue;
            results.add(this.setup[i]);
        }
        return results;
    }

    public synchronized void updateTaskStatus(TaskInProgress tip, TaskStatus status) {
        boolean change;
        double oldProgress = tip.getProgress();
        boolean wasRunning = tip.isRunning();
        boolean wasComplete = tip.isComplete();
        boolean wasPending = tip.isOnlyCommitPending();
        TaskAttemptID taskid = status.getTaskID();
        boolean wasAttemptRunning = tip.isAttemptRunning(taskid);
        if ((wasComplete || tip.wasKilled(taskid)) && status.getRunState() == TaskStatus.State.SUCCEEDED) {
            status.setRunState(TaskStatus.State.KILLED);
        }
        if ((this.isComplete() || this.jobFailed || this.jobKilled || !this.taskCleanupNeeded) && !tip.isCleanupAttempt(taskid)) {
            if (status.getRunState() == TaskStatus.State.FAILED_UNCLEAN) {
                status.setRunState(TaskStatus.State.FAILED);
            } else if (status.getRunState() == TaskStatus.State.KILLED_UNCLEAN) {
                status.setRunState(TaskStatus.State.KILLED);
            }
        }
        if (change = tip.updateStatus(status)) {
            TaskStatus.State state = status.getRunState();
            TaskTracker taskTracker = this.jobtracker.getTaskTracker(tip.machineWhereTaskRan(taskid));
            TaskTrackerStatus ttStatus = taskTracker == null ? null : taskTracker.getStatus();
            String taskTrackerHttpLocation = null;
            if (null != ttStatus) {
                String host = NetUtils.getStaticResolution((String)ttStatus.getHost()) != null ? NetUtils.getStaticResolution((String)ttStatus.getHost()) : ttStatus.getHost();
                taskTrackerHttpLocation = "http://" + host + ":" + ttStatus.getHttpPort();
            }
            TaskCompletionEvent taskEvent = null;
            if (state == TaskStatus.State.SUCCEEDED) {
                taskEvent = new TaskCompletionEvent(this.taskCompletionEventTracker, taskid, tip.idWithinJob(), status.getIsMap() && !tip.isJobCleanupTask() && !tip.isJobSetupTask(), TaskCompletionEvent.Status.SUCCEEDED, taskTrackerHttpLocation);
                taskEvent.setTaskRunTime((int)(status.getFinishTime() - status.getStartTime()));
                tip.setSuccessEventNumber(this.taskCompletionEventTracker);
            } else {
                if (state == TaskStatus.State.COMMIT_PENDING) {
                    if (!wasComplete && !wasPending) {
                        tip.doCommit(taskid);
                    }
                    return;
                }
                if (state == TaskStatus.State.FAILED_UNCLEAN || state == TaskStatus.State.KILLED_UNCLEAN) {
                    tip.incompleteSubTask(taskid, this.status);
                    if (tip.isMapTask()) {
                        this.mapCleanupTasks.add(taskid);
                    } else {
                        this.reduceCleanupTasks.add(taskid);
                    }
                    this.jobtracker.removeTaskEntry(taskid);
                } else if (state == TaskStatus.State.FAILED || state == TaskStatus.State.KILLED) {
                    TaskCompletionEvent.Status taskCompletionStatus;
                    TaskCompletionEvent t;
                    int eventNumber = tip.getSuccessEventNumber();
                    if (eventNumber != -1 && (t = this.taskCompletionEvents.get(eventNumber)).getTaskAttemptId().equals(taskid)) {
                        t.setTaskStatus(TaskCompletionEvent.Status.OBSOLETE);
                    }
                    this.failedTask(tip, taskid, status, taskTracker, wasRunning, wasComplete, wasAttemptRunning);
                    TaskCompletionEvent.Status status2 = taskCompletionStatus = state == TaskStatus.State.FAILED ? TaskCompletionEvent.Status.FAILED : TaskCompletionEvent.Status.KILLED;
                    if (tip.isFailed()) {
                        taskCompletionStatus = TaskCompletionEvent.Status.TIPFAILED;
                    }
                    taskEvent = new TaskCompletionEvent(this.taskCompletionEventTracker, taskid, tip.idWithinJob(), status.getIsMap() && !tip.isJobCleanupTask() && !tip.isJobSetupTask(), taskCompletionStatus, taskTrackerHttpLocation);
                }
            }
            if (taskEvent != null) {
                this.taskCompletionEvents.add(taskEvent);
                ++this.taskCompletionEventTracker;
                JobTrackerStatistics.TaskTrackerStat ttStat = this.jobtracker.getStatistics().getTaskTrackerStat(tip.machineWhereTaskRan(taskid));
                if (ttStat != null) {
                    ttStat.incrTotalTasks();
                }
                if (state == TaskStatus.State.SUCCEEDED) {
                    this.completedTask(tip, status);
                    if (ttStat != null) {
                        ttStat.incrSucceededTasks();
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Taking progress for " + tip.getTIPId() + " from " + oldProgress + " to " + tip.getProgress()));
        }
        if (!tip.isJobCleanupTask() && !tip.isJobSetupTask()) {
            double progressDelta = tip.getProgress() - oldProgress;
            if (tip.isMapTask()) {
                this.status.setMapProgress((float)((double)this.status.mapProgress() + progressDelta / (double)this.maps.length));
            } else {
                this.status.setReduceProgress((float)((double)this.status.reduceProgress() + progressDelta / (double)this.reduces.length));
            }
        }
    }

    public synchronized org.apache.hadoop.mapred.Counters getJobCounters() {
        return this.jobCounters;
    }

    public synchronized org.apache.hadoop.mapred.Counters getMapCounters() {
        return this.incrementTaskCounters(new org.apache.hadoop.mapred.Counters(), this.maps);
    }

    public synchronized org.apache.hadoop.mapred.Counters getReduceCounters() {
        return this.incrementTaskCounters(new org.apache.hadoop.mapred.Counters(), this.reduces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.apache.hadoop.mapred.Counters getCounters() {
        org.apache.hadoop.mapred.Counters result = new org.apache.hadoop.mapred.Counters();
        JobInProgress jobInProgress = this;
        synchronized (jobInProgress) {
            result.incrAllCounters(this.getJobCounters());
        }
        this.incrementTaskCounters(result, this.maps);
        return this.incrementTaskCounters(result, this.reduces);
    }

    private org.apache.hadoop.mapred.Counters incrementTaskCounters(org.apache.hadoop.mapred.Counters counters, TaskInProgress[] tips) {
        for (TaskInProgress tip : tips) {
            counters.incrAllCounters(tip.getCounters());
        }
        return counters;
    }

    public synchronized Task obtainNewMapTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts, int maxCacheLevel) throws IOException {
        if (this.status.getRunState() != JobStatus.RUNNING) {
            LOG.info((Object)("Cannot create task split for " + this.profile.getJobID()));
            return null;
        }
        int target = this.findNewMapTask(tts, clusterSize, numUniqueHosts, maxCacheLevel);
        if (target == -1) {
            return null;
        }
        Task result = this.maps[target].getTaskToRun(tts.getTrackerName());
        if (result != null) {
            this.addRunningTaskToTIP(this.maps[target], result.getTaskID(), tts, true);
        }
        return result;
    }

    public synchronized Task obtainNewMapTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts) throws IOException {
        return this.obtainNewMapTask(tts, clusterSize, numUniqueHosts, this.anyCacheLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task obtainTaskCleanupTask(TaskTrackerStatus tts, boolean isMapSlot) throws IOException {
        if (!this.tasksInited.get()) {
            return null;
        }
        JobInProgress jobInProgress = this;
        synchronized (jobInProgress) {
            if (this.status.getRunState() != JobStatus.RUNNING || this.jobFailed || this.jobKilled) {
                return null;
            }
            String taskTracker = tts.getTrackerName();
            if (!this.shouldRunOnTaskTracker(taskTracker)) {
                return null;
            }
            TaskAttemptID taskid = null;
            TaskInProgress tip = null;
            if (isMapSlot) {
                if (!this.mapCleanupTasks.isEmpty()) {
                    taskid = this.mapCleanupTasks.remove(0);
                    tip = this.maps[taskid.getTaskID().getId()];
                }
            } else if (!this.reduceCleanupTasks.isEmpty()) {
                taskid = this.reduceCleanupTasks.remove(0);
                tip = this.reduces[taskid.getTaskID().getId()];
            }
            if (tip != null) {
                return tip.addRunningTask(taskid, taskTracker, true);
            }
            return null;
        }
    }

    public synchronized Task obtainNewLocalMapTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts) throws IOException {
        if (!this.tasksInited.get()) {
            LOG.info((Object)("Cannot create task split for " + this.profile.getJobID()));
            return null;
        }
        return this.obtainNewMapTask(tts, clusterSize, numUniqueHosts, this.maxLevel);
    }

    public synchronized Task obtainNewNonLocalMapTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts) throws IOException {
        if (!this.tasksInited.get()) {
            LOG.info((Object)("Cannot create task split for " + this.profile.getJobID()));
            return null;
        }
        return this.obtainNewMapTask(tts, clusterSize, numUniqueHosts, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task obtainJobCleanupTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts, boolean isMapSlot) throws IOException {
        if (!this.tasksInited.get() || !this.jobSetupCleanupNeeded) {
            return null;
        }
        JobInProgress jobInProgress = this;
        synchronized (jobInProgress) {
            if (!this.canLaunchJobCleanupTask()) {
                return null;
            }
            String taskTracker = tts.getTrackerName();
            this.clusterSize = clusterSize;
            if (!this.shouldRunOnTaskTracker(taskTracker)) {
                return null;
            }
            ArrayList<TaskInProgress> cleanupTaskList = new ArrayList<TaskInProgress>();
            if (isMapSlot) {
                cleanupTaskList.add(this.cleanup[0]);
            } else {
                cleanupTaskList.add(this.cleanup[1]);
            }
            TaskInProgress tip = this.findTaskFromList(cleanupTaskList, tts, numUniqueHosts, false);
            if (tip == null) {
                return null;
            }
            Task result = tip.getTaskToRun(tts.getTrackerName());
            if (result != null) {
                this.addRunningTaskToTIP(tip, result.getTaskID(), tts, true);
                if (this.jobFailed) {
                    result.setJobCleanupTaskState(JobStatus.State.FAILED);
                } else if (this.jobKilled) {
                    result.setJobCleanupTaskState(JobStatus.State.KILLED);
                } else {
                    result.setJobCleanupTaskState(JobStatus.State.SUCCEEDED);
                }
            }
            return result;
        }
    }

    private synchronized boolean canLaunchJobCleanupTask() {
        boolean launchCleanupTask;
        if (this.status.getRunState() != JobStatus.RUNNING && this.status.getRunState() != JobStatus.PREP) {
            return false;
        }
        if (this.launchedCleanup || !this.isSetupFinished()) {
            return false;
        }
        if (this.jobKilled || this.jobFailed) {
            return true;
        }
        boolean bl = launchCleanupTask = this.finishedMapTasks + this.failedMapTIPs == this.numMapTasks;
        if (launchCleanupTask) {
            launchCleanupTask = this.finishedReduceTasks + this.failedReduceTIPs == this.numReduceTasks;
        }
        return launchCleanupTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task obtainJobSetupTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts, boolean isMapSlot) throws IOException {
        if (!this.tasksInited.get() || !this.jobSetupCleanupNeeded) {
            return null;
        }
        JobInProgress jobInProgress = this;
        synchronized (jobInProgress) {
            if (!this.canLaunchSetupTask()) {
                return null;
            }
            String taskTracker = tts.getTrackerName();
            this.clusterSize = clusterSize;
            if (!this.shouldRunOnTaskTracker(taskTracker)) {
                return null;
            }
            ArrayList<TaskInProgress> setupTaskList = new ArrayList<TaskInProgress>();
            if (isMapSlot) {
                setupTaskList.add(this.setup[0]);
            } else {
                setupTaskList.add(this.setup[1]);
            }
            TaskInProgress tip = this.findTaskFromList(setupTaskList, tts, numUniqueHosts, false);
            if (tip == null) {
                return null;
            }
            Task result = tip.getTaskToRun(tts.getTrackerName());
            if (result != null) {
                this.addRunningTaskToTIP(tip, result.getTaskID(), tts, true);
            }
            return result;
        }
    }

    public synchronized boolean scheduleReduces() {
        return this.finishedMapTasks >= this.completedMapsForReduceSlowstart;
    }

    private synchronized boolean canLaunchSetupTask() {
        return this.tasksInited.get() && this.status.getRunState() == JobStatus.PREP && !this.launchedSetup && !this.jobKilled && !this.jobFailed;
    }

    public synchronized Task obtainNewReduceTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts) throws IOException {
        if (this.status.getRunState() != JobStatus.RUNNING) {
            LOG.info((Object)("Cannot create task split for " + this.profile.getJobID()));
            return null;
        }
        if (!this.scheduleReduces()) {
            return null;
        }
        int target = this.findNewReduceTask(tts, clusterSize, numUniqueHosts);
        if (target == -1) {
            return null;
        }
        Task result = this.reduces[target].getTaskToRun(tts.getTrackerName());
        if (result != null) {
            this.addRunningTaskToTIP(this.reduces[target], result.getTaskID(), tts, true);
        }
        return result;
    }

    private int getMatchingLevelForNodes(Node n1, Node n2) {
        int count = 0;
        do {
            if (n1.equals(n2)) {
                return count;
            }
            ++count;
            n1 = n1.getParent();
            n2 = n2.getParent();
        } while (n1 != null);
        return this.maxLevel;
    }

    synchronized void addRunningTaskToTIP(TaskInProgress tip, TaskAttemptID id, TaskTrackerStatus tts, boolean isScheduled) {
        TaskType name;
        if (!isScheduled) {
            tip.addRunningTask(id, tts.getTrackerName());
        }
        JobTrackerInstrumentation metrics = this.jobtracker.getInstrumentation();
        String splits = "";
        JobCounter counter = null;
        if (tip.isJobSetupTask()) {
            this.launchedSetup = true;
            name = TaskType.JOB_SETUP;
        } else if (tip.isJobCleanupTask()) {
            this.launchedCleanup = true;
            name = TaskType.JOB_CLEANUP;
        } else if (tip.isMapTask()) {
            ++this.runningMapTasks;
            name = TaskType.MAP;
            counter = JobCounter.TOTAL_LAUNCHED_MAPS;
            splits = tip.getSplitNodes();
            if (tip.isSpeculating()) {
                ++this.speculativeMapTasks;
                metrics.speculateMap(id);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Chosen speculative task, current speculativeMap task count: " + this.speculativeMapTasks));
                }
            }
            metrics.launchMap(id);
        } else {
            ++this.runningReduceTasks;
            name = TaskType.REDUCE;
            counter = JobCounter.TOTAL_LAUNCHED_REDUCES;
            if (tip.isSpeculating()) {
                ++this.speculativeReduceTasks;
                metrics.speculateReduce(id);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Chosen speculative task, current speculativeReduce task count: " + this.speculativeReduceTasks));
                }
            }
            metrics.launchReduce(id);
        }
        if (tip.isFirstAttempt(id)) {
            TaskStartedEvent tse = new TaskStartedEvent(tip.getTIPId(), tip.getExecStartTime(), name, splits);
            this.jobHistory.logEvent(tse, tip.getJob().jobId);
            this.setFirstTaskLaunchTime(tip);
        }
        if (!tip.isJobSetupTask() && !tip.isJobCleanupTask()) {
            this.jobCounters.incrCounter(counter, 1L);
        }
        if (tip.isMapTask() && !tip.isJobSetupTask() && !tip.isJobCleanupTask()) {
            int level = this.getLocalityLevel(tip, tts);
            switch (level) {
                case 0: {
                    LOG.info((Object)("Choosing data-local task " + tip.getTIPId()));
                    this.jobCounters.incrCounter(JobCounter.DATA_LOCAL_MAPS, 1L);
                    metrics.launchDataLocalMap(id);
                    break;
                }
                case 1: {
                    LOG.info((Object)("Choosing rack-local task " + tip.getTIPId()));
                    this.jobCounters.incrCounter(JobCounter.RACK_LOCAL_MAPS, 1L);
                    metrics.launchRackLocalMap(id);
                    break;
                }
                default: {
                    if (level == this.maxLevel) break;
                    LOG.info((Object)("Choosing cached task at level " + level + tip.getTIPId()));
                    this.jobCounters.incrCounter(JobCounter.OTHER_LOCAL_MAPS, 1L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFirstTaskLaunchTime(TaskInProgress tip) {
        TaskType key = this.getTaskType(tip);
        Map<TaskType, Long> map = this.firstTaskLaunchTimes;
        synchronized (map) {
            if (!this.firstTaskLaunchTimes.containsKey((Object)key)) {
                this.firstTaskLaunchTimes.put(key, tip.getExecStartTime());
            }
        }
    }

    public static String convertTrackerNameToHostName(String trackerName) {
        int indexOfColon = trackerName.indexOf(":");
        String trackerHostName = indexOfColon == -1 ? trackerName : trackerName.substring(0, indexOfColon);
        return trackerHostName.substring("tracker_".length());
    }

    synchronized void addTrackerTaskFailure(String trackerName, TaskTracker taskTracker) {
        if ((double)this.flakyTaskTrackers < (double)this.clusterSize * 0.25) {
            String trackerHostName = JobInProgress.convertTrackerNameToHostName(trackerName);
            Integer trackerFailures = this.trackerToFailuresMap.get(trackerHostName);
            if (trackerFailures == null) {
                trackerFailures = 0;
            }
            trackerFailures = trackerFailures + 1;
            this.trackerToFailuresMap.put(trackerHostName, trackerFailures);
            if (trackerFailures == this.maxTaskFailuresPerTracker) {
                ++this.flakyTaskTrackers;
                if (taskTracker != null) {
                    if (this.trackersReservedForMaps.containsKey(taskTracker)) {
                        taskTracker.unreserveSlots(TaskType.MAP, this);
                    }
                    if (this.trackersReservedForReduces.containsKey(taskTracker)) {
                        taskTracker.unreserveSlots(TaskType.REDUCE, this);
                    }
                }
                LOG.info((Object)("TaskTracker at '" + trackerHostName + "' turned 'flaky'"));
            }
        }
    }

    public synchronized void reserveTaskTracker(TaskTracker taskTracker, TaskType type, int numSlots) {
        Map<TaskTracker, FallowSlotInfo> map = type == TaskType.MAP ? this.trackersReservedForMaps : this.trackersReservedForReduces;
        long now = System.currentTimeMillis();
        FallowSlotInfo info = map.get(taskTracker);
        int reservedSlots = 0;
        if (info == null) {
            info = new FallowSlotInfo(now, numSlots);
            reservedSlots = numSlots;
        } else if (info.getNumSlots() != numSlots) {
            JobCounter counter = type == TaskType.MAP ? JobCounter.FALLOW_SLOTS_MILLIS_MAPS : JobCounter.FALLOW_SLOTS_MILLIS_REDUCES;
            long fallowSlotMillis = (now - info.getTimestamp()) * (long)info.getNumSlots();
            this.jobCounters.incrCounter(counter, fallowSlotMillis);
            reservedSlots = numSlots - info.getNumSlots();
            info.setTimestamp(now);
            info.setNumSlots(numSlots);
        }
        map.put(taskTracker, info);
        if (type == TaskType.MAP) {
            this.jobtracker.getInstrumentation().addReservedMapSlots(reservedSlots);
        } else {
            this.jobtracker.getInstrumentation().addReservedReduceSlots(reservedSlots);
        }
        this.jobtracker.incrementReservations(type, reservedSlots);
    }

    public synchronized void unreserveTaskTracker(TaskTracker taskTracker, TaskType type) {
        Map<TaskTracker, FallowSlotInfo> map = type == TaskType.MAP ? this.trackersReservedForMaps : this.trackersReservedForReduces;
        FallowSlotInfo info = map.get(taskTracker);
        if (info == null) {
            LOG.warn((Object)("Cannot find information about fallow slots for " + taskTracker.getTrackerName()));
            return;
        }
        long now = System.currentTimeMillis();
        JobCounter counter = type == TaskType.MAP ? JobCounter.FALLOW_SLOTS_MILLIS_MAPS : JobCounter.FALLOW_SLOTS_MILLIS_REDUCES;
        long fallowSlotMillis = (now - info.getTimestamp()) * (long)info.getNumSlots();
        this.jobCounters.incrCounter(counter, fallowSlotMillis);
        map.remove(taskTracker);
        if (type == TaskType.MAP) {
            this.jobtracker.getInstrumentation().decReservedMapSlots(info.getNumSlots());
        } else {
            this.jobtracker.getInstrumentation().decReservedReduceSlots(info.getNumSlots());
        }
        this.jobtracker.decrementReservations(type, info.getNumSlots());
    }

    public int getNumReservedTaskTrackersForMaps() {
        return this.trackersReservedForMaps.size();
    }

    public int getNumReservedTaskTrackersForReduces() {
        return this.trackersReservedForReduces.size();
    }

    private int getTrackerTaskFailures(String trackerName) {
        String trackerHostName = JobInProgress.convertTrackerNameToHostName(trackerName);
        Integer failedTasks = this.trackerToFailuresMap.get(trackerHostName);
        return failedTasks != null ? failedTasks : 0;
    }

    List<String> getBlackListedTrackers() {
        ArrayList<String> blackListedTrackers = new ArrayList<String>();
        for (Map.Entry<String, Integer> e : this.trackerToFailuresMap.entrySet()) {
            if (e.getValue() < this.maxTaskFailuresPerTracker) continue;
            blackListedTrackers.add(e.getKey());
        }
        return blackListedTrackers;
    }

    int getNoOfBlackListedTrackers() {
        return this.flakyTaskTrackers;
    }

    synchronized Map<String, Integer> getTaskTrackerErrors() {
        TreeMap<String, Integer> trackerErrors = new TreeMap<String, Integer>(this.trackerToFailuresMap);
        return trackerErrors;
    }

    private synchronized void retireMap(TaskInProgress tip) {
        if (this.runningMapCache == null) {
            LOG.warn((Object)"Running cache for maps missing!! Job details are missing.");
            return;
        }
        String[] splitLocations = tip.getSplitLocations();
        if (splitLocations == null || splitLocations.length == 0) {
            this.nonLocalRunningMaps.remove(tip);
            return;
        }
        for (String host : splitLocations) {
            Node node = this.jobtracker.getNode(host);
            for (int j = 0; j < this.maxLevel; ++j) {
                Set<TaskInProgress> hostMaps = this.runningMapCache.get(node);
                if (hostMaps != null) {
                    hostMaps.remove(tip);
                    if (hostMaps.size() == 0) {
                        this.runningMapCache.remove(node);
                    }
                }
                node = node.getParent();
            }
        }
    }

    private synchronized void retireReduce(TaskInProgress tip) {
        if (this.runningReduces == null) {
            LOG.warn((Object)"Running list for reducers missing!! Job details are missing.");
            return;
        }
        this.runningReduces.remove(tip);
    }

    protected synchronized void scheduleMap(TaskInProgress tip) {
        this.runningMapTaskStats.add(0.0);
        if (this.runningMapCache == null) {
            LOG.warn((Object)"Running cache for maps is missing!! Job details are missing.");
            return;
        }
        String[] splitLocations = tip.getSplitLocations();
        if (splitLocations == null || splitLocations.length == 0) {
            this.nonLocalRunningMaps.add(tip);
            return;
        }
        for (String host : splitLocations) {
            Node node = this.jobtracker.getNode(host);
            for (int j = 0; j < this.maxLevel; ++j) {
                Set<TaskInProgress> hostMaps = this.runningMapCache.get(node);
                if (hostMaps == null) {
                    hostMaps = new LinkedHashSet<TaskInProgress>();
                    this.runningMapCache.put(node, hostMaps);
                }
                hostMaps.add(tip);
                node = node.getParent();
            }
        }
    }

    protected synchronized void scheduleReduce(TaskInProgress tip) {
        this.runningReduceTaskStats.add(0.0);
        if (this.runningReduces == null) {
            LOG.warn((Object)"Running cache for reducers missing!! Job details are missing.");
            return;
        }
        this.runningReduces.add(tip);
    }

    private synchronized void failMap(TaskInProgress tip) {
        if (this.nonRunningMapCache == null) {
            LOG.warn((Object)"Non-running cache for maps missing!! Job details are missing.");
            return;
        }
        String[] splitLocations = tip.getSplitLocations();
        if (splitLocations.length == 0) {
            this.nonLocalMaps.add(0, tip);
            return;
        }
        for (String host : splitLocations) {
            Node node = this.jobtracker.getNode(host);
            for (int j = 0; j < this.maxLevel; ++j) {
                List<TaskInProgress> hostMaps = this.nonRunningMapCache.get(node);
                if (hostMaps == null) {
                    hostMaps = new LinkedList<TaskInProgress>();
                    this.nonRunningMapCache.put(node, hostMaps);
                }
                hostMaps.add(0, tip);
                node = node.getParent();
            }
        }
    }

    private synchronized void failReduce(TaskInProgress tip) {
        if (this.nonRunningReduces == null) {
            LOG.warn((Object)"Failed cache for reducers missing!! Job details are missing.");
            return;
        }
        this.nonRunningReduces.add(0, tip);
    }

    private synchronized TaskInProgress findTaskFromList(Collection<TaskInProgress> tips, TaskTrackerStatus ttStatus, int numUniqueHosts, boolean removeFailedTip) {
        Iterator<TaskInProgress> iter = tips.iterator();
        while (iter.hasNext()) {
            TaskInProgress tip = iter.next();
            if (tip.isRunnable() && !tip.isRunning()) {
                if (!tip.hasFailedOnMachine(ttStatus.getHost()) || tip.getNumberOfFailedMachines() >= numUniqueHosts) {
                    iter.remove();
                    return tip;
                }
                if (!removeFailedTip) continue;
                iter.remove();
                continue;
            }
            iter.remove();
        }
        return null;
    }

    public boolean hasSpeculativeMaps() {
        return this.hasSpeculativeMaps;
    }

    public boolean hasSpeculativeReduces() {
        return this.hasSpeculativeReduces;
    }

    protected synchronized TaskInProgress findSpeculativeTask(Collection<TaskInProgress> list, String taskTrackerName, String taskTrackerHost, TaskType taskType) {
        if (list.isEmpty()) {
            return null;
        }
        long now = JobTracker.getClock().getTime();
        if (this.isSlowTracker(taskTrackerName) || this.atSpeculativeCap(list, taskType)) {
            return null;
        }
        TaskInProgress slowestTIP = null;
        EstimatedTimeLeftComparator LateComparator = new EstimatedTimeLeftComparator(now);
        for (TaskInProgress tip : list) {
            if (tip.hasRunOnMachine(taskTrackerHost, taskTrackerName) || !tip.canBeSpeculated(now)) continue;
            if (slowestTIP == null) {
                slowestTIP = tip;
                continue;
            }
            slowestTIP = LateComparator.compare(tip, slowestTIP) < 0 ? tip : slowestTIP;
        }
        if (slowestTIP != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Chose task " + slowestTIP.getTIPId() + ". Statistics: Task's : " + slowestTIP.getCurrentProgressRate(now) + " Job's : " + (slowestTIP.isMapTask() ? this.runningMapTaskStats : this.runningReduceTaskStats)));
        }
        return slowestTIP;
    }

    private synchronized int findNewMapTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts, int maxCacheLevel) {
        String taskTrackerName = tts.getTrackerName();
        String taskTrackerHost = tts.getHost();
        if (this.numMapTasks == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No maps to schedule for " + this.profile.getJobID()));
            }
            return -1;
        }
        TaskInProgress tip = null;
        this.clusterSize = clusterSize;
        if (!this.shouldRunOnTaskTracker(taskTrackerName)) {
            return -1;
        }
        long outSize = this.resourceEstimator.getEstimatedMapOutputSize();
        long availSpace = tts.getResourceStatus().getAvailableSpace();
        if (availSpace < outSize) {
            LOG.warn((Object)("No room for map task. Node " + tts.getHost() + " has " + availSpace + " bytes free; but we expect map to take " + outSize));
            return -1;
        }
        Node node = this.jobtracker.getNode(tts.getHost());
        if (node != null) {
            Node key = node;
            int level = 0;
            int maxLevelToSchedule = Math.min(maxCacheLevel, this.maxLevel);
            for (level = 0; level < maxLevelToSchedule; ++level) {
                List<TaskInProgress> cacheForLevel = this.nonRunningMapCache.get(key);
                if (cacheForLevel != null && (tip = this.findTaskFromList(cacheForLevel, tts, numUniqueHosts, level == 0)) != null) {
                    this.scheduleMap(tip);
                    if (cacheForLevel.size() == 0) {
                        this.nonRunningMapCache.remove(key);
                    }
                    return tip.getIdWithinJob();
                }
                key = key.getParent();
            }
            if (level == maxCacheLevel) {
                return -1;
            }
        }
        Collection<Node> nodesAtMaxLevel = this.jobtracker.getNodesAtMaxLevel();
        Node nodeParentAtMaxLevel = node == null ? null : JobTracker.getParentNode(node, this.maxLevel - 1);
        for (Node parent : nodesAtMaxLevel) {
            List<TaskInProgress> cache;
            if (parent == nodeParentAtMaxLevel || (cache = this.nonRunningMapCache.get(parent)) == null || (tip = this.findTaskFromList(cache, tts, numUniqueHosts, false)) == null) continue;
            this.scheduleMap(tip);
            if (cache.size() == 0) {
                this.nonRunningMapCache.remove(parent);
            }
            LOG.info((Object)("Choosing a non-local task " + tip.getTIPId()));
            return tip.getIdWithinJob();
        }
        tip = this.findTaskFromList(this.nonLocalMaps, tts, numUniqueHosts, false);
        if (tip != null) {
            this.scheduleMap(tip);
            LOG.info((Object)("Choosing a non-local task " + tip.getTIPId()));
            return tip.getIdWithinJob();
        }
        if (this.hasSpeculativeMaps && (tip = this.getSpeculativeMap(taskTrackerName, taskTrackerHost)) != null) {
            return tip.getIdWithinJob();
        }
        return -1;
    }

    private synchronized TaskInProgress getSpeculativeMap(String taskTrackerName, String taskTrackerHost) {
        HashSet<TaskInProgress> allTips = new HashSet<TaskInProgress>();
        Collection<Node> nodesAtMaxLevel = this.jobtracker.getNodesAtMaxLevel();
        for (Node parent : nodesAtMaxLevel) {
            Set<TaskInProgress> cache = this.runningMapCache.get(parent);
            if (cache == null) continue;
            allTips.addAll(cache);
        }
        allTips.addAll(this.nonLocalRunningMaps);
        TaskInProgress tip = this.findSpeculativeTask(allTips, taskTrackerName, taskTrackerHost, TaskType.MAP);
        if (tip != null) {
            LOG.info((Object)("Choosing map task " + tip.getTIPId() + " for speculative execution"));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("No speculative map task found for tracker " + taskTrackerName));
        }
        return tip;
    }

    private synchronized int findNewReduceTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts) {
        String taskTrackerName = tts.getTrackerName();
        String taskTrackerHost = tts.getHost();
        if (this.numReduceTasks == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No reduces to schedule for " + this.profile.getJobID()));
            }
            return -1;
        }
        TaskInProgress tip = null;
        this.clusterSize = clusterSize;
        if (!this.shouldRunOnTaskTracker(taskTrackerName)) {
            return -1;
        }
        long outSize = this.resourceEstimator.getEstimatedReduceInputSize();
        long availSpace = tts.getResourceStatus().getAvailableSpace();
        if (availSpace < outSize) {
            LOG.warn((Object)("No room for reduce task. Node " + taskTrackerName + " has " + availSpace + " bytes free; but we expect reduce input to take " + outSize));
            return -1;
        }
        tip = this.findTaskFromList(this.nonRunningReduces, tts, numUniqueHosts, false);
        if (tip != null) {
            this.scheduleReduce(tip);
            return tip.getIdWithinJob();
        }
        if (this.hasSpeculativeReduces && (tip = this.getSpeculativeReduce(taskTrackerName, taskTrackerHost)) != null) {
            return tip.getIdWithinJob();
        }
        return -1;
    }

    private synchronized TaskInProgress getSpeculativeReduce(String taskTrackerName, String taskTrackerHost) {
        TaskInProgress tip = this.findSpeculativeTask(this.runningReduces, taskTrackerName, taskTrackerHost, TaskType.REDUCE);
        if (tip != null) {
            LOG.info((Object)("Choosing reduce task " + tip.getTIPId() + " for speculative execution"));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("No speculative map task found for tracker " + taskTrackerHost));
        }
        return tip;
    }

    private boolean atSpeculativeCap(Collection<TaskInProgress> tasks, TaskType type) {
        boolean atCap;
        int numSlots;
        int speculativeTaskCount;
        float numTasks = tasks.size();
        if (numTasks == 0.0f) {
            return true;
        }
        int n = speculativeTaskCount = type == TaskType.MAP ? this.speculativeMapTasks : this.speculativeReduceTasks;
        if (speculativeTaskCount < 10) {
            return false;
        }
        ClusterStatus c = this.jobtracker.getClusterStatus(false);
        int n2 = numSlots = type == TaskType.MAP ? c.getMaxMapTasks() : c.getMaxReduceTasks();
        if ((float)speculativeTaskCount < (float)numSlots * 0.01f) {
            return false;
        }
        boolean bl = atCap = (float)speculativeTaskCount / numTasks >= this.speculativeCap;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("SpeculativeCap is " + this.speculativeCap + ", specTasks/numTasks is " + (float)speculativeTaskCount / numTasks + ", so atSpecCap() is returning " + atCap));
        }
        return atCap;
    }

    protected boolean isSlowTracker(String taskTracker) {
        if (this.trackerMapStats.get(taskTracker) != null && this.trackerMapStats.get(taskTracker).mean() - this.mapTaskStats.mean() > this.mapTaskStats.std() * (double)this.slowNodeThreshold) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Tracker " + taskTracker + " declared slow. trackerMapStats.get(taskTracker).mean() :" + this.trackerMapStats.get(taskTracker).mean() + " mapTaskStats :" + this.mapTaskStats));
            }
            return true;
        }
        if (this.trackerReduceStats.get(taskTracker) != null && this.trackerReduceStats.get(taskTracker).mean() - this.reduceTaskStats.mean() > this.reduceTaskStats.std() * (double)this.slowNodeThreshold) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Tracker " + taskTracker + " declared slow. trackerReduceStats.get(taskTracker).mean() :" + this.trackerReduceStats.get(taskTracker).mean() + " reduceTaskStats :" + this.reduceTaskStats));
            }
            return true;
        }
        return false;
    }

    private boolean shouldRunOnTaskTracker(String taskTracker) {
        int taskTrackerFailedTasks = this.getTrackerTaskFailures(taskTracker);
        if ((double)this.flakyTaskTrackers < (double)this.clusterSize * 0.25 && taskTrackerFailedTasks >= this.maxTaskFailuresPerTracker) {
            if (LOG.isDebugEnabled()) {
                String flakyTracker = JobInProgress.convertTrackerNameToHostName(taskTracker);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Ignoring the black-listed tasktracker: '" + flakyTracker + "' for assigning a new task"));
                }
            }
            return false;
        }
        return true;
    }

    private void meterTaskAttempt(TaskInProgress tip, TaskStatus status) {
        JobCounter slotCounter = tip.isMapTask() ? JobCounter.SLOTS_MILLIS_MAPS : JobCounter.SLOTS_MILLIS_REDUCES;
        this.jobCounters.incrCounter(slotCounter, (long)tip.getNumSlotsRequired() * (status.getFinishTime() - status.getStartTime()));
    }

    public synchronized boolean completedTask(TaskInProgress tip, TaskStatus status) {
        TaskAttemptID taskid = status.getTaskID();
        JobTrackerInstrumentation metrics = this.jobtracker.getInstrumentation();
        this.meterTaskAttempt(tip, status);
        if (tip.isComplete()) {
            tip.alreadyCompletedTask(taskid);
            if (this.status.getRunState() != JobStatus.RUNNING) {
                this.jobtracker.markCompletedTaskAttempt(status.getTaskTracker(), taskid);
            }
            return false;
        }
        boolean wasSpeculating = tip.isSpeculating();
        LOG.info((Object)("Task '" + taskid + "' has completed " + tip.getTIPId() + " successfully."));
        tip.completed(taskid);
        this.resourceEstimator.updateWithCompletedTask(status, tip);
        TaskTrackerStatus ttStatus = this.jobtracker.getTaskTrackerStatus(status.getTaskTracker());
        String trackerHostname = this.jobtracker.getNode(ttStatus.getHost()).toString();
        TaskType taskType = this.getTaskType(tip);
        TaskAttemptStartedEvent tse = new TaskAttemptStartedEvent(status.getTaskID(), taskType, status.getStartTime(), status.getTaskTracker(), ttStatus.getHttpPort());
        this.jobHistory.logEvent(tse, status.getTaskID().getJobID());
        if (status.getIsMap()) {
            MapAttemptFinishedEvent mfe = new MapAttemptFinishedEvent(status.getTaskID(), taskType, TaskStatus.State.SUCCEEDED.toString(), status.getMapFinishTime(), status.getFinishTime(), trackerHostname, status.getStateString(), new Counters(status.getCounters()));
            this.jobHistory.logEvent(mfe, status.getTaskID().getJobID());
        } else {
            ReduceAttemptFinishedEvent rfe = new ReduceAttemptFinishedEvent(status.getTaskID(), taskType, TaskStatus.State.SUCCEEDED.toString(), status.getShuffleFinishTime(), status.getSortFinishTime(), status.getFinishTime(), trackerHostname, status.getStateString(), new Counters(status.getCounters()));
            this.jobHistory.logEvent(rfe, status.getTaskID().getJobID());
        }
        TaskFinishedEvent tfe = new TaskFinishedEvent(tip.getTIPId(), tip.getExecFinishTime(), taskType, TaskStatus.State.SUCCEEDED.toString(), new Counters(status.getCounters()));
        this.jobHistory.logEvent(tfe, tip.getJob().getJobID());
        if (tip.isJobSetupTask()) {
            this.killSetupTip(!tip.isMapTask());
            this.setupComplete();
        } else if (tip.isJobCleanupTask()) {
            if (tip.isMapTask()) {
                this.cleanup[1].kill();
            } else {
                this.cleanup[0].kill();
            }
            if (this.jobFailed) {
                this.terminateJob(JobStatus.FAILED);
            }
            if (this.jobKilled) {
                this.terminateJob(JobStatus.KILLED);
            } else {
                this.jobComplete();
            }
            this.jobtracker.markCompletedTaskAttempt(status.getTaskTracker(), taskid);
        } else if (tip.isMapTask()) {
            --this.runningMapTasks;
            ++this.finishedMapTasks;
            metrics.completeMap(taskid);
            if (!tip.isJobSetupTask() && this.hasSpeculativeMaps) {
                this.updateTaskTrackerStats(tip, ttStatus, this.trackerMapStats, this.mapTaskStats);
            }
            this.retireMap(tip);
            if (this.finishedMapTasks + this.failedMapTIPs == this.numMapTasks) {
                this.status.setMapProgress(1.0f);
            }
        } else {
            --this.runningReduceTasks;
            ++this.finishedReduceTasks;
            metrics.completeReduce(taskid);
            if (!tip.isJobSetupTask() && this.hasSpeculativeReduces) {
                this.updateTaskTrackerStats(tip, ttStatus, this.trackerReduceStats, this.reduceTaskStats);
            }
            this.retireReduce(tip);
            if (this.finishedReduceTasks + this.failedReduceTIPs == this.numReduceTasks) {
                this.status.setReduceProgress(1.0f);
            }
        }
        this.decrementSpeculativeCount(wasSpeculating, tip);
        if (!this.jobSetupCleanupNeeded && this.canLaunchJobCleanupTask()) {
            this.jobComplete();
        }
        return true;
    }

    private void updateTaskTrackerStats(TaskInProgress tip, TaskTrackerStatus ttStatus, Map<String, DataStatistics> trackerStats, DataStatistics overallStats) {
        float tipDuration = tip.getExecFinishTime() - tip.getDispatchTime(tip.getSuccessfulTaskid());
        DataStatistics ttStats = trackerStats.get(ttStatus.getTrackerName());
        double oldMean = 0.0;
        if (ttStats != null) {
            oldMean = ttStats.mean();
            ttStats.add(tipDuration);
            overallStats.updateStatistics(oldMean, ttStats.mean());
        } else {
            ttStats = new DataStatistics(tipDuration);
            trackerStats.put(ttStatus.getTrackerName(), ttStats);
            overallStats.add(tipDuration);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Added mean of " + ttStats.mean() + " to trackerStats of type " + (tip.isMapTask() ? "Map" : "Reduce") + " on " + ttStatus.getTrackerName() + ". DataStatistics is now: " + trackerStats.get(ttStatus.getTrackerName())));
        }
    }

    public void updateStatistics(double oldProg, double newProg, boolean isMap) {
        if (isMap) {
            this.runningMapTaskStats.updateStatistics(oldProg, newProg);
        } else {
            this.runningReduceTaskStats.updateStatistics(oldProg, newProg);
        }
    }

    public DataStatistics getRunningTaskStatistics(boolean isMap) {
        if (isMap) {
            return this.runningMapTaskStats;
        }
        return this.runningReduceTaskStats;
    }

    public float getSlowTaskThreshold() {
        return this.slowTaskThreshold;
    }

    private void changeStateTo(int newState) {
        int oldState = this.status.getRunState();
        if (oldState == newState) {
            return;
        }
        this.status.setRunState(newState);
        if (oldState == JobStatus.PREP) {
            this.jobtracker.getInstrumentation().decPrepJob(this.conf, this.jobId);
        } else if (oldState == JobStatus.RUNNING) {
            this.jobtracker.getInstrumentation().decRunningJob(this.conf, this.jobId);
        }
        if (newState == JobStatus.PREP) {
            this.jobtracker.getInstrumentation().addPrepJob(this.conf, this.jobId);
        } else if (newState == JobStatus.RUNNING) {
            this.jobtracker.getInstrumentation().addRunningJob(this.conf, this.jobId);
        }
    }

    private void jobComplete() {
        JobTrackerInstrumentation metrics = this.jobtracker.getInstrumentation();
        if (this.status.getRunState() == JobStatus.RUNNING || this.status.getRunState() == JobStatus.PREP) {
            this.changeStateTo(JobStatus.SUCCEEDED);
            this.status.setCleanupProgress(1.0f);
            if (this.maps.length == 0) {
                this.status.setMapProgress(1.0f);
            }
            if (this.reduces.length == 0) {
                this.status.setReduceProgress(1.0f);
            }
            this.finishTime = JobTracker.getClock().getTime();
            this.status.setFinishTime(this.finishTime);
            LOG.info((Object)("Job " + this.status.getJobID() + " has completed successfully."));
            JobSummary.logJobSummary(this, this.jobtracker.getClusterStatus(false));
            JobFinishedEvent jfe = new JobFinishedEvent(this.status.getJobID(), this.finishTime, this.finishedMapTasks, this.finishedReduceTasks, this.failedMapTasks, this.failedReduceTasks, new Counters(this.getMapCounters()), new Counters(this.getReduceCounters()), new Counters(this.getCounters()));
            this.jobHistory.logEvent(jfe, this.status.getJobID());
            this.jobHistory.closeWriter(this.status.getJobID());
            this.garbageCollect();
            metrics.completeJob(this.conf, this.status.getJobID());
        }
    }

    private synchronized void terminateJob(int jobTerminationState) {
        if (this.status.getRunState() == JobStatus.RUNNING || this.status.getRunState() == JobStatus.PREP) {
            this.finishTime = JobTracker.getClock().getTime();
            this.status.setMapProgress(1.0f);
            this.status.setReduceProgress(1.0f);
            this.status.setCleanupProgress(1.0f);
            this.status.setFinishTime(this.finishTime);
            if (jobTerminationState == JobStatus.FAILED) {
                this.changeStateTo(JobStatus.FAILED);
            } else {
                this.changeStateTo(JobStatus.KILLED);
            }
            JobSummary.logJobSummary(this, this.jobtracker.getClusterStatus(false));
            JobUnsuccessfulCompletionEvent failedEvent = new JobUnsuccessfulCompletionEvent(this.status.getJobID(), this.finishTime, this.finishedMapTasks, this.finishedReduceTasks, JobStatus.getJobRunState(jobTerminationState));
            this.jobHistory.logEvent(failedEvent, this.status.getJobID());
            this.jobHistory.closeWriter(this.status.getJobID());
            this.garbageCollect();
            this.jobtracker.getInstrumentation().terminateJob(this.conf, this.status.getJobID());
            if (jobTerminationState == JobStatus.FAILED) {
                this.jobtracker.getInstrumentation().failedJob(this.conf, this.status.getJobID());
            } else {
                this.jobtracker.getInstrumentation().killedJob(this.conf, this.status.getJobID());
            }
        }
    }

    private synchronized void terminate(int jobTerminationState) {
        if (!this.tasksInited.get()) {
            this.terminateJob(jobTerminationState);
            return;
        }
        if (this.status.getRunState() == JobStatus.RUNNING || this.status.getRunState() == JobStatus.PREP) {
            int i;
            LOG.info((Object)("Killing job '" + this.status.getJobID() + "'"));
            if (jobTerminationState == JobStatus.FAILED) {
                if (this.jobFailed) {
                    return;
                }
                this.jobFailed = true;
            } else if (jobTerminationState == JobStatus.KILLED) {
                if (this.jobKilled) {
                    return;
                }
                this.jobKilled = true;
            }
            this.clearUncleanTasks();
            for (i = 0; i < this.setup.length; ++i) {
                this.setup[i].kill();
            }
            for (i = 0; i < this.maps.length; ++i) {
                this.maps[i].kill();
            }
            for (i = 0; i < this.reduces.length; ++i) {
                this.reduces[i].kill();
            }
            if (!this.jobSetupCleanupNeeded) {
                this.terminateJob(jobTerminationState);
            }
        }
    }

    private void cancelReservedSlots() {
        HashSet<TaskTracker> tm = new HashSet<TaskTracker>(this.trackersReservedForMaps.keySet());
        for (TaskTracker tt : tm) {
            tt.unreserveSlots(TaskType.MAP, this);
        }
        HashSet<TaskTracker> tr = new HashSet<TaskTracker>(this.trackersReservedForReduces.keySet());
        for (TaskTracker tt : tr) {
            tt.unreserveSlots(TaskType.REDUCE, this);
        }
    }

    private void clearUncleanTasks() {
        TaskAttemptID taskid = null;
        TaskInProgress tip = null;
        while (!this.mapCleanupTasks.isEmpty()) {
            taskid = this.mapCleanupTasks.remove(0);
            tip = this.maps[taskid.getTaskID().getId()];
            this.updateTaskStatus(tip, tip.getTaskStatus(taskid));
        }
        while (!this.reduceCleanupTasks.isEmpty()) {
            taskid = this.reduceCleanupTasks.remove(0);
            tip = this.reduces[taskid.getTaskID().getId()];
            this.updateTaskStatus(tip, tip.getTaskStatus(taskid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        boolean killNow = false;
        JobInitKillStatus jobInitKillStatus = this.jobInitKillStatus;
        synchronized (jobInitKillStatus) {
            this.jobInitKillStatus.killed = true;
            if (!this.jobInitKillStatus.initStarted || this.jobInitKillStatus.initDone) {
                killNow = true;
            }
        }
        if (killNow) {
            this.terminate(JobStatus.KILLED);
        }
    }

    synchronized void fail() {
        this.terminate(JobStatus.FAILED);
    }

    private void decrementSpeculativeCount(boolean wasSpeculating, TaskInProgress tip) {
        if (wasSpeculating) {
            if (tip.isMapTask()) {
                --this.speculativeMapTasks;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Decremented count for " + tip.getTIPId() + "/" + tip.getJob().getJobID() + ". Current speculativeMap task count: " + this.speculativeMapTasks));
                }
            } else {
                --this.speculativeReduceTasks;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Decremented count for " + tip.getTIPId() + "/" + tip.getJob().getJobID() + ". Current speculativeReduce task count: " + this.speculativeReduceTasks));
                }
            }
        }
    }

    private void failedTask(TaskInProgress tip, TaskAttemptID taskid, TaskStatus status, TaskTracker taskTracker, boolean wasRunning, boolean wasComplete, boolean wasAttemptRunning) {
        TaskTrackerStatus taskTrackerStatus;
        boolean wasFailed = tip.isFailed();
        boolean wasSpeculating = tip.isSpeculating();
        tip.incompleteSubTask(taskid, this.status);
        this.decrementSpeculativeCount(wasSpeculating, tip);
        boolean isRunning = tip.isRunning();
        boolean isComplete = tip.isComplete();
        if (wasAttemptRunning) {
            if (!tip.isJobCleanupTask() && !tip.isJobSetupTask()) {
                if (tip.isMapTask()) {
                    --this.runningMapTasks;
                } else {
                    --this.runningReduceTasks;
                }
            }
            this.meterTaskAttempt(tip, status);
        }
        if (wasRunning && !isRunning) {
            if (tip.isJobCleanupTask()) {
                this.launchedCleanup = false;
            } else if (tip.isJobSetupTask()) {
                this.launchedSetup = false;
            } else if (tip.isMapTask()) {
                if (!isComplete) {
                    this.retireMap(tip);
                    this.failMap(tip);
                }
            } else if (!isComplete) {
                this.retireReduce(tip);
                this.failReduce(tip);
            }
        }
        if (wasComplete && !isComplete && tip.isMapTask()) {
            this.failMap(tip);
            --this.finishedMapTasks;
        }
        TaskStatus taskStatus = tip.getTaskStatus(taskid);
        String taskTrackerName = taskStatus.getTaskTracker();
        String taskTrackerHostName = JobInProgress.convertTrackerNameToHostName(taskTrackerName);
        int taskTrackerPort = -1;
        TaskTrackerStatus taskTrackerStatus2 = taskTrackerStatus = taskTracker == null ? null : taskTracker.getStatus();
        if (taskTrackerStatus != null) {
            taskTrackerPort = taskTrackerStatus.getHttpPort();
        }
        long startTime = taskStatus.getStartTime();
        long finishTime = taskStatus.getFinishTime();
        List<String> taskDiagnosticInfo = tip.getDiagnosticInfo(taskid);
        String diagInfo = taskDiagnosticInfo == null ? "" : StringUtils.arrayToString((String[])taskDiagnosticInfo.toArray(new String[0]));
        TaskType taskType = this.getTaskType(tip);
        TaskAttemptStartedEvent tse = new TaskAttemptStartedEvent(taskid, taskType, startTime, taskTrackerName, taskTrackerPort);
        this.jobHistory.logEvent(tse, taskid.getJobID());
        TaskAttemptUnsuccessfulCompletionEvent tue = new TaskAttemptUnsuccessfulCompletionEvent(taskid, taskType, taskStatus.getRunState().toString(), finishTime, taskTrackerHostName, diagInfo);
        this.jobHistory.logEvent(tue, taskid.getJobID());
        if (!tip.isJobCleanupTask() && !tip.isJobSetupTask()) {
            if (tip.isMapTask()) {
                ++this.failedMapTasks;
            } else {
                ++this.failedReduceTasks;
            }
        }
        if (status.getRunState() == TaskStatus.State.FAILED) {
            this.addTrackerTaskFailure(taskTrackerName, taskTracker);
        }
        this.jobtracker.markCompletedTaskAttempt(status.getTaskTracker(), taskid);
        if (!wasFailed && tip.isFailed()) {
            boolean killJob;
            boolean bl = tip.isJobCleanupTask() || tip.isJobSetupTask() ? true : (tip.isMapTask() ? ++this.failedMapTIPs * 100 > this.mapFailuresPercent * this.numMapTasks : (killJob = ++this.failedReduceTIPs * 100 > this.reduceFailuresPercent * this.numReduceTasks));
            if (killJob) {
                LOG.info((Object)("Aborting job " + this.profile.getJobID()));
                TaskFailedEvent tfe = new TaskFailedEvent(tip.getTIPId(), finishTime, taskType, diagInfo, TaskStatus.State.FAILED.toString(), null);
                this.jobHistory.logEvent(tfe, tip.getJob().getJobID());
                if (tip.isJobCleanupTask()) {
                    if (tip.isMapTask()) {
                        this.cleanup[1].kill();
                    } else {
                        this.cleanup[0].kill();
                    }
                    this.terminateJob(JobStatus.FAILED);
                } else {
                    if (tip.isJobSetupTask()) {
                        this.killSetupTip(!tip.isMapTask());
                    }
                    this.fail();
                }
            }
            if (!tip.isJobCleanupTask() && !tip.isJobSetupTask()) {
                if (tip.isMapTask()) {
                    this.jobCounters.incrCounter(JobCounter.NUM_FAILED_MAPS, 1L);
                } else {
                    this.jobCounters.incrCounter(JobCounter.NUM_FAILED_REDUCES, 1L);
                }
            }
        }
    }

    void killSetupTip(boolean isMap) {
        if (isMap) {
            this.setup[0].kill();
        } else {
            this.setup[1].kill();
        }
    }

    boolean isSetupFinished() {
        return this.tasksInited.get() && this.setup.length == 0 || this.setup[0].isComplete() || this.setup[0].isFailed() || this.setup[1].isComplete() || this.setup[1].isFailed();
    }

    public synchronized void failedTask(TaskInProgress tip, TaskAttemptID taskid, String reason, TaskStatus.Phase phase, TaskStatus.State state, String trackerName) {
        TaskStatus status = TaskStatus.createTaskStatus(tip.isMapTask(), taskid, 0.0f, tip.isMapTask() ? this.numSlotsPerMap : this.numSlotsPerReduce, state, reason, reason, trackerName, phase, new org.apache.hadoop.mapred.Counters());
        TaskStatus oldStatus = tip.getTaskStatus(taskid);
        long startTime = oldStatus == null ? JobTracker.getClock().getTime() : oldStatus.getStartTime();
        status.setStartTime(startTime);
        status.setFinishTime(JobTracker.getClock().getTime());
        boolean wasComplete = tip.isComplete();
        this.updateTaskStatus(tip, status);
        boolean isComplete = tip.isComplete();
        if (wasComplete && !isComplete) {
            TaskType taskType = this.getTaskType(tip);
            TaskFailedEvent tfe = new TaskFailedEvent(tip.getTIPId(), tip.getExecFinishTime(), taskType, reason, TaskStatus.State.FAILED.toString(), taskid);
            this.jobHistory.logEvent(tfe, tip.getJob().getJobID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void garbageCollect() {
        JobInProgress jobInProgress = this;
        synchronized (jobInProgress) {
            this.cancelReservedSlots();
            this.jobtracker.getInstrumentation().decWaitingMaps(this.getJobID(), this.pendingMaps());
            this.jobtracker.getInstrumentation().decWaitingReduces(this.getJobID(), this.pendingReduces());
            this.jobtracker.storeCompletedJob(this);
            this.jobtracker.finalizeJob(this);
            try {
                if (this.localJobFile != null) {
                    this.localFs.delete(this.localJobFile, true);
                    this.localJobFile = null;
                }
                Path tempDir = this.jobtracker.getSystemDirectoryForJob(this.getJobID());
                new CleanupQueue().addToQueue(new CleanupQueue.PathDeletionContext(this.jobtracker.getFileSystem(), tempDir.toUri().getPath()));
            }
            catch (IOException e) {
                LOG.warn((Object)("Error cleaning up " + this.profile.getJobID() + ": " + e));
            }
            this.nonRunningMapCache = null;
            this.runningMapCache = null;
            this.nonRunningReduces = null;
            this.runningReduces = null;
        }
        if (this.conf.getBoolean("mapreduce.job.complete.cancel.delegation.tokens", true)) {
            DelegationTokenRenewal.removeDelegationTokenRenewalForJob(this.jobId);
        }
    }

    public synchronized TaskInProgress getTaskInProgress(TaskID tipid) {
        if (tipid.getTaskType() == TaskType.MAP) {
            if (this.cleanup.length > 0 && tipid.equals(this.cleanup[0].getTIPId())) {
                return this.cleanup[0];
            }
            if (this.setup.length > 0 && tipid.equals(this.setup[0].getTIPId())) {
                return this.setup[0];
            }
            for (int i = 0; i < this.maps.length; ++i) {
                if (!tipid.equals(this.maps[i].getTIPId())) continue;
                return this.maps[i];
            }
        } else {
            if (this.cleanup.length > 0 && tipid.equals(this.cleanup[1].getTIPId())) {
                return this.cleanup[1];
            }
            if (this.setup.length > 0 && tipid.equals(this.setup[1].getTIPId())) {
                return this.setup[1];
            }
            for (int i = 0; i < this.reduces.length; ++i) {
                if (!tipid.equals(this.reduces[i].getTIPId())) continue;
                return this.reduces[i];
            }
        }
        return null;
    }

    public synchronized TaskStatus findFinishedMap(int mapId) {
        TaskInProgress tip = this.maps[mapId];
        if (tip.isComplete()) {
            TaskStatus[] statuses = tip.getTaskStatuses();
            for (int i = 0; i < statuses.length; ++i) {
                if (statuses[i].getRunState() != TaskStatus.State.SUCCEEDED) continue;
                return statuses[i];
            }
        }
        return null;
    }

    synchronized int getNumTaskCompletionEvents() {
        return this.taskCompletionEvents.size();
    }

    public synchronized TaskCompletionEvent[] getTaskCompletionEvents(int fromEventId, int maxEvents) {
        TaskCompletionEvent[] events = TaskCompletionEvent.EMPTY_ARRAY;
        if (this.taskCompletionEvents.size() > fromEventId) {
            int actualMax = Math.min(maxEvents, this.taskCompletionEvents.size() - fromEventId);
            events = this.taskCompletionEvents.subList(fromEventId, actualMax + fromEventId).toArray(events);
        }
        return events;
    }

    synchronized void fetchFailureNotification(TaskInProgress tip, TaskAttemptID mapTaskId, String mapTrackerName, TaskAttemptID reduceTaskId, String reduceTrackerName) {
        boolean isMapFaulty;
        Integer fetchFailures = this.mapTaskIdToFetchFailuresMap.get(mapTaskId);
        fetchFailures = fetchFailures == null ? 1 : fetchFailures + 1;
        this.mapTaskIdToFetchFailuresMap.put(mapTaskId, fetchFailures);
        LOG.info((Object)("Failed fetch notification #" + fetchFailures + " for map task: " + mapTaskId + " running on tracker: " + mapTrackerName + " and reduce task: " + reduceTaskId + " running on tracker: " + reduceTrackerName));
        float failureRate = (float)fetchFailures.intValue() / (float)this.runningReduceTasks;
        boolean bl = isMapFaulty = (double)failureRate >= 0.5;
        if (fetchFailures >= 3 && isMapFaulty) {
            LOG.info((Object)("Too many fetch-failures for output of task: " + mapTaskId + " ... killing it"));
            this.failedTask(tip, mapTaskId, "Too many fetch-failures", tip.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.REDUCE, TaskStatus.State.FAILED, mapTrackerName);
            this.mapTaskIdToFetchFailuresMap.remove(mapTaskId);
        }
    }

    public JobID getJobID() {
        return this.jobId;
    }

    public synchronized Object getSchedulingInfo() {
        return this.schedulingInfo;
    }

    public synchronized void setSchedulingInfo(Object schedulingInfo) {
        this.schedulingInfo = schedulingInfo;
        this.status.setSchedulingInfo(schedulingInfo.toString());
    }

    boolean isComplete() {
        return this.status.isJobComplete();
    }

    private TaskType getTaskType(TaskInProgress tip) {
        if (tip.isJobCleanupTask()) {
            return TaskType.JOB_CLEANUP;
        }
        if (tip.isJobSetupTask()) {
            return TaskType.JOB_SETUP;
        }
        if (tip.isMapTask()) {
            return TaskType.MAP;
        }
        return TaskType.REDUCE;
    }

    int getLocalityLevel(TaskInProgress tip, TaskTrackerStatus tts) {
        Node tracker = this.jobtracker.getNode(tts.getHost());
        int level = this.maxLevel;
        for (String local : this.maps[tip.getIdWithinJob()].getSplitLocations()) {
            Node datanode = this.jobtracker.getNode(local);
            int newLevel = this.maxLevel;
            if (tracker != null && datanode != null) {
                newLevel = this.getMatchingLevelForNodes(tracker, datanode);
            }
            if (newLevel < level && (level = newLevel) == 0) break;
        }
        return level;
    }

    void setClusterSize(int clusterSize) {
        this.clusterSize = clusterSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUpLocalizedJobConf(JobConf jobConf, org.apache.hadoop.mapreduce.JobID id) {
        String localJobFilePath = this.jobtracker.getLocalJobFilePath(id);
        File localJobFile = new File(localJobFilePath);
        FileOutputStream jobOut = null;
        try {
            jobOut = new FileOutputStream(localJobFile);
            jobConf.writeXml(jobOut);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Job conf for " + id + " stored at " + localJobFile.getAbsolutePath()));
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)"Failed to store job conf on the local filesystem ", (Throwable)ioe);
        }
        finally {
            if (jobOut != null) {
                try {
                    jobOut.close();
                }
                catch (IOException ie) {
                    LOG.info((Object)("Failed to close the job configuration file " + StringUtils.stringifyException((Throwable)ie)));
                }
            }
        }
    }

    void cleanupLocalizedJobConf(org.apache.hadoop.mapreduce.JobID id) {
        String localJobFilePath = this.jobtracker.getLocalJobFilePath(id);
        File f = new File(localJobFilePath);
        LOG.info((Object)("Deleting localized job conf at " + f));
        if (!f.delete() && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Failed to delete file " + f));
        }
    }

    private void generateAndStoreTokens() throws IOException {
        Path jobDir = this.jobtracker.getSystemDirectoryForJob(this.jobId);
        Path keysFile = new Path(jobDir, "jobToken");
        if (this.tokenStorage == null) {
            this.tokenStorage = new Credentials();
        }
        JobTokenIdentifier identifier = new JobTokenIdentifier(new Text(this.jobId.toString()));
        Token token = new Token((TokenIdentifier)identifier, (SecretManager)this.jobtracker.getJobTokenSecretManager());
        token.setService(identifier.getJobId());
        TokenCache.setJobToken((Token<? extends TokenIdentifier>)token, this.tokenStorage);
        this.tokenStorage.writeTokenStorageFile(keysFile, (Configuration)this.jobtracker.getConf());
        LOG.info((Object)("jobToken generated and stored with users keys in " + keysFile.toUri().getPath()));
    }

    public String getJobSubmitHostAddress() {
        return this.submitHostAddress;
    }

    public String getJobSubmitHostName() {
        return this.submitHostName;
    }

    static class JobSummary {
        static final Log LOG = LogFactory.getLog(JobSummary.class);
        static final char EQUALS = '=';
        static final char[] charsToEscape = new char[]{',', '=', '\\'};

        JobSummary() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static SummaryBuilder getTaskLaunchTimesSummary(JobInProgress job) {
            Map<TaskType, Long> timeMap;
            SummaryBuilder summary = new SummaryBuilder();
            Map<TaskType, Long> map = timeMap = job.getFirstTaskLaunchTimes();
            synchronized (map) {
                for (Map.Entry<TaskType, Long> e : timeMap.entrySet()) {
                    summary.add("first" + StringUtils.camelize((String)e.getKey().name()) + "TaskLaunchTime", e.getValue());
                }
            }
            return summary;
        }

        public static void logJobSummary(JobInProgress job, ClusterStatus cluster) {
            JobStatus status = job.getStatus();
            JobProfile profile = job.getProfile();
            org.apache.hadoop.mapred.Counters jobCounters = job.getJobCounters();
            long mapSlotSeconds = (jobCounters.getCounter(JobCounter.SLOTS_MILLIS_MAPS) + jobCounters.getCounter(JobCounter.FALLOW_SLOTS_MILLIS_MAPS)) / 1000L;
            long reduceSlotSeconds = (jobCounters.getCounter(JobCounter.SLOTS_MILLIS_REDUCES) + jobCounters.getCounter(JobCounter.FALLOW_SLOTS_MILLIS_REDUCES)) / 1000L;
            SummaryBuilder summary = new SummaryBuilder().add("jobId", job.getJobID()).add("submitTime", job.getStartTime()).add("launchTime", job.getLaunchTime()).add(JobSummary.getTaskLaunchTimesSummary(job)).add("finishTime", job.getFinishTime()).add("numMaps", job.getTasks(TaskType.MAP).length).add("numSlotsPerMap", job.getNumSlotsPerMap()).add("numReduces", job.getTasks(TaskType.REDUCE).length).add("numSlotsPerReduce", job.getNumSlotsPerReduce()).add("user", profile.getUser()).add("queue", profile.getQueueName()).add("status", JobStatus.getJobRunState(status.getRunState())).add("mapSlotSeconds", mapSlotSeconds).add("reduceSlotsSeconds", reduceSlotSeconds).add("clusterMapCapacity", cluster.getMaxMapTasks()).add("clusterReduceCapacity", cluster.getMaxReduceTasks());
            LOG.info((Object)summary);
        }

        static class SummaryBuilder {
            final StringBuilder buffer = new StringBuilder();

            SummaryBuilder() {
            }

            SummaryBuilder add(String key, long value) {
                return this._add(key, Long.toString(value));
            }

            <T> SummaryBuilder add(String key, T value) {
                return this._add(key, StringUtils.escapeString((String)String.valueOf(value), (char)'\\', (char[])charsToEscape));
            }

            SummaryBuilder add(SummaryBuilder summary) {
                if (this.buffer.length() > 0) {
                    this.buffer.append(',');
                }
                this.buffer.append((CharSequence)summary.buffer);
                return this;
            }

            SummaryBuilder _add(String key, String value) {
                if (this.buffer.length() > 0) {
                    this.buffer.append(',');
                }
                this.buffer.append(key).append('=').append(value);
                return this;
            }

            public String toString() {
                return this.buffer.toString();
            }
        }
    }

    private static class JobInitKillStatus {
        boolean killed;
        boolean initStarted;
        boolean initDone;

        private JobInitKillStatus() {
        }
    }

    static class DataStatistics {
        private int count = 0;
        private double sum = 0.0;
        private double sumSquares = 0.0;

        public DataStatistics() {
        }

        public DataStatistics(double initNum) {
            this.count = 1;
            this.sum = initNum;
            this.sumSquares = initNum * initNum;
        }

        public void add(double newNum) {
            ++this.count;
            this.sum += newNum;
            this.sumSquares += newNum * newNum;
        }

        public void updateStatistics(double old, double update) {
            this.sub(old);
            this.add(update);
        }

        private void sub(double oldNum) {
            --this.count;
            this.sum = Math.max(this.sum -= oldNum, 0.0);
            this.sumSquares = Math.max(this.sumSquares -= oldNum * oldNum, 0.0);
        }

        public double mean() {
            return this.sum / (double)this.count;
        }

        public double var() {
            return Math.max(this.sumSquares / (double)this.count - this.mean() * this.mean(), 0.0);
        }

        public double std() {
            return Math.sqrt(this.var());
        }

        public String toString() {
            return "DataStatistics: count is " + this.count + ", sum is " + this.sum + ", sumSquares is " + this.sumSquares + " mean is " + this.mean() + " std() is " + this.std();
        }
    }

    private static class EstimatedTimeLeftComparator
    implements Comparator<TaskInProgress> {
        private long time;

        public EstimatedTimeLeftComparator(long now) {
            this.time = now;
        }

        @Override
        public int compare(TaskInProgress tip1, TaskInProgress tip2) {
            double t2;
            double t1 = tip1.getCurrentProgressRate(this.time) / Math.max(1.0E-4, 1.0 - tip1.getProgress());
            if (t1 < (t2 = tip2.getCurrentProgressRate(this.time) / Math.max(1.0E-4, 1.0 - tip2.getProgress()))) {
                return -1;
            }
            if (t2 < t1) {
                return 1;
            }
            return 0;
        }
    }

    private static class FallowSlotInfo {
        long timestamp;
        int numSlots;

        public FallowSlotInfo(long timestamp, int numSlots) {
            this.timestamp = timestamp;
            this.numSlots = numSlots;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public int getNumSlots() {
            return this.numSlots;
        }

        public void setNumSlots(int numSlots) {
            this.numSlots = numSlots;
        }
    }

    static class KillInterruptedException
    extends InterruptedException {
        private static final long serialVersionUID = 1L;

        public KillInterruptedException(String msg) {
            super(msg);
        }
    }
}

