/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.SocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapreduce.protocol.ClientProtocol;
import org.apache.hadoop.mapreduce.protocol.ClientProtocolProvider;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
public class JobTrackerClientProtocolProvider
extends ClientProtocolProvider {
    @Override
    public ClientProtocol create(Configuration conf) throws IOException {
        String framework = conf.get("mapreduce.framework.name");
        if (framework != null && !framework.equals("classic")) {
            return null;
        }
        String tracker = conf.get("mapreduce.jobtracker.address", "local");
        if (!"local".equals(tracker)) {
            return this.createRPCProxy(JobTracker.getAddress(conf), conf);
        }
        return null;
    }

    @Override
    public ClientProtocol create(InetSocketAddress addr, Configuration conf) throws IOException {
        return this.createRPCProxy(addr, conf);
    }

    private ClientProtocol createRPCProxy(InetSocketAddress addr, Configuration conf) throws IOException {
        return (ClientProtocol)RPC.getProxy(ClientProtocol.class, (long)36L, (InetSocketAddress)addr, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)conf, (SocketFactory)NetUtils.getSocketFactory((Configuration)conf, ClientProtocol.class));
    }

    @Override
    public void close(ClientProtocol clientProtocol) throws IOException {
        RPC.stopProxy((Object)clientProtocol);
    }
}

