/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.mapred.CleanupQueue;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JvmManager;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;

class LinuxTaskController
extends TaskController {
    private static final Log LOG = LogFactory.getLog(LinuxTaskController.class);
    private static final String COMMAND_FILE = "taskjvm.sh";
    private static String taskControllerExe;

    @Override
    public void setup() throws IOException {
        block2: {
            super.setup();
            String[] taskControllerCmd = new String[]{this.getTaskControllerExecutablePath()};
            Shell.ShellCommandExecutor shExec = new Shell.ShellCommandExecutor(taskControllerCmd);
            try {
                shExec.execute();
            }
            catch (Shell.ExitCodeException e) {
                int exitCode = shExec.getExitCode();
                if (exitCode == 1) break block2;
                LOG.warn((Object)("Exit code from checking binary permissions is : " + exitCode));
                this.logOutput(shExec.getOutput());
                throw new IOException("Task controller setup failed because of invalidpermissions/ownership with exit code " + exitCode, e);
            }
        }
    }

    @Override
    void launchTaskJVM(TaskController.TaskControllerContext context) throws IOException {
        Shell.ShellCommandExecutor shExec;
        JvmManager.JvmEnv env = context.env;
        String cmdLine = TaskLog.buildCommandLine(env.setup, env.vargs, env.stdout, env.stderr, env.logSize, true);
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> entry : env.env.entrySet()) {
            sb.append("export ");
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
            sb.append("\n");
        }
        sb.append(cmdLine);
        this.writeCommand(sb.toString(), this.getTaskCacheDirectory(context, context.env.workDir));
        List<String> launchTaskJVMArgs = this.buildLaunchTaskArgs(context, context.env.workDir);
        context.shExec = shExec = this.buildTaskControllerExecutor(TaskControllerCommands.LAUNCH_TASK_JVM, env.conf.getUser(), launchTaskJVMArgs, env.workDir, env.env);
        try {
            shExec.execute();
        }
        catch (Exception e) {
            int exitCode = shExec.getExitCode();
            LOG.warn((Object)("Exit code from task is : " + exitCode));
            if (exitCode != 143 && exitCode != 137) {
                LOG.warn((Object)("Exception thrown while launching task JVM : " + StringUtils.stringifyException((Throwable)e)));
                LOG.info((Object)"Output from LinuxTaskController's launchTaskJVM follows:");
                this.logOutput(shExec.getOutput());
            }
            throw new IOException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)"Output from LinuxTaskController's launchTaskJVM follows:");
            this.logOutput(shExec.getOutput());
        }
    }

    @Override
    void runDebugScript(TaskController.DebugScriptContext context) throws IOException {
        String debugOut = FileUtil.makeShellPath((File)context.stdout);
        String cmdLine = TaskLog.buildDebugScriptCommandLine(context.args, debugOut);
        this.writeCommand(cmdLine, this.getTaskCacheDirectory(context, context.workDir));
        List<String> launchTaskJVMArgs = this.buildLaunchTaskArgs(context, context.workDir);
        this.runCommand(TaskControllerCommands.RUN_DEBUG_SCRIPT, context.task.getUser(), launchTaskJVMArgs, context.workDir, null);
    }

    private void runCommand(TaskControllerCommands taskControllerCommand, String user, List<String> cmdArgs, File workDir, Map<String, String> env) throws IOException {
        Shell.ShellCommandExecutor shExec = this.buildTaskControllerExecutor(taskControllerCommand, user, cmdArgs, workDir, env);
        try {
            shExec.execute();
        }
        catch (Exception e) {
            LOG.warn((Object)("Exit code from " + taskControllerCommand.toString() + " is : " + shExec.getExitCode()));
            LOG.warn((Object)("Exception thrown by " + taskControllerCommand.toString() + " : " + StringUtils.stringifyException((Throwable)e)));
            LOG.info((Object)("Output from LinuxTaskController's " + taskControllerCommand.toString() + " follows:"));
            this.logOutput(shExec.getOutput());
            throw new IOException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)("Output from LinuxTaskController's " + taskControllerCommand.toString() + " follows:"));
            this.logOutput(shExec.getOutput());
        }
    }

    private List<String> buildInitializeTaskArgs(TaskController.TaskExecContext context) {
        ArrayList<String> commandArgs = new ArrayList<String>(3);
        String taskId = context.task.getTaskID().toString();
        String jobId = this.getJobId(context);
        commandArgs.add(jobId);
        if (!context.task.isTaskCleanupTask()) {
            commandArgs.add(taskId);
        } else {
            commandArgs.add(taskId + ".cleanup");
        }
        return commandArgs;
    }

    @Override
    void initializeTask(TaskController.TaskControllerContext context) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Going to do " + TaskControllerCommands.INITIALIZE_TASK.toString() + " for " + context.task.getTaskID().toString()));
        }
        this.runCommand(TaskControllerCommands.INITIALIZE_TASK, context.env.conf.getUser(), this.buildInitializeTaskArgs(context), context.env.workDir, context.env.env);
    }

    private List<String> buildTaskCleanupArgs(TaskController.TaskControllerTaskPathDeletionContext context) {
        ArrayList<String> commandArgs = new ArrayList<String>(3);
        commandArgs.add(context.mapredLocalDir.toUri().getPath());
        commandArgs.add(context.task.getJobID().toString());
        String workDir = "";
        if (context.isWorkDir) {
            workDir = "/work";
        }
        if (context.task.isTaskCleanupTask()) {
            commandArgs.add(context.task.getTaskID() + ".cleanup" + workDir);
        } else {
            commandArgs.add(context.task.getTaskID() + workDir);
        }
        return commandArgs;
    }

    private List<String> buildJobCleanupArgs(TaskController.TaskControllerJobPathDeletionContext context) {
        ArrayList<String> commandArgs = new ArrayList<String>(2);
        commandArgs.add(context.mapredLocalDir.toUri().getPath());
        commandArgs.add(context.jobId.toString());
        return commandArgs;
    }

    @Override
    void enableTaskForCleanup(CleanupQueue.PathDeletionContext context) throws IOException {
        if (!(context instanceof TaskController.TaskControllerTaskPathDeletionContext)) {
            throw new IllegalArgumentException("PathDeletionContext provided is not TaskControllerTaskPathDeletionContext.");
        }
        TaskController.TaskControllerTaskPathDeletionContext tContext = (TaskController.TaskControllerTaskPathDeletionContext)context;
        this.enablePathForCleanup(tContext, TaskControllerCommands.ENABLE_TASK_FOR_CLEANUP, this.buildTaskCleanupArgs(tContext));
    }

    @Override
    void enableJobForCleanup(CleanupQueue.PathDeletionContext context) throws IOException {
        if (!(context instanceof TaskController.TaskControllerJobPathDeletionContext)) {
            throw new IllegalArgumentException("PathDeletionContext provided is not TaskControllerJobPathDeletionContext.");
        }
        TaskController.TaskControllerJobPathDeletionContext tContext = (TaskController.TaskControllerJobPathDeletionContext)context;
        this.enablePathForCleanup(tContext, TaskControllerCommands.ENABLE_JOB_FOR_CLEANUP, this.buildJobCleanupArgs(tContext));
    }

    private void enablePathForCleanup(TaskController.TaskControllerPathDeletionContext c, TaskControllerCommands command, List<String> cleanupArgs) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Going to do " + command.toString() + " for " + c.fullPath));
        }
        if (c.user != null && c.fs instanceof LocalFileSystem) {
            try {
                this.runCommand(command, c.user, cleanupArgs, null, null);
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to change permissions for " + c.fullPath));
            }
        } else {
            throw new IllegalArgumentException("Either user is null or the file system is not local file system.");
        }
    }

    private void logOutput(String output) {
        String shExecOutput = output;
        if (shExecOutput != null) {
            for (String str : shExecOutput.split("\n")) {
                LOG.info((Object)str);
            }
        }
    }

    private String getJobId(TaskController.TaskExecContext context) {
        String taskId = context.task.getTaskID().toString();
        TaskAttemptID tId = TaskAttemptID.forName(taskId);
        String jobId = tId.getJobID().toString();
        return jobId;
    }

    private List<String> buildLaunchTaskArgs(TaskController.TaskExecContext context, File workDir) {
        ArrayList<String> commandArgs = new ArrayList<String>(3);
        LOG.debug((Object)("getting the task directory as: " + this.getTaskCacheDirectory(context, workDir)));
        LOG.debug((Object)("getting the tt_root as " + this.getDirectoryChosenForTask(new File(this.getTaskCacheDirectory(context, workDir)), context)));
        commandArgs.add(this.getDirectoryChosenForTask(new File(this.getTaskCacheDirectory(context, workDir)), context));
        commandArgs.addAll(this.buildInitializeTaskArgs(context));
        return commandArgs;
    }

    private String getDirectoryChosenForTask(File directory, TaskController.TaskExecContext context) {
        String jobId = this.getJobId(context);
        String taskId = context.task.getTaskID().toString();
        for (String dir : this.mapredLocalDirs) {
            File mapredDir = new File(dir);
            File taskDir = new File(mapredDir, TaskTracker.getTaskWorkDir(context.task.getUser(), jobId, taskId, context.task.isTaskCleanupTask())).getParentFile();
            if (!directory.equals(taskDir)) continue;
            return dir;
        }
        LOG.error((Object)"Couldn't parse task cache directory correctly");
        throw new IllegalArgumentException("invalid task cache directory " + directory.getAbsolutePath());
    }

    private Shell.ShellCommandExecutor buildTaskControllerExecutor(TaskControllerCommands command, String userName, List<String> cmdArgs, File workDir, Map<String, String> env) throws IOException {
        String[] taskControllerCmd = new String[3 + cmdArgs.size()];
        taskControllerCmd[0] = this.getTaskControllerExecutablePath();
        taskControllerCmd[1] = userName;
        taskControllerCmd[2] = String.valueOf(command.ordinal());
        int i = 3;
        for (String cmdArg : cmdArgs) {
            taskControllerCmd[i++] = cmdArg;
        }
        if (LOG.isDebugEnabled()) {
            for (String cmd : taskControllerCmd) {
                LOG.debug((Object)("taskctrl command = " + cmd));
            }
        }
        Shell.ShellCommandExecutor shExec = null;
        shExec = workDir != null && workDir.exists() ? new Shell.ShellCommandExecutor(taskControllerCmd, workDir, env) : new Shell.ShellCommandExecutor(taskControllerCmd);
        return shExec;
    }

    private String getTaskCacheDirectory(TaskController.TaskExecContext context, File workDir) {
        String taskId = context.task.getTaskID().toString();
        File cacheDirForJob = workDir.getParentFile().getParentFile();
        if (context.task.isTaskCleanupTask()) {
            taskId = taskId + ".cleanup";
        }
        return new File(cacheDirForJob, taskId).getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCommand(String cmdLine, String directory) throws IOException {
        PrintWriter pw = null;
        String commandFile = directory + File.separator + COMMAND_FILE;
        LOG.info((Object)("Writing commands to " + commandFile));
        LOG.info((Object)"--------Commands Begin--------");
        LOG.info((Object)cmdLine);
        LOG.info((Object)"--------Commands End--------");
        try {
            FileWriter fw = new FileWriter(commandFile);
            BufferedWriter bw = new BufferedWriter(fw);
            pw = new PrintWriter(bw);
            pw.write(cmdLine);
        }
        catch (IOException ioe) {
            LOG.error((Object)("Caught IOException while writing JVM command line to file. " + ioe.getMessage()));
        }
        finally {
            File f;
            if (pw != null) {
                pw.close();
            }
            if ((f = new File(commandFile)).exists()) {
                f.setReadable(true, false);
                f.setExecutable(true, false);
            }
        }
    }

    private List<String> buildInitializeJobCommandArgs(TaskController.JobInitializationContext context) {
        ArrayList<String> initJobCmdArgs = new ArrayList<String>();
        initJobCmdArgs.add(context.jobid.toString());
        return initJobCmdArgs;
    }

    @Override
    void initializeJob(TaskController.JobInitializationContext context) throws IOException {
        LOG.debug((Object)("Going to initialize job " + context.jobid.toString() + " on the TT"));
        this.runCommand(TaskControllerCommands.INITIALIZE_JOB, context.user, this.buildInitializeJobCommandArgs(context), context.workDir, null);
    }

    @Override
    public void initializeDistributedCacheFile(TaskController.DistributedCacheFileContext context) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Going to initialize distributed cache for " + context.user + " with localizedBaseDir " + context.localizedBaseDir + " and uniqueString " + context.uniqueString));
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("--");
        args.add(context.localizedBaseDir.toString());
        args.add(context.uniqueString);
        this.runCommand(TaskControllerCommands.INITIALIZE_DISTRIBUTEDCACHE_FILE, context.user, args, context.workDir, null);
    }

    @Override
    public void initializeUser(TaskController.InitializationContext context) throws IOException {
        LOG.debug((Object)("Going to initialize user directories for " + context.user + " on the TT"));
        this.runCommand(TaskControllerCommands.INITIALIZE_USER, context.user, new ArrayList<String>(), context.workDir, null);
    }

    private List<String> buildKillTaskCommandArgs(TaskController.TaskControllerContext context) {
        ArrayList<String> killTaskJVMArgs = new ArrayList<String>();
        killTaskJVMArgs.add(context.pid);
        return killTaskJVMArgs;
    }

    protected void signalTask(TaskController.TaskControllerContext context, TaskControllerCommands command) throws IOException {
        if (context.task == null) {
            LOG.info((Object)"Context task is null; not signaling the JVM");
            return;
        }
        Shell.ShellCommandExecutor shExec = this.buildTaskControllerExecutor(command, context.env.conf.getUser(), this.buildKillTaskCommandArgs(context), context.env.workDir, context.env.env);
        try {
            shExec.execute();
        }
        catch (Exception e) {
            LOG.warn((Object)("Output from task-contoller is : " + shExec.getOutput()));
            throw new IOException(e);
        }
    }

    @Override
    void terminateTask(TaskController.TaskControllerContext context) {
        try {
            this.signalTask(context, TaskControllerCommands.TERMINATE_TASK_JVM);
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception thrown while sending kill to the Task VM " + StringUtils.stringifyException((Throwable)e)));
        }
    }

    @Override
    void killTask(TaskController.TaskControllerContext context) {
        try {
            this.signalTask(context, TaskControllerCommands.KILL_TASK_JVM);
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception thrown while sending destroy to the Task VM " + StringUtils.stringifyException((Throwable)e)));
        }
    }

    @Override
    void dumpTaskStack(TaskController.TaskControllerContext context) {
        try {
            this.signalTask(context, TaskControllerCommands.SIGQUIT_TASK_JVM);
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception thrown while sending SIGQUIT to the Task VM " + StringUtils.stringifyException((Throwable)e)));
        }
    }

    protected String getTaskControllerExecutablePath() {
        return taskControllerExe;
    }

    @Override
    String getRunAsUser(JobConf conf) {
        return conf.getUser();
    }

    static {
        File hadoopBin = new File(System.getenv("HADOOP_PREFIX"), "bin");
        taskControllerExe = new File(hadoopBin, "task-controller").getAbsolutePath();
    }

    static enum TaskControllerCommands {
        INITIALIZE_USER,
        INITIALIZE_JOB,
        INITIALIZE_DISTRIBUTEDCACHE_FILE,
        LAUNCH_TASK_JVM,
        INITIALIZE_TASK,
        TERMINATE_TASK_JVM,
        KILL_TASK_JVM,
        RUN_DEBUG_SCRIPT,
        SIGQUIT_TASK_JVM,
        ENABLE_TASK_FOR_CLEANUP,
        ENABLE_JOB_FOR_CLEANUP;

    }
}

