/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.filecache;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.hadoop.mapreduce.filecache.TrackerDistributedCacheManager;

@InterfaceAudience.Private
public class TaskDistributedCacheManager {
    private final TrackerDistributedCacheManager distributedCacheManager;
    private final Configuration taskConf;
    private final List<CacheFile> cacheFiles = new ArrayList<CacheFile>();
    private final List<String> classPaths = new ArrayList<String>();
    private boolean setupCalled = false;

    TaskDistributedCacheManager(TrackerDistributedCacheManager distributedCacheManager, Configuration taskConf) throws IOException {
        this.distributedCacheManager = distributedCacheManager;
        this.taskConf = taskConf;
        this.cacheFiles.addAll(CacheFile.makeCacheFiles(DistributedCache.getCacheFiles(taskConf), DistributedCache.getFileTimestamps(taskConf), TrackerDistributedCacheManager.getFileVisibilities(taskConf), DistributedCache.getFileClassPaths(taskConf), CacheFile.FileType.REGULAR));
        this.cacheFiles.addAll(CacheFile.makeCacheFiles(DistributedCache.getCacheArchives(taskConf), DistributedCache.getArchiveTimestamps(taskConf), TrackerDistributedCacheManager.getArchiveVisibilities(taskConf), DistributedCache.getArchiveClassPaths(taskConf), CacheFile.FileType.ARCHIVE));
    }

    public void setup(LocalDirAllocator lDirAlloc, File workDir, String privateCacheSubdir, String publicCacheSubDir) throws IOException {
        this.setupCalled = true;
        if (this.cacheFiles.isEmpty()) {
            return;
        }
        ArrayList<Path> localArchives = new ArrayList<Path>();
        ArrayList<Path> localFiles = new ArrayList<Path>();
        Path workdirPath = new Path(workDir.getAbsolutePath());
        for (CacheFile cacheFile : this.cacheFiles) {
            URI uri = cacheFile.uri;
            FileSystem fileSystem = FileSystem.get((URI)uri, (Configuration)this.taskConf);
            FileStatus fileStatus = fileSystem.getFileStatus(new Path(uri.getPath()));
            String cacheSubdir = publicCacheSubDir;
            if (!cacheFile.isPublic) {
                cacheSubdir = privateCacheSubdir;
            }
            Path p = this.distributedCacheManager.getLocalCache(uri, this.taskConf, cacheSubdir, fileStatus, cacheFile.type == CacheFile.FileType.ARCHIVE, cacheFile.timestamp, workdirPath, false, cacheFile.isPublic);
            cacheFile.setLocalized(true);
            if (cacheFile.type == CacheFile.FileType.ARCHIVE) {
                localArchives.add(p);
            } else {
                localFiles.add(p);
            }
            if (!cacheFile.shouldBeAddedToClassPath) continue;
            this.classPaths.add(p.toString());
        }
        if (!localArchives.isEmpty()) {
            TrackerDistributedCacheManager.setLocalArchives(this.taskConf, TaskDistributedCacheManager.stringifyPathList(localArchives));
        }
        if (!localFiles.isEmpty()) {
            TrackerDistributedCacheManager.setLocalFiles(this.taskConf, TaskDistributedCacheManager.stringifyPathList(localFiles));
        }
    }

    List<CacheFile> getCacheFiles() {
        return this.cacheFiles;
    }

    private static String stringifyPathList(List<Path> p) {
        if (p == null || p.isEmpty()) {
            return null;
        }
        StringBuilder str = new StringBuilder(p.get(0).toString());
        for (int i = 1; i < p.size(); ++i) {
            str.append(",");
            str.append(p.get(i).toString());
        }
        return str.toString();
    }

    public List<String> getClassPaths() throws IOException {
        if (!this.setupCalled) {
            throw new IllegalStateException("getClassPaths() should be called after setup()");
        }
        return this.classPaths;
    }

    public void release() throws IOException {
        for (CacheFile c : this.cacheFiles) {
            if (!c.getLocalized()) continue;
            this.distributedCacheManager.releaseCache(c.uri, this.taskConf, c.timestamp, c.owner, CacheFile.FileType.ARCHIVE == c.type);
        }
    }

    public ClassLoader makeClassLoader(final ClassLoader parent) throws MalformedURLException {
        final URL[] urls = new URL[this.classPaths.size()];
        for (int i = 0; i < this.classPaths.size(); ++i) {
            urls[i] = new File(this.classPaths.get(i)).toURI().toURL();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new URLClassLoader(urls, parent);
            }
        });
    }

    static class CacheFile {
        final URI uri;
        boolean isPublic = true;
        final FileType type;
        final long timestamp;
        final boolean shouldBeAddedToClassPath;
        boolean localized = false;
        final String owner;

        private CacheFile(URI uri, FileType type, boolean isPublic, long timestamp, boolean classPath) throws IOException {
            this.uri = uri;
            this.type = type;
            this.isPublic = isPublic;
            this.timestamp = timestamp;
            this.shouldBeAddedToClassPath = classPath;
            this.owner = TrackerDistributedCacheManager.getLocalizedCacheOwner(isPublic);
        }

        private static List<CacheFile> makeCacheFiles(URI[] uris, String[] timestamps, String[] cacheVisibilities, Path[] paths, FileType type) throws IOException {
            ArrayList<CacheFile> ret = new ArrayList<CacheFile>();
            if (uris != null) {
                if (uris.length != timestamps.length) {
                    throw new IllegalArgumentException("Mismatched uris and timestamps.");
                }
                HashMap<String, Path> classPaths = new HashMap<String, Path>();
                if (paths != null) {
                    for (Path p : paths) {
                        classPaths.put(p.toUri().getPath().toString(), p);
                    }
                }
                for (int i = 0; i < uris.length; ++i) {
                    URI u = uris[i];
                    boolean isClassPath = null != classPaths.get(u.getPath());
                    long t = Long.parseLong(timestamps[i]);
                    ret.add(new CacheFile(u, type, Boolean.valueOf(cacheVisibilities[i]), t, isClassPath));
                }
            }
            return ret;
        }

        boolean getLocalized() {
            return this.localized;
        }

        void setLocalized(boolean val) {
            this.localized = val;
        }

        static enum FileType {
            REGULAR,
            ARCHIVE;

        }
    }
}

