/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.jobhistory.Event;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JhCounter;
import org.apache.hadoop.mapreduce.jobhistory.JhCounterGroup;
import org.apache.hadoop.mapreduce.jobhistory.JhCounters;

class EventWriter {
    static final String VERSION = "Avro-Json";
    private FSDataOutputStream out;
    private DatumWriter<Event> writer = new SpecificDatumWriter(Event.class);
    private Encoder encoder;
    private static final Schema GROUPS = Schema.createArray((Schema)JhCounterGroup.SCHEMA$);
    private static final Schema COUNTERS = Schema.createArray((Schema)JhCounter.SCHEMA$);

    EventWriter(FSDataOutputStream out) throws IOException {
        this.out = out;
        out.writeBytes(VERSION);
        out.writeBytes("\n");
        out.writeBytes(Event.SCHEMA$.toString());
        out.writeBytes("\n");
        this.encoder = new JsonEncoder(Event.SCHEMA$, (OutputStream)out);
    }

    synchronized void write(HistoryEvent event) throws IOException {
        Event wrapper = new Event();
        wrapper.type = event.getEventType();
        wrapper.event = event.getDatum();
        this.writer.write((Object)wrapper, this.encoder);
        this.encoder.flush();
        this.out.writeBytes("\n");
    }

    void flush() throws IOException {
        this.encoder.flush();
        this.out.flush();
    }

    void close() throws IOException {
        this.encoder.flush();
        this.out.close();
    }

    static JhCounters toAvro(Counters counters) {
        return EventWriter.toAvro(counters, "COUNTERS");
    }

    static JhCounters toAvro(Counters counters, String name) {
        JhCounters result = new JhCounters();
        result.name = new Utf8(name);
        result.groups = new GenericData.Array(0, GROUPS);
        if (counters == null) {
            return result;
        }
        for (CounterGroup group : counters) {
            JhCounterGroup g = new JhCounterGroup();
            g.name = new Utf8(group.getName());
            g.displayName = new Utf8(group.getDisplayName());
            g.counts = new GenericData.Array(group.size(), COUNTERS);
            for (Counter counter : group) {
                JhCounter c = new JhCounter();
                c.name = new Utf8(counter.getName());
                c.displayName = new Utf8(counter.getDisplayName());
                c.value = counter.getValue();
                g.counts.add((Object)c);
            }
            result.groups.add((Object)g);
        }
        return result;
    }
}

