/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSError;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.mapred.JVMId;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JvmContext;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapred.YarnOutputFiles;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.log4j.LogManager;

class YarnChild {
    private static final Log LOG = LogFactory.getLog(YarnChild.class);
    static volatile TaskAttemptID taskid = null;
    private static final FsPermission urw_gr = FsPermission.createImmutable((short)416);

    YarnChild() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Throwable {
        LOG.debug((Object)"Child starting");
        final JobConf defaultConf = new JobConf();
        defaultConf.addResource("job.xml");
        UserGroupInformation.setConfiguration((Configuration)defaultConf);
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        final InetSocketAddress address = new InetSocketAddress(host, port);
        TaskAttemptID firstTaskid = TaskAttemptID.forName((String)args[2]);
        int jvmIdInt = Integer.parseInt(args[3]);
        JVMId jvmId = new JVMId(firstTaskid.getJobID(), firstTaskid.getTaskType() == TaskType.MAP, jvmIdInt);
        DefaultMetricsSystem.initialize((String)(StringUtils.camelize((String)firstTaskid.getTaskType().name()) + "Task"));
        Token<JobTokenIdentifier> jt = YarnChild.loadCredentials(defaultConf, address);
        UserGroupInformation taskOwner = UserGroupInformation.createRemoteUser((String)firstTaskid.getJobID().toString());
        taskOwner.addToken(jt);
        final TaskUmbilicalProtocol umbilical = (TaskUmbilicalProtocol)taskOwner.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<TaskUmbilicalProtocol>(){

            @Override
            public TaskUmbilicalProtocol run() throws Exception {
                return (TaskUmbilicalProtocol)RPC.getProxy(TaskUmbilicalProtocol.class, (long)19L, (InetSocketAddress)address, (Configuration)defaultConf);
            }
        });
        JvmContext context = new JvmContext(jvmId, "-1000");
        LOG.debug((Object)("PID: " + System.getenv().get("JVM_PID")));
        Task task = null;
        UserGroupInformation childUGI = null;
        try {
            boolean idleLoopCount = false;
            JvmTask myTask = null;
            int idle = 0;
            while (null == myTask) {
                long sleepTimeMilliSecs = Math.min(idle * 500, 1500);
                LOG.info((Object)("Sleeping for " + sleepTimeMilliSecs + "ms before retrying again. Got null now."));
                TimeUnit.MILLISECONDS.sleep(sleepTimeMilliSecs);
                myTask = umbilical.getTask(context);
                ++idle;
            }
            if (myTask.shouldDie()) {
                return;
            }
            task = myTask.getTask();
            taskid = task.getTaskID();
            final JobConf job = YarnChild.configureTask(task, defaultConf.getCredentials(), jt);
            JvmMetrics.initSingleton((String)jvmId.toString(), (String)job.getSessionId());
            childUGI = UserGroupInformation.createRemoteUser((String)System.getenv(ApplicationConstants.Environment.USER.toString()));
            for (Token token : UserGroupInformation.getCurrentUser().getTokens()) {
                childUGI.addToken(token);
            }
            final Task taskFinal = task;
            childUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    FileSystem.get((Configuration)job).setWorkingDirectory(job.getWorkingDirectory());
                    taskFinal.run(job, umbilical);
                    return null;
                }
            });
        }
        catch (FSError e) {
            LOG.fatal((Object)"FSError from child", (Throwable)e);
            umbilical.fsError(taskid, e.getMessage());
        }
        catch (Exception exception) {
            LOG.warn((Object)("Exception running child : " + StringUtils.stringifyException((Throwable)exception)));
            try {
                if (task != null) {
                    if (childUGI == null) {
                        task.taskCleanup(umbilical);
                    } else {
                        final Task taskFinal = task;
                        childUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                taskFinal.taskCleanup(umbilical);
                                return null;
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                LOG.info((Object)("Exception cleaning up: " + StringUtils.stringifyException((Throwable)e)));
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            exception.printStackTrace(new PrintStream(baos));
            if (taskid != null) {
                umbilical.fatalError(taskid, baos.toString());
            }
        }
        catch (Throwable throwable) {
            LOG.fatal((Object)("Error running child : " + StringUtils.stringifyException((Throwable)throwable)));
            if (taskid != null) {
                Throwable tCause = throwable.getCause();
                String cause = tCause == null ? throwable.getMessage() : StringUtils.stringifyException((Throwable)tCause);
                umbilical.fatalError(taskid, cause);
            }
        }
        finally {
            RPC.stopProxy((Object)umbilical);
            DefaultMetricsSystem.shutdown();
            LogManager.shutdown();
        }
    }

    private static Token<JobTokenIdentifier> loadCredentials(JobConf conf, InetSocketAddress address) throws IOException {
        String tokenFileLocation = System.getenv("HADOOP_TOKEN_FILE_LOCATION");
        String jobTokenFile = new Path(tokenFileLocation).makeQualified((FileSystem)FileSystem.getLocal((Configuration)conf)).toUri().getPath();
        Credentials credentials = TokenCache.loadTokens((String)jobTokenFile, (JobConf)conf);
        LOG.debug((Object)("loading token. # keys =" + credentials.numberOfSecretKeys() + "; from file=" + jobTokenFile));
        Token jt = TokenCache.getJobToken((Credentials)credentials);
        jt.setService(new Text(address.getAddress().getHostAddress() + ":" + address.getPort()));
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        current.addToken(jt);
        for (Token tok : credentials.getAllTokens()) {
            current.addToken(tok);
        }
        conf.setCredentials(credentials);
        return jt;
    }

    private static void configureLocalDirs(Task task, JobConf job) {
        String[] localSysDirs = StringUtils.getTrimmedStrings((String)System.getenv("YARN_LOCAL_DIRS"));
        job.setStrings("mapreduce.cluster.local.dir", localSysDirs);
        LOG.info((Object)("mapreduce.cluster.local.dir for child: " + job.get("mapreduce.cluster.local.dir")));
    }

    private static JobConf configureTask(Task task, Credentials credentials, Token<JobTokenIdentifier> jt) throws IOException {
        JobConf job = new JobConf("job.xml");
        job.setCredentials(credentials);
        String appAttemptIdEnv = System.getenv("APPLICATION_ATTEMPT_ID_ENV");
        LOG.debug((Object)("APPLICATION_ATTEMPT_ID: " + appAttemptIdEnv));
        job.setInt("mapreduce.job.application.attempt.id", Integer.parseInt(appAttemptIdEnv));
        job.setBoolean("ipc.client.tcpnodelay", true);
        job.setClass("mapreduce.task.local.output.class", YarnOutputFiles.class, MapOutputFile.class);
        task.setJobTokenSecret(JobTokenSecretManager.createSecretKey((byte[])jt.getPassword()));
        YarnChild.configureLocalDirs(task, job);
        task.localizeConfiguration(job);
        YarnChild.setupDistributedCacheConfig(job);
        Path localTaskFile = new Path("job.xml");
        YarnChild.writeLocalJobFile(localTaskFile, job);
        task.setJobFile(localTaskFile.toString());
        task.setConf((Configuration)job);
        return job;
    }

    private static void setupDistributedCacheConfig(JobConf job) throws IOException {
        URI[] cacheFiles;
        String localWorkDir = System.getenv("PWD");
        URI[] cacheArchives = DistributedCache.getCacheArchives((Configuration)job);
        if (cacheArchives != null) {
            ArrayList<String> localArchives = new ArrayList<String>();
            for (int i = 0; i < cacheArchives.length; ++i) {
                URI u = cacheArchives[i];
                Path p = new Path(u);
                Path name = new Path(null == u.getFragment() ? p.getName() : u.getFragment());
                String linkName = name.toUri().getPath();
                localArchives.add(new Path(localWorkDir, linkName).toUri().getPath());
            }
            if (!localArchives.isEmpty()) {
                job.set("mapreduce.job.cache.local.archives", StringUtils.arrayToString((String[])localArchives.toArray(new String[localArchives.size()])));
            }
        }
        if ((cacheFiles = DistributedCache.getCacheFiles((Configuration)job)) != null) {
            ArrayList<String> localFiles = new ArrayList<String>();
            for (int i = 0; i < cacheFiles.length; ++i) {
                URI u = cacheFiles[i];
                Path p = new Path(u);
                Path name = new Path(null == u.getFragment() ? p.getName() : u.getFragment());
                String linkName = name.toUri().getPath();
                localFiles.add(new Path(localWorkDir, linkName).toUri().getPath());
            }
            if (!localFiles.isEmpty()) {
                job.set("mapreduce.job.cache.local.files", StringUtils.arrayToString((String[])localFiles.toArray(new String[localFiles.size()])));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLocalJobFile(Path jobFile, JobConf conf) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        localFs.delete(jobFile);
        FSDataOutputStream out = null;
        try {
            out = FileSystem.create((FileSystem)localFs, (Path)jobFile, (FsPermission)urw_gr);
            conf.writeXml((OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{out});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{out});
    }
}

