/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.mortbay.log.Log;

public class JobEndNotifier
implements Configurable {
    private static final String JOB_ID = "$jobId";
    private static final String JOB_STATUS = "$jobStatus";
    private Configuration conf;
    protected String userUrl;
    protected int numTries;
    protected int waitInterval;
    protected URL urlToNotify;

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.numTries = Math.min(conf.getInt("mapreduce.job.end-notification.retry.attempts", 0) + 1, conf.getInt("mapreduce.job.end-notification.max.attempts", 1));
        this.waitInterval = Math.min(conf.getInt("mapreduce.job.end-notification.retry.interval", 5), conf.getInt("mapreduce.job.end-notification.max.retry.interval", 5));
        this.waitInterval = this.waitInterval < 0 ? 5 : this.waitInterval;
        this.userUrl = conf.get("mapreduce.job.end-notification.url");
    }

    public Configuration getConf() {
        return this.conf;
    }

    protected boolean notifyURLOnce() {
        boolean success = false;
        try {
            Log.info((String)("Job end notification trying " + this.urlToNotify));
            URLConnection conn = this.urlToNotify.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            conn.setAllowUserInteraction(false);
            InputStream is = conn.getInputStream();
            conn.getContent();
            is.close();
            success = true;
            Log.info((String)("Job end notification to " + this.urlToNotify + " succeeded"));
        }
        catch (IOException ioe) {
            Log.warn((String)("Job end notification to " + this.urlToNotify + " failed"), (Throwable)ioe);
        }
        return success;
    }

    public void notify(JobReport jobReport) throws InterruptedException {
        if (this.userUrl == null) {
            Log.info((String)"Job end notification URL not set, skipping.");
            return;
        }
        if (this.userUrl.contains(JOB_ID)) {
            this.userUrl = this.userUrl.replace(JOB_ID, jobReport.getJobId().toString());
        }
        if (this.userUrl.contains(JOB_STATUS)) {
            this.userUrl = this.userUrl.replace(JOB_STATUS, jobReport.getJobState().toString());
        }
        try {
            this.urlToNotify = new URL(this.userUrl);
        }
        catch (MalformedURLException mue) {
            Log.warn((String)("Job end notification couldn't parse " + this.userUrl), (Throwable)mue);
            return;
        }
        boolean success = false;
        while (this.numTries-- > 0 && !success) {
            Log.info((String)("Job end notification attempts left " + this.numTries));
            success = this.notifyURLOnce();
            if (success) continue;
            Thread.sleep(this.waitInterval);
        }
        if (!success) {
            Log.warn((String)("Job end notification failed to notify : " + this.urlToNotify));
        } else {
            Log.info((String)("Job end notification succeeded for " + jobReport.getJobId()));
        }
    }
}

