/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Inject;
import java.util.Date;
import java.util.Map;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class JobBlock
extends HtmlBlock {
    final AppContext appContext;
    int runningMapTasks = 0;
    int pendingMapTasks = 0;
    int runningReduceTasks = 0;
    int pendingReduceTasks = 0;
    int newMapAttempts = 0;
    int runningMapAttempts = 0;
    int killedMapAttempts = 0;
    int failedMapAttempts = 0;
    int successfulMapAttempts = 0;
    int newReduceAttempts = 0;
    int runningReduceAttempts = 0;
    int killedReduceAttempts = 0;
    int failedReduceAttempts = 0;
    int successfulReduceAttempts = 0;

    @Inject
    JobBlock(AppContext appctx) {
        this.appContext = appctx;
    }

    protected void render(HtmlBlock.Block html) {
        String jid = this.$("job.id");
        if (jid.isEmpty()) {
            html.p()._(new Object[]{"Sorry, can't do anything without a JobID."})._();
            return;
        }
        JobId jobID = MRApps.toJobID((String)jid);
        Job job = this.appContext.getJob(jobID);
        if (job == null) {
            html.p()._(new Object[]{"Sorry, ", jid, " not found."})._();
            return;
        }
        JobReport jobReport = job.getReport();
        String mapPct = StringHelper.percent((double)jobReport.getMapProgress());
        String reducePct = StringHelper.percent((double)jobReport.getReduceProgress());
        int mapTasks = job.getTotalMaps();
        int mapTasksComplete = job.getCompletedMaps();
        int reduceTasks = job.getTotalReduces();
        int reducesTasksComplete = job.getCompletedReduces();
        long startTime = jobReport.getStartTime();
        long finishTime = jobReport.getFinishTime();
        this.countTasksAndAttempts(job);
        this.info("Job Overview")._("Job Name:", (Object)job.getName())._("State:", (Object)job.getState())._("Uberized:", (Object)job.isUber())._("Started:", (Object)new Date(startTime))._("Elapsed:", (Object)StringUtils.formatTime((long)Times.elapsed((long)startTime, (long)finishTime)));
        ((Hamlet.DIV)((Hamlet.TABLE)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.DIV)((Hamlet.TABLE)((Hamlet.TR)((Hamlet.TD)((Hamlet.DIV)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.TR)((Hamlet.TD)((Hamlet.DIV)((Hamlet.TR)((Hamlet.TABLE)html._(InfoBlock.class).div(".info-wrap.ui-widget-content.ui-corner-bottom").table("#job").tr().th(".ui-state-default", "Task Type").th(".ui-state-default", "Progress").th(".ui-state-default", "Total").th(".ui-state-default", "Pending").th(".ui-state-default", "Running").th(".ui-state-default", "Complete")._()).tr(".odd").th().a(this.url(new String[]{"tasks", jid, "m"}), "Map")._()).td().div(".ui-progressbar.ui-widget.ui-widget-content.ui-corner-all").$title(StringHelper.join((Object[])new Object[]{mapPct, Character.valueOf('%')})).div(".ui-progressbar-value.ui-widget-header.ui-corner-left").$style(StringHelper.join((Object[])new Object[]{"width:", mapPct, Character.valueOf('%')}))._())._())._()).td(String.valueOf(mapTasks)).td(String.valueOf(this.pendingMapTasks)).td(String.valueOf(this.runningMapTasks)).td(String.valueOf(mapTasksComplete))._()).tr(".even").th().a(this.url(new String[]{"tasks", jid, "r"}), "Reduce")._()).td().div(".ui-progressbar.ui-widget.ui-widget-content.ui-corner-all").$title(StringHelper.join((Object[])new Object[]{reducePct, Character.valueOf('%')})).div(".ui-progressbar-value.ui-widget-header.ui-corner-left").$style(StringHelper.join((Object[])new Object[]{"width:", reducePct, Character.valueOf('%')}))._())._())._()).td(String.valueOf(reduceTasks)).td(String.valueOf(this.pendingReduceTasks)).td(String.valueOf(this.runningReduceTasks)).td(String.valueOf(reducesTasksComplete))._())._()).table("#job").tr().th(".ui-state-default", "Attempt Type").th(".ui-state-default", "New").th(".ui-state-default", "Running").th(".ui-state-default", "Failed").th(".ui-state-default", "Killed").th(".ui-state-default", "Successful")._()).tr(".odd").th("Maps").td().a(this.url(new String[]{"attempts", jid, "m", MRApps.TaskAttemptStateUI.NEW.toString()}), String.valueOf(this.newMapAttempts))._()).td().a(this.url(new String[]{"attempts", jid, "m", MRApps.TaskAttemptStateUI.RUNNING.toString()}), String.valueOf(this.runningMapAttempts))._()).td().a(this.url(new String[]{"attempts", jid, "m", MRApps.TaskAttemptStateUI.FAILED.toString()}), String.valueOf(this.failedMapAttempts))._()).td().a(this.url(new String[]{"attempts", jid, "m", MRApps.TaskAttemptStateUI.KILLED.toString()}), String.valueOf(this.killedMapAttempts))._()).td().a(this.url(new String[]{"attempts", jid, "m", MRApps.TaskAttemptStateUI.SUCCESSFUL.toString()}), String.valueOf(this.successfulMapAttempts))._())._()).tr(".even").th("Reduces").td().a(this.url(new String[]{"attempts", jid, "r", MRApps.TaskAttemptStateUI.NEW.toString()}), String.valueOf(this.newReduceAttempts))._()).td().a(this.url(new String[]{"attempts", jid, "r", MRApps.TaskAttemptStateUI.RUNNING.toString()}), String.valueOf(this.runningReduceAttempts))._()).td().a(this.url(new String[]{"attempts", jid, "r", MRApps.TaskAttemptStateUI.FAILED.toString()}), String.valueOf(this.failedReduceAttempts))._()).td().a(this.url(new String[]{"attempts", jid, "r", MRApps.TaskAttemptStateUI.KILLED.toString()}), String.valueOf(this.killedReduceAttempts))._()).td().a(this.url(new String[]{"attempts", jid, "r", MRApps.TaskAttemptStateUI.SUCCESSFUL.toString()}), String.valueOf(this.successfulReduceAttempts))._())._())._())._();
    }

    private void countTasksAndAttempts(Job job) {
        Map<TaskId, Task> tasks = job.getTasks();
        for (Task task : tasks.values()) {
            block0 : switch (task.getType()) {
                case MAP: {
                    switch (task.getState()) {
                        case RUNNING: {
                            ++this.runningMapTasks;
                            break;
                        }
                        case SCHEDULED: {
                            ++this.pendingMapTasks;
                        }
                    }
                    break;
                }
                case REDUCE: {
                    switch (task.getState()) {
                        case RUNNING: {
                            ++this.runningReduceTasks;
                            break block0;
                        }
                        case SCHEDULED: {
                            ++this.pendingReduceTasks;
                        }
                    }
                }
            }
            Map<TaskAttemptId, TaskAttempt> attempts = task.getAttempts();
            for (TaskAttempt attempt : attempts.values()) {
                int newAttempts = 0;
                int running = 0;
                int successful = 0;
                int failed = 0;
                int killed = 0;
                if (MRApps.TaskAttemptStateUI.NEW.correspondsTo(attempt.getState())) {
                    ++newAttempts;
                } else if (MRApps.TaskAttemptStateUI.RUNNING.correspondsTo(attempt.getState())) {
                    ++running;
                } else if (MRApps.TaskAttemptStateUI.SUCCESSFUL.correspondsTo(attempt.getState())) {
                    ++successful;
                } else if (MRApps.TaskAttemptStateUI.FAILED.correspondsTo(attempt.getState())) {
                    ++failed;
                } else if (MRApps.TaskAttemptStateUI.KILLED.correspondsTo(attempt.getState())) {
                    ++killed;
                }
                switch (task.getType()) {
                    case MAP: {
                        this.newMapAttempts += newAttempts;
                        this.runningMapAttempts += running;
                        this.successfulMapAttempts += successful;
                        this.failedMapAttempts += failed;
                        this.killedMapAttempts += killed;
                        break;
                    }
                    case REDUCE: {
                        this.newReduceAttempts += newAttempts;
                        this.runningReduceAttempts += running;
                        this.successfulReduceAttempts += successful;
                        this.failedReduceAttempts += failed;
                        this.killedReduceAttempts += killed;
                    }
                }
            }
        }
    }
}

