/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class JobsBlock
extends HtmlBlock {
    final AppContext appContext;

    @Inject
    JobsBlock(AppContext appCtx) {
        this.appContext = appCtx;
    }

    protected void render(HtmlBlock.Block html) {
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.h2("Active Jobs").table("#jobs").thead().tr().th(".id", "Job ID").th(".name", "Name").th(".state", "State").th("Map Progress").th("Maps Total").th("Maps Completed").th("Reduce Progress").th("Reduces Total").th("Reduces Completed")._())._()).tbody();
        for (Job job : this.appContext.getAllJobs().values()) {
            String jobID = MRApps.toString((JobId)job.getID());
            JobReport report = job.getReport();
            String mapPct = StringHelper.percent((double)report.getMapProgress());
            String mapsTotal = String.valueOf(job.getTotalMaps());
            String mapsCompleted = String.valueOf(job.getCompletedMaps());
            String reducePct = StringHelper.percent((double)report.getReduceProgress());
            String reduceTotal = String.valueOf(job.getTotalReduces());
            String reduceCompleted = String.valueOf(job.getCompletedReduces());
            ((Hamlet.TR)((Hamlet.TD)((Hamlet.DIV)((Hamlet.TD)((Hamlet.TR)((Hamlet.TD)((Hamlet.DIV)((Hamlet.TD)((Hamlet.TR)((Hamlet.TD)tbody.tr().td().span().$title(String.valueOf(job.getID().getId()))._()).a(this.url(new String[]{"job", jobID}), jobID)._()).td(job.getName().toString()).td(job.getState().toString()).td().span().$title(mapPct)._()).div(".ui-progressbar.ui-widget.ui-widget-content.ui-corner-all").$title(StringHelper.join((Object[])new Object[]{mapPct, Character.valueOf('%')})).div(".ui-progressbar-value.ui-widget-header.ui-corner-left").$style(StringHelper.join((Object[])new Object[]{"width:", mapPct, Character.valueOf('%')}))._())._())._()).td(mapsTotal).td(mapsCompleted).td().span().$title(reducePct)._()).div(".ui-progressbar.ui-widget.ui-widget-content.ui-corner-all").$title(StringHelper.join((Object[])new Object[]{reducePct, Character.valueOf('%')})).div(".ui-progressbar-value.ui-widget-header.ui-corner-left").$style(StringHelper.join((Object[])new Object[]{"width:", reducePct, Character.valueOf('%')}))._())._())._()).td(reduceTotal).td(reduceCompleted)._();
        }
        ((Hamlet.TABLE)tbody._())._();
    }
}

