/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class TasksBlock
extends HtmlBlock {
    final App app;

    @Inject
    TasksBlock(App app) {
        this.app = app;
    }

    protected void render(HtmlBlock.Block html) {
        if (this.app.getJob() == null) {
            html.h2(this.$("title"));
            return;
        }
        TaskType type = null;
        String symbol = this.$("task.type");
        if (!symbol.isEmpty()) {
            type = MRApps.taskType((String)symbol);
        }
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#tasks").thead().tr().th("Task").th("Progress").th("State").th("Start Time").th("Finish Time").th("Elapsed Time")._())._()).tbody();
        for (Task task : this.app.getJob().getTasks().values()) {
            if (type != null && task.getType() != type) continue;
            String tid = MRApps.toString((TaskId)task.getID());
            TaskReport report = task.getReport();
            String pct = StringHelper.percent((double)report.getProgress());
            long startTime = report.getStartTime();
            long finishTime = report.getFinishTime();
            long elapsed = Times.elapsed((long)startTime, (long)finishTime);
            ((Hamlet.TR)((Hamlet.TD)((Hamlet.TR)((Hamlet.TD)((Hamlet.TR)((Hamlet.TD)((Hamlet.TR)((Hamlet.TD)((Hamlet.DIV)((Hamlet.TD)((Hamlet.TR)((Hamlet.TD)tbody.tr().td().br().$title(String.valueOf(task.getID().getId()))._()).a(this.url(new String[]{"task", tid}), tid)._()).td().br().$title(pct)._()).div(".ui-progressbar.ui-widget.ui-widget-content.ui-corner-all").$title(StringHelper.join((Object[])new Object[]{pct, Character.valueOf('%')})).div(".ui-progressbar-value.ui-widget-header.ui-corner-left").$style(StringHelper.join((Object[])new Object[]{"width:", pct, Character.valueOf('%')}))._())._())._()).td(report.getTaskState().toString()).td().br().$title(String.valueOf(startTime))._())._(new Object[]{Times.format((long)startTime)})._()).td().br().$title(String.valueOf(finishTime))._())._(new Object[]{Times.format((long)finishTime)})._()).td().br().$title(String.valueOf(elapsed))._())._(new Object[]{StringUtils.formatTime((long)elapsed)})._())._();
        }
        ((Hamlet.TABLE)tbody._())._();
    }
}

