/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.hs.CompletedTaskAttempt;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;

public class CompletedTask
implements Task {
    private final org.apache.hadoop.mapreduce.v2.api.records.TaskType type;
    private org.apache.hadoop.mapreduce.v2.api.records.Counters counters;
    private final long startTime;
    private final long finishTime;
    private TaskState state;
    private final TaskId taskId;
    private final TaskReport report;
    private final Map<TaskAttemptId, TaskAttempt> attempts = new LinkedHashMap<TaskAttemptId, TaskAttempt>();
    private static final Log LOG = LogFactory.getLog(CompletedTask.class);

    CompletedTask(TaskId taskId, JobHistoryParser.TaskInfo taskInfo) {
        LOG.debug((Object)("HandlingTaskId: [" + taskId + "]"));
        this.taskId = taskId;
        this.startTime = taskInfo.getStartTime();
        this.finishTime = taskInfo.getFinishTime();
        this.type = TypeConverter.toYarn((TaskType)taskInfo.getTaskType());
        if (taskInfo.getCounters() != null) {
            this.counters = TypeConverter.toYarn((Counters)taskInfo.getCounters());
        }
        this.state = taskInfo.getTaskStatus() != null ? TaskState.valueOf((String)taskInfo.getTaskStatus()) : TaskState.KILLED;
        this.report = (TaskReport)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(TaskReport.class);
        for (JobHistoryParser.TaskAttemptInfo attemptHistory : taskInfo.getAllTaskAttempts().values()) {
            CompletedTaskAttempt attempt = new CompletedTaskAttempt(taskId, attemptHistory);
            this.report.addAllDiagnostics(attempt.getDiagnostics());
            this.attempts.put(attempt.getID(), attempt);
            if (attemptHistory.getTaskStatus() == null || !attemptHistory.getTaskStatus().equals(TaskState.SUCCEEDED.toString()) || this.report.getSuccessfulAttempt() != null) continue;
            this.report.setSuccessfulAttempt(TypeConverter.toYarn((TaskAttemptID)attemptHistory.getAttemptId()));
        }
        this.report.setTaskId(taskId);
        this.report.setStartTime(this.startTime);
        this.report.setFinishTime(this.finishTime);
        this.report.setTaskState(this.state);
        this.report.setProgress(this.getProgress());
        this.report.setCounters(this.getCounters());
        this.report.addAllRunningAttempts(new ArrayList<TaskAttemptId>(this.attempts.keySet()));
    }

    public boolean canCommit(TaskAttemptId taskAttemptID) {
        return false;
    }

    public TaskAttempt getAttempt(TaskAttemptId attemptID) {
        return this.attempts.get(attemptID);
    }

    public Map<TaskAttemptId, TaskAttempt> getAttempts() {
        return this.attempts;
    }

    public org.apache.hadoop.mapreduce.v2.api.records.Counters getCounters() {
        return this.counters;
    }

    public TaskId getID() {
        return this.taskId;
    }

    public float getProgress() {
        return 1.0f;
    }

    public TaskReport getReport() {
        return this.report;
    }

    public org.apache.hadoop.mapreduce.v2.api.records.TaskType getType() {
        return this.type;
    }

    public boolean isFinished() {
        return true;
    }

    public TaskState getState() {
        return this.state;
    }
}

