/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.v2.hs.HistoryClientService;
import org.apache.hadoop.mapreduce.v2.hs.HistoryContext;
import org.apache.hadoop.mapreduce.v2.hs.JobHistory;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.service.CompositeService;
import org.apache.hadoop.yarn.service.Service;

public class JobHistoryServer
extends CompositeService {
    private static final Log LOG = LogFactory.getLog(JobHistoryServer.class);
    private HistoryContext historyContext;
    private HistoryClientService clientService;
    private JobHistory jobHistoryService;

    public JobHistoryServer() {
        super(JobHistoryServer.class.getName());
    }

    public synchronized void init(Configuration conf) {
        YarnConfiguration config = new YarnConfiguration(conf);
        try {
            this.doSecureLogin(conf);
        }
        catch (IOException ie) {
            throw new YarnException("History Server Failed to login", (Throwable)ie);
        }
        this.jobHistoryService = new JobHistory();
        this.historyContext = this.jobHistoryService;
        this.clientService = new HistoryClientService(this.historyContext);
        this.addService((Service)this.jobHistoryService);
        this.addService((Service)this.clientService);
        super.init((Configuration)config);
    }

    protected void doSecureLogin(Configuration conf) throws IOException {
        SecurityUtil.login((Configuration)conf, (String)"mapreduce.jobhistory.keytab", (String)"mapreduce.jobhistory.principal");
    }

    public static void main(String[] args) {
        StringUtils.startupShutdownMessage(JobHistoryServer.class, (String[])args, (Log)LOG);
        try {
            JobHistoryServer jobHistoryServer = new JobHistoryServer();
            Runtime.getRuntime().addShutdownHook((Thread)new CompositeService.CompositeServiceShutdownHook((CompositeService)jobHistoryServer));
            YarnConfiguration conf = new YarnConfiguration((Configuration)new JobConf());
            jobHistoryServer.init((Configuration)conf);
            jobHistoryServer.start();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting JobHistoryServer", t);
            System.exit(-1);
        }
    }
}

