/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import com.google.inject.Inject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.util.BuilderUtils;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.ResponseInfo;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class HsJobBlock
extends HtmlBlock {
    final AppContext appContext;
    int killedMapAttempts = 0;
    int failedMapAttempts = 0;
    int successfulMapAttempts = 0;
    int killedReduceAttempts = 0;
    int failedReduceAttempts = 0;
    int successfulReduceAttempts = 0;
    long avgMapTime = 0L;
    long avgReduceTime = 0L;
    long avgShuffleTime = 0L;
    long avgSortTime = 0L;
    int numMaps;
    int numReduces;

    @Inject
    HsJobBlock(AppContext appctx) {
        this.appContext = appctx;
    }

    protected void render(HtmlBlock.Block html) {
        String jid = this.$("job.id");
        if (jid.isEmpty()) {
            html.p()._(new Object[]{"Sorry, can't do anything without a JobID."})._();
            return;
        }
        JobId jobID = MRApps.toJobID((String)jid);
        Job job = this.appContext.getJob(jobID);
        if (job == null) {
            html.p()._(new Object[]{"Sorry, ", jid, " not found."})._();
            return;
        }
        Map acls = job.getJobACLs();
        List amInfos = job.getAMInfos();
        JobReport jobReport = job.getReport();
        int mapTasks = job.getTotalMaps();
        int mapTasksComplete = job.getCompletedMaps();
        int reduceTasks = job.getTotalReduces();
        int reducesTasksComplete = job.getCompletedReduces();
        long startTime = jobReport.getStartTime();
        long finishTime = jobReport.getFinishTime();
        this.countTasksAndAttempts(job);
        ResponseInfo infoBlock = this.info("Job Overview")._("Job Name:", (Object)job.getName())._("User Name:", (Object)job.getUserName())._("Queue:", (Object)job.getQueueName())._("State:", (Object)job.getState())._("Uberized:", (Object)job.isUber())._("Started:", (Object)new Date(startTime))._("Finished:", (Object)new Date(finishTime))._("Elapsed:", (Object)StringUtils.formatTime((long)Times.elapsed((long)startTime, (long)finishTime, (boolean)false)));
        String amString = amInfos.size() == 1 ? "ApplicationMaster" : "ApplicationMasters";
        List diagnostics = job.getDiagnostics();
        if (diagnostics != null && !diagnostics.isEmpty()) {
            StringBuffer b = new StringBuffer();
            for (String diag : diagnostics) {
                b.append(diag);
            }
            infoBlock._("Diagnostics:", (Object)b.toString());
        }
        if (this.numMaps > 0) {
            infoBlock._("Average Map Time", (Object)StringUtils.formatTime((long)this.avgMapTime));
        }
        if (this.numReduces > 0) {
            infoBlock._("Average Reduce Time", (Object)StringUtils.formatTime((long)this.avgReduceTime));
            infoBlock._("Average Shuffle Time", (Object)StringUtils.formatTime((long)this.avgShuffleTime));
            infoBlock._("Average Merge Time", (Object)StringUtils.formatTime((long)this.avgSortTime));
        }
        for (Map.Entry entry : acls.entrySet()) {
            infoBlock._("ACL " + ((JobACL)entry.getKey()).getAclName() + ":", (Object)((AccessControlList)entry.getValue()).getAclString());
        }
        Hamlet.DIV div = html._(InfoBlock.class).div(".info-wrap.ui-widget-content.ui-corner-bottom");
        Hamlet.TABLE table = div.table("#job");
        ((Hamlet.TABLE)table.tr().th(amString)._()).tr().th(".ui-state-default", "Attempt Number").th(".ui-state-default", "Start Time").th(".ui-state-default", "Node").th(".ui-state-default", "Logs")._();
        for (AMInfo amInfo : amInfos) {
            String nodeHttpAddress = amInfo.getNodeManagerHost() + ":" + amInfo.getNodeManagerHttpPort();
            NodeId nodeId = BuilderUtils.newNodeId((String)amInfo.getNodeManagerHost(), (int)amInfo.getNodeManagerPort());
            ((Hamlet.TR)((Hamlet.TR)table.tr().td(String.valueOf(amInfo.getAppAttemptId().getAttemptId())).td(new Date(amInfo.getStartTime()).toString()).td().a(".nodelink", this.url(new String[]{"http://", nodeHttpAddress}), nodeHttpAddress)._()).td().a(".logslink", this.url(new String[]{"logs", nodeId.toString(), amInfo.getContainerId().toString(), jid, job.getUserName()}), "logs")._())._();
        }
        table._();
        div._();
        ((Hamlet.DIV)((Hamlet.TABLE)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.DIV)((Hamlet.TABLE)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.TR)((Hamlet.TABLE)html.div(".info-wrap.ui-widget-content.ui-corner-bottom").table("#job").tr().th(".ui-state-default", "Task Type").th(".ui-state-default", "Total").th(".ui-state-default", "Complete")._()).tr(".odd").th().a(this.url(new String[]{"tasks", jid, "m"}), "Map")._()).td(String.valueOf(mapTasks)).td(String.valueOf(mapTasksComplete))._()).tr(".even").th().a(this.url(new String[]{"tasks", jid, "r"}), "Reduce")._()).td(String.valueOf(reduceTasks)).td(String.valueOf(reducesTasksComplete))._())._()).table("#job").tr().th(".ui-state-default", "Attempt Type").th(".ui-state-default", "Failed").th(".ui-state-default", "Killed").th(".ui-state-default", "Successful")._()).tr(".odd").th("Maps").td().a(this.url(new String[]{"attempts", jid, "m", MRApps.TaskAttemptStateUI.FAILED.toString()}), String.valueOf(this.failedMapAttempts))._()).td().a(this.url(new String[]{"attempts", jid, "m", MRApps.TaskAttemptStateUI.KILLED.toString()}), String.valueOf(this.killedMapAttempts))._()).td().a(this.url(new String[]{"attempts", jid, "m", MRApps.TaskAttemptStateUI.SUCCESSFUL.toString()}), String.valueOf(this.successfulMapAttempts))._())._()).tr(".even").th("Reduces").td().a(this.url(new String[]{"attempts", jid, "r", MRApps.TaskAttemptStateUI.FAILED.toString()}), String.valueOf(this.failedReduceAttempts))._()).td().a(this.url(new String[]{"attempts", jid, "r", MRApps.TaskAttemptStateUI.KILLED.toString()}), String.valueOf(this.killedReduceAttempts))._()).td().a(this.url(new String[]{"attempts", jid, "r", MRApps.TaskAttemptStateUI.SUCCESSFUL.toString()}), String.valueOf(this.successfulReduceAttempts))._())._())._())._();
    }

    private void countTasksAndAttempts(Job job) {
        this.numReduces = 0;
        this.numMaps = 0;
        Map tasks = job.getTasks();
        for (Task task : tasks.values()) {
            Map attempts = task.getAttempts();
            for (TaskAttempt attempt : attempts.values()) {
                int successful = 0;
                int failed = 0;
                int killed = 0;
                if (!MRApps.TaskAttemptStateUI.NEW.correspondsTo(attempt.getState()) && !MRApps.TaskAttemptStateUI.RUNNING.correspondsTo(attempt.getState())) {
                    if (MRApps.TaskAttemptStateUI.SUCCESSFUL.correspondsTo(attempt.getState())) {
                        ++successful;
                    } else if (MRApps.TaskAttemptStateUI.FAILED.correspondsTo(attempt.getState())) {
                        ++failed;
                    } else if (MRApps.TaskAttemptStateUI.KILLED.correspondsTo(attempt.getState())) {
                        ++killed;
                    }
                }
                switch (task.getType()) {
                    case MAP: {
                        this.successfulMapAttempts += successful;
                        this.failedMapAttempts += failed;
                        this.killedMapAttempts += killed;
                        if (attempt.getState() != TaskAttemptState.SUCCEEDED) break;
                        ++this.numMaps;
                        this.avgMapTime += attempt.getFinishTime() - attempt.getLaunchTime();
                        break;
                    }
                    case REDUCE: {
                        this.successfulReduceAttempts += successful;
                        this.failedReduceAttempts += failed;
                        this.killedReduceAttempts += killed;
                        if (attempt.getState() != TaskAttemptState.SUCCEEDED) break;
                        ++this.numReduces;
                        this.avgShuffleTime += attempt.getShuffleFinishTime() - attempt.getLaunchTime();
                        this.avgSortTime += attempt.getSortFinishTime() - attempt.getLaunchTime();
                        this.avgReduceTime += attempt.getFinishTime() - attempt.getShuffleFinishTime();
                    }
                }
            }
        }
        if (this.numMaps > 0) {
            this.avgMapTime /= (long)this.numMaps;
        }
        if (this.numReduces > 0) {
            this.avgReduceTime /= (long)this.numReduces;
            this.avgShuffleTime /= (long)this.numReduces;
            this.avgSortTime /= (long)this.numReduces;
        }
    }
}

