/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.JobACLsManager;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.JobSummary;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.hs.CompletedJob;
import org.apache.hadoop.mapreduce.v2.hs.HistoryContext;
import org.apache.hadoop.mapreduce.v2.hs.PartialJob;
import org.apache.hadoop.mapreduce.v2.jobhistory.FileNameIndexUtils;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobIndexInfo;
import org.apache.hadoop.yarn.Clock;
import org.apache.hadoop.yarn.ClusterInfo;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.service.AbstractService;

public class JobHistory
extends AbstractService
implements HistoryContext {
    private static final int DEFAULT_JOBLIST_CACHE_SIZE = 20000;
    private static final int DEFAULT_LOADEDJOB_CACHE_SIZE = 5;
    private static final int DEFAULT_DATESTRING_CACHE_SIZE = 200000;
    private static final long DEFAULT_MOVE_THREAD_INTERVAL = 180000L;
    private static final int DEFAULT_MOVE_THREAD_COUNT = 3;
    static final long DEFAULT_HISTORY_MAX_AGE = 604800000L;
    static final long DEFAULT_RUN_INTERVAL = 86400000L;
    private static final Log LOG = LogFactory.getLog(JobHistory.class);
    private static final Log SUMMARY_LOG = LogFactory.getLog(JobSummary.class);
    public static final Pattern CONF_FILENAME_REGEX = Pattern.compile("(job_[0-9]+_[0-9]+)_conf.xml(?:\\.[0-9]+\\.old)?");
    public static final String OLD_SUFFIX = ".old";
    private static String DONE_BEFORE_SERIAL_TAIL = JobHistoryUtils.doneSubdirsBeforeSerialTail();
    private final SortedMap<String, Set<String>> idToDateString = new ConcurrentSkipListMap<String, Set<String>>();
    private final SortedMap<JobId, MetaInfo> jobListCache = new ConcurrentSkipListMap<JobId, MetaInfo>();
    private final SortedMap<JobId, MetaInfo> intermediateListCache = new ConcurrentSkipListMap<JobId, MetaInfo>();
    private final Set<Path> existingDoneSubdirs = new HashSet<Path>();
    private Map<JobId, Job> loadedJobCache = null;
    private Map<String, Long> userDirModificationTimeMap = new HashMap<String, Long>();
    private int jobListCacheSize;
    private JobACLsManager aclsMgr;
    private int loadedJobCacheSize;
    private int dateStringCacheSize;
    private long moveThreadInterval;
    private int numMoveThreads;
    private Configuration conf;
    private boolean debugMode;
    private int serialNumberLowDigits;
    private String serialNumberFormat;
    private Path doneDirPrefixPath = null;
    private FileContext doneDirFc;
    private Path intermediateDoneDirPath = null;
    private FileContext intermediateDoneDirFc;
    private Thread moveIntermediateToDoneThread = null;
    private MoveIntermediateToDoneRunnable moveIntermediateToDoneRunnable = null;
    private ScheduledThreadPoolExecutor cleanerScheduledExecutor = null;
    private ApplicationAttemptId appAttemptID;
    private ApplicationId appID;
    private String userName;

    public void init(Configuration conf) throws YarnException {
        LOG.info((Object)"JobHistory Init");
        this.conf = conf;
        this.appID = (ApplicationId)RecordFactoryProvider.getRecordFactory((Configuration)conf).newRecordInstance(ApplicationId.class);
        this.appAttemptID = (ApplicationAttemptId)RecordFactoryProvider.getRecordFactory((Configuration)conf).newRecordInstance(ApplicationAttemptId.class);
        this.debugMode = conf.getBoolean("mapreduce.jobhistory.debug-mode", false);
        this.serialNumberLowDigits = this.debugMode ? 1 : 3;
        this.serialNumberFormat = "%0" + (6 + this.serialNumberLowDigits) + "d";
        String doneDirPrefix = null;
        doneDirPrefix = JobHistoryUtils.getConfiguredHistoryServerDoneDirPrefix((Configuration)conf);
        try {
            this.doneDirPrefixPath = FileContext.getFileContext((Configuration)conf).makeQualified(new Path(doneDirPrefix));
            this.doneDirFc = FileContext.getFileContext((URI)this.doneDirPrefixPath.toUri(), (Configuration)conf);
            this.mkdir(this.doneDirFc, this.doneDirPrefixPath, new FsPermission(JobHistoryUtils.HISTORY_DONE_DIR_PERMISSION));
        }
        catch (IOException e) {
            throw new YarnException("Error creating done directory: [" + this.doneDirPrefixPath + "]", (Throwable)e);
        }
        String intermediateDoneDirPrefix = null;
        intermediateDoneDirPrefix = JobHistoryUtils.getConfiguredHistoryIntermediateDoneDirPrefix((Configuration)conf);
        try {
            this.intermediateDoneDirPath = FileContext.getFileContext((Configuration)conf).makeQualified(new Path(intermediateDoneDirPrefix));
            this.intermediateDoneDirFc = FileContext.getFileContext((URI)this.intermediateDoneDirPath.toUri(), (Configuration)conf);
            this.mkdir(this.intermediateDoneDirFc, this.intermediateDoneDirPath, new FsPermission(JobHistoryUtils.HISTORY_INTERMEDIATE_DONE_DIR_PERMISSIONS.toShort()));
        }
        catch (IOException e) {
            LOG.info((Object)("error creating done directory on dfs " + e));
            throw new YarnException("Error creating intermediate done directory: [" + this.intermediateDoneDirPath + "]", (Throwable)e);
        }
        this.aclsMgr = new JobACLsManager(conf);
        this.jobListCacheSize = conf.getInt("mapreduce.jobhistory.joblist.cache.size", 20000);
        this.loadedJobCacheSize = conf.getInt("mapreduce.jobhistory.loadedjobs.cache.size", 5);
        this.dateStringCacheSize = conf.getInt("mapreduce.jobhistory.datestring.cache.size", 200000);
        this.moveThreadInterval = conf.getLong("mapreduce.jobhistory.move.interval-ms", 180000L);
        this.numMoveThreads = conf.getInt("mapreduce.jobhistory.move.thread-count", 3);
        this.loadedJobCache = Collections.synchronizedMap(new LinkedHashMap<JobId, Job>(this.loadedJobCacheSize + 1, 0.75f, true){

            @Override
            public boolean removeEldestEntry(Map.Entry<JobId, Job> eldest) {
                return super.size() > JobHistory.this.loadedJobCacheSize;
            }
        });
        try {
            this.initExisting();
        }
        catch (IOException e) {
            throw new YarnException("Failed to intialize existing directories", (Throwable)e);
        }
        super.init(conf);
    }

    private void mkdir(FileContext fc, Path path, FsPermission fsp) throws IOException {
        if (!fc.util().exists(path)) {
            try {
                fc.mkdir(path, fsp, true);
                FileStatus fsStatus = fc.getFileStatus(path);
                LOG.info((Object)("Perms after creating " + fsStatus.getPermission().toShort() + ", Expected: " + fsp.toShort()));
                if (fsStatus.getPermission().toShort() != fsp.toShort()) {
                    LOG.info((Object)("Explicitly setting permissions to : " + fsp.toShort() + ", " + fsp));
                    fc.setPermission(path, fsp);
                }
            }
            catch (FileAlreadyExistsException e) {
                LOG.info((Object)("Directory: [" + path + "] already exists."));
            }
        }
    }

    public void start() {
        this.moveIntermediateToDoneRunnable = new MoveIntermediateToDoneRunnable(this.moveThreadInterval, this.numMoveThreads);
        this.moveIntermediateToDoneThread = new Thread(this.moveIntermediateToDoneRunnable);
        this.moveIntermediateToDoneThread.setName("MoveIntermediateToDoneScanner");
        this.moveIntermediateToDoneThread.start();
        boolean startCleanerService = this.conf.getBoolean("mapreduce.jobhistory.cleaner.enable", true);
        if (startCleanerService) {
            long maxAgeOfHistoryFiles = this.conf.getLong("mapreduce.jobhistory.max-age-ms", 604800000L);
            this.cleanerScheduledExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("LogCleaner").build());
            long runInterval = this.conf.getLong("mapreduce.jobhistory.cleaner.interval-ms", 86400000L);
            this.cleanerScheduledExecutor.scheduleAtFixedRate(new HistoryCleaner(maxAgeOfHistoryFiles), 30000L, runInterval, TimeUnit.MILLISECONDS);
        }
        super.start();
    }

    public void stop() {
        LOG.info((Object)"Stopping JobHistory");
        if (this.moveIntermediateToDoneThread != null) {
            LOG.info((Object)"Stopping move thread");
            this.moveIntermediateToDoneRunnable.stop();
            this.moveIntermediateToDoneThread.interrupt();
            try {
                LOG.info((Object)"Joining on move thread");
                this.moveIntermediateToDoneThread.join();
            }
            catch (InterruptedException e) {
                LOG.info((Object)"Interrupted while stopping move thread");
            }
        }
        if (this.cleanerScheduledExecutor != null) {
            LOG.info((Object)"Stopping History Cleaner");
            this.cleanerScheduledExecutor.shutdown();
            boolean interrupted = false;
            long currentTime = System.currentTimeMillis();
            while (!this.cleanerScheduledExecutor.isShutdown() && System.currentTimeMillis() > currentTime + 1000L && !interrupted) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (!this.cleanerScheduledExecutor.isShutdown()) {
                LOG.warn((Object)"HistoryCleanerService shutdown may not have succeeded");
            }
        }
        super.stop();
    }

    public JobHistory() {
        super(JobHistory.class.getName());
    }

    private void initExisting() throws IOException {
        LOG.info((Object)"Initializing Existing Jobs...");
        List<FileStatus> timestampedDirList = this.findTimestampedDirectories();
        Collections.sort(timestampedDirList);
        for (FileStatus fs : timestampedDirList) {
            this.addDirectoryToSerialNumberIndex(fs.getPath());
            this.addDirectoryToJobListCache(fs.getPath());
        }
    }

    private void removeDirectoryFromSerialNumberIndex(Path serialDirPath) {
        String serialPart = serialDirPath.getName();
        String timeStampPart = JobHistoryUtils.getTimestampPartFromPath((String)serialDirPath.toString());
        if (timeStampPart == null) {
            LOG.warn((Object)("Could not find timestamp portion from path: " + serialDirPath.toString() + ". Continuing with next"));
            return;
        }
        if (serialPart == null) {
            LOG.warn((Object)("Could not find serial portion from path: " + serialDirPath.toString() + ". Continuing with next"));
            return;
        }
        if (this.idToDateString.containsKey(serialPart)) {
            Set set = (Set)this.idToDateString.get(serialPart);
            set.remove(timeStampPart);
            if (set.isEmpty()) {
                this.idToDateString.remove(serialPart);
            }
        }
    }

    private void addDirectoryToSerialNumberIndex(Path serialDirPath) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding " + serialDirPath + " to serial index"));
        }
        String serialPart = serialDirPath.getName();
        String timestampPart = JobHistoryUtils.getTimestampPartFromPath((String)serialDirPath.toString());
        if (timestampPart == null) {
            LOG.warn((Object)("Could not find timestamp portion from path: " + serialDirPath.toString() + ". Continuing with next"));
            return;
        }
        if (serialPart == null) {
            LOG.warn((Object)("Could not find serial portion from path: " + serialDirPath.toString() + ". Continuing with next"));
        }
        this.addToSerialNumberIndex(serialPart, timestampPart);
    }

    private void addToSerialNumberIndex(String serialPart, String timestampPart) {
        if (!this.idToDateString.containsKey(serialPart)) {
            this.idToDateString.put(serialPart, new HashSet());
            if (this.idToDateString.size() > this.dateStringCacheSize) {
                this.idToDateString.remove(this.idToDateString.firstKey());
            }
            Set datePartSet = (Set)this.idToDateString.get(serialPart);
            datePartSet.add(timestampPart);
        }
    }

    private void addDirectoryToJobListCache(Path path) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding " + path + " to job list cache."));
        }
        List<FileStatus> historyFileList = JobHistory.scanDirectoryForHistoryFiles(path, this.doneDirFc);
        for (FileStatus fs : historyFileList) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding in history for " + fs.getPath()));
            }
            JobIndexInfo jobIndexInfo = FileNameIndexUtils.getIndexInfo((String)fs.getPath().getName());
            String confFileName = JobHistoryUtils.getIntermediateConfFileName((JobId)jobIndexInfo.getJobId());
            String summaryFileName = JobHistoryUtils.getIntermediateSummaryFileName((JobId)jobIndexInfo.getJobId());
            MetaInfo metaInfo = new MetaInfo(fs.getPath(), new Path(fs.getPath().getParent(), confFileName), new Path(fs.getPath().getParent(), summaryFileName), jobIndexInfo);
            this.addToJobListCache(jobIndexInfo.getJobId(), metaInfo);
        }
    }

    private static List<FileStatus> scanDirectory(Path path, FileContext fc, PathFilter pathFilter) throws IOException {
        path = fc.makeQualified(path);
        ArrayList<FileStatus> jhStatusList = new ArrayList<FileStatus>();
        RemoteIterator fileStatusIter = fc.listStatus(path);
        while (fileStatusIter.hasNext()) {
            FileStatus fileStatus = (FileStatus)fileStatusIter.next();
            Path filePath = fileStatus.getPath();
            if (!fileStatus.isFile() || !pathFilter.accept(filePath)) continue;
            jhStatusList.add(fileStatus);
        }
        return jhStatusList;
    }

    private static List<FileStatus> scanDirectoryForHistoryFiles(Path path, FileContext fc) throws IOException {
        return JobHistory.scanDirectory(path, fc, JobHistoryUtils.getHistoryFileFilter());
    }

    private List<FileStatus> findTimestampedDirectories() throws IOException {
        List fsList = JobHistoryUtils.localGlobber((FileContext)this.doneDirFc, (Path)this.doneDirPrefixPath, (String)DONE_BEFORE_SERIAL_TAIL);
        return fsList;
    }

    private void addToJobListCache(JobId jobId, MetaInfo metaInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding " + jobId + " to job list cache with " + metaInfo.getJobIndexInfo()));
        }
        this.jobListCache.put(jobId, metaInfo);
        if (this.jobListCache.size() > this.jobListCacheSize) {
            this.jobListCache.remove(this.jobListCache.firstKey());
        }
    }

    private void addToLoadedJobCache(Job job) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding " + job.getID() + " to loaded job cache"));
        }
        this.loadedJobCache.put(job.getID(), job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanIntermediateDirectory() throws IOException {
        List userDirList = JobHistoryUtils.localGlobber((FileContext)this.intermediateDoneDirFc, (Path)this.intermediateDoneDirPath, (String)"");
        for (FileStatus userDir : userDirList) {
            String name = userDir.getPath().getName();
            long newModificationTime = userDir.getModificationTime();
            boolean shouldScan = false;
            Map<String, Long> map = this.userDirModificationTimeMap;
            synchronized (map) {
                if (!this.userDirModificationTimeMap.containsKey(name) || newModificationTime > this.userDirModificationTimeMap.get(name)) {
                    shouldScan = true;
                    this.userDirModificationTimeMap.put(name, newModificationTime);
                }
            }
            if (!shouldScan) continue;
            this.scanIntermediateDirectory(userDir.getPath());
        }
    }

    private void scanIntermediateDirectory(Path absPath) throws IOException {
        List<FileStatus> fileStatusList = JobHistory.scanDirectoryForHistoryFiles(absPath, this.intermediateDoneDirFc);
        for (FileStatus fs : fileStatusList) {
            JobIndexInfo jobIndexInfo = FileNameIndexUtils.getIndexInfo((String)fs.getPath().getName());
            String confFileName = JobHistoryUtils.getIntermediateConfFileName((JobId)jobIndexInfo.getJobId());
            String summaryFileName = JobHistoryUtils.getIntermediateSummaryFileName((JobId)jobIndexInfo.getJobId());
            MetaInfo metaInfo = new MetaInfo(fs.getPath(), new Path(fs.getPath().getParent(), confFileName), new Path(fs.getPath().getParent(), summaryFileName), jobIndexInfo);
            if (this.intermediateListCache.containsKey(jobIndexInfo.getJobId())) continue;
            this.intermediateListCache.put(jobIndexInfo.getJobId(), metaInfo);
        }
    }

    private MetaInfo getJobMetaInfo(List<FileStatus> fileStatusList, JobId jobId) throws IOException {
        for (FileStatus fs : fileStatusList) {
            JobIndexInfo jobIndexInfo = FileNameIndexUtils.getIndexInfo((String)fs.getPath().getName());
            if (!jobIndexInfo.getJobId().equals((Object)jobId)) continue;
            String confFileName = JobHistoryUtils.getIntermediateConfFileName((JobId)jobIndexInfo.getJobId());
            String summaryFileName = JobHistoryUtils.getIntermediateSummaryFileName((JobId)jobIndexInfo.getJobId());
            MetaInfo metaInfo = new MetaInfo(fs.getPath(), new Path(fs.getPath().getParent(), confFileName), new Path(fs.getPath().getParent(), summaryFileName), jobIndexInfo);
            return metaInfo;
        }
        return null;
    }

    private MetaInfo scanOldDirsForJob(JobId jobId) throws IOException {
        int jobSerialNumber = JobHistoryUtils.jobSerialNumber((JobId)jobId);
        String boxedSerialNumber = String.valueOf(jobSerialNumber);
        Set dateStringSet = (Set)this.idToDateString.get(boxedSerialNumber);
        if (dateStringSet == null) {
            return null;
        }
        for (String timestampPart : dateStringSet) {
            Path logDir = this.canonicalHistoryLogPath(jobId, timestampPart);
            List<FileStatus> fileStatusList = JobHistory.scanDirectoryForHistoryFiles(logDir, this.doneDirFc);
            MetaInfo metaInfo = this.getJobMetaInfo(fileStatusList, jobId);
            if (metaInfo == null) continue;
            return metaInfo;
        }
        return null;
    }

    private MetaInfo scanIntermediateForJob(JobId jobId) throws IOException {
        this.scanIntermediateDirectory();
        return (MetaInfo)this.intermediateListCache.get(jobId);
    }

    public String getApplicationName() {
        return "Job History Server";
    }

    private Job loadJob(MetaInfo metaInfo) {
        MetaInfo metaInfo2 = metaInfo;
        synchronized (metaInfo2) {
            try {
                CompletedJob job = new CompletedJob(this.conf, metaInfo.getJobIndexInfo().getJobId(), metaInfo.getHistoryFile(), false, metaInfo.getJobIndexInfo().getUser(), metaInfo.getConfFile(), this.aclsMgr);
                this.addToLoadedJobCache(job);
                return job;
            }
            catch (IOException e) {
                throw new YarnException("Could not find/load job: " + metaInfo.getJobIndexInfo().getJobId(), (Throwable)e);
            }
        }
    }

    private Map<JobId, Job> getAllJobsInternal() {
        MetaInfo mi;
        TreeMap<JobId, Job> result = new TreeMap<JobId, Job>();
        try {
            this.scanIntermediateDirectory();
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to scan intermediate directory", (Throwable)e);
            throw new YarnException((Throwable)e);
        }
        for (JobId jobId : this.intermediateListCache.keySet()) {
            mi = (MetaInfo)this.intermediateListCache.get(jobId);
            if (mi == null) continue;
            result.put(jobId, new PartialJob(mi.getJobIndexInfo(), mi.getJobIndexInfo().getJobId()));
        }
        for (JobId jobId : this.jobListCache.keySet()) {
            mi = (MetaInfo)this.jobListCache.get(jobId);
            if (mi == null) continue;
            result.put(jobId, new PartialJob(mi.getJobIndexInfo(), mi.getJobIndexInfo().getJobId()));
        }
        return result;
    }

    MetaInfo getJobMetaInfo(JobId jobId) throws IOException {
        MetaInfo metaInfo = null;
        if (this.jobListCache.containsKey(jobId)) {
            metaInfo = (MetaInfo)this.jobListCache.get(jobId);
        }
        if (metaInfo != null) {
            return metaInfo;
        }
        metaInfo = this.scanIntermediateForJob(jobId);
        if (metaInfo != null) {
            return metaInfo;
        }
        metaInfo = this.scanOldDirsForJob(jobId);
        if (metaInfo != null) {
            return metaInfo;
        }
        return null;
    }

    private Job findJob(JobId jobId) throws IOException {
        if (this.loadedJobCache.containsKey(jobId)) {
            return this.loadedJobCache.get(jobId);
        }
        MetaInfo metaInfo = null;
        if (this.jobListCache.containsKey(jobId)) {
            metaInfo = (MetaInfo)this.jobListCache.get(jobId);
        }
        if (metaInfo != null) {
            return this.loadJob(metaInfo);
        }
        metaInfo = this.scanIntermediateForJob(jobId);
        if (metaInfo != null) {
            return this.loadJob(metaInfo);
        }
        metaInfo = this.scanOldDirsForJob(jobId);
        if (metaInfo != null) {
            return this.loadJob(metaInfo);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveToDone(MetaInfo metaInfo) throws IOException {
        long completeTime = metaInfo.getJobIndexInfo().getFinishTime();
        if (completeTime == 0L) {
            completeTime = System.currentTimeMillis();
        }
        JobId jobId = metaInfo.getJobIndexInfo().getJobId();
        ArrayList<Path> paths = new ArrayList<Path>();
        Path historyFile = metaInfo.getHistoryFile();
        if (historyFile == null) {
            LOG.info((Object)("No file for job-history with " + jobId + " found in cache!"));
        } else {
            paths.add(historyFile);
        }
        Path confFile = metaInfo.getConfFile();
        if (confFile == null) {
            LOG.info((Object)("No file for jobConf with " + jobId + " found in cache!"));
        } else {
            paths.add(confFile);
        }
        Path summaryFile = metaInfo.getSummaryFile();
        if (summaryFile == null) {
            LOG.info((Object)("No summary file for job: " + jobId));
        } else {
            try {
                String jobSummaryString = this.getJobSummary(this.intermediateDoneDirFc, summaryFile);
                SUMMARY_LOG.info((Object)jobSummaryString);
                LOG.info((Object)("Deleting JobSummary file: [" + summaryFile + "]"));
                this.intermediateDoneDirFc.delete(summaryFile, false);
                metaInfo.setSummaryFile(null);
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed to process summary file: [" + summaryFile + "]"));
                throw e;
            }
        }
        Path targetDir = this.canonicalHistoryLogPath(jobId, completeTime);
        this.addDirectoryToSerialNumberIndex(targetDir);
        try {
            this.maybeMakeSubdirectory(targetDir);
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed creating subdirectory: " + targetDir + " while attempting to move files for jobId: " + jobId));
            throw e;
        }
        MetaInfo metaInfo2 = metaInfo;
        synchronized (metaInfo2) {
            Path toPath;
            if (historyFile != null) {
                toPath = this.doneDirFc.makeQualified(new Path(targetDir, historyFile.getName()));
                try {
                    this.moveToDoneNow(historyFile, toPath);
                }
                catch (IOException e) {
                    LOG.warn((Object)("Failed to move file: " + historyFile + " for jobId: " + jobId));
                    throw e;
                }
                metaInfo.setHistoryFile(toPath);
            }
            if (confFile != null) {
                toPath = this.doneDirFc.makeQualified(new Path(targetDir, confFile.getName()));
                try {
                    this.moveToDoneNow(confFile, toPath);
                }
                catch (IOException e) {
                    LOG.warn((Object)("Failed to move file: " + historyFile + " for jobId: " + jobId));
                    throw e;
                }
                metaInfo.setConfFile(toPath);
            }
        }
        this.addToJobListCache(jobId, metaInfo);
        this.intermediateListCache.remove(jobId);
    }

    private void moveToDoneNow(Path src, Path target) throws IOException {
        LOG.info((Object)("Moving " + src.toString() + " to " + target.toString()));
        this.intermediateDoneDirFc.rename(src, target, new Options.Rename[]{Options.Rename.NONE});
    }

    String getJobSummary(FileContext fc, Path path) throws IOException {
        Path qPath = fc.makeQualified(path);
        FSDataInputStream in = fc.open(qPath);
        String jobSummaryString = in.readUTF();
        in.close();
        return jobSummaryString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeMakeSubdirectory(Path path) throws IOException {
        boolean existsInExistingCache = false;
        Set<Path> set = this.existingDoneSubdirs;
        synchronized (set) {
            if (this.existingDoneSubdirs.contains(path)) {
                existsInExistingCache = true;
            }
        }
        try {
            this.doneDirFc.getFileStatus(path);
            if (!existsInExistingCache) {
                this.existingDoneSubdirs.add(path);
                if (this.debugMode) {
                    LOG.info((Object)("JobHistory.maybeMakeSubdirectory -- We believed " + path + " already existed, but it didn't."));
                }
            }
        }
        catch (FileNotFoundException fnfE) {
            try {
                FsPermission fsp = new FsPermission(JobHistoryUtils.HISTORY_DONE_DIR_PERMISSION);
                this.doneDirFc.mkdir(path, fsp, true);
                FileStatus fsStatus = this.doneDirFc.getFileStatus(path);
                LOG.info((Object)("Perms after creating " + fsStatus.getPermission().toShort() + ", Expected: " + fsp.toShort()));
                if (fsStatus.getPermission().toShort() != fsp.toShort()) {
                    LOG.info((Object)("Explicitly setting permissions to : " + fsp.toShort() + ", " + fsp));
                    this.doneDirFc.setPermission(path, fsp);
                }
                Set<Path> set2 = this.existingDoneSubdirs;
                synchronized (set2) {
                    this.existingDoneSubdirs.add(path);
                }
            }
            catch (FileAlreadyExistsException faeE) {
                // empty catch block
            }
        }
    }

    private Path canonicalHistoryLogPath(JobId id, String timestampComponent) {
        return new Path(this.doneDirPrefixPath, JobHistoryUtils.historyLogSubdirectory((JobId)id, (String)timestampComponent, (String)this.serialNumberFormat));
    }

    private Path canonicalHistoryLogPath(JobId id, long millisecondTime) {
        String timestampComponent = JobHistoryUtils.timestampDirectoryComponent((long)millisecondTime, (boolean)this.debugMode);
        return new Path(this.doneDirPrefixPath, JobHistoryUtils.historyLogSubdirectory((JobId)id, (String)timestampComponent, (String)this.serialNumberFormat));
    }

    public synchronized Job getJob(JobId jobId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Looking for Job " + jobId));
        }
        Job job = null;
        try {
            job = this.findJob(jobId);
        }
        catch (IOException e) {
            throw new YarnException((Throwable)e);
        }
        return job;
    }

    @Override
    public Map<JobId, Job> getAllJobs(ApplicationId appID) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Called getAllJobs(AppId): " + appID));
        }
        JobID oldJobID = TypeConverter.fromYarn((ApplicationId)appID);
        HashMap<JobId, Job> jobs = new HashMap<JobId, Job>();
        JobId jobID = TypeConverter.toYarn((JobID)oldJobID);
        jobs.put(jobID, this.getJob(jobID));
        return jobs;
    }

    public Map<JobId, Job> getAllJobs() {
        LOG.debug((Object)"Called getAllJobs()");
        return this.getAllJobsInternal();
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.appAttemptID;
    }

    public ApplicationId getApplicationID() {
        return this.appID;
    }

    public EventHandler getEventHandler() {
        return null;
    }

    public CharSequence getUser() {
        if (this.userName != null) {
            this.userName = this.conf.get("mapreduce.job.user.name", "history-user");
        }
        return this.userName;
    }

    public Clock getClock() {
        return null;
    }

    public ClusterInfo getClusterInfo() {
        return null;
    }

    public class HistoryCleaner
    implements Runnable {
        private long currentTime;
        long maxAgeMillis;
        long filesDeleted = 0L;
        long dirsDeleted = 0L;

        public HistoryCleaner(long maxAge) {
            this.maxAgeMillis = maxAge;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            LOG.info((Object)"History Cleaner started");
            this.currentTime = System.currentTimeMillis();
            boolean halted = false;
            try {
                List serialDirList = JobHistory.this.findTimestampedDirectories();
                Collections.sort(serialDirList);
                for (FileStatus serialDir : serialDirList) {
                    List historyFileList = JobHistory.scanDirectoryForHistoryFiles(serialDir.getPath(), JobHistory.this.doneDirFc);
                    for (FileStatus historyFile : historyFileList) {
                        JobIndexInfo jobIndexInfo = FileNameIndexUtils.getIndexInfo((String)historyFile.getPath().getName());
                        long effectiveTimestamp = this.getEffectiveTimestamp(jobIndexInfo.getFinishTime(), historyFile);
                        if (this.shouldDelete(effectiveTimestamp)) {
                            String confFileName = JobHistoryUtils.getIntermediateConfFileName((JobId)jobIndexInfo.getJobId());
                            MetaInfo metaInfo = new MetaInfo(historyFile.getPath(), new Path(historyFile.getPath().getParent(), confFileName), null, jobIndexInfo);
                            this.delete(metaInfo);
                            continue;
                        }
                        halted = true;
                        break;
                    }
                    if (!halted) {
                        this.deleteDir(serialDir.getPath());
                        JobHistory.this.removeDirectoryFromSerialNumberIndex(serialDir.getPath());
                        Set set = JobHistory.this.existingDoneSubdirs;
                        synchronized (set) {
                            JobHistory.this.existingDoneSubdirs.remove(serialDir.getPath());
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Error in History cleaner run", (Throwable)e);
            }
            LOG.info((Object)"History Cleaner complete");
            LOG.info((Object)("FilesDeleted: " + this.filesDeleted));
            LOG.info((Object)("Directories Deleted: " + this.dirsDeleted));
        }

        private boolean shouldDelete(long ts) {
            return ts + this.maxAgeMillis <= this.currentTime;
        }

        private long getEffectiveTimestamp(long finishTime, FileStatus fileStatus) {
            if (finishTime == 0L) {
                return fileStatus.getModificationTime();
            }
            return finishTime;
        }

        private void delete(MetaInfo metaInfo) throws IOException {
            this.deleteFile(metaInfo.getHistoryFile());
            this.deleteFile(metaInfo.getConfFile());
            JobHistory.this.jobListCache.remove(metaInfo.getJobIndexInfo().getJobId());
            JobHistory.this.loadedJobCache.remove(metaInfo.getJobIndexInfo().getJobId());
        }

        private void deleteFile(Path path) throws IOException {
            JobHistory.this.doneDirFc.delete(JobHistory.this.doneDirFc.makeQualified(path), false);
            ++this.filesDeleted;
        }

        private void deleteDir(Path path) throws IOException {
            JobHistory.this.doneDirFc.delete(JobHistory.this.doneDirFc.makeQualified(path), true);
            ++this.dirsDeleted;
        }
    }

    static class MetaInfo {
        private Path historyFile;
        private Path confFile;
        private Path summaryFile;
        JobIndexInfo jobIndexInfo;

        MetaInfo(Path historyFile, Path confFile, Path summaryFile, JobIndexInfo jobIndexInfo) {
            this.historyFile = historyFile;
            this.confFile = confFile;
            this.summaryFile = summaryFile;
            this.jobIndexInfo = jobIndexInfo;
        }

        Path getHistoryFile() {
            return this.historyFile;
        }

        Path getConfFile() {
            return this.confFile;
        }

        Path getSummaryFile() {
            return this.summaryFile;
        }

        JobIndexInfo getJobIndexInfo() {
            return this.jobIndexInfo;
        }

        void setHistoryFile(Path historyFile) {
            this.historyFile = historyFile;
        }

        void setConfFile(Path confFile) {
            this.confFile = confFile;
        }

        void setSummaryFile(Path summaryFile) {
            this.summaryFile = summaryFile;
        }
    }

    private class MoveIntermediateToDoneRunnable
    implements Runnable {
        private long sleepTime;
        private ThreadPoolExecutor moveToDoneExecutor = null;
        private boolean running = false;

        public void stop() {
            this.running = false;
        }

        MoveIntermediateToDoneRunnable(long sleepTime, int numMoveThreads) {
            this.sleepTime = sleepTime;
            ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("MoveIntermediateToDone Thread #%d").build();
            this.moveToDoneExecutor = new ThreadPoolExecutor(1, numMoveThreads, 1L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>(), tf);
            this.running = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Thread.currentThread().setName("IntermediateHistoryScanner");
            try {
                while (this.running) {
                    LOG.info((Object)"Starting scan to move intermediate done files");
                    JobHistory.this.scanIntermediateDirectory();
                    for (final MetaInfo metaInfo : JobHistory.this.intermediateListCache.values()) {
                        this.moveToDoneExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    JobHistory.this.moveToDone(metaInfo);
                                }
                                catch (IOException e) {
                                    LOG.info((Object)("Failed to process metaInfo for job: " + metaInfo.jobIndexInfo.getJobId()), (Throwable)e);
                                }
                            }
                        });
                    }
                    MoveIntermediateToDoneRunnable i$ = this;
                    synchronized (i$) {
                        try {
                            this.wait(this.sleepTime);
                        }
                        catch (InterruptedException e) {
                            LOG.info((Object)"IntermediateHistoryScannerThread interrupted");
                        }
                    }
                }
                return;
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to get a list of intermediate files to be moved from: " + JobHistory.this.intermediateDoneDirPath));
            }
        }
    }
}

