/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import com.google.inject.Inject;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.ConfEntryInfo;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.AMAttemptInfo;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.JobInfo;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.ResponseInfo;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class HsJobBlock
extends HtmlBlock {
    final AppContext appContext;

    @Inject
    HsJobBlock(AppContext appctx) {
        this.appContext = appctx;
    }

    protected void render(HtmlBlock.Block html) {
        String jid = this.$("job.id");
        if (jid.isEmpty()) {
            html.p()._(new Object[]{"Sorry, can't do anything without a JobID."})._();
            return;
        }
        JobId jobID = MRApps.toJobID((String)jid);
        Job j = this.appContext.getJob(jobID);
        if (j == null) {
            html.p()._(new Object[]{"Sorry, ", jid, " not found."})._();
            return;
        }
        List amInfos = j.getAMInfos();
        JobInfo job = new JobInfo(j);
        ResponseInfo infoBlock = this.info("Job Overview")._("Job Name:", (Object)job.getName())._("User Name:", (Object)job.getUserName())._("Queue:", (Object)job.getQueueName())._("State:", (Object)job.getState())._("Uberized:", (Object)job.isUber())._("Started:", (Object)new Date(job.getStartTime()))._("Finished:", (Object)new Date(job.getFinishTime()))._("Elapsed:", (Object)StringUtils.formatTime((long)Times.elapsed((long)job.getStartTime(), (long)job.getFinishTime(), (boolean)false)));
        String amString = amInfos.size() == 1 ? "ApplicationMaster" : "ApplicationMasters";
        List diagnostics = j.getDiagnostics();
        if (diagnostics != null && !diagnostics.isEmpty()) {
            StringBuffer b = new StringBuffer();
            for (String diag : diagnostics) {
                b.append(diag);
            }
            infoBlock._("Diagnostics:", (Object)b.toString());
        }
        if (job.getNumMaps() > 0L) {
            infoBlock._("Average Map Time", (Object)StringUtils.formatTime((long)job.getAvgMapTime()));
        }
        if (job.getNumReduces() > 0L) {
            infoBlock._("Average Reduce Time", (Object)StringUtils.formatTime((long)job.getAvgReduceTime()));
            infoBlock._("Average Shuffle Time", (Object)StringUtils.formatTime((long)job.getAvgShuffleTime()));
            infoBlock._("Average Merge Time", (Object)StringUtils.formatTime((long)job.getAvgMergeTime()));
        }
        for (ConfEntryInfo entry : job.getAcls()) {
            infoBlock._("ACL " + entry.getName() + ":", (Object)entry.getValue());
        }
        Hamlet.DIV div = html._(InfoBlock.class).div(".info-wrap.ui-widget-content.ui-corner-bottom");
        Hamlet.TABLE table = div.table("#job");
        ((Hamlet.TABLE)table.tr().th(amString)._()).tr().th(".ui-state-default", "Attempt Number").th(".ui-state-default", "Start Time").th(".ui-state-default", "Node").th(".ui-state-default", "Logs")._();
        for (AMInfo amInfo : amInfos) {
            AMAttemptInfo attempt = new AMAttemptInfo(amInfo, job.getId(), job.getUserName(), "", "");
            ((Hamlet.TR)((Hamlet.TR)table.tr().td(String.valueOf(attempt.getAttemptId())).td(new Date(attempt.getStartTime()).toString()).td().a(".nodelink", this.url(new String[]{"http://", attempt.getNodeHttpAddress()}), attempt.getNodeHttpAddress())._()).td().a(".logslink", this.url(new String[]{attempt.getShortLogsLink()}), "logs")._())._();
        }
        table._();
        div._();
        ((Hamlet.DIV)((Hamlet.TABLE)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.DIV)((Hamlet.TABLE)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.TR)((Hamlet.TABLE)html.div(".info-wrap.ui-widget-content.ui-corner-bottom").table("#job").tr().th(".ui-state-default", "Task Type").th(".ui-state-default", "Total").th(".ui-state-default", "Complete")._()).tr(".odd").th().a(this.url(new String[]{"tasks", jid, "m"}), "Map")._()).td(String.valueOf(String.valueOf(job.getMapsTotal()))).td(String.valueOf(String.valueOf(job.getMapsCompleted())))._()).tr(".even").th().a(this.url(new String[]{"tasks", jid, "r"}), "Reduce")._()).td(String.valueOf(String.valueOf(job.getReducesTotal()))).td(String.valueOf(String.valueOf(job.getReducesCompleted())))._())._()).table("#job").tr().th(".ui-state-default", "Attempt Type").th(".ui-state-default", "Failed").th(".ui-state-default", "Killed").th(".ui-state-default", "Successful")._()).tr(".odd").th("Maps").td().a(this.url(new String[]{"attempts", jid, "m", MRApps.TaskAttemptStateUI.FAILED.toString()}), String.valueOf(job.getFailedMapAttempts()))._()).td().a(this.url(new String[]{"attempts", jid, "m", MRApps.TaskAttemptStateUI.KILLED.toString()}), String.valueOf(job.getKilledMapAttempts()))._()).td().a(this.url(new String[]{"attempts", jid, "m", MRApps.TaskAttemptStateUI.SUCCESSFUL.toString()}), String.valueOf(job.getSuccessfulMapAttempts()))._())._()).tr(".even").th("Reduces").td().a(this.url(new String[]{"attempts", jid, "r", MRApps.TaskAttemptStateUI.FAILED.toString()}), String.valueOf(job.getFailedReduceAttempts()))._()).td().a(this.url(new String[]{"attempts", jid, "r", MRApps.TaskAttemptStateUI.KILLED.toString()}), String.valueOf(job.getKilledReduceAttempts()))._()).td().a(this.url(new String[]{"attempts", jid, "r", MRApps.TaskAttemptStateUI.SUCCESSFUL.toString()}), String.valueOf(job.getSuccessfulReduceAttempts()))._())._())._())._();
    }
}

