/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.hs.HistoryFileManager;
import org.apache.hadoop.mapreduce.v2.hs.HistoryStorage;
import org.apache.hadoop.mapreduce.v2.hs.PartialJob;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.JobInfo;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.JobsInfo;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.service.AbstractService;

public class CachedHistoryStorage
extends AbstractService
implements HistoryStorage {
    private static final Log LOG = LogFactory.getLog(CachedHistoryStorage.class);
    private Map<JobId, Job> loadedJobCache = null;
    private int loadedJobCacheSize;
    private HistoryFileManager hsManager;

    @Override
    public void setHistoryFileManager(HistoryFileManager hsManager) {
        this.hsManager = hsManager;
    }

    public void init(Configuration conf) throws YarnException {
        LOG.info((Object)"CachedHistoryStorage Init");
        this.loadedJobCacheSize = conf.getInt("mapreduce.jobhistory.loadedjobs.cache.size", 5);
        this.loadedJobCache = Collections.synchronizedMap(new LinkedHashMap<JobId, Job>(this.loadedJobCacheSize + 1, 0.75f, true){

            @Override
            public boolean removeEldestEntry(Map.Entry<JobId, Job> eldest) {
                return super.size() > CachedHistoryStorage.this.loadedJobCacheSize;
            }
        });
        super.init(conf);
    }

    public CachedHistoryStorage() {
        super(CachedHistoryStorage.class.getName());
    }

    private Job loadJob(HistoryFileManager.HistoryFileInfo fileInfo) {
        try {
            Job job = fileInfo.loadJob();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding " + job.getID() + " to loaded job cache"));
            }
            this.loadedJobCache.put(job.getID(), job);
            return job;
        }
        catch (IOException e) {
            throw new YarnException("Could not find/load job: " + fileInfo.getJobId(), (Throwable)e);
        }
    }

    @Override
    public Job getFullJob(JobId jobId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Looking for Job " + jobId));
        }
        try {
            HistoryFileManager.HistoryFileInfo fileInfo = this.hsManager.getFileInfo(jobId);
            Job result = null;
            if (fileInfo != null) {
                result = this.loadedJobCache.get(jobId);
                if (result == null) {
                    result = this.loadJob(fileInfo);
                } else if (fileInfo.isDeleted()) {
                    this.loadedJobCache.remove(jobId);
                    result = null;
                }
            } else {
                this.loadedJobCache.remove(jobId);
            }
            return result;
        }
        catch (IOException e) {
            throw new YarnException((Throwable)e);
        }
    }

    @Override
    public Map<JobId, Job> getAllPartialJobs() {
        LOG.debug((Object)"Called getAllPartialJobs()");
        TreeMap<JobId, Job> result = new TreeMap<JobId, Job>();
        try {
            for (HistoryFileManager.HistoryFileInfo mi : this.hsManager.getAllFileInfo()) {
                if (mi == null) continue;
                JobId id = mi.getJobId();
                result.put(id, new PartialJob(mi.getJobIndexInfo(), id));
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Error trying to scan for all FileInfos", (Throwable)e);
            throw new YarnException((Throwable)e);
        }
        return result;
    }

    @Override
    public JobsInfo getPartialJobs(Long offset, Long count, String user, String queue, Long sBegin, Long sEnd, Long fBegin, Long fEnd, JobState jobState) {
        return CachedHistoryStorage.getPartialJobs(this.getAllPartialJobs().values(), offset, count, user, queue, sBegin, sEnd, fBegin, fEnd, jobState);
    }

    public static JobsInfo getPartialJobs(Collection<Job> jobs, Long offset, Long count, String user, String queue, Long sBegin, Long sEnd, Long fBegin, Long fEnd, JobState jobState) {
        JobsInfo allJobs = new JobsInfo();
        if (sBegin == null || sBegin < 0L) {
            sBegin = 0L;
        }
        if (sEnd == null) {
            sEnd = Long.MAX_VALUE;
        }
        if (fBegin == null || fBegin < 0L) {
            fBegin = 0L;
        }
        if (fEnd == null) {
            fEnd = Long.MAX_VALUE;
        }
        if (offset == null || offset < 0L) {
            offset = 0L;
        }
        if (count == null) {
            count = Long.MAX_VALUE;
        }
        if (offset > (long)jobs.size()) {
            return allJobs;
        }
        long at = 0L;
        long end = offset + count - 1L;
        if (end < 0L) {
            end = Long.MAX_VALUE;
        }
        for (Job job : jobs) {
            JobReport report;
            if (at > end) break;
            if (queue != null && !queue.isEmpty() && !job.getQueueName().equals(queue) || user != null && !user.isEmpty() && !job.getUserName().equals(user) || (report = job.getReport()).getStartTime() < sBegin || report.getStartTime() > sEnd || report.getFinishTime() < fBegin || report.getFinishTime() > fEnd || jobState != null && jobState != report.getJobState() || ++at - 1L < offset) continue;
            JobInfo jobInfo = new JobInfo(job);
            allJobs.add(jobInfo);
        }
        return allJobs;
    }
}

