/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.ClusterMetrics;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.QueueAclsInfo;
import org.apache.hadoop.mapreduce.QueueInfo;
import org.apache.hadoop.mapreduce.TaskTrackerInfo;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.client.YarnClientImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.ProtoUtils;

public class ResourceMgrDelegate
extends YarnClientImpl {
    private static final Log LOG = LogFactory.getLog(ResourceMgrDelegate.class);
    private YarnConfiguration conf;
    private GetNewApplicationResponse application;
    private ApplicationId applicationId;

    public ResourceMgrDelegate(YarnConfiguration conf) {
        this.conf = conf;
        this.init((Configuration)conf);
        this.start();
    }

    public TaskTrackerInfo[] getActiveTrackers() throws IOException, InterruptedException {
        return TypeConverter.fromYarnNodes((List)super.getNodeReports());
    }

    public JobStatus[] getAllJobs() throws IOException, InterruptedException {
        return TypeConverter.fromYarnApps((List)super.getApplicationList(), (Configuration)this.conf);
    }

    public TaskTrackerInfo[] getBlacklistedTrackers() throws IOException, InterruptedException {
        LOG.warn((Object)"getBlacklistedTrackers - Not implemented yet");
        return new TaskTrackerInfo[0];
    }

    public ClusterMetrics getClusterMetrics() throws IOException, InterruptedException {
        YarnClusterMetrics metrics = super.getYarnClusterMetrics();
        ClusterMetrics oldMetrics = new ClusterMetrics(1, 1, 1, 1, 1, 1, metrics.getNumNodeManagers() * 10, metrics.getNumNodeManagers() * 2, 1, metrics.getNumNodeManagers(), 0, 0);
        return oldMetrics;
    }

    InetSocketAddress getConnectAddress() {
        return this.rmAddress;
    }

    public Token getDelegationToken(Text renewer) throws IOException, InterruptedException {
        return ProtoUtils.convertFromProtoFormat((org.apache.hadoop.yarn.api.records.Token)super.getRMDelegationToken(renewer), (InetSocketAddress)this.rmAddress);
    }

    public String getFilesystemName() throws IOException, InterruptedException {
        return FileSystem.get((Configuration)this.conf).getUri().toString();
    }

    public JobID getNewJobID() throws IOException, InterruptedException {
        this.application = super.getNewApplication();
        this.applicationId = this.application.getApplicationId();
        return TypeConverter.fromYarn((ApplicationId)this.applicationId);
    }

    public QueueInfo getQueue(String queueName) throws IOException, InterruptedException {
        org.apache.hadoop.yarn.api.records.QueueInfo queueInfo = super.getQueueInfo(queueName);
        return queueInfo == null ? null : TypeConverter.fromYarn((org.apache.hadoop.yarn.api.records.QueueInfo)queueInfo, (Configuration)this.conf);
    }

    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException, InterruptedException {
        return TypeConverter.fromYarnQueueUserAclsInfo((List)super.getQueueAclsInfo());
    }

    public QueueInfo[] getQueues() throws IOException, InterruptedException {
        return TypeConverter.fromYarnQueueInfo((List)super.getAllQueues(), (Configuration)this.conf);
    }

    public QueueInfo[] getRootQueues() throws IOException, InterruptedException {
        return TypeConverter.fromYarnQueueInfo((List)super.getRootQueueInfos(), (Configuration)this.conf);
    }

    public QueueInfo[] getChildQueues(String parent) throws IOException, InterruptedException {
        return TypeConverter.fromYarnQueueInfo((List)super.getChildQueueInfos(parent), (Configuration)this.conf);
    }

    public String getStagingAreaDir() throws IOException, InterruptedException {
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        Path path = MRApps.getStagingAreaDir((Configuration)this.conf, (String)user);
        LOG.debug((Object)("getStagingAreaDir: dir=" + path));
        return path.toString();
    }

    public String getSystemDir() throws IOException, InterruptedException {
        Path sysDir = new Path("jobSubmitDir");
        return sysDir.toString();
    }

    public long getTaskTrackerExpiryInterval() throws IOException, InterruptedException {
        return 0L;
    }

    public void setJobPriority(JobID arg0, String arg1) throws IOException, InterruptedException {
    }

    public long getProtocolVersion(String arg0, long arg1) throws IOException {
        return 0L;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }
}

