/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.yarn.api.records.AMResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ProtoBase;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerStatusPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

public class AMResponsePBImpl
extends ProtoBase<YarnProtos.AMResponseProto>
implements AMResponse {
    YarnProtos.AMResponseProto proto = YarnProtos.AMResponseProto.getDefaultInstance();
    YarnProtos.AMResponseProto.Builder builder = null;
    boolean viaProto = false;
    Resource limit;
    private List<Container> allocatedContainers = null;
    private List<ContainerStatus> completedContainersStatuses = null;

    public AMResponsePBImpl() {
        this.builder = YarnProtos.AMResponseProto.newBuilder();
    }

    public AMResponsePBImpl(YarnProtos.AMResponseProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    @Override
    public synchronized YarnProtos.AMResponseProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private synchronized void mergeLocalToBuilder() {
        Iterable<GeneratedMessage> iterable;
        if (this.allocatedContainers != null) {
            this.builder.clearAllocatedContainers();
            iterable = this.getProtoIterable(this.allocatedContainers);
            this.builder.addAllAllocatedContainers(iterable);
        }
        if (this.completedContainersStatuses != null) {
            this.builder.clearCompletedContainerStatuses();
            iterable = this.getContainerStatusProtoIterable(this.completedContainersStatuses);
            this.builder.addAllCompletedContainerStatuses(iterable);
        }
        if (this.limit != null) {
            this.builder.setLimit(this.convertToProtoFormat(this.limit));
        }
    }

    private synchronized void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private synchronized void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.AMResponseProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public synchronized boolean getReboot() {
        YarnProtos.AMResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getReboot();
    }

    @Override
    public synchronized void setReboot(boolean reboot) {
        this.maybeInitBuilder();
        this.builder.setReboot(reboot);
    }

    @Override
    public synchronized int getResponseId() {
        YarnProtos.AMResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getResponseId();
    }

    @Override
    public synchronized void setResponseId(int responseId) {
        this.maybeInitBuilder();
        this.builder.setResponseId(responseId);
    }

    @Override
    public synchronized Resource getAvailableResources() {
        YarnProtos.AMResponseProtoOrBuilder p;
        if (this.limit != null) {
            return this.limit;
        }
        YarnProtos.AMResponseProtoOrBuilder aMResponseProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasLimit()) {
            return null;
        }
        this.limit = this.convertFromProtoFormat(p.getLimit());
        return this.limit;
    }

    @Override
    public synchronized void setAvailableResources(Resource limit) {
        this.maybeInitBuilder();
        if (limit == null) {
            this.builder.clearLimit();
        }
        this.limit = limit;
    }

    @Override
    public synchronized List<Container> getAllocatedContainers() {
        this.initLocalNewContainerList();
        return this.allocatedContainers;
    }

    private synchronized void initLocalNewContainerList() {
        if (this.allocatedContainers != null) {
            return;
        }
        YarnProtos.AMResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ContainerProto> list = p.getAllocatedContainersList();
        this.allocatedContainers = new ArrayList<Container>();
        for (YarnProtos.ContainerProto c : list) {
            this.allocatedContainers.add(this.convertFromProtoFormat(c));
        }
    }

    @Override
    public synchronized void setAllocatedContainers(List<Container> containers) {
        if (containers == null) {
            return;
        }
        this.initLocalNewContainerList();
        this.allocatedContainers.addAll(containers);
    }

    private synchronized Iterable<YarnProtos.ContainerProto> getProtoIterable(final List<Container> newContainersList) {
        this.maybeInitBuilder();
        return new Iterable<YarnProtos.ContainerProto>(){

            @Override
            public synchronized Iterator<YarnProtos.ContainerProto> iterator() {
                return new Iterator<YarnProtos.ContainerProto>(){
                    Iterator<Container> iter;
                    {
                        this.iter = newContainersList.iterator();
                    }

                    @Override
                    public synchronized boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public synchronized YarnProtos.ContainerProto next() {
                        return AMResponsePBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public synchronized void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private synchronized Iterable<YarnProtos.ContainerStatusProto> getContainerStatusProtoIterable(final List<ContainerStatus> newContainersList) {
        this.maybeInitBuilder();
        return new Iterable<YarnProtos.ContainerStatusProto>(){

            @Override
            public synchronized Iterator<YarnProtos.ContainerStatusProto> iterator() {
                return new Iterator<YarnProtos.ContainerStatusProto>(){
                    Iterator<ContainerStatus> iter;
                    {
                        this.iter = newContainersList.iterator();
                    }

                    @Override
                    public synchronized boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public synchronized YarnProtos.ContainerStatusProto next() {
                        return AMResponsePBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public synchronized void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public synchronized List<ContainerStatus> getCompletedContainersStatuses() {
        this.initLocalFinishedContainerList();
        return this.completedContainersStatuses;
    }

    private synchronized void initLocalFinishedContainerList() {
        if (this.completedContainersStatuses != null) {
            return;
        }
        YarnProtos.AMResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ContainerStatusProto> list = p.getCompletedContainerStatusesList();
        this.completedContainersStatuses = new ArrayList<ContainerStatus>();
        for (YarnProtos.ContainerStatusProto c : list) {
            this.completedContainersStatuses.add(this.convertFromProtoFormat(c));
        }
    }

    @Override
    public synchronized void setCompletedContainersStatuses(List<ContainerStatus> containers) {
        if (containers == null) {
            return;
        }
        this.initLocalFinishedContainerList();
        this.completedContainersStatuses.addAll(containers);
    }

    private synchronized ContainerPBImpl convertFromProtoFormat(YarnProtos.ContainerProto p) {
        return new ContainerPBImpl(p);
    }

    private synchronized YarnProtos.ContainerProto convertToProtoFormat(Container t) {
        return ((ContainerPBImpl)t).getProto();
    }

    private synchronized ContainerStatusPBImpl convertFromProtoFormat(YarnProtos.ContainerStatusProto p) {
        return new ContainerStatusPBImpl(p);
    }

    private synchronized YarnProtos.ContainerStatusProto convertToProtoFormat(ContainerStatus t) {
        return ((ContainerStatusPBImpl)t).getProto();
    }

    private synchronized ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    private synchronized YarnProtos.ResourceProto convertToProtoFormat(Resource r) {
        return ((ResourcePBImpl)r).getProto();
    }
}

