/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.hadoop.yarn.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.ProtoBase;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeHealthStatusPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.util.ProtoUtils;

public class NodeReportPBImpl
extends ProtoBase<YarnProtos.NodeReportProto>
implements NodeReport {
    private YarnProtos.NodeReportProto proto = YarnProtos.NodeReportProto.getDefaultInstance();
    private YarnProtos.NodeReportProto.Builder builder = null;
    private boolean viaProto = false;
    private NodeId nodeId;
    private Resource used;
    private Resource capability;
    private NodeHealthStatus nodeHealthStatus;

    public NodeReportPBImpl() {
        this.builder = YarnProtos.NodeReportProto.newBuilder();
    }

    public NodeReportPBImpl(YarnProtos.NodeReportProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    @Override
    public Resource getCapability() {
        YarnProtos.NodeReportProtoOrBuilder p;
        if (this.capability != null) {
            return this.capability;
        }
        YarnProtos.NodeReportProtoOrBuilder nodeReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasCapability()) {
            return null;
        }
        this.capability = this.convertFromProtoFormat(p.getCapability());
        return this.capability;
    }

    @Override
    public NodeHealthStatus getNodeHealthStatus() {
        YarnProtos.NodeReportProtoOrBuilder p;
        if (this.nodeHealthStatus != null) {
            return this.nodeHealthStatus;
        }
        YarnProtos.NodeReportProtoOrBuilder nodeReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNodeHealthStatus()) {
            return null;
        }
        this.nodeHealthStatus = this.convertFromProtoFormat(p.getNodeHealthStatus());
        return this.nodeHealthStatus;
    }

    @Override
    public String getHttpAddress() {
        YarnProtos.NodeReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.hasHttpAddress() ? p.getHttpAddress() : null;
    }

    @Override
    public int getNumContainers() {
        YarnProtos.NodeReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.hasNumContainers() ? p.getNumContainers() : 0;
    }

    @Override
    public String getRackName() {
        YarnProtos.NodeReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.hasRackName() ? p.getRackName() : null;
    }

    @Override
    public Resource getUsed() {
        YarnProtos.NodeReportProtoOrBuilder p;
        if (this.used != null) {
            return this.used;
        }
        YarnProtos.NodeReportProtoOrBuilder nodeReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasUsed()) {
            return null;
        }
        this.used = this.convertFromProtoFormat(p.getUsed());
        return this.used;
    }

    @Override
    public NodeId getNodeId() {
        YarnProtos.NodeReportProtoOrBuilder p;
        if (this.nodeId != null) {
            return this.nodeId;
        }
        YarnProtos.NodeReportProtoOrBuilder nodeReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNodeId()) {
            return null;
        }
        this.nodeId = this.convertFromProtoFormat(p.getNodeId());
        return this.nodeId;
    }

    @Override
    public void setNodeId(NodeId nodeId) {
        this.maybeInitBuilder();
        if (nodeId == null) {
            this.builder.clearNodeId();
        }
        this.nodeId = nodeId;
    }

    @Override
    public NodeState getNodeState() {
        YarnProtos.NodeReportProtoOrBuilder p;
        YarnProtos.NodeReportProtoOrBuilder nodeReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNodeState()) {
            return null;
        }
        return ProtoUtils.convertFromProtoFormat(p.getNodeState());
    }

    @Override
    public void setNodeState(NodeState nodeState) {
        this.maybeInitBuilder();
        if (nodeState == null) {
            this.builder.clearNodeState();
            return;
        }
        this.builder.setNodeState(ProtoUtils.convertToProtoFormat(nodeState));
    }

    @Override
    public void setCapability(Resource capability) {
        this.maybeInitBuilder();
        if (capability == null) {
            this.builder.clearCapability();
        }
        this.capability = capability;
    }

    @Override
    public void setNodeHealthStatus(NodeHealthStatus healthStatus) {
        this.maybeInitBuilder();
        if (healthStatus == null) {
            this.builder.clearNodeHealthStatus();
        }
        this.nodeHealthStatus = healthStatus;
    }

    @Override
    public void setHttpAddress(String httpAddress) {
        this.maybeInitBuilder();
        if (httpAddress == null) {
            this.builder.clearHttpAddress();
            return;
        }
        this.builder.setHttpAddress(httpAddress);
    }

    @Override
    public void setNumContainers(int numContainers) {
        this.maybeInitBuilder();
        if (numContainers == 0) {
            this.builder.clearNumContainers();
            return;
        }
        this.builder.setNumContainers(numContainers);
    }

    @Override
    public void setRackName(String rackName) {
        this.maybeInitBuilder();
        if (rackName == null) {
            this.builder.clearRackName();
            return;
        }
        this.builder.setRackName(rackName);
    }

    @Override
    public void setUsed(Resource used) {
        this.maybeInitBuilder();
        if (used == null) {
            this.builder.clearUsed();
        }
        this.used = used;
    }

    @Override
    public YarnProtos.NodeReportProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToBuilder() {
        if (this.nodeId != null && !((NodeIdPBImpl)this.nodeId).getProto().equals(this.builder.getNodeId())) {
            this.builder.setNodeId(this.convertToProtoFormat(this.nodeId));
        }
        if (this.used != null && !((ResourcePBImpl)this.used).getProto().equals(this.builder.getUsed())) {
            this.builder.setUsed(this.convertToProtoFormat(this.used));
        }
        if (this.capability != null && !((ResourcePBImpl)this.capability).getProto().equals(this.builder.getCapability())) {
            this.builder.setCapability(this.convertToProtoFormat(this.capability));
        }
        if (this.nodeHealthStatus != null && !((NodeHealthStatusPBImpl)this.nodeHealthStatus).getProto().equals(this.builder.getNodeHealthStatus())) {
            this.builder.setNodeHealthStatus(this.convertToProtoFormat(this.nodeHealthStatus));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.NodeReportProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private NodeIdPBImpl convertFromProtoFormat(YarnProtos.NodeIdProto p) {
        return new NodeIdPBImpl(p);
    }

    private YarnProtos.NodeIdProto convertToProtoFormat(NodeId nodeId) {
        return ((NodeIdPBImpl)nodeId).getProto();
    }

    private ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource r) {
        return ((ResourcePBImpl)r).getProto();
    }

    private NodeHealthStatusPBImpl convertFromProtoFormat(YarnProtos.NodeHealthStatusProto p) {
        return new NodeHealthStatusPBImpl(p);
    }

    private YarnProtos.NodeHealthStatusProto convertToProtoFormat(NodeHealthStatus r) {
        return ((NodeHealthStatusPBImpl)r).getProto();
    }
}

