/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import java.text.NumberFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ContainerId
implements Comparable<ContainerId> {
    private static final ThreadLocal<NumberFormat> appAttemptIdFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(2);
            return fmt;
        }
    };
    private static final ThreadLocal<NumberFormat> containerIdFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(6);
            return fmt;
        }
    };

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ApplicationAttemptId getApplicationAttemptId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setApplicationAttemptId(ApplicationAttemptId var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setId(int var1);

    public int hashCode() {
        int prime = 435569;
        int result = 7507;
        result = 435569 * result + this.getId();
        result = 435569 * result + this.getApplicationAttemptId().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerId other = (ContainerId)obj;
        if (!this.getApplicationAttemptId().equals(other.getApplicationAttemptId())) {
            return false;
        }
        return this.getId() == other.getId();
    }

    @Override
    public int compareTo(ContainerId other) {
        if (this.getApplicationAttemptId().compareTo(other.getApplicationAttemptId()) == 0) {
            return this.getId() - other.getId();
        }
        return this.getApplicationAttemptId().compareTo(other.getApplicationAttemptId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("container_");
        ApplicationId appId = this.getApplicationAttemptId().getApplicationId();
        sb.append(appId.getClusterTimestamp()).append("_");
        sb.append(ApplicationId.appIdFormat.get().format(appId.getId())).append("_");
        sb.append(appAttemptIdFormat.get().format(this.getApplicationAttemptId().getAttemptId())).append("_");
        sb.append(containerIdFormat.get().format(this.getId()));
        return sb.toString();
    }
}

