/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ResourceRequest
implements Comparable<ResourceRequest> {
    public static final String ANY = "*";

    public static boolean isAnyLocation(String hostName) {
        return ANY.equals(hostName);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Priority getPriority();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setPriority(Priority var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getHostName();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setHostName(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Resource getCapability();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setCapability(Resource var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getNumContainers();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setNumContainers(int var1);

    public int hashCode() {
        int prime = 2153;
        int result = 2459;
        Resource capability = this.getCapability();
        String hostName = this.getHostName();
        Priority priority = this.getPriority();
        result = 2153 * result + (capability == null ? 0 : capability.hashCode());
        result = 2153 * result + (hostName == null ? 0 : hostName.hashCode());
        result = 2153 * result + this.getNumContainers();
        result = 2153 * result + (priority == null ? 0 : priority.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceRequest other = (ResourceRequest)obj;
        Resource capability = this.getCapability();
        if (capability == null ? other.getCapability() != null : !capability.equals(other.getCapability())) {
            return false;
        }
        String hostName = this.getHostName();
        if (hostName == null ? other.getHostName() != null : !hostName.equals(other.getHostName())) {
            return false;
        }
        if (this.getNumContainers() != other.getNumContainers()) {
            return false;
        }
        Priority priority = this.getPriority();
        return !(priority == null ? other.getPriority() != null : !priority.equals(other.getPriority()));
    }

    @Override
    public int compareTo(ResourceRequest other) {
        int priorityComparison = this.getPriority().compareTo(other.getPriority());
        if (priorityComparison == 0) {
            int hostNameComparison = this.getHostName().compareTo(other.getHostName());
            if (hostNameComparison == 0) {
                int capabilityComparison = this.getCapability().compareTo(other.getCapability());
                if (capabilityComparison == 0) {
                    int numContainersComparison = this.getNumContainers() - other.getNumContainers();
                    if (numContainersComparison == 0) {
                        return 0;
                    }
                    return numContainersComparison;
                }
                return capabilityComparison;
            }
            return hostNameComparison;
        }
        return priorityComparison;
    }
}

