/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.yarn.api.protocolrecords.PreemptionContainer;
import org.apache.hadoop.yarn.api.protocolrecords.PreemptionContract;
import org.apache.hadoop.yarn.api.protocolrecords.PreemptionResourceRequest;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.PreemptionContainerPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.PreemptionResourceRequestPBImpl;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

public class PreemptionContractPBImpl
implements PreemptionContract {
    YarnServiceProtos.PreemptionContractProto proto = YarnServiceProtos.PreemptionContractProto.getDefaultInstance();
    YarnServiceProtos.PreemptionContractProto.Builder builder = null;
    boolean viaProto = false;
    private Set<PreemptionContainer> containers;
    private List<PreemptionResourceRequest> resources;

    public PreemptionContractPBImpl() {
        this.builder = YarnServiceProtos.PreemptionContractProto.newBuilder();
    }

    public PreemptionContractPBImpl(YarnServiceProtos.PreemptionContractProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public synchronized YarnServiceProtos.PreemptionContractProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void mergeLocalToBuilder() {
        if (this.resources != null) {
            this.addResourcesToProto();
        }
        if (this.containers != null) {
            this.addContainersToProto();
        }
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.PreemptionContractProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public synchronized Set<PreemptionContainer> getContainers() {
        this.initPreemptionContainers();
        return this.containers;
    }

    @Override
    public synchronized void setContainers(Set<PreemptionContainer> containers) {
        if (null == containers) {
            this.builder.clearContainer();
        }
        this.containers = containers;
    }

    @Override
    public synchronized List<PreemptionResourceRequest> getResourceRequest() {
        this.initPreemptionResourceRequests();
        return this.resources;
    }

    @Override
    public synchronized void setResourceRequest(List<PreemptionResourceRequest> req) {
        if (null == this.resources) {
            this.builder.clearResource();
        }
        this.resources = req;
    }

    private void initPreemptionResourceRequests() {
        if (this.resources != null) {
            return;
        }
        YarnServiceProtos.PreemptionContractProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnServiceProtos.PreemptionResourceRequestProto> list = p.getResourceList();
        this.resources = new ArrayList<PreemptionResourceRequest>();
        for (YarnServiceProtos.PreemptionResourceRequestProto rr : list) {
            this.resources.add(this.convertFromProtoFormat(rr));
        }
    }

    private void addResourcesToProto() {
        this.maybeInitBuilder();
        this.builder.clearResource();
        if (null == this.resources) {
            return;
        }
        Iterable<YarnServiceProtos.PreemptionResourceRequestProto> iterable = new Iterable<YarnServiceProtos.PreemptionResourceRequestProto>(){

            @Override
            public Iterator<YarnServiceProtos.PreemptionResourceRequestProto> iterator() {
                return new Iterator<YarnServiceProtos.PreemptionResourceRequestProto>(){
                    Iterator<PreemptionResourceRequest> iter;
                    {
                        this.iter = PreemptionContractPBImpl.this.resources.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnServiceProtos.PreemptionResourceRequestProto next() {
                        return PreemptionContractPBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllResource((Iterable<? extends YarnServiceProtos.PreemptionResourceRequestProto>)iterable);
    }

    private void initPreemptionContainers() {
        if (this.containers != null) {
            return;
        }
        YarnServiceProtos.PreemptionContractProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnServiceProtos.PreemptionContainerProto> list = p.getContainerList();
        this.containers = new HashSet<PreemptionContainer>();
        for (YarnServiceProtos.PreemptionContainerProto c : list) {
            this.containers.add(this.convertFromProtoFormat(c));
        }
    }

    private void addContainersToProto() {
        this.maybeInitBuilder();
        this.builder.clearContainer();
        if (null == this.containers) {
            return;
        }
        Iterable<YarnServiceProtos.PreemptionContainerProto> iterable = new Iterable<YarnServiceProtos.PreemptionContainerProto>(){

            @Override
            public Iterator<YarnServiceProtos.PreemptionContainerProto> iterator() {
                return new Iterator<YarnServiceProtos.PreemptionContainerProto>(){
                    Iterator<PreemptionContainer> iter;
                    {
                        this.iter = PreemptionContractPBImpl.this.containers.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnServiceProtos.PreemptionContainerProto next() {
                        return PreemptionContractPBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllContainer((Iterable<? extends YarnServiceProtos.PreemptionContainerProto>)iterable);
    }

    private PreemptionContainerPBImpl convertFromProtoFormat(YarnServiceProtos.PreemptionContainerProto p) {
        return new PreemptionContainerPBImpl(p);
    }

    private YarnServiceProtos.PreemptionContainerProto convertToProtoFormat(PreemptionContainer t) {
        return ((PreemptionContainerPBImpl)t).getProto();
    }

    private PreemptionResourceRequestPBImpl convertFromProtoFormat(YarnServiceProtos.PreemptionResourceRequestProto p) {
        return new PreemptionResourceRequestPBImpl(p);
    }

    private YarnServiceProtos.PreemptionResourceRequestProto convertToProtoFormat(PreemptionResourceRequest t) {
        return ((PreemptionResourceRequestPBImpl)t).getProto();
    }
}

