/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class NodeReport {
    @InterfaceAudience.Private
    public static NodeReport newInstance(NodeId nodeId, NodeState nodeState, String httpAddress, String rackName, Resource used, Resource capability, int numContainers, NodeHealthStatus nodeHealthStatus) {
        NodeReport nodeReport = Records.newRecord(NodeReport.class);
        nodeReport.setNodeId(nodeId);
        nodeReport.setNodeState(nodeState);
        nodeReport.setHttpAddress(httpAddress);
        nodeReport.setRackName(rackName);
        nodeReport.setUsed(used);
        nodeReport.setCapability(capability);
        nodeReport.setNumContainers(numContainers);
        nodeReport.setNodeHealthStatus(nodeHealthStatus);
        return nodeReport;
    }

    public abstract NodeId getNodeId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNodeId(NodeId var1);

    public abstract NodeState getNodeState();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNodeState(NodeState var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getHttpAddress();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setHttpAddress(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getRackName();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setRackName(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Resource getUsed();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setUsed(Resource var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Resource getCapability();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setCapability(Resource var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getNumContainers();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNumContainers(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract NodeHealthStatus getNodeHealthStatus();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNodeHealthStatus(NodeHealthStatus var1);
}

