/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.yarn.api.records.DelegationToken;
import org.apache.hadoop.yarn.client.YarnClientImpl;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.util.BuilderUtils;

public class RMDelegationTokenRenewer
extends TokenRenewer {
    public boolean handleKind(Text kind) {
        return RMDelegationTokenIdentifier.KIND_NAME.equals((Object)kind);
    }

    public boolean isManaged(Token<?> token) throws IOException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long renew(Token<?> token, Configuration conf) throws IOException, InterruptedException {
        YarnClientImpl yarnClient = this.getYarnClient(conf, SecurityUtil.getTokenServiceAddr(token));
        try {
            DelegationToken dToken = BuilderUtils.newDelegationToken((byte[])token.getIdentifier(), (String)token.getKind().toString(), (byte[])token.getPassword(), (String)token.getService().toString());
            long l = yarnClient.renewRMDelegationToken(dToken);
            return l;
        }
        finally {
            yarnClient.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(Token<?> token, Configuration conf) throws IOException, InterruptedException {
        YarnClientImpl yarnClient = this.getYarnClient(conf, SecurityUtil.getTokenServiceAddr(token));
        try {
            DelegationToken dToken = BuilderUtils.newDelegationToken((byte[])token.getIdentifier(), (String)token.getKind().toString(), (byte[])token.getPassword(), (String)token.getService().toString());
            yarnClient.cancelRMDelegationToken(dToken);
            return;
        }
        finally {
            yarnClient.stop();
        }
    }

    private YarnClientImpl getYarnClient(Configuration conf, InetSocketAddress rmAddress) {
        YarnClientImpl yarnClient = new YarnClientImpl(rmAddress);
        yarnClient.init(conf);
        yarnClient.start();
        return yarnClient;
    }
}

