/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.AMRMProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.client.AMRMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.service.AbstractService;
import org.apache.hadoop.yarn.util.BuilderUtils;

@InterfaceStability.Unstable
public class AMRMClientImpl
extends AbstractService
implements AMRMClient {
    private static final Log LOG = LogFactory.getLog(AMRMClientImpl.class);
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private int lastResponseId = 0;
    protected AMRMProtocol rmClient;
    protected final ApplicationAttemptId appAttemptId;
    protected Resource clusterAvailableResources;
    protected int clusterNodeCount;
    protected final Map<Priority, Map<String, Map<Resource, ResourceRequest>>> remoteRequestsTable = new TreeMap<Priority, Map<String, Map<Resource, ResourceRequest>>>();
    protected final Set<ResourceRequest> ask = new TreeSet<ResourceRequest>((Comparator<ResourceRequest>)new BuilderUtils.ResourceRequestComparator());
    protected final Set<ContainerId> release = new TreeSet<ContainerId>();

    public AMRMClientImpl(ApplicationAttemptId appAttemptId) {
        super(AMRMClientImpl.class.getName());
        this.appAttemptId = appAttemptId;
    }

    public synchronized void init(Configuration conf) {
        super.init(conf);
    }

    public synchronized void start() {
        UserGroupInformation currentUser;
        final YarnConfiguration conf = new YarnConfiguration(this.getConfig());
        final YarnRPC rpc = YarnRPC.create((Configuration)conf);
        final InetSocketAddress rmAddress = conf.getSocketAddr("yarn.resourcemanager.scheduler.address", "0.0.0.0:8030", 8030);
        try {
            currentUser = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new YarnException((Throwable)e);
        }
        if (UserGroupInformation.isSecurityEnabled()) {
            String tokenURLEncodedStr = System.getenv().get("AppMasterTokenEnv");
            Token token = new Token();
            try {
                token.decodeFromUrlString(tokenURLEncodedStr);
            }
            catch (IOException e) {
                throw new YarnException((Throwable)e);
            }
            SecurityUtil.setTokenService((Token)token, (InetSocketAddress)rmAddress);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("AppMasterToken is " + token));
            }
            currentUser.addToken(token);
        }
        this.rmClient = (AMRMProtocol)currentUser.doAs((PrivilegedAction)new PrivilegedAction<AMRMProtocol>(){

            @Override
            public AMRMProtocol run() {
                return (AMRMProtocol)rpc.getProxy(AMRMProtocol.class, rmAddress, (Configuration)conf);
            }
        });
        LOG.debug((Object)("Connecting to ResourceManager at " + rmAddress));
        super.start();
    }

    public synchronized void stop() {
        if (this.rmClient != null) {
            RPC.stopProxy((Object)this.rmClient);
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterApplicationMasterResponse registerApplicationMaster(String appHostName, int appHostPort, String appTrackingUrl) throws YarnRemoteException {
        RegisterApplicationMasterRequest request = (RegisterApplicationMasterRequest)this.recordFactory.newRecordInstance(RegisterApplicationMasterRequest.class);
        AMRMClientImpl aMRMClientImpl = this;
        synchronized (aMRMClientImpl) {
            request.setApplicationAttemptId(this.appAttemptId);
        }
        request.setHost(appHostName);
        request.setRpcPort(appHostPort);
        if (appTrackingUrl != null) {
            request.setTrackingUrl(appTrackingUrl);
        }
        RegisterApplicationMasterResponse response = this.rmClient.registerApplicationMaster(request);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AllocateResponse allocate(float progressIndicator) throws YarnRemoteException {
        AMRMClientImpl aMRMClientImpl;
        AllocateResponse allocateResponse = null;
        ArrayList<ResourceRequest> askList = null;
        ArrayList<ContainerId> releaseList = null;
        AllocateRequest allocateRequest = null;
        try {
            aMRMClientImpl = this;
            synchronized (aMRMClientImpl) {
                askList = new ArrayList<ResourceRequest>(this.ask);
                releaseList = new ArrayList<ContainerId>(this.release);
                this.ask.clear();
                this.release.clear();
                allocateRequest = BuilderUtils.newAllocateRequest((ApplicationAttemptId)this.appAttemptId, (int)this.lastResponseId, (float)progressIndicator, askList, releaseList);
            }
            allocateResponse = this.rmClient.allocate(allocateRequest);
            aMRMClientImpl = this;
            synchronized (aMRMClientImpl) {
                this.clusterNodeCount = allocateResponse.getNumClusterNodes();
                this.lastResponseId = allocateResponse.getResponseId();
                this.clusterAvailableResources = allocateResponse.getAvailableResources();
            }
        }
        finally {
            if (allocateResponse == null) {
                aMRMClientImpl = this;
                synchronized (aMRMClientImpl) {
                    this.release.addAll(releaseList);
                    for (ResourceRequest oldAsk : askList) {
                        if (this.ask.contains(oldAsk)) continue;
                        this.ask.add(oldAsk);
                    }
                }
            }
        }
        return allocateResponse;
    }

    @Override
    public void unregisterApplicationMaster(FinalApplicationStatus appStatus, String appMessage, String appTrackingUrl) throws YarnRemoteException {
        FinishApplicationMasterRequest request = (FinishApplicationMasterRequest)this.recordFactory.newRecordInstance(FinishApplicationMasterRequest.class);
        request.setAppAttemptId(this.appAttemptId);
        request.setFinishApplicationStatus(appStatus);
        if (appMessage != null) {
            request.setDiagnostics(appMessage);
        }
        if (appTrackingUrl != null) {
            request.setTrackingUrl(appTrackingUrl);
        }
        this.rmClient.finishApplicationMaster(request);
    }

    @Override
    public synchronized void addContainerRequest(AMRMClient.ContainerRequest req) {
        if (req.hosts != null) {
            for (String host : req.hosts) {
                this.addResourceRequest(req.priority, host, req.capability, req.containerCount);
            }
        }
        if (req.racks != null) {
            for (String rack : req.racks) {
                this.addResourceRequest(req.priority, rack, req.capability, req.containerCount);
            }
        }
        this.addResourceRequest(req.priority, "*", req.capability, req.containerCount);
    }

    @Override
    public synchronized void removeContainerRequest(AMRMClient.ContainerRequest req) {
        if (req.hosts != null) {
            for (String hostName : req.hosts) {
                this.decResourceRequest(req.priority, hostName, req.capability, req.containerCount);
            }
        }
        if (req.racks != null) {
            for (String rack : req.racks) {
                this.decResourceRequest(req.priority, rack, req.capability, req.containerCount);
            }
        }
        this.decResourceRequest(req.priority, "*", req.capability, req.containerCount);
    }

    @Override
    public synchronized void releaseAssignedContainer(ContainerId containerId) {
        this.release.add(containerId);
    }

    @Override
    public synchronized Resource getClusterAvailableResources() {
        return this.clusterAvailableResources;
    }

    @Override
    public synchronized int getClusterNodeCount() {
        return this.clusterNodeCount;
    }

    private void addResourceRequestToAsk(ResourceRequest remoteRequest) {
        if (this.ask.contains(remoteRequest)) {
            this.ask.remove(remoteRequest);
        }
        this.ask.add(remoteRequest);
    }

    private void addResourceRequest(Priority priority, String resourceName, Resource capability, int containerCount) {
        ResourceRequest remoteRequest;
        Map<Resource, ResourceRequest> reqMap;
        Map<String, Map<Resource, ResourceRequest>> remoteRequests = this.remoteRequestsTable.get(priority);
        if (remoteRequests == null) {
            remoteRequests = new HashMap<String, Map<Resource, ResourceRequest>>();
            this.remoteRequestsTable.put(priority, remoteRequests);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Added priority=" + priority));
            }
        }
        if ((reqMap = remoteRequests.get(resourceName)) == null) {
            reqMap = new HashMap<Resource, ResourceRequest>();
            remoteRequests.put(resourceName, reqMap);
        }
        if ((remoteRequest = reqMap.get(capability)) == null) {
            remoteRequest = BuilderUtils.newResourceRequest((Priority)priority, (String)resourceName, (Resource)capability, (int)0);
            reqMap.put(capability, remoteRequest);
        }
        remoteRequest.setNumContainers(remoteRequest.getNumContainers() + containerCount);
        this.addResourceRequestToAsk(remoteRequest);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addResourceRequest: applicationId=" + this.appAttemptId + " priority=" + priority.getPriority() + " resourceName=" + resourceName + " numContainers=" + remoteRequest.getNumContainers() + " #asks=" + this.ask.size()));
        }
    }

    private void decResourceRequest(Priority priority, String resourceName, Resource capability, int containerCount) {
        Map<String, Map<Resource, ResourceRequest>> remoteRequests = this.remoteRequestsTable.get(priority);
        if (remoteRequests == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Not decrementing resource as priority " + priority + " is not present in request table"));
            }
            return;
        }
        Map<Resource, ResourceRequest> reqMap = remoteRequests.get(resourceName);
        if (reqMap == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Not decrementing resource as " + resourceName + " is not present in request table"));
            }
            return;
        }
        ResourceRequest remoteRequest = reqMap.get(capability);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("BEFORE decResourceRequest: applicationId=" + this.appAttemptId + " priority=" + priority.getPriority() + " resourceName=" + resourceName + " numContainers=" + remoteRequest.getNumContainers() + " #asks=" + this.ask.size()));
        }
        remoteRequest.setNumContainers(remoteRequest.getNumContainers() - containerCount);
        if (remoteRequest.getNumContainers() < 0) {
            remoteRequest.setNumContainers(0);
        }
        this.addResourceRequestToAsk(remoteRequest);
        if (remoteRequest.getNumContainers() == 0) {
            reqMap.remove(capability);
            if (reqMap.size() == 0) {
                remoteRequests.remove(resourceName);
            }
            if (remoteRequests.size() == 0) {
                this.remoteRequestsTable.remove(priority);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)("AFTER decResourceRequest: applicationId=" + this.appAttemptId + " priority=" + priority.getPriority() + " resourceName=" + resourceName + " numContainers=" + remoteRequest.getNumContainers() + " #asks=" + this.ask.size()));
        }
    }
}

