/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.impl.pb.client;

import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetSocketAddress;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ContainerManager;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetContainerStatusRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetContainerStatusResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.StartContainerRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.StartContainerResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.StopContainerRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.StopContainerResponsePBImpl;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.ipc.ProtoOverHadoopRpcEngine;
import org.apache.hadoop.yarn.proto.ContainerManager;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

public class ContainerManagerPBClientImpl
implements ContainerManager,
Closeable {
    static final String NM_COMMAND_TIMEOUT = "yarn.rpc.nm-command-timeout";
    static final int DEFAULT_COMMAND_TIMEOUT = 60000;
    private ContainerManager.ContainerManagerService.BlockingInterface proxy;

    public ContainerManagerPBClientImpl(long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, ContainerManager.ContainerManagerService.BlockingInterface.class, ProtoOverHadoopRpcEngine.class);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        int expireIntvl = conf.getInt(NM_COMMAND_TIMEOUT, 60000);
        this.proxy = (ContainerManager.ContainerManagerService.BlockingInterface)RPC.getProxy(ContainerManager.ContainerManagerService.BlockingInterface.class, (long)clientVersion, (InetSocketAddress)addr, (UserGroupInformation)ugi, (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)expireIntvl);
    }

    @Override
    public void close() {
        if (this.proxy != null) {
            RPC.stopProxy((Object)this.proxy);
        }
    }

    public GetContainerStatusResponse getContainerStatus(GetContainerStatusRequest request) throws YarnRemoteException {
        YarnServiceProtos.GetContainerStatusRequestProto requestProto = ((GetContainerStatusRequestPBImpl)request).getProto();
        try {
            return new GetContainerStatusResponsePBImpl(this.proxy.getContainerStatus(null, requestProto));
        }
        catch (ServiceException e) {
            if (e.getCause() instanceof YarnRemoteException) {
                throw (YarnRemoteException)e.getCause();
            }
            if (e.getCause() instanceof UndeclaredThrowableException) {
                throw (UndeclaredThrowableException)e.getCause();
            }
            throw new UndeclaredThrowableException(e);
        }
    }

    public StartContainerResponse startContainer(StartContainerRequest request) throws YarnRemoteException {
        YarnServiceProtos.StartContainerRequestProto requestProto = ((StartContainerRequestPBImpl)request).getProto();
        try {
            return new StartContainerResponsePBImpl(this.proxy.startContainer(null, requestProto));
        }
        catch (ServiceException e) {
            if (e.getCause() instanceof YarnRemoteException) {
                throw (YarnRemoteException)e.getCause();
            }
            if (e.getCause() instanceof UndeclaredThrowableException) {
                throw (UndeclaredThrowableException)e.getCause();
            }
            throw new UndeclaredThrowableException(e);
        }
    }

    public StopContainerResponse stopContainer(StopContainerRequest request) throws YarnRemoteException {
        YarnServiceProtos.StopContainerRequestProto requestProto = ((StopContainerRequestPBImpl)request).getProto();
        try {
            return new StopContainerResponsePBImpl(this.proxy.stopContainer(null, requestProto));
        }
        catch (ServiceException e) {
            if (e.getCause() instanceof YarnRemoteException) {
                throw (YarnRemoteException)e.getCause();
            }
            if (e.getCause() instanceof UndeclaredThrowableException) {
                throw (UndeclaredThrowableException)e.getCause();
            }
            throw new UndeclaredThrowableException(e);
        }
    }
}

