/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.impl.pb.client;

import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.yarn.api.ClientRMProtocol;
import org.apache.hadoop.yarn.api.ClientRMProtocolPB;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.CancelDelegationTokenRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.CancelDelegationTokenResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetAllApplicationsRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetAllApplicationsResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetApplicationReportRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetApplicationReportResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetClusterMetricsRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetClusterMetricsResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetClusterNodesRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetClusterNodesResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetDelegationTokenRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetDelegationTokenResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetNewApplicationRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetNewApplicationResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetQueueInfoRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetQueueInfoResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetQueueUserAclsInfoRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetQueueUserAclsInfoResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.KillApplicationRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.KillApplicationResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.RenewDelegationTokenRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.RenewDelegationTokenResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.SubmitApplicationRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.SubmitApplicationResponsePBImpl;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.exceptions.impl.pb.YarnRemoteExceptionPBImpl;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

public class ClientRMProtocolPBClientImpl
implements ClientRMProtocol,
Closeable {
    private ClientRMProtocolPB proxy;

    public ClientRMProtocolPBClientImpl(long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, ClientRMProtocolPB.class, ProtobufRpcEngine.class);
        this.proxy = (ClientRMProtocolPB)RPC.getProxy(ClientRMProtocolPB.class, (long)clientVersion, (InetSocketAddress)addr, (Configuration)conf);
    }

    @Override
    public void close() {
        if (this.proxy != null) {
            RPC.stopProxy((Object)this.proxy);
        }
    }

    public KillApplicationResponse forceKillApplication(KillApplicationRequest request) throws YarnRemoteException {
        YarnServiceProtos.KillApplicationRequestProto requestProto = ((KillApplicationRequestPBImpl)request).getProto();
        try {
            return new KillApplicationResponsePBImpl(this.proxy.forceKillApplication(null, requestProto));
        }
        catch (ServiceException e) {
            throw YarnRemoteExceptionPBImpl.unwrapAndThrowException((ServiceException)e);
        }
    }

    public GetApplicationReportResponse getApplicationReport(GetApplicationReportRequest request) throws YarnRemoteException {
        YarnServiceProtos.GetApplicationReportRequestProto requestProto = ((GetApplicationReportRequestPBImpl)request).getProto();
        try {
            return new GetApplicationReportResponsePBImpl(this.proxy.getApplicationReport(null, requestProto));
        }
        catch (ServiceException e) {
            throw YarnRemoteExceptionPBImpl.unwrapAndThrowException((ServiceException)e);
        }
    }

    public GetClusterMetricsResponse getClusterMetrics(GetClusterMetricsRequest request) throws YarnRemoteException {
        YarnServiceProtos.GetClusterMetricsRequestProto requestProto = ((GetClusterMetricsRequestPBImpl)request).getProto();
        try {
            return new GetClusterMetricsResponsePBImpl(this.proxy.getClusterMetrics(null, requestProto));
        }
        catch (ServiceException e) {
            throw YarnRemoteExceptionPBImpl.unwrapAndThrowException((ServiceException)e);
        }
    }

    public GetNewApplicationResponse getNewApplication(GetNewApplicationRequest request) throws YarnRemoteException {
        YarnServiceProtos.GetNewApplicationRequestProto requestProto = ((GetNewApplicationRequestPBImpl)request).getProto();
        try {
            return new GetNewApplicationResponsePBImpl(this.proxy.getNewApplication(null, requestProto));
        }
        catch (ServiceException e) {
            throw YarnRemoteExceptionPBImpl.unwrapAndThrowException((ServiceException)e);
        }
    }

    public SubmitApplicationResponse submitApplication(SubmitApplicationRequest request) throws YarnRemoteException {
        YarnServiceProtos.SubmitApplicationRequestProto requestProto = ((SubmitApplicationRequestPBImpl)request).getProto();
        try {
            return new SubmitApplicationResponsePBImpl(this.proxy.submitApplication(null, requestProto));
        }
        catch (ServiceException e) {
            throw YarnRemoteExceptionPBImpl.unwrapAndThrowException((ServiceException)e);
        }
    }

    public GetAllApplicationsResponse getAllApplications(GetAllApplicationsRequest request) throws YarnRemoteException {
        YarnServiceProtos.GetAllApplicationsRequestProto requestProto = ((GetAllApplicationsRequestPBImpl)request).getProto();
        try {
            return new GetAllApplicationsResponsePBImpl(this.proxy.getAllApplications(null, requestProto));
        }
        catch (ServiceException e) {
            throw YarnRemoteExceptionPBImpl.unwrapAndThrowException((ServiceException)e);
        }
    }

    public GetClusterNodesResponse getClusterNodes(GetClusterNodesRequest request) throws YarnRemoteException {
        YarnServiceProtos.GetClusterNodesRequestProto requestProto = ((GetClusterNodesRequestPBImpl)request).getProto();
        try {
            return new GetClusterNodesResponsePBImpl(this.proxy.getClusterNodes(null, requestProto));
        }
        catch (ServiceException e) {
            throw YarnRemoteExceptionPBImpl.unwrapAndThrowException((ServiceException)e);
        }
    }

    public GetQueueInfoResponse getQueueInfo(GetQueueInfoRequest request) throws YarnRemoteException {
        YarnServiceProtos.GetQueueInfoRequestProto requestProto = ((GetQueueInfoRequestPBImpl)request).getProto();
        try {
            return new GetQueueInfoResponsePBImpl(this.proxy.getQueueInfo(null, requestProto));
        }
        catch (ServiceException e) {
            throw YarnRemoteExceptionPBImpl.unwrapAndThrowException((ServiceException)e);
        }
    }

    public GetQueueUserAclsInfoResponse getQueueUserAcls(GetQueueUserAclsInfoRequest request) throws YarnRemoteException {
        YarnServiceProtos.GetQueueUserAclsInfoRequestProto requestProto = ((GetQueueUserAclsInfoRequestPBImpl)request).getProto();
        try {
            return new GetQueueUserAclsInfoResponsePBImpl(this.proxy.getQueueUserAcls(null, requestProto));
        }
        catch (ServiceException e) {
            throw YarnRemoteExceptionPBImpl.unwrapAndThrowException((ServiceException)e);
        }
    }

    public GetDelegationTokenResponse getDelegationToken(GetDelegationTokenRequest request) throws YarnRemoteException {
        SecurityProtos.GetDelegationTokenRequestProto requestProto = ((GetDelegationTokenRequestPBImpl)request).getProto();
        try {
            return new GetDelegationTokenResponsePBImpl(this.proxy.getDelegationToken(null, requestProto));
        }
        catch (ServiceException e) {
            throw YarnRemoteExceptionPBImpl.unwrapAndThrowException((ServiceException)e);
        }
    }

    public RenewDelegationTokenResponse renewDelegationToken(RenewDelegationTokenRequest request) throws YarnRemoteException {
        SecurityProtos.RenewDelegationTokenRequestProto requestProto = ((RenewDelegationTokenRequestPBImpl)request).getProto();
        try {
            return new RenewDelegationTokenResponsePBImpl(this.proxy.renewDelegationToken(null, requestProto));
        }
        catch (ServiceException e) {
            throw YarnRemoteExceptionPBImpl.unwrapAndThrowException((ServiceException)e);
        }
    }

    public CancelDelegationTokenResponse cancelDelegationToken(CancelDelegationTokenRequest request) throws YarnRemoteException {
        SecurityProtos.CancelDelegationTokenRequestProto requestProto = ((CancelDelegationTokenRequestPBImpl)request).getProto();
        try {
            return new CancelDelegationTokenResponsePBImpl(this.proxy.cancelDelegationToken(null, requestProto));
        }
        catch (ServiceException e) {
            throw YarnRemoteExceptionPBImpl.unwrapAndThrowException((ServiceException)e);
        }
    }
}

