/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.yarn.util.ProcfsBasedProcessTree;

public abstract class ResourceCalculatorProcessTree
extends Configured {
    static final Log LOG = LogFactory.getLog(ResourceCalculatorProcessTree.class);

    public ResourceCalculatorProcessTree(String root) {
    }

    public abstract void updateProcessTree();

    public abstract String getProcessTreeDump();

    public long getCumulativeVmem() {
        return this.getCumulativeVmem(0);
    }

    public long getCumulativeRssmem() {
        return this.getCumulativeRssmem(0);
    }

    public abstract long getCumulativeVmem(int var1);

    public abstract long getCumulativeRssmem(int var1);

    public abstract long getCumulativeCpuTime();

    public abstract boolean checkPidPgrpidForMatch();

    public static ResourceCalculatorProcessTree getResourceCalculatorProcessTree(String pid, Class<? extends ResourceCalculatorProcessTree> clazz, Configuration conf) {
        if (clazz != null) {
            try {
                Constructor<? extends ResourceCalculatorProcessTree> c = clazz.getConstructor(String.class);
                ResourceCalculatorProcessTree rctree = c.newInstance(pid);
                rctree.setConf(conf);
                return rctree;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Linux")) {
                return new ProcfsBasedProcessTree(pid);
            }
        }
        catch (SecurityException se) {
            return null;
        }
        return null;
    }
}

