/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.yarn.api.ClientRMProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.records.DelegationToken;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RMDelegationTokenIdentifier
extends AbstractDelegationTokenIdentifier {
    public static final Text KIND_NAME = new Text("RM_DELEGATION_TOKEN");

    public RMDelegationTokenIdentifier() {
    }

    public RMDelegationTokenIdentifier(Text owner, Text renewer, Text realUser) {
        super(owner, renewer, realUser);
    }

    public Text getKind() {
        return KIND_NAME;
    }

    public static class Renewer
    extends TokenRenewer {
        private static AbstractDelegationTokenSecretManager<RMDelegationTokenIdentifier> localSecretManager;
        private static InetSocketAddress localServiceAddress;

        public boolean handleKind(Text kind) {
            return KIND_NAME.equals((Object)kind);
        }

        public boolean isManaged(Token<?> token) throws IOException {
            return true;
        }

        @InterfaceAudience.Private
        public static void setSecretManager(AbstractDelegationTokenSecretManager<RMDelegationTokenIdentifier> secretManager, InetSocketAddress serviceAddress) {
            localSecretManager = secretManager;
            localServiceAddress = serviceAddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long renew(Token<?> token, Configuration conf) throws IOException, InterruptedException {
            ClientRMProtocol rmClient = Renewer.getRmClient(token, conf);
            if (rmClient != null) {
                try {
                    RenewDelegationTokenRequest request = Records.newRecord(RenewDelegationTokenRequest.class);
                    request.setDelegationToken(Renewer.convertToProtoToken(token));
                    long l = rmClient.renewDelegationToken(request).getNextExpirationTime();
                    return l;
                }
                finally {
                    RPC.stopProxy((Object)rmClient);
                }
            }
            return localSecretManager.renewToken(token, Renewer.getRenewer(token));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(Token<?> token, Configuration conf) throws IOException, InterruptedException {
            ClientRMProtocol rmClient = Renewer.getRmClient(token, conf);
            if (rmClient != null) {
                try {
                    CancelDelegationTokenRequest request = Records.newRecord(CancelDelegationTokenRequest.class);
                    request.setDelegationToken(Renewer.convertToProtoToken(token));
                    rmClient.cancelDelegationToken(request);
                }
                finally {
                    RPC.stopProxy((Object)rmClient);
                }
            } else {
                localSecretManager.cancelToken(token, Renewer.getRenewer(token));
            }
        }

        private static ClientRMProtocol getRmClient(Token<?> token, Configuration conf) {
            InetSocketAddress addr = SecurityUtil.getTokenServiceAddr(token);
            if (localSecretManager != null && (localServiceAddress.getAddress().isAnyLocalAddress() ? NetUtils.isLocalAddress((InetAddress)addr.getAddress()) && addr.getPort() == localServiceAddress.getPort() : addr.equals(localServiceAddress))) {
                return null;
            }
            YarnRPC rpc = YarnRPC.create(conf);
            return (ClientRMProtocol)rpc.getProxy(ClientRMProtocol.class, addr, conf);
        }

        private static String getRenewer(Token<?> token) throws IOException {
            return ((RMDelegationTokenIdentifier)token.decodeIdentifier()).getRenewer().toString();
        }

        private static DelegationToken convertToProtoToken(Token<?> token) {
            return BuilderUtils.newDelegationToken(token.getIdentifier(), token.getKind().toString(), token.getPassword(), token.getService().toString());
        }
    }
}

