/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.RunJar;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class FSDownload
implements Callable<Path> {
    private static final Log LOG = LogFactory.getLog(FSDownload.class);
    private FileContext files;
    private final UserGroupInformation userUgi;
    private Configuration conf;
    private LocalResource resource;
    private Path destDirPath;
    private static final FsPermission cachePerms = new FsPermission(493);
    static final FsPermission PUBLIC_FILE_PERMS = new FsPermission(365);
    static final FsPermission PRIVATE_FILE_PERMS = new FsPermission(320);
    static final FsPermission PUBLIC_DIR_PERMS = new FsPermission(493);
    static final FsPermission PRIVATE_DIR_PERMS = new FsPermission(448);

    public FSDownload(FileContext files, UserGroupInformation ugi, Configuration conf, Path destDirPath, LocalResource resource) {
        this.conf = conf;
        this.destDirPath = destDirPath;
        this.files = files;
        this.userUgi = ugi;
        this.resource = resource;
    }

    LocalResource getResource() {
        return this.resource;
    }

    private void createDir(Path path, FsPermission perm) throws IOException {
        this.files.mkdir(path, perm, false);
        if (!perm.equals((Object)this.files.getUMask().applyUMask(perm))) {
            this.files.setPermission(path, perm);
        }
    }

    private static boolean isPublic(FileSystem fs, Path current) throws IOException {
        if (!FSDownload.checkPublicPermsForAll(fs, current = fs.makeQualified(current), FsAction.READ_EXECUTE, FsAction.READ)) {
            return false;
        }
        return FSDownload.ancestorsHaveExecutePermissions(fs, current.getParent());
    }

    private static boolean checkPublicPermsForAll(FileSystem fs, Path current, FsAction dir, FsAction file) throws IOException {
        return FSDownload.checkPublicPermsForAll(fs, fs.getFileStatus(current), dir, file);
    }

    private static boolean checkPublicPermsForAll(FileSystem fs, FileStatus status, FsAction dir, FsAction file) throws IOException {
        FsPermission perms = status.getPermission();
        FsAction otherAction = perms.getOtherAction();
        if (status.isDirectory()) {
            if (!otherAction.implies(dir)) {
                return false;
            }
            for (FileStatus child : fs.listStatus(status.getPath())) {
                if (FSDownload.checkPublicPermsForAll(fs, child, dir, file)) continue;
                return false;
            }
            return true;
        }
        return otherAction.implies(file);
    }

    private static boolean ancestorsHaveExecutePermissions(FileSystem fs, Path path) throws IOException {
        for (Path current = path; current != null; current = current.getParent()) {
            if (FSDownload.checkPermissionOfOther(fs, current, FsAction.EXECUTE)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkPermissionOfOther(FileSystem fs, Path path, FsAction action) throws IOException {
        FileStatus status = fs.getFileStatus(path);
        FsPermission perms = status.getPermission();
        FsAction otherAction = perms.getOtherAction();
        return otherAction.implies(action);
    }

    private Path copy(Path sCopy, Path dstdir) throws IOException {
        FileSystem sourceFs = sCopy.getFileSystem(this.conf);
        Path dCopy = new Path(dstdir, sCopy.getName() + ".tmp");
        FileStatus sStat = sourceFs.getFileStatus(sCopy);
        if (sStat.getModificationTime() != this.resource.getTimestamp()) {
            throw new IOException("Resource " + sCopy + " changed on src filesystem (expected " + this.resource.getTimestamp() + ", was " + sStat.getModificationTime());
        }
        if (this.resource.getVisibility() == LocalResourceVisibility.PUBLIC && !FSDownload.isPublic(sourceFs, sCopy)) {
            throw new IOException("Resource " + sCopy + " is not publicly accessable and as such cannot be part of the" + " public cache.");
        }
        sourceFs.copyToLocalFile(sCopy, dCopy);
        return dCopy;
    }

    private long unpack(File localrsrc, File dst, Pattern pattern) throws IOException {
        switch (this.resource.getType()) {
            case ARCHIVE: {
                String lowerDst = dst.getName().toLowerCase();
                if (lowerDst.endsWith(".jar")) {
                    RunJar.unJar((File)localrsrc, (File)dst);
                    break;
                }
                if (lowerDst.endsWith(".zip")) {
                    FileUtil.unZip((File)localrsrc, (File)dst);
                    break;
                }
                if (lowerDst.endsWith(".tar.gz") || lowerDst.endsWith(".tgz") || lowerDst.endsWith(".tar")) {
                    FileUtil.unTar((File)localrsrc, (File)dst);
                    break;
                }
                LOG.warn((Object)("Cannot unpack " + localrsrc));
                if (localrsrc.renameTo(dst)) break;
                throw new IOException("Unable to rename file: [" + localrsrc + "] to [" + dst + "]");
            }
            case PATTERN: {
                String lowerDst = dst.getName().toLowerCase();
                if (lowerDst.endsWith(".jar")) {
                    RunJar.unJar((File)localrsrc, (File)dst, (Pattern)pattern);
                    File newDst = new File(dst, dst.getName());
                    if (!dst.exists() && !dst.mkdir()) {
                        throw new IOException("Unable to create directory: [" + dst + "]");
                    }
                    if (localrsrc.renameTo(newDst)) break;
                    throw new IOException("Unable to rename file: [" + localrsrc + "] to [" + newDst + "]");
                }
                if (lowerDst.endsWith(".zip")) {
                    LOG.warn((Object)("Treating [" + localrsrc + "] as an archive even though it " + "was specified as PATTERN"));
                    FileUtil.unZip((File)localrsrc, (File)dst);
                    break;
                }
                if (lowerDst.endsWith(".tar.gz") || lowerDst.endsWith(".tgz") || lowerDst.endsWith(".tar")) {
                    LOG.warn((Object)("Treating [" + localrsrc + "] as an archive even though it " + "was specified as PATTERN"));
                    FileUtil.unTar((File)localrsrc, (File)dst);
                    break;
                }
                LOG.warn((Object)("Cannot unpack " + localrsrc));
                if (localrsrc.renameTo(dst)) break;
                throw new IOException("Unable to rename file: [" + localrsrc + "] to [" + dst + "]");
            }
            default: {
                if (localrsrc.renameTo(dst)) break;
                throw new IOException("Unable to rename file: [" + localrsrc + "] to [" + dst + "]");
            }
        }
        if (localrsrc.isFile()) {
            try {
                this.files.delete(new Path(localrsrc.toString()), false);
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        return 0L;
    }

    @Override
    public Path call() throws Exception {
        Path sCopy;
        try {
            sCopy = ConverterUtils.getPathFromYarnURL(this.resource.getResource());
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid resource", e);
        }
        this.createDir(this.destDirPath, cachePerms);
        final Path dst_work = new Path(this.destDirPath + "_tmp");
        this.createDir(dst_work, cachePerms);
        Path dFinal = this.files.makeQualified(new Path(dst_work, sCopy.getName()));
        try {
            Path dTmp = null == this.userUgi ? this.files.makeQualified(this.copy(sCopy, dst_work)) : (Path)this.userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Path>(){

                @Override
                public Path run() throws Exception {
                    return FSDownload.this.files.makeQualified(FSDownload.this.copy(sCopy, dst_work));
                }
            });
            Pattern pattern = null;
            String p = this.resource.getPattern();
            if (p != null) {
                pattern = Pattern.compile(p);
            }
            this.unpack(new File(dTmp.toUri()), new File(dFinal.toUri()), pattern);
            this.changePermissions(dFinal.getFileSystem(this.conf), dFinal);
            this.files.rename(dst_work, this.destDirPath, new Options.Rename[]{Options.Rename.OVERWRITE});
        }
        catch (Exception e) {
            try {
                this.files.delete(this.destDirPath, true);
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw e;
        }
        finally {
            try {
                this.files.delete(dst_work, true);
            }
            catch (FileNotFoundException ignore) {}
            this.conf = null;
            this.resource = null;
        }
        return this.files.makeQualified(new Path(this.destDirPath, sCopy.getName()));
    }

    private void changePermissions(FileSystem fs, final Path path) throws IOException, InterruptedException {
        FileStatus fStatus = fs.getFileStatus(path);
        FsPermission perm = cachePerms;
        perm = this.resource.getVisibility() == LocalResourceVisibility.PUBLIC ? (fStatus.isDirectory() ? PUBLIC_DIR_PERMS : PUBLIC_FILE_PERMS) : (fStatus.isDirectory() ? PRIVATE_DIR_PERMS : PRIVATE_FILE_PERMS);
        LOG.debug((Object)("Changing permissions for path " + path + " to perm " + perm));
        final FsPermission fPerm = perm;
        if (null == this.userUgi) {
            this.files.setPermission(path, perm);
        } else {
            this.userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    FSDownload.this.files.setPermission(path, fPerm);
                    return null;
                }
            });
        }
        if (fStatus.isDirectory() && !fStatus.isSymlink()) {
            FileStatus[] statuses;
            for (FileStatus status : statuses = fs.listStatus(path)) {
                this.changePermissions(fs, status.getPath());
            }
        }
    }
}

