/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.factories.impl.pb;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;

public class RecordFactoryPBImpl
implements RecordFactory {
    private static final String PB_IMPL_PACKAGE_SUFFIX = "impl.pb";
    private static final String PB_IMPL_CLASS_SUFFIX = "PBImpl";
    private static final RecordFactoryPBImpl self = new RecordFactoryPBImpl();
    private Configuration localConf = new Configuration();
    private ConcurrentMap<Class<?>, Constructor<?>> cache = new ConcurrentHashMap();

    private RecordFactoryPBImpl() {
    }

    public static RecordFactory get() {
        return self;
    }

    public <T> T newRecordInstance(Class<T> clazz) {
        Constructor constructor = (Constructor)this.cache.get(clazz);
        if (constructor == null) {
            Class pbClazz = null;
            try {
                pbClazz = this.localConf.getClassByName(this.getPBImplClassName(clazz));
            }
            catch (ClassNotFoundException e) {
                throw new YarnException("Failed to load class: [" + this.getPBImplClassName(clazz) + "]", (Throwable)e);
            }
            try {
                constructor = pbClazz.getConstructor(new Class[0]);
                constructor.setAccessible(true);
                this.cache.putIfAbsent(clazz, constructor);
            }
            catch (NoSuchMethodException e) {
                throw new YarnException("Could not find 0 argument constructor", (Throwable)e);
            }
        }
        try {
            Object retObject = constructor.newInstance(new Object[0]);
            return retObject;
        }
        catch (InvocationTargetException e) {
            throw new YarnException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new YarnException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new YarnException((Throwable)e);
        }
    }

    private String getPBImplClassName(Class<?> clazz) {
        String srcPackagePart = this.getPackageName(clazz);
        String srcClassName = this.getClassName(clazz);
        String destPackagePart = srcPackagePart + "." + PB_IMPL_PACKAGE_SUFFIX;
        String destClassPart = srcClassName + PB_IMPL_CLASS_SUFFIX;
        return destPackagePart + "." + destClassPart;
    }

    private String getClassName(Class<?> clazz) {
        String fqName = clazz.getName();
        return fqName.substring(fqName.lastIndexOf(".") + 1, fqName.length());
    }

    private String getPackageName(Class<?> clazz) {
        return clazz.getPackage().getName();
    }
}

