/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.ipc;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;

public class RPCUtil {
    public static YarnRemoteException getRemoteException(Throwable t) {
        return new YarnRemoteException(t);
    }

    public static YarnRemoteException getRemoteException(String message) {
        return new YarnRemoteException(message);
    }

    private static <T extends Throwable> T instantiateException(Class<? extends T> cls, RemoteException re) throws RemoteException {
        try {
            Constructor<T> cn = cls.getConstructor(String.class);
            cn.setAccessible(true);
            Throwable ex = (Throwable)cn.newInstance(re.getMessage());
            ex.initCause((Throwable)re);
            return (T)ex;
        }
        catch (NoSuchMethodException e) {
            throw re;
        }
        catch (IllegalArgumentException e) {
            throw re;
        }
        catch (SecurityException e) {
            throw re;
        }
        catch (InstantiationException e) {
            throw re;
        }
        catch (IllegalAccessException e) {
            throw re;
        }
        catch (InvocationTargetException e) {
            throw re;
        }
    }

    public static Void unwrapAndThrowException(ServiceException se) throws IOException, YarnRemoteException {
        Throwable cause = se.getCause();
        if (cause == null) {
            throw new IOException((Throwable)se);
        }
        if (cause instanceof RemoteException) {
            RemoteException re = (RemoteException)cause;
            Class<?> realClass = null;
            try {
                realClass = Class.forName(re.getClassName());
            }
            catch (ClassNotFoundException cnf) {
                throw RPCUtil.instantiateException(YarnRemoteException.class, re);
            }
            if (YarnRemoteException.class.isAssignableFrom(realClass)) {
                throw RPCUtil.instantiateException(realClass.asSubclass(YarnRemoteException.class), re);
            }
            if (IOException.class.isAssignableFrom(realClass)) {
                throw RPCUtil.instantiateException(realClass.asSubclass(IOException.class), re);
            }
            throw re;
        }
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        throw new IOException((Throwable)se);
    }
}

